/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;

@ApiCallScope
final class IsCalleeInFileVisitor
extends AbstractReturningSoyNodeVisitor<Boolean> {
    private final Map<CallBasicNode, Boolean> memoizedResults = new HashMap<CallBasicNode, Boolean>();

    @Inject
    IsCalleeInFileVisitor() {
    }

    @Override
    protected Boolean visitCallBasicNode(CallBasicNode node) {
        if (this.memoizedResults.containsKey(node)) {
            return this.memoizedResults.get(node);
        }
        SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
        HashSet<String> templatesInFile = new HashSet<String>();
        for (TemplateNode template : file.getChildren()) {
            templatesInFile.add(template.getTemplateName());
        }
        String calleeName = node.getCalleeName();
        Boolean result = templatesInFile.contains(calleeName);
        this.memoizedResults.put(node, result);
        return result;
    }
}

