/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.shared.internal.CodeBuilder;
import java.util.List;

final class JsCodeBuilder
extends CodeBuilder<JsExpr> {
    JsCodeBuilder() {
    }

    @Override
    public void initOutputVarIfNecessary() {
        if (this.getOutputVarIsInited()) {
            return;
        }
        this.appendLine("var ", this.getOutputVarName(), " = '';");
        this.setOutputVarInited();
    }

    @Override
    public void addToOutputVar(List<? extends JsExpr> jsExprs) {
        if (this.getOutputVarIsInited()) {
            this.appendLine(this.getOutputVarName(), " += ", JsExprUtils.concatJsExprs(jsExprs).getText(), ";");
        } else {
            String contents = JsExprUtils.concatJsExprsForceString(jsExprs).getText();
            this.appendLine("var ", this.getOutputVarName(), " = ", contents, ";");
            this.setOutputVarInited();
        }
    }
}

