/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;

final class ExpressionToSoyValueProviderCompiler {
    private final TemplateParameterLookup variables;
    private final ExpressionCompiler exprCompiler;

    static ExpressionToSoyValueProviderCompiler create(ExpressionCompiler exprCompiler, TemplateParameterLookup variables) {
        return new ExpressionToSoyValueProviderCompiler(exprCompiler, variables);
    }

    private ExpressionToSoyValueProviderCompiler(ExpressionCompiler exprCompiler, TemplateParameterLookup variables) {
        this.exprCompiler = exprCompiler;
        this.variables = variables;
    }

    Optional<Expression> compileAvoidingBoxing(ExprNode node, Label reattachPoint) {
        Preconditions.checkNotNull((Object)node);
        return (Optional)new CompilerVisitor(this.variables, null, this.exprCompiler.asBasicCompiler(reattachPoint)).exec(node);
    }

    Optional<Expression> compileAvoidingDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        return (Optional)new CompilerVisitor(this.variables, this.exprCompiler, null).exec(node);
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<Optional<Expression>> {
        final TemplateParameterLookup variables;
        @Nullable
        final ExpressionCompiler exprCompiler;
        @Nullable
        final ExpressionCompiler.BasicExpressionCompiler detachingExprCompiler;

        CompilerVisitor(TemplateParameterLookup variables, ExpressionCompiler exprCompiler, ExpressionCompiler.BasicExpressionCompiler detachingExprCompiler) {
            this.variables = variables;
            Preconditions.checkArgument((exprCompiler == null != (detachingExprCompiler == null) ? 1 : 0) != 0);
            this.exprCompiler = exprCompiler;
            this.detachingExprCompiler = detachingExprCompiler;
        }

        private boolean allowsBoxing() {
            return this.exprCompiler != null;
        }

        private boolean allowsDetaches() {
            return this.detachingExprCompiler != null;
        }

        @Override
        protected final Optional<Expression> visitExprRootNode(ExprRootNode node) {
            return (Optional)this.visit(node.getRoot());
        }

        @Override
        protected Optional<Expression> visitNullNode(NullNode node) {
            return Optional.of((Object)FieldRef.NULL_PROVIDER.accessor());
        }

        @Override
        protected Optional<Expression> visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            if (this.allowsDetaches()) {
                Optional right = (Optional)this.visit(node.getRightChild());
                if (!right.isPresent()) {
                    return Optional.absent();
                }
                Expression left = this.detachingExprCompiler.compile(node.getLeftChild()).box().cast(SoyValueProvider.class);
                return Optional.of((Object)BytecodeUtils.firstNonNull(left, (Expression)right.get()));
            }
            return this.visitExprNode(node);
        }

        @Override
        protected final Optional<Expression> visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            if (this.allowsDetaches()) {
                Optional trueBranch = (Optional)this.visit(node.getChild(1));
                Optional falseBranch = (Optional)this.visit(node.getChild(2));
                if (!trueBranch.isPresent() || !falseBranch.isPresent()) {
                    return Optional.absent();
                }
                SoyExpression condition = this.detachingExprCompiler.compile(node.getChild(0)).coerceToBoolean();
                return Optional.of((Object)BytecodeUtils.ternary(condition, (Expression)trueBranch.get(), (Expression)falseBranch.get()));
            }
            return this.visitExprNode(node);
        }

        @Override
        Optional<Expression> visitForeachLoopVar(VarRefNode varRef, LocalVar local) {
            return Optional.of((Object)this.variables.getLocal(local));
        }

        @Override
        Optional<Expression> visitParam(VarRefNode varRef, TemplateParam param) {
            return Optional.of((Object)this.variables.getParam(param));
        }

        @Override
        Optional<Expression> visitIjParam(VarRefNode node, InjectedParam ij) {
            return Optional.of((Object)MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(this.variables.getIjRecord(), BytecodeUtils.constant(ij.name())));
        }

        @Override
        Optional<Expression> visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            return Optional.of((Object)this.variables.getLocal(local));
        }

        @Override
        protected Optional<Expression> visitDataAccessNode(DataAccessNode node) {
            return this.visitExprNode(node);
        }

        @Override
        protected final Optional<Expression> visitExprNode(ExprNode node) {
            Optional<SoyExpression> compileWithNoDetaches;
            if (this.allowsBoxing() && (compileWithNoDetaches = this.exprCompiler.compileWithNoDetaches(node)).isPresent()) {
                return Optional.of((Object)((SoyExpression)compileWithNoDetaches.get()).box());
            }
            return Optional.absent();
        }
    }
}

