/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

final class AnnotationRef<T extends Annotation> {
    private static final Ordering<Method> METHOD_ORDERING = new Ordering<Method>(){

        public int compare(@Nullable Method left, @Nullable Method right) {
            return left.toGenericString().compareTo(right.toGenericString());
        }
    };
    private final Class<T> annType;
    private final String typeDescriptor;
    private final boolean isRuntimeVisible;
    private final ImmutableMap<Method, FieldWriter> writers;

    static <T extends Annotation> AnnotationRef<T> forType(Class<T> annType) {
        Preconditions.checkArgument((boolean)annType.isAnnotation());
        return new AnnotationRef<T>(annType);
    }

    private AnnotationRef(Class<T> annType) {
        this.annType = annType;
        Retention retention = annType.getAnnotation(Retention.class);
        this.isRuntimeVisible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
        this.typeDescriptor = Type.getDescriptor(annType);
        ImmutableMap.Builder writersBuilder = ImmutableMap.builder();
        for (Method method : METHOD_ORDERING.sortedCopy(Arrays.asList(annType.getDeclaredMethods()))) {
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers())) continue;
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                if (returnType.getComponentType().isAnnotation()) {
                    throw new UnsupportedOperationException("Arrays of annotations are not supported");
                }
                writersBuilder.put((Object)method, (Object)AnnotationRef.arrayFieldWriter(method.getName()));
                continue;
            }
            if (returnType.isAnnotation()) {
                AnnotationRef<?> forType = AnnotationRef.forType(returnType);
                writersBuilder.put((Object)method, (Object)AnnotationRef.annotationFieldWriter(method.getName(), forType));
                continue;
            }
            writersBuilder.put((Object)method, (Object)AnnotationRef.simpleFieldWriter(method.getName()));
        }
        this.writers = writersBuilder.build();
    }

    void write(T instance, ClassVisitor visitor) {
        this.doWrite(instance, visitor.visitAnnotation(this.typeDescriptor, this.isRuntimeVisible));
    }

    private void doWrite(T instance, AnnotationVisitor annVisitor) {
        for (Map.Entry entry : this.writers.entrySet()) {
            ((FieldWriter)entry.getValue()).write(annVisitor, this.invokeExplosively(instance, (Method)entry.getKey()));
        }
        annVisitor.visitEnd();
    }

    private Object invokeExplosively(T instance, Method key) {
        Object invoke;
        try {
            invoke = key.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return invoke;
    }

    private static <T extends Annotation> FieldWriter annotationFieldWriter(final String name, final AnnotationRef<T> ref) {
        return new FieldWriter(){

            @Override
            public void write(AnnotationVisitor visitor, Object value) {
                ref.doWrite((Annotation)ref.annType.cast(value), visitor.visitAnnotation(name, ref.typeDescriptor));
            }
        };
    }

    private static FieldWriter simpleFieldWriter(final String name) {
        return new FieldWriter(){

            @Override
            public void write(AnnotationVisitor visitor, Object value) {
                visitor.visit(name, value);
            }
        };
    }

    private static FieldWriter arrayFieldWriter(final String name) {
        return new FieldWriter(){

            @Override
            public void write(AnnotationVisitor visitor, Object value) {
                int len = Array.getLength(value);
                AnnotationVisitor arrayVisitor = visitor.visitArray(name);
                for (int i = 0; i < len; ++i) {
                    arrayVisitor.visit(null, Array.get(value, i));
                }
                arrayVisitor.visitEnd();
            }
        };
    }

    private static interface FieldWriter {
        public void write(AnnotationVisitor var1, Object var2);
    }
}

