/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.shared.internal.CodeBuilder;
import java.util.List;

public final class IncrementalDomCodeBuilder
extends CodeBuilder<JsExpr> {
    private SanitizedContent.ContentKind contentKind;

    @Override
    public void initOutputVarIfNecessary() {
    }

    @Override
    public void addToOutputVar(List<? extends JsExpr> jsExprs) {
        if (this.getContentKind() == SanitizedContent.ContentKind.HTML || this.getContentKind() == SanitizedContent.ContentKind.ATTRIBUTES) {
            for (JsExpr jsExpr : jsExprs) {
                this.append(jsExpr.getText());
            }
        } else {
            this.appendLine(this.getOutputVarName(), " += ", JsExprUtils.concatJsExprs(jsExprs).getText(), ";");
        }
    }

    protected void addToOutput(List<? extends JsExpr> jsExprs) {
        this.append(JsExprUtils.concatJsExprs(jsExprs).getText());
    }

    public void setContentKind(SanitizedContent.ContentKind contentKind) {
        this.contentKind = contentKind;
    }

    public SanitizedContent.ContentKind getContentKind() {
        return this.contentKind;
    }
}

