/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.jssrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class GoogMsgDefNode
extends AbstractParentSoyNode<MsgNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<MsgNode> {
    private final ImmutableMap<MsgNode, Long> childToMsgIdMap;
    private final String renderedGoogMsgVarName;
    private final String sourceString;

    public GoogMsgDefNode(int id, MsgFallbackGroupNode origMsgFbGrpNode, List<Long> childMsgIds) {
        super(id, origMsgFbGrpNode.getSourceLocation());
        int numChildren = origMsgFbGrpNode.numChildren();
        Preconditions.checkArgument((childMsgIds.size() == numChildren ? 1 : 0) != 0);
        this.addChildren(origMsgFbGrpNode.getChildren());
        ImmutableMap.Builder childToMsgIdMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < numChildren; ++i) {
            childToMsgIdMapBuilder.put((Object)this.getChild(i), (Object)childMsgIds.get(i));
        }
        this.childToMsgIdMap = childToMsgIdMapBuilder.build();
        this.renderedGoogMsgVarName = "msg_s" + id;
        this.sourceString = "[GoogMsgDefNode " + this.renderedGoogMsgVarName + " " + origMsgFbGrpNode.toSourceString() + "]";
    }

    private GoogMsgDefNode(GoogMsgDefNode orig, CopyState copyState) {
        super(orig, copyState);
        this.childToMsgIdMap = orig.childToMsgIdMap;
        this.renderedGoogMsgVarName = orig.renderedGoogMsgVarName;
        this.sourceString = orig.sourceString;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.GOOG_MSG_DEF_NODE;
    }

    public long getChildMsgId(MsgNode child) {
        return (Long)this.childToMsgIdMap.get((Object)child);
    }

    public String getRenderedGoogMsgVarName() {
        return this.renderedGoogMsgVarName;
    }

    public String getVarName() {
        return this.getRenderedGoogMsgVarName();
    }

    @Override
    public String toSourceString() {
        return this.sourceString;
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public GoogMsgDefNode copy(CopyState copyState) {
        return new GoogMsgDefNode(this, copyState);
    }
}

