/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.NameAttributePair;
import com.google.template.soy.soytree.RequirecssUtils;
import java.util.List;
import javax.annotation.Nullable;

public final class NamespaceDeclaration {
    static final AutoescapeMode DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE = AutoescapeMode.STRICT;
    public static final NamespaceDeclaration NULL = new NamespaceDeclaration();
    private static final SoyErrorKind UNSUPPORTED_ATTRIBUTE_KEY = SoyErrorKind.of("Unsupported attribute ''{0}'', expected one of [{1}].");
    private final String namespace;
    private final Optional<AutoescapeMode> namespaceAutoescapeMode;
    private final ImmutableList<String> requiredCssNamespaces;
    private final String cssBaseNamespace;

    public NamespaceDeclaration(String namespace, List<NameAttributePair> attrs, ErrorReporter errorReporter) {
        AutoescapeMode defaultAutoescapeMode = null;
        ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
        String cssBaseNamespace = null;
        block10: for (NameAttributePair attr : attrs) {
            switch (attr.getName()) {
                case "autoescape": {
                    defaultAutoescapeMode = AutoescapeMode.parseAutoEscapeMode(attr.getValue(), attr.getLocation(), errorReporter);
                    continue block10;
                }
                case "requirecss": {
                    requiredCssNamespaces = RequirecssUtils.parseRequirecssAttr(attr.getValue(), attr.getLocation());
                    continue block10;
                }
                case "cssbase": {
                    cssBaseNamespace = attr.getValue();
                    continue block10;
                }
            }
            errorReporter.report(attr.getLocation(), UNSUPPORTED_ATTRIBUTE_KEY, attr.getName(), ImmutableList.of((Object)"autoescape", (Object)"requirecss", (Object)"cssbase"));
        }
        this.namespace = namespace;
        this.namespaceAutoescapeMode = Optional.fromNullable(defaultAutoescapeMode);
        this.requiredCssNamespaces = requiredCssNamespaces;
        this.cssBaseNamespace = cssBaseNamespace;
    }

    private NamespaceDeclaration() {
        this.namespace = null;
        this.namespaceAutoescapeMode = Optional.absent();
        this.requiredCssNamespaces = ImmutableList.of();
        this.cssBaseNamespace = null;
    }

    public boolean isDefined() {
        return this != NULL;
    }

    public AutoescapeMode getDefaultAutoescapeMode() {
        return (AutoescapeMode)((Object)this.namespaceAutoescapeMode.or((Object)DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE));
    }

    public Optional<AutoescapeMode> getAutoescapeMode() {
        return this.namespaceAutoescapeMode;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    @Nullable
    public String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }
}

