/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class CallParamValueNode
extends CallParamNode
implements SoyNode.ExprHolderNode {
    private static final SoyErrorKind SELF_ENDING_TAG_WITHOUT_VALUE = SoyErrorKind.of("A ''param'' tag should be self-ending (with a trailing ''/'') if and only if it also contains a value (invalid tag is '{'param {0} /'}').");
    private static final SoyErrorKind SELF_ENDING_TAG_WITH_KIND_ATTRIBUTE = SoyErrorKind.of("The ''kind'' attribute is not allowed on self-ending ''param'' tags (invalid tag is '{'param {0} /'}').");
    private final String key;
    private final ExprUnion valueExprUnion;

    private CallParamValueNode(int id, SourceLocation sourceLocation, String key, ExprUnion valueExprUnion, String commandText) {
        super(id, sourceLocation, commandText);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.valueExprUnion = (ExprUnion)Preconditions.checkNotNull((Object)valueExprUnion);
    }

    private CallParamValueNode(CallParamValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.key = orig.key;
        this.valueExprUnion = orig.valueExprUnion != null ? orig.valueExprUnion.copy(copyState) : null;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_VALUE_NODE;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getValueExprText() {
        return this.valueExprUnion.getExprText();
    }

    public ExprUnion getValueExprUnion() {
        return this.valueExprUnion;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(true);
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.valueExprUnion);
    }

    @Override
    public CallParamValueNode copy(CopyState copyState) {
        return new CallParamValueNode(this, copyState);
    }

    public static final class Builder
    extends CallParamNode.Builder {
        private static CallParamValueNode error() {
            return new Builder(-1, "error: error", SourceLocation.UNKNOWN).build(ExplodingErrorReporter.get());
        }

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            super(id, commandText, sourceLocation);
        }

        public CallParamValueNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            CallParamNode.CommandTextParseResult parseResult = this.parseCommandTextHelper(errorReporter);
            if (parseResult.valueExprUnion == null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_TAG_WITHOUT_VALUE, this.commandText);
            }
            if (parseResult.contentKind != null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_TAG_WITH_KIND_ATTRIBUTE, this.commandText);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return Builder.error();
            }
            CallParamValueNode node = new CallParamValueNode(this.id, this.sourceLocation, parseResult.key, parseResult.valueExprUnion, this.commandText);
            return node;
        }
    }
}

