/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AutoValue_CallNode_DataAttribute;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public abstract class CallNode
extends AbstractParentCommandNode<CallParamNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CallParamNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    public static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final DataAttribute dataAttr;
    @Nullable
    private final String userSuppliedPlaceholderName;
    private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();

    protected CallNode(int id, SourceLocation sourceLocation, String commandName, CommandTextInfo commandTextInfo, ImmutableList<String> escapingDirectiveNames) {
        super(id, sourceLocation, commandName, commandTextInfo.commandText);
        this.dataAttr = commandTextInfo.dataAttribute;
        this.userSuppliedPlaceholderName = commandTextInfo.userSuppliedPlaceholderName;
        this.escapingDirectiveNames = escapingDirectiveNames;
        this.maybeSetSyntaxVersionUpperBound(commandTextInfo.syntaxVersionBound);
    }

    protected static DataAttribute parseDataAttributeHelper(String dataAttr, SourceLocation sourceLocation, ErrorReporter errorReporter) {
        if (dataAttr == null) {
            return DataAttribute.none();
        }
        if (dataAttr.equals("all")) {
            return DataAttribute.all();
        }
        return DataAttribute.expr(new ExprRootNode(new ExpressionParser(dataAttr, sourceLocation, errorReporter).parseExpression()));
    }

    protected CallNode(CallNode orig, CopyState copyState) {
        super(orig, copyState);
        this.dataAttr = orig.dataAttr.copy(copyState);
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.escapingDirectiveNames = orig.escapingDirectiveNames;
    }

    public DataAttribute dataAttribute() {
        return this.dataAttr;
    }

    @Override
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(this.numChildren() == 0);
    }

    @Override
    public String toSourceString() {
        return this.numChildren() == 0 ? this.getTagString() : super.toSourceString();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return this.dataAttr.dataExpr() != null ? ImmutableList.of((Object)new ExprUnion(this.dataAttr.dataExpr())) : Collections.emptyList();
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        return FALLBACK_BASE_PLACEHOLDER_NAME;
    }

    @Override
    public Object genSamenessKey() {
        return this.getId();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    public Collection<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        return callee.getParams();
    }

    public void setEscapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
        this.escapingDirectiveNames = escapingDirectiveNames;
    }

    public ImmutableList<String> getEscapingDirectiveNames() {
        return this.escapingDirectiveNames;
    }

    public static abstract class DataAttribute {
        public static DataAttribute none() {
            return new AutoValue_CallNode_DataAttribute(false, null);
        }

        public static DataAttribute all() {
            return new AutoValue_CallNode_DataAttribute(true, null);
        }

        public static DataAttribute expr(ExprRootNode expr) {
            return new AutoValue_CallNode_DataAttribute(true, expr);
        }

        DataAttribute() {
        }

        public abstract boolean isPassingData();

        public final boolean isPassingAllData() {
            return this.isPassingData() && this.dataExpr() == null;
        }

        @Nullable
        public abstract ExprRootNode dataExpr();

        DataAttribute copy(CopyState copyState) {
            if (this.dataExpr() == null) {
                return this;
            }
            return new AutoValue_CallNode_DataAttribute(true, this.dataExpr().copy(copyState));
        }
    }

    @Immutable
    protected static class CommandTextInfo {
        private final String commandText;
        private final DataAttribute dataAttribute;
        @Nullable
        private final String userSuppliedPlaceholderName;
        @Nullable
        protected final SyntaxVersionUpperBound syntaxVersionBound;

        public CommandTextInfo(String commandText, DataAttribute dataAttribute, @Nullable String userSuppliedPlaceholderName, @Nullable SyntaxVersionUpperBound syntaxVersionBound) {
            this.commandText = commandText;
            this.dataAttribute = dataAttribute;
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            this.syntaxVersionBound = syntaxVersionBound;
        }
    }
}

