/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public abstract class CodeBuilder<E extends TargetExpr> {
    private static final String SPACES = "                    ";
    private static final int INDENT_SIZE = 2;
    private final StringBuilder code = new StringBuilder();
    private String indent = "";
    private Deque<Pair<String, Boolean>> outputVars = new ArrayDeque<Pair<String, Boolean>>();
    private String currOutputVarName = null;
    private boolean currOutputVarIsInited = false;

    public void increaseIndent() {
        this.changeIndentHelper(1);
    }

    public void increaseIndentTwice() {
        this.changeIndentHelper(2);
    }

    public void decreaseIndent() {
        this.changeIndentHelper(-1);
    }

    public void decreaseIndentTwice() {
        this.changeIndentHelper(-2);
    }

    private void changeIndentHelper(int chg) {
        int newIndentDepth = this.indent.length() + chg * 2;
        Preconditions.checkState((newIndentDepth >= 0 && newIndentDepth <= SPACES.length() ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, newIndentDepth);
    }

    public void pushOutputVar(String outputVarName) {
        this.outputVars.push(Pair.of(outputVarName, false));
        this.currOutputVarName = outputVarName;
        this.currOutputVarIsInited = false;
    }

    public void popOutputVar() {
        this.outputVars.pop();
        Pair<String, Boolean> topPair = this.outputVars.peek();
        if (topPair != null) {
            this.currOutputVarName = (String)topPair.first;
            this.currOutputVarIsInited = (Boolean)topPair.second;
        } else {
            this.currOutputVarName = null;
            this.currOutputVarIsInited = false;
        }
    }

    public void setOutputVarInited() {
        this.outputVars.pop();
        this.outputVars.push(Pair.of(this.currOutputVarName, true));
        this.currOutputVarIsInited = true;
    }

    public String getOutputVarName() {
        return this.currOutputVarName;
    }

    public CodeBuilder<E> append(String ... codeFragments) {
        for (String codeFragment : codeFragments) {
            this.code.append(codeFragment);
        }
        return this;
    }

    public CodeBuilder<E> appendLine(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public CodeBuilder<E> appendLineStart(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        return this;
    }

    public CodeBuilder<E> appendLineEnd(String ... codeFragments) {
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public CodeBuilder<E> appendOutputVarName() {
        this.code.append(this.currOutputVarName);
        return this;
    }

    public String getCode() {
        return this.code.toString();
    }

    public abstract void initOutputVarIfNecessary();

    public abstract void addToOutputVar(List<? extends E> var1);

    protected boolean getOutputVarIsInited() {
        return this.currOutputVarIsInited;
    }
}

