/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.PyApiCallScopeBindingAnnotations;
import com.google.template.soy.pysrc.internal.PyCodeBuilder;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.shared.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;

final class GenPyCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final SoyErrorKind NON_NAMESPACED_TEMPLATE = SoyErrorKind.of("Called template does not reside in a namespace.");
    private final SoyPySrcOptions pySrcOptions;
    private final ImmutableMap<String, String> namespaceManifest;
    @VisibleForTesting
    protected PyCodeBuilder pyCodeBuilder;
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    @VisibleForTesting
    protected GenPyExprsVisitor genPyExprsVisitor;
    private final GenPyCallExprVisitor genPyCallExprVisitor;
    @VisibleForTesting
    protected LocalVariableStack localVarExprs;

    @Inject
    GenPyCodeVisitor(SoyPySrcOptions pySrcOptions, @PyApiCallScopeBindingAnnotations.PyCurrentManifest ImmutableMap<String, String> currentManifest, IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory, GenPyCallExprVisitor genPyCallExprVisitor) {
        this.pySrcOptions = pySrcOptions;
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
        this.genPyCallExprVisitor = genPyCallExprVisitor;
        this.namespaceManifest = new ImmutableMap.Builder().putAll(pySrcOptions.getNamespaceManifest()).putAll(currentManifest).build();
    }

    public List<String> gen(SoyFileSetNode node, ErrorReporter errorReporter) {
        this.pyCodeBuilder = null;
        this.genPyExprsVisitor = null;
        this.localVarExprs = null;
        return new Impl(errorReporter).exec(node);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, ErrorReporter errorReporter) {
        new Impl(errorReporter).exec(node);
    }

    private static Pair<String, String> namespaceAndNameFromModule(String moduleName) {
        String namespace = moduleName;
        String name = moduleName;
        int lastDotIndex = moduleName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            namespace = moduleName.substring(0, lastDotIndex);
            name = moduleName.substring(lastDotIndex + 1);
        }
        return Pair.of(namespace, name);
    }

    private final class Impl
    extends AbstractSoyNodeVisitor<List<String>> {
        private List<String> pyFilesContents;
        final ErrorReporter errorReporter;

        Impl(ErrorReporter reporter) {
            this.errorReporter = reporter;
        }

        @Override
        public List<String> exec(SoyNode node) {
            this.pyFilesContents = new ArrayList<String>();
            this.visit(node);
            return this.pyFilesContents;
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            if (node.numChildren() > 0 && !((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node.getChild(0))).booleanValue()) {
                GenPyCodeVisitor.this.pyCodeBuilder.initOutputVarIfNecessary();
            }
            ArrayList<PyExpr> childPyExprs = new ArrayList<PyExpr>();
            for (SoyNode child : node.getChildren()) {
                if (((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(child)).booleanValue()) {
                    childPyExprs.addAll(GenPyCodeVisitor.this.genPyExprsVisitor.exec(child));
                    continue;
                }
                if (!childPyExprs.isEmpty()) {
                    GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)childPyExprs);
                    childPyExprs.clear();
                }
                this.visit(child);
            }
            if (!childPyExprs.isEmpty()) {
                GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)childPyExprs);
                childPyExprs.clear();
            }
        }

        @Override
        protected void visitSoyFileSetNode(SoyFileSetNode node) {
            for (SoyFileNode soyFile : node.getChildren()) {
                this.visit(soyFile);
            }
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            if (node.getSoyFileKind() != SoyFileKind.SRC) {
                return;
            }
            GenPyCodeVisitor.this.pyCodeBuilder = new PyCodeBuilder();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("# coding=utf-8");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("\"\"\" This file was automatically generated from ", node.getFileName(), ".");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("Please don't edit this file by hand.");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("SOY_NAMESPACE: '" + node.getNamespace() + "'.");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            if (node.getNamespace() != null) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("Templates in namespace ", node.getNamespace(), ".");
            }
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("\"\"\"");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps();
            this.addCodeToRequireSoyNamespaces(node);
            this.addCodeToFixUnicodeStrings();
            for (TemplateNode template : node.getChildren()) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
                this.visit(template);
            }
            this.pyFilesContents.add(GenPyCodeVisitor.this.pyCodeBuilder.getCode());
            GenPyCodeVisitor.this.pyCodeBuilder = null;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            GenPyCodeVisitor.this.localVarExprs = new LocalVariableStack();
            GenPyCodeVisitor.this.genPyExprsVisitor = GenPyCodeVisitor.this.genPyExprsVisitorFactory.create(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("def ", node.getPartialTemplateName().substring(1), "(data={}, ijData={}):");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            this.generateFunctionBody(node);
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
        }

        @Override
        protected void visitTemplateDelegateNode(TemplateDelegateNode node) {
            this.visitTemplateNode(node);
            String delTemplateIdExprText = "'" + node.getDelTemplateName() + "'";
            String delTemplateVariantExprText = "'" + node.getDelTemplateVariant() + "'";
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("runtime.register_delegate_fn(", delTemplateIdExprText, ", ", delTemplateVariantExprText, ", ", node.getDelPriority().toString(), ", ", node.getPartialTemplateName().substring(1), ", '", node.getPartialTemplateName().substring(1), "')");
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)GenPyCodeVisitor.this.genPyExprsVisitor.exec(node));
        }

        @Override
        protected void visitIfNode(IfNode node) {
            if (((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node)).booleanValue()) {
                GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)GenPyCodeVisitor.this.genPyExprsVisitor.exec(node));
                return;
            }
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    PyExpr condPyExpr = (PyExpr)translator.exec(icn.getExprUnion().getExpr());
                    if (icn.getCommandName().equals("if")) {
                        GenPyCodeVisitor.this.pyCodeBuilder.appendLine("if ", condPyExpr.getText(), ":");
                    } else {
                        GenPyCodeVisitor.this.pyCodeBuilder.appendLine("elif ", condPyExpr.getText(), ":");
                    }
                    GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                    this.visitChildren(icn);
                    GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    continue;
                }
                if (child instanceof IfElseNode) {
                    GenPyCodeVisitor.this.pyCodeBuilder.appendLine("else:");
                    GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                    this.visitChildren((IfElseNode)child);
                    GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    continue;
                }
                throw new AssertionError((Object)("Unexpected if child node type. Child: " + child));
            }
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            String switchValueVarName = "switchValue";
            PyExpr switchValuePyExpr = (PyExpr)translator.exec(node.getExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(switchValueVarName, " = ", switchValuePyExpr.getText());
            if (node.getChildren().size() == 1 && node.getChild(0) instanceof SwitchDefaultNode) {
                this.visitChildren((SwitchDefaultNode)node.getChild(0));
                return;
            }
            boolean isFirstCase = true;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    for (ExprNode exprNode : scn.getExprList()) {
                        PyExpr casePyExpr = (PyExpr)translator.exec(exprNode);
                        PyExpr conditionFn = new PyFunctionExprBuilder("runtime.type_safe_eq").addArg(new PyExpr(switchValueVarName, Integer.MAX_VALUE)).addArg(casePyExpr).asPyExpr();
                        if (isFirstCase) {
                            GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart("if ").append(conditionFn.getText()).appendLineEnd(":");
                            isFirstCase = false;
                        } else {
                            GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart("elif ").append(conditionFn.getText()).appendLineEnd(":");
                        }
                        GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                        this.visitChildren(scn);
                        GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    }
                    continue;
                }
                if (child instanceof SwitchDefaultNode) {
                    SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                    GenPyCodeVisitor.this.pyCodeBuilder.appendLine("else:");
                    GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                    this.visitChildren(sdn);
                    GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                    continue;
                }
                throw new AssertionError((Object)("Unexpected switch child node type. Child: " + child));
            }
        }

        @Override
        protected void visitForNode(ForNode node) {
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            String varName = node.getVarName();
            String nodeId = Integer.toString(node.getId());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart("for ", varName, nodeId, " in ");
            PyFunctionExprBuilder funcBuilder = new PyFunctionExprBuilder("xrange");
            for (ExprUnion arg : node.getAllExprUnions()) {
                funcBuilder.addArg((PyExpr)translator.exec(arg.getExpr()));
            }
            GenPyCodeVisitor.this.pyCodeBuilder.appendLineEnd(funcBuilder.asPyExpr().getText(), ":");
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.localVarExprs.addVariable(varName, new PyExpr(varName + nodeId, Integer.MAX_VALUE));
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            this.visitChildren(node);
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            GenPyCodeVisitor.this.localVarExprs.popFrame();
        }

        @Override
        protected void visitForeachNode(ForeachNode node) {
            boolean hasIfemptyNode;
            ForeachNonemptyNode nonEmptyNode = (ForeachNonemptyNode)node.getChild(0);
            String baseVarName = nonEmptyNode.getVarName();
            String listVarName = String.format("%sList%d", baseVarName, node.getId());
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            PyExpr dataRefPyExpr = (PyExpr)translator.exec(node.getExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(listVarName, " = ", dataRefPyExpr.getText());
            boolean bl = hasIfemptyNode = node.numChildren() == 2;
            if (hasIfemptyNode) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("if ", listVarName, ":");
                GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            }
            this.visit(nonEmptyNode);
            if (hasIfemptyNode) {
                GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("else:");
                GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
                this.visit(node.getChild(1));
                GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            }
        }

        @Override
        protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
            String baseVarName = node.getVarName();
            String foreachNodeId = Integer.toString(node.getForeachNodeId());
            String listVarName = baseVarName + "List" + foreachNodeId;
            String indexVarName = baseVarName + "Index" + foreachNodeId;
            String dataVarName = baseVarName + "Data" + foreachNodeId;
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("for ", indexVarName, ", ", dataVarName, " in enumerate(", listVarName, "):");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            int eqPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.EQUAL);
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.localVarExprs.addVariable(baseVarName, new PyExpr(dataVarName, Integer.MAX_VALUE)).addVariable(baseVarName + "__isFirst", new PyExpr(indexVarName + " == 0", eqPrecedence)).addVariable(baseVarName + "__isLast", new PyExpr(indexVarName + " == len(" + listVarName + ") - 1", eqPrecedence)).addVariable(baseVarName + "__index", new PyExpr(indexVarName, Integer.MAX_VALUE));
            this.visitChildren(node);
            GenPyCodeVisitor.this.localVarExprs.popFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
        }

        @Override
        protected void visitForeachIfemptyNode(ForeachIfemptyNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            String generatedVarName = node.getUniqueVarName();
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(GenPyCodeVisitor.this.localVarExprs, this.errorReporter);
            PyExpr valuePyExpr = (PyExpr)translator.exec(node.getValueExpr());
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(generatedVarName, " = ", valuePyExpr.getText());
            GenPyCodeVisitor.this.localVarExprs.addVariable(node.getVarName(), new PyExpr(generatedVarName, Integer.MAX_VALUE));
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            if (node.getContentKind() == null) {
                throw LegacyInternalSyntaxException.createWithMetaInfo("Let content node is missing a content kind. This may be due to using a non-strict template, which is unsupported in the Python compiler.", node.getSourceLocation());
            }
            String generatedVarName = node.getUniqueVarName();
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar(generatedVarName);
            this.visitChildren(node);
            PyStringExpr generatedContent = GenPyCodeVisitor.this.pyCodeBuilder.getOutputAsString();
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
            GenPyCodeVisitor.this.localVarExprs.popFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(generatedVarName, " = ", PyExprUtils.wrapAsSanitizedContent(node.getContentKind(), generatedContent).getText());
            GenPyCodeVisitor.this.localVarExprs.addVariable(node.getVarName(), new PyExpr(generatedVarName, Integer.MAX_VALUE));
        }

        @Override
        protected void visitCallNode(CallNode node) {
            for (CallParamNode child : node.getChildren()) {
                if (!(child instanceof CallParamContentNode) || ((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(child)).booleanValue()) continue;
                this.visit(child);
            }
            GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar(GenPyCodeVisitor.this.genPyCallExprVisitor.exec(node, GenPyCodeVisitor.this.localVarExprs, this.errorReporter).toPyString());
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            Preconditions.checkArgument(((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node) == false ? 1 : 0) != 0, (Object)"Should only define 'param<n>' when not computable as Python expressions.");
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar("param" + node.getId());
            GenPyCodeVisitor.this.pyCodeBuilder.initOutputVarIfNecessary();
            this.visitChildren(node);
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (!((Boolean)GenPyCodeVisitor.this.isComputableAsPyExprVisitor.exec(node)).booleanValue()) {
                throw new UnsupportedOperationException();
            }
            GenPyCodeVisitor.this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)GenPyCodeVisitor.this.genPyExprsVisitor.exec(node));
        }

        private void addCodeToRequireGeneralDeps() {
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from __future__ import unicode_literals");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import collections");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import math");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import random");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import sys");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import bidi");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import directives");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import runtime");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", GenPyCodeVisitor.this.pySrcOptions.getRuntimePath(), " import sanitize");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
            if (!GenPyCodeVisitor.this.pySrcOptions.getBidiIsRtlFn().isEmpty()) {
                int dotIndex = GenPyCodeVisitor.this.pySrcOptions.getBidiIsRtlFn().lastIndexOf(46);
                String bidiModulePath = GenPyCodeVisitor.this.pySrcOptions.getBidiIsRtlFn().substring(0, dotIndex);
                Pair nameSpaceAndName = GenPyCodeVisitor.namespaceAndNameFromModule(bidiModulePath);
                String bidiNamespace = (String)nameSpaceAndName.first;
                String bidiModuleName = (String)nameSpaceAndName.second;
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", bidiNamespace, " import ", bidiModuleName, " as ", "external_bidi");
            }
            if (!GenPyCodeVisitor.this.pySrcOptions.getTranslationClass().isEmpty()) {
                Pair nameSpaceAndName = GenPyCodeVisitor.namespaceAndNameFromModule(GenPyCodeVisitor.this.pySrcOptions.getTranslationClass());
                String translationNamespace = (String)nameSpaceAndName.first;
                String translationName = (String)nameSpaceAndName.second;
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("from ", translationNamespace, " import ", translationName);
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("translator_impl", " = ", translationName, "()");
            }
        }

        private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
            TreeSet<String> calleeModules = new TreeSet<String>();
            for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
                String calleeNotInFile = node.getCalleeName();
                int lastDotIndex = calleeNotInFile.lastIndexOf(46);
                if (lastDotIndex == -1) {
                    this.errorReporter.report(node.getSourceLocation(), NON_NAMESPACED_TEMPLATE, new Object[0]);
                    continue;
                }
                String calleeModule = calleeNotInFile.substring(0, lastDotIndex);
                if (calleeModule.isEmpty()) continue;
                calleeModules.add(calleeModule);
            }
            for (String calleeModule : calleeModules) {
                Pair nameSpaceAndName = GenPyCodeVisitor.namespaceAndNameFromModule(calleeModule);
                String calleeNamespace = (String)nameSpaceAndName.first;
                String calleeName = (String)nameSpaceAndName.second;
                if (GenPyCodeVisitor.this.namespaceManifest.containsKey((Object)calleeModule)) {
                    GenPyCodeVisitor.this.pyCodeBuilder.appendLine("import ", (String)GenPyCodeVisitor.this.namespaceManifest.get((Object)calleeModule), " as ", calleeName);
                    continue;
                }
                GenPyCodeVisitor.this.pyCodeBuilder.appendLineStart(calleeName, " = runtime.namespaced_import('", calleeName, "', namespace='", calleeNamespace, "'");
                if (!GenPyCodeVisitor.this.pySrcOptions.getEnvironmentModulePath().isEmpty()) {
                    GenPyCodeVisitor.this.pyCodeBuilder.append(", environment_path='").append(GenPyCodeVisitor.this.pySrcOptions.getEnvironmentModulePath(), "'");
                }
                GenPyCodeVisitor.this.pyCodeBuilder.appendLineEnd(")");
            }
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("NAMESPACE_MANIFEST = {");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndentTwice();
            for (Map.Entry entry : GenPyCodeVisitor.this.namespaceManifest.entrySet()) {
                GenPyCodeVisitor.this.pyCodeBuilder.appendLine("'", (String)entry.getKey(), "': '", (String)entry.getValue(), "',");
            }
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndentTwice();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("}");
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
        }

        private void addCodeToFixUnicodeStrings() {
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("try:");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("str = unicode");
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("except NameError:");
            GenPyCodeVisitor.this.pyCodeBuilder.increaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("pass");
            GenPyCodeVisitor.this.pyCodeBuilder.decreaseIndent();
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine(new String[0]);
        }

        private void generateFunctionBody(TemplateNode node) {
            GenPyCodeVisitor.this.localVarExprs.pushFrame();
            GenPyCodeVisitor.this.pyCodeBuilder.pushOutputVar("output");
            this.visitChildren(node);
            PyExpr resultPyExpr = GenPyCodeVisitor.this.pyCodeBuilder.getOutputAsString();
            GenPyCodeVisitor.this.pyCodeBuilder.popOutputVar();
            resultPyExpr = PyExprUtils.wrapAsSanitizedContent(node.getContentKind(), resultPyExpr);
            GenPyCodeVisitor.this.pyCodeBuilder.appendLine("return ", resultPyExpr.getText());
            GenPyCodeVisitor.this.localVarExprs.popFrame();
        }
    }
}

