/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.types.SoyEnumType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Map;

final class SubstituteGlobalsVisitor {
    private static final SoyErrorKind UNBOUND_GLOBAL = SoyErrorKind.of("Unbound global ''{0}''.");
    private static final SoyErrorKind ENUM_MEMBERSHIP_ERROR = SoyErrorKind.of("''{0}'' is not a member of enum ''{1}''.");
    private final ImmutableMap<String, PrimitiveData> compileTimeGlobals;
    private final boolean shouldAssertNoUnboundGlobals;
    private final SoyTypeRegistry typeRegistry;
    private final SubstituteGlobalsInExprVisitor exprVisitor = new SubstituteGlobalsInExprVisitor();
    private final ErrorReporter errorReporter;

    SubstituteGlobalsVisitor(Map<String, PrimitiveData> compileTimeGlobals, SoyTypeRegistry typeRegistry, boolean shouldAssertNoUnboundGlobals, ErrorReporter errorReporter) {
        this.compileTimeGlobals = ImmutableMap.copyOf(compileTimeGlobals);
        this.typeRegistry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)typeRegistry);
        this.shouldAssertNoUnboundGlobals = shouldAssertNoUnboundGlobals;
        this.errorReporter = errorReporter;
    }

    public void exec(SoyNode soyTree) {
        SoytreeUtils.execOnAllV2Exprs(soyTree, this.exprVisitor);
    }

    @VisibleForTesting
    final class SubstituteGlobalsInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        SubstituteGlobalsInExprVisitor() {
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
            PrimitiveData value;
            PrimitiveData primitiveData = value = SubstituteGlobalsVisitor.this.compileTimeGlobals != null ? (PrimitiveData)SubstituteGlobalsVisitor.this.compileTimeGlobals.get((Object)node.getName()) : null;
            if (value == null && SubstituteGlobalsVisitor.this.typeRegistry != null) {
                value = this.getEnumValue(node);
            }
            if (value == null) {
                if (SubstituteGlobalsVisitor.this.shouldAssertNoUnboundGlobals) {
                    SubstituteGlobalsVisitor.this.errorReporter.report(node.getSourceLocation(), UNBOUND_GLOBAL, node.getName());
                }
                return;
            }
            node.getParent().replaceChild(node, InternalValueUtils.convertPrimitiveDataToExpr(value));
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildrenAllowingConcurrentModification((ExprNode.ParentExprNode)node);
            }
        }

        private PrimitiveData getEnumValue(GlobalNode node) {
            String name = node.getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot < 0) {
                return null;
            }
            String enumTypeName = name.substring(0, lastDot);
            SoyType type = SubstituteGlobalsVisitor.this.typeRegistry.getType(enumTypeName);
            if (type instanceof SoyEnumType) {
                SoyEnumType enumType = (SoyEnumType)type;
                String enumValueName = name.substring(lastDot + 1);
                Integer enumValue = enumType.getValue(enumValueName);
                if (enumValue != null) {
                    return IntegerData.forValue(enumValue.intValue());
                }
                SubstituteGlobalsVisitor.this.errorReporter.report(node.getSourceLocation(), ENUM_MEMBERSHIP_ERROR, enumValueName, enumTypeName);
            }
            return null;
        }
    }
}

