/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.html.AbstractHtmlSoyNodeVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.AliasUtils;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenDirectivePluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenFunctionPluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateToJsExprVisitor;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.passes.FindIndirectParamsVisitor;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.shared.internal.CodeBuilder;
import com.google.template.soy.shared.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.jssrc.GoogMsgDefNode;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class GenJsCodeVisitor
extends AbstractHtmlSoyNodeVisitor<List<String>> {
    private static final SoyErrorKind NON_NAMESPACED_TEMPLATE = SoyErrorKind.of("Using the option to provide/require Soy namespaces, but called template does not reside in a namespace.");
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private static final String GOOG_IS_RTL_NAMESPACE = "goog.i18n.bidi";
    private static final String GOOG_MESSAGE_FORMAT_NAMESPACE = "goog.i18n.MessageFormat";
    private final SoyJsSrcOptions jsSrcOptions;
    private final JsExprTranslator jsExprTranslator;
    protected final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    CodeBuilder<JsExpr> jsCodeBuilder;
    protected Deque<Map<String, JsExpr>> localVarTranslations;
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    GenJsCodeVisitorAssistantForMsgs assistantForMsgs;
    private GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor;
    protected TemplateRegistry templateRegistry;
    private final SoyTypeOps typeOps;
    private Set<String> alreadyRequiredNamespaces;
    protected ErrorReporter errorReporter;
    @VisibleForTesting
    protected TemplateAliases templateAliases;

    @Inject
    protected GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor, SoyTypeOps typeOps) {
        this.jsSrcOptions = jsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.genDirectivePluginRequiresVisitor = genDirectivePluginRequiresVisitor;
        this.typeOps = typeOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gen(SoyFileSetNode node, TemplateRegistry registry, ErrorReporter errorReporter) {
        this.templateRegistry = (TemplateRegistry)Preconditions.checkNotNull((Object)registry);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        try {
            this.jsFilesContents = Lists.newArrayList();
            this.jsCodeBuilder = null;
            this.localVarTranslations = null;
            this.genJsExprsVisitor = null;
            this.assistantForMsgs = null;
            this.visit(node);
            List<String> list = this.jsFilesContents;
            return list;
        }
        finally {
            this.templateRegistry = null;
            this.errorReporter = null;
        }
    }

    @Override
    @Deprecated
    public final List<String> exec(SoyNode node) {
        throw new UnsupportedOperationException();
    }

    void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(node.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList consecChildrenJsExprs = Lists.newArrayList();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChildrenJsExprs.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (!consecChildrenJsExprs.isEmpty()) {
                this.jsCodeBuilder.addToOutputVar(consecChildrenJsExprs);
                consecChildrenJsExprs.clear();
            }
            this.visit(child);
        }
        if (!consecChildrenJsExprs.isEmpty()) {
            this.jsCodeBuilder.addToOutputVar(consecChildrenJsExprs);
            consecChildrenJsExprs.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    protected CodeBuilder<JsExpr> createCodeBuilder() {
        return new JsCodeBuilder();
    }

    protected CodeBuilder<JsExpr> getJsCodeBuilder() {
        return this.jsCodeBuilder;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        this.jsCodeBuilder = this.createCodeBuilder();
        this.alreadyRequiredNamespaces = new LinkedHashSet<String>();
        this.jsCodeBuilder.appendLine("// This file was automatically generated from ", node.getFileName(), ".");
        this.jsCodeBuilder.appendLine("// Please don't edit this file by hand.");
        this.jsCodeBuilder.appendLine(new String[0]);
        this.jsCodeBuilder.appendLine("/**");
        String fileOverviewDescription = node.getNamespace() == null ? "" : " Templates in namespace " + node.getNamespace() + ".";
        this.jsCodeBuilder.appendLine(" * @fileoverview", fileOverviewDescription);
        if (node.getDelPackageName() != null) {
            this.jsCodeBuilder.appendLine(" * @modName {", node.getDelPackageName(), "}");
        }
        this.addJsDocToProvideDelTemplates(node);
        this.addJsDocToRequireDelTemplates(node);
        this.addCodeToRequireCss(node);
        this.jsCodeBuilder.appendLine(" * @public").appendLine(" */");
        this.jsCodeBuilder.appendLine(new String[0]);
        this.templateAliases = AliasUtils.IDENTITY_ALIASES;
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            this.templateAliases = AliasUtils.createTemplateAliases(node);
            this.addCodeToDeclareGoogModule(node);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireGoogModules(node);
        } else if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            this.addCodeToProvideSoyNamespace(node);
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                this.addCodeToProvideJsFunctions(node);
            }
            this.jsCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireSoyNamespaces(node);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                this.addCodeToProvideSoyNamespace(node);
            }
            this.addCodeToProvideJsFunctions(node);
            this.jsCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireJsFunctions(node);
        } else {
            this.addCodeToDefineJsNamespaces(node);
        }
        for (TemplateNode template : node.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(template);
        }
        this.jsFilesContents.add(this.jsCodeBuilder.getCode());
        this.jsCodeBuilder = null;
    }

    private void addCodeToRequireCss(SoyFileNode soyFile) {
        TreeSet requiredCssNamespaces = Sets.newTreeSet();
        requiredCssNamespaces.addAll(soyFile.getRequiredCssNamespaces());
        for (TemplateNode template : soyFile.getChildren()) {
            requiredCssNamespaces.addAll(template.getRequiredCssNamespaces());
        }
        for (String requiredCssNamespace : requiredCssNamespaces) {
            this.jsCodeBuilder.appendLine(" * @requirecss {", requiredCssNamespace, "}");
        }
    }

    private void addCodeToDefineJsNamespaces(SoyFileNode soyFile) {
        TreeSet jsNamespaces = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            String templateName = template.getTemplateName();
            Matcher dotMatcher = DOT.matcher(templateName);
            while (dotMatcher.find()) {
                jsNamespaces.add(templateName.substring(0, dotMatcher.start()));
            }
        }
        for (String jsNamespace : jsNamespaces) {
            boolean hasDot;
            boolean bl = hasDot = jsNamespace.indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !hasDot) continue;
            this.jsCodeBuilder.appendLine("if (typeof ", jsNamespace, " == 'undefined') { ", hasDot ? "" : "var ", jsNamespace, " = {}; }");
        }
    }

    private void addCodeToProvideSoyNamespace(SoyFileNode soyFile) {
        if (soyFile.getNamespace() != null) {
            this.jsCodeBuilder.appendLine("goog.provide('", soyFile.getNamespace(), "');");
        }
    }

    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace;
    }

    private void addCodeToDeclareGoogModule(SoyFileNode soyFile) {
        String exportNamespace = this.getGoogModuleNamespace(soyFile.getNamespace());
        this.jsCodeBuilder.appendLine("goog.module('", exportNamespace, "');\n");
    }

    private void addCodeToRequireGoogModules(SoyFileNode soyFile) {
        int counter = 1;
        HashSet<String> calls = new HashSet<String>();
        for (CallBasicNode callNode : SoytreeUtils.getAllNodesOfType(soyFile, CallBasicNode.class)) {
            calls.add(callNode.getCalleeName());
        }
        TreeMultimap namespaceToTemplates = TreeMultimap.create();
        for (String call : calls) {
            namespaceToTemplates.put((Object)call.substring(0, call.lastIndexOf(46)), (Object)call);
        }
        for (String namespace : namespaceToTemplates.keySet()) {
            if (namespace.equals(soyFile.getNamespace())) continue;
            String namespaceAlias = "$import" + counter++;
            String importNamespace = this.getGoogModuleNamespace(namespace);
            this.jsCodeBuilder.appendLine("var ", namespaceAlias, " = goog.require('", importNamespace, "');");
            for (String fullyQualifiedName : namespaceToTemplates.get((Object)namespace)) {
                String alias = this.templateAliases.get(fullyQualifiedName);
                String shortName = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46));
                this.jsCodeBuilder.appendLine("var ", alias, " = ", namespaceAlias, shortName, ";");
            }
        }
    }

    private void addCodeToProvideJsFunctions(SoyFileNode soyFile) {
        TreeSet templateNames = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            templateNames.add(template.getTemplateName());
        }
        for (String templateName : templateNames) {
            this.jsCodeBuilder.appendLine("goog.provide('", templateName, "');");
        }
    }

    private void addJsDocToProvideDelTemplates(SoyFileNode soyFile) {
        TreeSet delTemplateNames = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            if (!(template instanceof TemplateDelegateNode)) continue;
            delTemplateNames.add(((TemplateDelegateNode)template).getDelTemplateName());
        }
        for (String delTemplateName : delTemplateNames) {
            this.jsCodeBuilder.appendLine(" * @hassoydeltemplate {", delTemplateName, "}");
        }
    }

    private void addJsDocToRequireDelTemplates(SoyFileNode soyFile) {
        TreeSet delTemplateNames = Sets.newTreeSet();
        for (CallDelegateNode delCall : SoytreeUtils.getAllNodesOfType(soyFile, CallDelegateNode.class)) {
            delTemplateNames.add(delCall.getDelCalleeName());
        }
        for (String delTemplateName : delTemplateNames) {
            this.jsCodeBuilder.appendLine(" * @hassoydelcall {", delTemplateName, "}");
        }
    }

    protected void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        this.addGoogRequire("soy", false);
        this.addGoogRequire("soydata", false);
        Object requiredObjectTypes = ImmutableSortedSet.of();
        if (this.hasStrictParams(soyFile)) {
            requiredObjectTypes = this.getRequiredObjectTypes(soyFile);
            this.addGoogRequire("goog.asserts", true);
        }
        if (this.jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir()) {
            this.addGoogRequire(GOOG_IS_RTL_NAMESPACE, true);
        }
        if (SoytreeUtils.hasNodesOfType(soyFile, MsgPluralNode.class, MsgSelectNode.class)) {
            this.addGoogRequire(GOOG_MESSAGE_FORMAT_NAMESPACE, false);
        }
        if (SoytreeUtils.hasNodesOfType(soyFile, XidNode.class)) {
            this.addGoogRequire("xid", false);
        }
        TreeSet pluginRequiredJsLibNames = Sets.newTreeSet();
        pluginRequiredJsLibNames.addAll(this.genDirectivePluginRequiresVisitor.exec(soyFile));
        pluginRequiredJsLibNames.addAll(new GenFunctionPluginRequiresVisitor().exec(soyFile));
        for (String namespace : pluginRequiredJsLibNames) {
            this.addGoogRequire(namespace, false);
        }
        if (!requiredObjectTypes.isEmpty()) {
            this.jsCodeBuilder.appendLine(new String[0]);
            Iterator iterator = requiredObjectTypes.iterator();
            while (iterator.hasNext()) {
                String requiredType = (String)iterator.next();
                this.addGoogRequire(requiredType, false);
            }
        }
    }

    private void addGoogRequire(String namespace, boolean suppressExtra) {
        if (!this.alreadyRequiredNamespaces.contains(namespace)) {
            if (suppressExtra) {
                this.jsCodeBuilder.appendLine("/** @suppress {extraRequire} */");
            }
            this.jsCodeBuilder.appendLine("goog.require('" + namespace + "');");
            this.alreadyRequiredNamespaces.add(namespace);
        }
    }

    protected void addCodeToRequireGoogModuleDeps(SoyFileNode soyFile) {
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        String prevCalleeNamespace = null;
        TreeSet calleeNamespaces = Sets.newTreeSet();
        for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            String calleeNotInFile = node.getCalleeName();
            int lastDotIndex = calleeNotInFile.lastIndexOf(46);
            if (lastDotIndex == -1) {
                this.errorReporter.report(node.getSourceLocation(), NON_NAMESPACED_TEMPLATE, new Object[0]);
                continue;
            }
            calleeNamespaces.add(calleeNotInFile.substring(0, lastDotIndex));
        }
        for (String calleeNamespace : calleeNamespaces) {
            if (calleeNamespace.length() <= 0 || calleeNamespace.equals(prevCalleeNamespace)) continue;
            this.addGoogRequire(calleeNamespace, false);
            prevCalleeNamespace = calleeNamespace;
        }
    }

    private void addCodeToRequireJsFunctions(SoyFileNode soyFile) {
        TreeSet<String> requires = new TreeSet<String>();
        for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            requires.add(node.getCalleeName());
        }
        for (String require : requires) {
            this.addGoogRequire(require, false);
        }
    }

    protected String getTemplateReturnType(TemplateNode node) {
        return node.getContentKind() == null ? "string" : "!" + NodeContentKinds.toJsSanitizedContentCtorName(node.getContentKind());
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        boolean useStrongTyping = this.hasStrictParams(node);
        String templateName = node.getTemplateName();
        String partialName = node.getPartialTemplateName();
        String alias = this.templateAliases.get(templateName);
        boolean addToExports = this.jsSrcOptions.shouldGenerateGoogModules();
        this.localVarTranslations = new ArrayDeque<Map<String, JsExpr>>();
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations, this.templateAliases, this.errorReporter);
        this.assistantForMsgs = null;
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            if (useStrongTyping) {
                this.genParamsRecordType(node);
            } else {
                this.jsCodeBuilder.appendLine(" * @param {Object<string, *>=} opt_data");
            }
            this.jsCodeBuilder.appendLine(" * @param {(null|undefined)=} opt_ignored");
            this.jsCodeBuilder.appendLine(" * @param {Object<string, *>=} opt_ijData");
            String returnType = this.getTemplateReturnType(node);
            this.jsCodeBuilder.appendLine(" * @return {", returnType, "}");
            String suppressions = "checkTypes";
            this.jsCodeBuilder.appendLine(" * @suppress {" + suppressions + "}");
            if (node.getVisibility() == Visibility.PRIVATE) {
                this.jsCodeBuilder.appendLine(" * @private");
            }
            this.jsCodeBuilder.appendLine(" */");
        }
        if (addToExports) {
            this.jsCodeBuilder.appendLine("function ", alias, "(opt_data, opt_ignored, opt_ijData) {");
        } else {
            this.jsCodeBuilder.appendLine(alias, " = function(opt_data, opt_ignored, opt_ijData) {");
        }
        this.jsCodeBuilder.increaseIndent();
        if (!SoytreeUtils.getAllNodesOfType(node, OperatorNodes.NullCoalescingOpNode.class).isEmpty() || !SoytreeUtils.getAllNodesOfType(node, SwitchNode.class).isEmpty()) {
            this.jsCodeBuilder.appendLine("var $$temp;");
        }
        if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            this.jsCodeBuilder.appendLine("opt_data = opt_data || {};");
        }
        this.generateFunctionBody(node);
        this.jsCodeBuilder.decreaseIndent();
        if (addToExports) {
            this.jsCodeBuilder.appendLine("}");
            this.jsCodeBuilder.appendLine("exports.", partialName.substring(1), " = ", alias, ";");
        } else {
            this.jsCodeBuilder.appendLine("};");
        }
        this.jsCodeBuilder.appendLine("if (goog.DEBUG) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine(alias + ".soyTemplateName = '" + templateName + "';");
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
        if (node instanceof TemplateDelegateNode) {
            TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
            String delTemplateIdExprText = "soy.$$getDelTemplateId('" + nodeAsDelTemplate.getDelTemplateName() + "')";
            String delTemplateVariantExprText = "'" + nodeAsDelTemplate.getDelTemplateVariant() + "'";
            this.jsCodeBuilder.appendLine("soy.$$registerDelegateFn(", delTemplateIdExprText, ", ", delTemplateVariantExprText, ", ", nodeAsDelTemplate.getDelPriority().toString(), ", ", nodeAsDelTemplate.getTemplateName(), ");");
        }
    }

    protected void generateFunctionBody(TemplateNode node) {
        JsExpr resultJsExpr;
        this.localVarTranslations.push(Maps.newHashMap());
        this.genParamTypeChecks(node);
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<JsExpr> templateBodyJsExprs = this.genJsExprsVisitor.exec(node);
            resultJsExpr = node.getContentKind() == null ? JsExprUtils.concatJsExprsForceString(templateBodyJsExprs) : JsExprUtils.concatJsExprs(templateBodyJsExprs);
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            this.visitChildren(node);
            resultJsExpr = new JsExpr("output", Integer.MAX_VALUE);
            this.jsCodeBuilder.popOutputVar();
        }
        if (node.getContentKind() != null) {
            resultJsExpr = JsExprUtils.maybeWrapAsSanitizedContent(node.getContentKind(), resultJsExpr);
        }
        this.jsCodeBuilder.appendLine("return ", resultJsExpr.getText(), ";");
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitGoogMsgDefNode(GoogMsgDefNode node) {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new GenJsCodeVisitorAssistantForMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.jsCodeBuilder, this.localVarTranslations, this.templateAliases, this.genJsExprsVisitor, this.errorReporter);
        }
        this.assistantForMsgs.visitForUseByMaster(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        JsExpr valueJsExpr = this.jsExprTranslator.translateToJsExpr(node.getValueExpr(), this.localVarTranslations, this.errorReporter);
        this.jsCodeBuilder.appendLine("var ", generatedVarName, " = ", valueJsExpr.getText(), ";");
        this.localVarTranslations.peek().put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar(generatedVarName);
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
        if (node.getContentKind() != null) {
            String sanitizedContentOrdainer = NodeContentKinds.toJsSanitizedContentOrdainerForInternalBlocks(node.getContentKind());
            this.jsCodeBuilder.appendLine(generatedVarName, " = ", sanitizedContentOrdainer, "(", generatedVarName, ");");
        }
        this.localVarTranslations.peek().put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
            return;
        }
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                JsExpr condJsExpr = this.jsExprTranslator.translateToJsExpr(icn.getExprUnion(), this.localVarTranslations, this.errorReporter);
                if (icn.getCommandName().equals("if")) {
                    this.jsCodeBuilder.appendLine("if (", condJsExpr.getText(), ") {");
                } else {
                    this.jsCodeBuilder.appendLine("} else if (", condJsExpr.getText(), ") {");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(icn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof IfElseNode) {
                IfElseNode ien = (IfElseNode)child;
                this.jsCodeBuilder.appendLine("} else {");
                this.jsCodeBuilder.increaseIndent();
                this.visit(ien);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        String switchExpr = this.coerceTypeForSwitchComparison(node.getExpr(), node.getExprText());
        this.jsCodeBuilder.appendLine("switch (", switchExpr, ") {");
        this.jsCodeBuilder.increaseIndent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprNode exprNode : scn.getExprList()) {
                    JsExpr caseJsExpr = this.jsExprTranslator.translateToJsExpr(exprNode, this.localVarTranslations, this.errorReporter);
                    this.jsCodeBuilder.appendLine("case ", caseJsExpr.getText(), ":");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(scn);
                this.jsCodeBuilder.appendLine("break;");
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.jsCodeBuilder.appendLine("default:");
                this.jsCodeBuilder.increaseIndent();
                this.visit(sdn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    private String coerceTypeForSwitchComparison(@Nullable ExprRootNode v2Expr, @Nullable String v1Expr) {
        String jsExpr = this.jsExprTranslator.translateToJsExpr(v2Expr, v1Expr, this.localVarTranslations, this.errorReporter).getText();
        if (v2Expr != null) {
            SoyType type = v2Expr.getType();
            if (SoyTypes.makeNullable(StringType.getInstance()).isAssignableFrom(type) || type.equals(AnyType.getInstance()) || type.equals(UnknownType.getInstance())) {
                return "(goog.isObject($$temp = " + jsExpr + ")) ? $$temp.toString() : $$temp";
            }
            return jsExpr;
        }
        return jsExpr;
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfemptyNode;
        ForeachNonemptyNode nonEmptyNode = (ForeachNonemptyNode)node.getChild(0);
        String baseVarName = nonEmptyNode.getVarName();
        String nodeId = Integer.toString(node.getId());
        String listVarName = baseVarName + "List" + nodeId;
        String listLenVarName = baseVarName + "ListLen" + nodeId;
        JsExpr dataRefJsExpr = this.jsExprTranslator.translateToJsExpr(node.getExpr(), node.getExprText(), this.localVarTranslations, this.errorReporter);
        this.jsCodeBuilder.appendLine("var ", listVarName, " = ", dataRefJsExpr.getText(), ";");
        this.jsCodeBuilder.appendLine("var ", listLenVarName, " = ", listVarName, ".length;");
        boolean bl = hasIfemptyNode = node.numChildren() == 2;
        if (hasIfemptyNode) {
            this.jsCodeBuilder.appendLine("if (", listLenVarName, " > 0) {");
            this.jsCodeBuilder.increaseIndent();
        }
        this.visit(nonEmptyNode);
        if (hasIfemptyNode) {
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("} else {");
            this.jsCodeBuilder.increaseIndent();
            this.visit(node.getChild(1));
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String baseVarName = node.getVarName();
        String foreachNodeId = Integer.toString(node.getForeachNodeId());
        String listVarName = baseVarName + "List" + foreachNodeId;
        String listLenVarName = baseVarName + "ListLen" + foreachNodeId;
        String indexVarName = baseVarName + "Index" + foreachNodeId;
        String dataVarName = baseVarName + "Data" + foreachNodeId;
        this.jsCodeBuilder.appendLine("for (var ", indexVarName, " = 0; ", indexVarName, " < ", listLenVarName, "; ", indexVarName, "++) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("var ", dataVarName, " = ", listVarName, "[", indexVarName, "];");
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(baseVarName, new JsExpr(dataVarName, Integer.MAX_VALUE));
        newLocalVarTranslationsFrame.put(baseVarName + "__isFirst", new JsExpr(indexVarName + " == 0", Operator.EQUAL.getPrecedence()));
        newLocalVarTranslationsFrame.put(baseVarName + "__isLast", new JsExpr(indexVarName + " == " + listLenVarName + " - 1", Operator.EQUAL.getPrecedence()));
        newLocalVarTranslationsFrame.put(baseVarName + "__index", new JsExpr(indexVarName, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForNode(ForNode node) {
        String incrementCode;
        String limitCode;
        String initCode;
        String varName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        ForNode.RangeArgs range = node.getRangeArgs();
        String incrementJsExprText = range.increment().isPresent() ? this.jsExprTranslator.translateToJsExpr((ExprNode)range.increment().get(), this.localVarTranslations, this.errorReporter).getText() : "1";
        String initJsExprText = range.start().isPresent() ? this.jsExprTranslator.translateToJsExpr((ExprNode)range.start().get(), this.localVarTranslations, this.errorReporter).getText() : "0";
        String limitJsExprText = this.jsExprTranslator.translateToJsExpr(range.limit(), this.localVarTranslations, this.errorReporter).getText();
        if (INTEGER.matcher(initJsExprText).matches()) {
            initCode = initJsExprText;
        } else {
            initCode = varName + "Init" + nodeId;
            this.jsCodeBuilder.appendLine("var ", initCode, " = ", initJsExprText, ";");
        }
        if (INTEGER.matcher(limitJsExprText).matches()) {
            limitCode = limitJsExprText;
        } else {
            limitCode = varName + "Limit" + nodeId;
            this.jsCodeBuilder.appendLine("var ", limitCode, " = ", limitJsExprText, ";");
        }
        if (INTEGER.matcher(incrementJsExprText).matches()) {
            incrementCode = incrementJsExprText;
        } else {
            incrementCode = varName + "Increment" + nodeId;
            this.jsCodeBuilder.appendLine("var ", incrementCode, " = ", incrementJsExprText, ";");
        }
        String incrementStmt = incrementCode.equals("1") ? varName + nodeId + "++" : varName + nodeId + " += " + incrementCode;
        this.jsCodeBuilder.appendLine("for (var ", varName, nodeId, " = ", initCode, "; ", varName, nodeId, " < ", limitCode, "; ", incrementStmt, ") {");
        this.jsCodeBuilder.increaseIndent();
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(varName, new JsExpr(varName + nodeId, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        JsExpr callExpr = this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations, this.templateAliases, this.errorReporter);
        this.jsCodeBuilder.addToOutputVar((List<JsExpr>)ImmutableList.of((Object)callExpr));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        if (this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            List<JsExpr> logMsgJsExprs = this.genJsExprsVisitor.execOnChildren(node);
            JsExpr logMsgJsExpr = JsExprUtils.concatJsExprs(logMsgJsExprs);
            this.jsCodeBuilder.appendLine("window.console.log(", logMsgJsExpr.getText(), ");");
        } else {
            this.localVarTranslations.push(Maps.newHashMap());
            this.jsCodeBuilder.pushOutputVar("logMsg_s" + node.getId());
            this.visitChildren(node);
            this.jsCodeBuilder.popOutputVar();
            this.localVarTranslations.pop();
            this.jsCodeBuilder.appendLine("window.console.log(logMsg_s", Integer.toString(node.getId()), ");");
        }
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
        this.jsCodeBuilder.appendLine("debugger;");
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.localVarTranslations.push(Maps.newHashMap());
                this.visitChildren((SoyNode.BlockNode)node);
                this.localVarTranslations.pop();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    private void genParamsRecordType(TemplateNode node) {
        HashSet paramNames = Sets.newHashSet();
        StringBuilder sb = new StringBuilder();
        sb.append(" * @param {{");
        boolean first = true;
        for (TemplateParam param : node.getParams()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("\n *    ");
            sb.append(this.genParamAlias(param.name()));
            sb.append(": ");
            String jsType = this.genParamTypeExpr(param.type());
            if (jsType.equals("?")) {
                jsType = "(?)";
            }
            sb.append(jsType);
            paramNames.add(param.name());
        }
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        if (!ipi.mayHaveIndirectParamsInExternalCalls && !ipi.mayHaveIndirectParamsInExternalDelCalls) {
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramNames.contains(indirectParamName)) continue;
                Collection paramTypes = ipi.indirectParamTypes.get((Object)indirectParamName);
                SoyType combinedType = this.typeOps.computeLowestCommonType(paramTypes);
                SoyType indirectParamType = this.typeOps.getTypeRegistry().getOrCreateUnionType(combinedType, NullType.getInstance());
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("\n *    ");
                sb.append(this.genParamAlias(indirectParamName));
                sb.append(": ");
                sb.append(this.genParamTypeExpr(indirectParamType));
            }
        }
        sb.append("\n * }} opt_data");
        this.jsCodeBuilder.appendLine(sb.toString());
    }

    private String genParamTypeExpr(SoyType type) {
        return JsSrcUtils.getJsTypeExpr(type, true, true);
    }

    protected void genParamTypeChecks(TemplateNode node) {
        for (TemplateParam param : node.getAllParams()) {
            if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
            String paramName = param.name();
            SoyType paramType = param.type();
            String paramVal = TranslateToJsExprVisitor.genCodeForParamAccess(paramName, param.isInjected(), paramType);
            String paramAlias = this.genParamAlias(paramName);
            boolean isAliasedLocalVar = false;
            switch (paramType.getKind()) {
                case ANY: 
                case UNKNOWN: {
                    break;
                }
                case STRING: {
                    this.genParamTypeChecksUsingGeneralAssert(paramName, paramAlias, paramVal, param.isInjected(), paramType, "goog.isString({0}) || ({0} instanceof goog.soy.data.SanitizedContent)", "string|goog.soy.data.SanitizedContent");
                    isAliasedLocalVar = true;
                    break;
                }
                case BOOL: {
                    this.genParamTypeChecksUsingGeneralAssert(paramName, paramAlias, "!!" + paramVal, param.isInjected(), paramType, "goog.isBoolean({0}) || {0} === 1 || {0} === 0", "boolean");
                    isAliasedLocalVar = true;
                    break;
                }
                case INT: 
                case FLOAT: 
                case LIST: 
                case RECORD: 
                case MAP: {
                    String assertionFunction = null;
                    switch (param.type().getKind()) {
                        case INT: 
                        case FLOAT: {
                            assertionFunction = "goog.asserts.assertNumber";
                            break;
                        }
                        case LIST: {
                            assertionFunction = "goog.asserts.assertArray";
                            break;
                        }
                        case RECORD: 
                        case MAP: {
                            assertionFunction = "goog.asserts.assertObject";
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    this.jsCodeBuilder.appendLine("var " + paramAlias + " = " + assertionFunction + "(" + paramVal + ", \"expected parameter '" + paramName + "' of type " + param.type() + ".\");");
                    isAliasedLocalVar = true;
                    break;
                }
                case OBJECT: {
                    if (param.type() instanceof SoyProtoType) {
                        paramVal = this.extractProtoFromMap(paramVal);
                    }
                    this.jsCodeBuilder.appendLine("var " + paramName + " = goog.asserts.assertInstanceof(" + paramVal + ", " + JsSrcUtils.getJsTypeName(param.type()) + ", \"expected parameter '" + paramName + "' of type " + JsSrcUtils.getJsTypeName(param.type()) + ".\");");
                    isAliasedLocalVar = true;
                    break;
                }
                case ENUM: {
                    this.jsCodeBuilder.appendLine("var " + paramAlias + " = goog.asserts.assertNumber(" + paramVal + ", \"expected param '" + paramName + "' of type " + param.type() + ".\");");
                    isAliasedLocalVar = true;
                    break;
                }
                case UNION: {
                    UnionType unionType = (UnionType)param.type();
                    if (this.containsProtoObjectType(unionType)) {
                        paramVal = this.extractProtoFromMap(paramVal);
                    }
                    this.genParamTypeChecksUsingGeneralAssert(paramName, paramAlias, paramVal, param.isInjected(), paramType, this.genUnionTypeTests(unionType), JsSrcUtils.getJsTypeExpr(param.type(), false, false));
                    isAliasedLocalVar = true;
                    break;
                }
                default: {
                    if (param.type() instanceof SanitizedType) {
                        String typeName = JsSrcUtils.getJsTypeName(param.type());
                        this.genParamTypeChecksUsingGeneralAssert(paramName, paramAlias, paramVal, param.isInjected(), paramType, "({0} instanceof " + typeName + ") || ({0} instanceof soydata.UnsanitizedText) || goog.isString({0})", typeName);
                        isAliasedLocalVar = true;
                        break;
                    }
                    throw new AssertionError((Object)("Unsupported type: " + param.type()));
                }
            }
            if (!isAliasedLocalVar) continue;
            this.localVarTranslations.peek().put(paramName, new JsExpr(paramAlias, Integer.MAX_VALUE));
        }
    }

    private String genUnionTypeTests(UnionType unionType) {
        TreeSet typeTests = Sets.newTreeSet();
        boolean hasNumber = false;
        block10: for (SoyType memberType : unionType.getMembers()) {
            switch (memberType.getKind()) {
                case ANY: 
                case UNKNOWN: {
                    typeTests.add("{0} != null");
                    continue block10;
                }
                case NULL: {
                    continue block10;
                }
                case BOOL: {
                    typeTests.add("goog.isBoolean({0}) || {0} === 1 || {0} === 0");
                    continue block10;
                }
                case STRING: {
                    typeTests.add("goog.isString({0})");
                    typeTests.add("({0} instanceof goog.soy.data.SanitizedContent)");
                    continue block10;
                }
                case INT: 
                case FLOAT: 
                case ENUM: {
                    if (hasNumber) continue block10;
                    typeTests.add("goog.isNumber({0})");
                    hasNumber = true;
                    continue block10;
                }
                case LIST: {
                    typeTests.add("goog.isArray({0})");
                    continue block10;
                }
                case RECORD: 
                case MAP: {
                    typeTests.add("goog.isObject({0})");
                    continue block10;
                }
                case OBJECT: {
                    String jsType = JsSrcUtils.getJsTypeName(memberType);
                    if (memberType instanceof SoyProtoType) {
                        if (unionType.isNullable()) {
                            typeTests.add("(({0}.$jspbMessageInstance || {0}) instanceof " + jsType + ")");
                            continue block10;
                        }
                        typeTests.add(this.extractProtoFromMap("{0}"));
                        continue block10;
                    }
                    typeTests.add("({0} instanceof " + jsType + ")");
                    continue block10;
                }
            }
            if (memberType instanceof SanitizedType) {
                typeTests.add("({0} instanceof " + JsSrcUtils.getJsTypeName(memberType) + ")");
                typeTests.add("({0} instanceof soydata.UnsanitizedText)");
                typeTests.add("goog.isString({0})");
                continue;
            }
            throw new AssertionError((Object)("Unsupported union member type: " + memberType));
        }
        String result = Joiner.on((String)" || ").join((Iterable)typeTests);
        if (unionType.isNullable()) {
            result = "{0} == null || " + result;
        }
        return result;
    }

    private void genParamTypeChecksUsingGeneralAssert(String paramName, String paramAlias, String paramVal, boolean isInjected, SoyType paramType, String typePredicate, String jsDocTypeExpr) {
        String paramAccessVal = TranslateToJsExprVisitor.genCodeForParamAccess(paramName, isInjected, paramType);
        this.jsCodeBuilder.appendLine("soy.asserts.assertType(" + MessageFormat.format(typePredicate, paramAccessVal) + ", '" + paramName + "', " + paramAccessVal + ", " + "'" + jsDocTypeExpr + "');");
        this.jsCodeBuilder.appendLine("var " + paramAlias + " = /** @type {" + jsDocTypeExpr + "} */ (" + paramVal + ");");
    }

    private String genParamAlias(String paramName) {
        return JsSrcUtils.isReservedWord(paramName) ? "param$" + paramName : paramName;
    }

    private String extractProtoFromMap(String mapVal) {
        return "(" + mapVal + " && " + mapVal + ".$jspbMessageInstance || " + mapVal + ")";
    }

    private boolean containsProtoObjectType(UnionType unionType) {
        for (SoyType memberType : unionType.getMembers()) {
            if (memberType.getKind() != SoyType.Kind.OBJECT || !(memberType instanceof SoyProtoType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStrictParams(SoyFileNode soyFile) {
        for (TemplateNode template : soyFile.getChildren()) {
            if (!this.hasStrictParams(template)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStrictParams(TemplateNode template) {
        for (TemplateParam param : template.getParams()) {
            if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
            return true;
        }
        return false;
    }

    private SortedSet<String> getRequiredObjectTypes(SoyFileNode soyFile) {
        TreeSet requiredObjectTypes = Sets.newTreeSet();
        FieldImportsVisitor fieldImportsVisitor = new FieldImportsVisitor(requiredObjectTypes);
        for (TemplateNode template : soyFile.getChildren()) {
            SoytreeUtils.execOnAllV2Exprs(template, fieldImportsVisitor);
            for (TemplateParam param : template.getAllParams()) {
                if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
                if (param.type().getKind() == SoyType.Kind.OBJECT) {
                    requiredObjectTypes.add(JsSrcUtils.getJsTypeName(param.type()));
                    continue;
                }
                if (param.type().getKind() != SoyType.Kind.UNION) continue;
                UnionType union = (UnionType)param.type();
                for (SoyType memberType : union.getMembers()) {
                    if (memberType.getKind() != SoyType.Kind.OBJECT) continue;
                    requiredObjectTypes.add(JsSrcUtils.getJsTypeName(memberType));
                }
            }
        }
        return requiredObjectTypes;
    }

    private static final class FieldImportsVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final SortedSet<String> imports;

        FieldImportsVisitor(SortedSet<String> imports) {
            this.imports = imports;
        }

        @Override
        public Void exec(ExprNode node) {
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            SoyType baseType = node.getBaseExprChild().getType();
            this.extractImportsFromType(baseType, node.getFieldName(), SoyBackendKind.JS_SRC);
            this.visit(node.getBaseExprChild());
        }

        private void extractImportsFromType(SoyType baseType, String fieldName, SoyBackendKind backendKind) {
            if (baseType instanceof SoyObjectType) {
                ImmutableSet<String> importedSymbols = ((SoyObjectType)baseType).getFieldAccessImports(fieldName, backendKind);
                this.imports.addAll((Collection<String>)importedSymbols);
            } else if (baseType instanceof UnionType) {
                for (SoyType memberBaseType : ((UnionType)baseType).getMembers()) {
                    this.extractImportsFromType(memberBaseType, fieldName, backendKind);
                }
            }
        }
    }
}

