/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.AdvisingStringBuilder;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class Runtime {
    public static final SoyValueProvider NULL_PROVIDER = new SoyValueProvider(){

        @Override
        public RenderResult status() {
            return RenderResult.done();
        }

        @Override
        public SoyValue resolve() {
            return null;
        }

        @Override
        public RenderResult renderAndResolve(AdvisingAppendable appendable, boolean isLast) throws IOException {
            appendable.append("null");
            return RenderResult.done();
        }

        public String toString() {
            return "NULL_PROVIDER";
        }
    };
    private static final AdvisingAppendable LOGGER = new AdvisingAppendable(){

        @Override
        public boolean softLimitReached() {
            return false;
        }

        @Override
        public AdvisingAppendable append(char c) throws IOException {
            System.out.append(c);
            return this;
        }

        @Override
        public AdvisingAppendable append(CharSequence csq, int start, int end) {
            System.out.append(csq, start, end);
            return this;
        }

        @Override
        public AdvisingAppendable append(CharSequence csq) {
            System.out.append(csq);
            return this;
        }
    };

    public static AssertionError unexpectedStateError(int state) {
        return new AssertionError((Object)("Unexpected state requested: " + state));
    }

    public static boolean stringEqualsAsNumber(String expr, double number) {
        try {
            return Double.parseDouble(expr) == number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static SoyValue resolveSoyValueProvider(SoyValueProvider provider) {
        SoyValue value = provider.resolve();
        if (value instanceof NullData) {
            return null;
        }
        return value;
    }

    public static SoyValueProvider getFieldProvider(SoyRecord record, String field) {
        if (record == null) {
            throw new NullPointerException("Attempted to access field '" + field + "' of null");
        }
        SoyValueProvider provider = record.getFieldProvider(field);
        return provider == null | provider instanceof NullData ? NULL_PROVIDER : provider;
    }

    public static SoyValue callSoyFunction(SoyJavaFunction function, List<SoyValue> args) {
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return function.computeForJava(args);
    }

    public static SoyValue applyPrintDirective(SoyJavaPrintDirective directive, SoyValue value, List<SoyValue> args) {
        value = value == null ? NullData.INSTANCE : value;
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return directive.applyForJava(value, args);
    }

    public static CompiledTemplate applyEscapers(final CompiledTemplate delegate, final List<SoyJavaPrintDirective> directives, final @Nullable SanitizedContent.ContentKind kind) {
        return new CompiledTemplate(){
            final AdvisingStringBuilder buffer = new AdvisingStringBuilder();

            @Override
            public RenderResult render(AdvisingAppendable appendable, RenderContext context) throws IOException {
                RenderResult result = delegate.render(this.buffer, context);
                if (result.isDone()) {
                    SoyValue resultData = kind == null ? StringData.forValue(this.buffer.toString()) : UnsafeSanitizedContentOrdainer.ordainAsSafe(this.buffer.toString(), kind);
                    for (SoyJavaPrintDirective directive : directives) {
                        resultData = directive.applyForJava(resultData, (List<SoyValue>)ImmutableList.of());
                    }
                    appendable.append(resultData.coerceToString());
                }
                return result;
            }
        };
    }

    public static SoyValueProvider getSoyListItem(List<SoyValueProvider> list, long index) {
        if (list == null) {
            throw new NullPointerException("Attempted to access list item '" + index + "' of null");
        }
        int size = list.size();
        if (index < (long)size & index >= 0L) {
            SoyValueProvider soyValueProvider = list.get((int)index);
            return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
        }
        return NULL_PROVIDER;
    }

    public static SoyValueProvider getSoyMapItem(SoyMap soyMap, SoyValue key) {
        if (soyMap == null) {
            throw new NullPointerException("Attempted to access map item '" + key + "' of null");
        }
        SoyValueProvider soyValueProvider = soyMap.getItemProvider(key);
        return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static void renderSoyMsgWithPlaceholders(SoyMsg msg, Map<String, Object> placeholders, Appendable out) throws IOException {
        if (msg.getParts().isEmpty()) {
            return;
        }
        SoyMsgPart firstPart = (SoyMsgPart)msg.getParts().get(0);
        if (firstPart instanceof SoyMsgPluralPart) {
            Runtime.renderPlural(msg, (SoyMsgPluralPart)firstPart, placeholders, out);
        } else if (firstPart instanceof SoyMsgSelectPart) {
            Runtime.renderSelect(msg, (SoyMsgSelectPart)firstPart, placeholders, out);
        } else {
            for (SoyMsgPart msgPart : msg.getParts()) {
                if (msgPart instanceof SoyMsgRawTextPart) {
                    Runtime.writeRawText((SoyMsgRawTextPart)msgPart, out);
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    Runtime.writePlaceholder((SoyMsgPlaceholderPart)msgPart, placeholders, out);
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + msgPart));
            }
        }
    }

    private static void renderSelect(SoyMsg msg, SoyMsgSelectPart firstPart, Map<String, Object> placeholders, Appendable out) throws IOException {
        String selectCase = Runtime.getSelectCase(placeholders, firstPart.getSelectVarName());
        for (SoyMsgPart casePart : firstPart.lookupCase(selectCase)) {
            if (casePart instanceof SoyMsgSelectPart) {
                Runtime.renderSelect(msg, (SoyMsgSelectPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgPluralPart) {
                Runtime.renderPlural(msg, (SoyMsgPluralPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgPlaceholderPart) {
                Runtime.writePlaceholder((SoyMsgPlaceholderPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgRawTextPart) {
                Runtime.writeRawText((SoyMsgRawTextPart)casePart, out);
                continue;
            }
            throw new AssertionError((Object)("unexpected part: " + casePart));
        }
    }

    private static void renderPlural(SoyMsg msg, SoyMsgPluralPart plural, Map<String, Object> placeholders, Appendable out) throws IOException {
        int pluralValue = Runtime.getPlural(placeholders, plural.getPluralVarName());
        for (SoyMsgPart casePart : plural.lookupCase(pluralValue, msg.getLocale())) {
            if (casePart instanceof SoyMsgPlaceholderPart) {
                Runtime.writePlaceholder((SoyMsgPlaceholderPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgRawTextPart) {
                Runtime.writeRawText((SoyMsgRawTextPart)casePart, out);
                continue;
            }
            if (casePart instanceof SoyMsgPluralRemainderPart) {
                out.append(String.valueOf(pluralValue - plural.getOffset()));
                continue;
            }
            throw new AssertionError((Object)("unexpected part: " + casePart));
        }
    }

    private static String getSelectCase(Map<String, Object> placeholders, String selectVarName) {
        String selectCase = (String)placeholders.get(selectVarName);
        if (selectCase == null) {
            throw new IllegalArgumentException("No value provided for select: '" + selectVarName + "'");
        }
        return selectCase;
    }

    private static int getPlural(Map<String, Object> placeholders, String pluralVarName) {
        IntegerData pluralValue = (IntegerData)placeholders.get(pluralVarName);
        if (pluralValue == null) {
            throw new IllegalArgumentException("No value provided for plural: '" + pluralVarName + "'");
        }
        return pluralValue.integerValue();
    }

    private static void writePlaceholder(SoyMsgPlaceholderPart placeholder, Map<String, Object> placeholders, Appendable out) throws IOException {
        String placeholderName = placeholder.getPlaceholderName();
        String str = (String)placeholders.get(placeholderName);
        if (str == null) {
            throw new IllegalArgumentException("No value provided for placeholder: '" + placeholderName + "'");
        }
        out.append(str);
    }

    private static void writeRawText(SoyMsgRawTextPart msgPart, Appendable out) throws IOException {
        out.append(msgPart.getRawText());
    }

    public static AdvisingAppendable logger() {
        return LOGGER;
    }

    public static boolean coerceToBoolean(double v) {
        return v != 0.0 & v == v;
    }

    public static String coerceToString(@Nullable SoyValue v) {
        return v == null ? "null" : v.coerceToString();
    }
}

