/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Joiner;
import com.google.template.soy.base.SourceLocation;
import java.util.ArrayDeque;

final class UnexpectedCompilerFailureException
extends RuntimeException {
    private final ArrayDeque<SourceLocation> compilationPath = new ArrayDeque();

    UnexpectedCompilerFailureException(SourceLocation original, Throwable cause) {
        super("unexpected compile failure", cause, false, false);
        this.compilationPath.add(original);
    }

    void addLocation(SourceLocation sourceLocation) {
        this.compilationPath.add(sourceLocation);
    }

    SourceLocation getOriginalLocation() {
        return this.compilationPath.getFirst();
    }

    String printSoyStack() {
        return Joiner.on((char)'\n').join(this.compilationPath);
    }
}

