/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.BytecodeProducer;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import java.io.IOException;
import java.util.Arrays;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

abstract class Statement
extends BytecodeProducer {
    private static final Type[] IO_EXCEPTION_ARRAY = new Type[]{Type.getType(IOException.class)};
    static final Statement NULL_STATEMENT = new Statement(){

        @Override
        void doGen(CodeBuilder adapter) {
        }
    };
    static final Statement RETURN = new Statement(){

        @Override
        void doGen(CodeBuilder adapter) {
            adapter.returnValue();
        }
    };

    static Statement returnExpression(final Expression expression) {
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                expression.gen(adapter);
                adapter.returnValue();
            }
        };
    }

    static Statement throwExpression(final Expression expression) {
        expression.checkAssignableTo(BytecodeUtils.THROWABLE_TYPE);
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                expression.gen(adapter);
                adapter.throwException();
            }
        };
    }

    static Statement concat(Statement ... statements) {
        return Statement.concat(Arrays.asList(statements));
    }

    static Statement concat(final Iterable<? extends Statement> statements) {
        Preconditions.checkNotNull(statements);
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                for (Statement statement : statements) {
                    statement.gen(adapter);
                }
            }
        };
    }

    Statement() {
    }

    Statement(SourceLocation location) {
        super(location);
    }

    final void writeMethod(int access, Method method, ClassVisitor visitor) {
        this.writeMethodTo(new CodeBuilder(access, method, null, visitor));
    }

    final void writeIOExceptionMethod(int access, Method method, ClassVisitor visitor) {
        this.writeMethodTo(new CodeBuilder(access, method, IO_EXCEPTION_ARRAY, visitor));
    }

    private final void writeMethodTo(CodeBuilder builder) {
        builder.visitCode();
        this.gen(builder);
        try {
            builder.endMethod();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to generate method:\n" + this, t);
        }
    }

    final Statement labelStart(final Label label) {
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                adapter.mark(label);
                Statement.this.gen(adapter);
            }
        };
    }

    final Statement withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        return new Statement(location){

            @Override
            void doGen(CodeBuilder adapter) {
                Statement.this.gen(adapter);
            }
        };
    }

    public String toString() {
        return "Statement:\n" + this.trace();
    }
}

