/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.HashMap;
import javax.annotation.Nullable;

final class CompiledTemplateRegistry {
    private final ImmutableBiMap<String, CompiledTemplateMetadata> templateNameToMetadata;
    private final ImmutableBiMap<String, CompiledTemplateMetadata> classNameToMetadata;
    private final ImmutableMap<String, SanitizedContent.ContentKind> deltemplateNameToContentKind;
    private final ImmutableSet<String> delegateTemplateNames;

    CompiledTemplateRegistry(TemplateRegistry registry) {
        HashMap<String, SanitizedContent.ContentKind> deltemplateNameToContentKind = new HashMap<String, SanitizedContent.ContentKind>();
        ImmutableBiMap.Builder templateToMetadata = ImmutableBiMap.builder();
        ImmutableBiMap.Builder classToMetadata = ImmutableBiMap.builder();
        ImmutableSet.Builder delegateTemplateNames = ImmutableSet.builder();
        for (TemplateNode template : registry.getAllTemplates()) {
            CompiledTemplateMetadata metadata = CompiledTemplateMetadata.create(template.getTemplateName(), template);
            templateToMetadata.put((Object)template.getTemplateName(), (Object)metadata);
            classToMetadata.put((Object)metadata.typeInfo().className(), (Object)metadata);
            if (!(template instanceof TemplateDelegateNode)) continue;
            delegateTemplateNames.add((Object)template.getTemplateName());
            if (template.getContentKind() == null) continue;
            deltemplateNameToContentKind.put(((TemplateDelegateNode)template).getDelTemplateName(), template.getContentKind());
        }
        this.templateNameToMetadata = templateToMetadata.build();
        this.classNameToMetadata = classToMetadata.build();
        this.deltemplateNameToContentKind = ImmutableMap.copyOf(deltemplateNameToContentKind);
        this.delegateTemplateNames = delegateTemplateNames.build();
    }

    ImmutableSet<String> getTemplateNames() {
        return this.templateNameToMetadata.keySet();
    }

    ImmutableSet<String> getDelegateTemplateNames() {
        return this.delegateTemplateNames;
    }

    CompiledTemplateMetadata getTemplateInfoByTemplateName(String templateName) {
        return (CompiledTemplateMetadata)this.templateNameToMetadata.get((Object)templateName);
    }

    CompiledTemplateMetadata getTemplateInfoByClassName(String templateName) {
        return (CompiledTemplateMetadata)this.classNameToMetadata.get((Object)templateName);
    }

    @Nullable
    SanitizedContent.ContentKind getDelTemplateContentKind(String delTemplateName) {
        return (SanitizedContent.ContentKind)((Object)this.deltemplateNameToContentKind.get((Object)delTemplateName));
    }
}

