/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.html;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.html.HtmlAttributeNode;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;

public final class HtmlOpenTagNode
extends AbstractParentSoyNode<HtmlAttributeNode>
implements SoyNode.StandaloneNode {
    private final String tagName;

    public HtmlOpenTagNode(int id, String tagName, SourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.tagName = tagName;
    }

    private HtmlOpenTagNode(HtmlOpenTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.tagName = orig.tagName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_OPEN_TAG;
    }

    public String getTagName() {
        return this.tagName;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + this.tagName);
        for (SoyNode child : this.getChildren()) {
            sb.append(child.toSourceString());
        }
        return sb.append("></" + this.tagName + ">").toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public SoyNode copy(CopyState copyState) {
        return new HtmlOpenTagNode(this, copyState);
    }
}

