/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParserConstants;
import com.google.template.soy.exprparse.ExpressionParserTokenManager;
import com.google.template.soy.exprparse.ParseErrors;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.SimpleCharStream;
import com.google.template.soy.exprparse.Token;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.base.UnescapeUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class ExpressionParser
implements ExpressionParserConstants {
    public static final SoyErrorKind INVALID_EXPRESSION_LIST = SoyErrorKind.of("Invalid expression list");
    private static final SoyErrorKind INVALID_PARAM_NAME_IJ = SoyErrorKind.of("Invalid param name ''ij'' (''ij'' is for injected data ref).");
    public static final SoyErrorKind INVALID_VAR_NAME = SoyErrorKind.of("Invalid var name ''{0}''");
    private static final SoyErrorKind INVALID_VAR_NAME_IJ = SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).");
    private static final SoyErrorKind SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Disallowed single-identifier key \"{0}\" in map literal (please surround with single quotes for string or parentheses for global).");
    private static final SoyErrorKind PARSE_ERROR = SoyErrorKind.of("{0}");
    private String input;
    private SourceLocation parentSourceLocation;
    private ErrorReporter errorReporter;
    public ExpressionParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ExpressionParser(String input, SourceLocation parentSourceLocation, ErrorReporter errorReporter) {
        this(new StringReader(input));
        this.input = input;
        this.parentSourceLocation = parentSourceLocation;
        this.errorReporter = errorReporter;
    }

    public List<ExprNode> parseExpressionList() {
        try {
            return this.ExprListInput();
        }
        catch (ParseException e) {
            ParseErrors.reportExprParseException(this.errorReporter, this.parentSourceLocation, e);
            return ImmutableList.of();
        }
    }

    public ExprNode parseExpression() {
        try {
            return this.ExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportExprParseException(this.errorReporter, this.parentSourceLocation, e);
            return VarRefNode.ERROR;
        }
    }

    public VarNode parseVariable() {
        try {
            return this.VarInput();
        }
        catch (ParseException e) {
            ParseErrors.reportExprParseException(this.errorReporter, "Expected a variable name ", this.parentSourceLocation, e);
            return VarNode.ERROR;
        }
    }

    private static final ExprNode.OperatorNode createOperatorNode(String op, int prec, ExprNode ... children) {
        Operator operator = Operator.of(op, children.length);
        if (operator.getPrecedence() != prec) {
            throw new IllegalArgumentException("invalid precedence " + prec + " for operator " + op);
        }
        return operator.createNode(children);
    }

    private SourceLocation createSrcLoc(Token token) {
        return new SourceLocation(this.parentSourceLocation.getFilePath(), Math.max(1, this.parentSourceLocation.getLineNumber()), Math.max(1, this.parentSourceLocation.getBeginColumn() + token.beginColumn), Math.max(1, this.parentSourceLocation.getLineNumber()), Math.max(1, this.parentSourceLocation.getBeginColumn() + token.endColumn));
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                primitive = new NullNode(SourceLocation.UNKNOWN);
                break;
            }
            case 2: {
                Token b = this.jj_consume_token(2);
                primitive = new BooleanNode(b.image.equals("true"), this.createSrcLoc(b));
                break;
            }
            case 3: {
                Token i = this.jj_consume_token(3);
                if (i.image.startsWith("0x")) {
                    primitive = new IntegerNode(Integer.parseInt(i.image.substring(2), 16), this.createSrcLoc(i));
                    break;
                }
                primitive = new IntegerNode(Integer.parseInt(i.image, 10), this.createSrcLoc(i));
                break;
            }
            case 4: {
                Token f = this.jj_consume_token(4);
                primitive = new FloatNode(Double.parseDouble(f.image), this.createSrcLoc(f));
                break;
            }
            case 5: {
                Token str = this.jj_consume_token(5);
                String strNoQuotes = str.image.substring(1, str.image.length() - 1);
                primitive = new StringNode(UnescapeUtils.unescapeJs(strNoQuotes), this.createSrcLoc(str));
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return primitive;
    }

    private final List<ExprNode> ExprListInput() throws ParseException {
        List<ExprNode> exprList = this.ExprList();
        ArrayList rootedExprList = Lists.newArrayList();
        for (ExprNode expr : exprList) {
            rootedExprList.add(expr);
        }
        this.jj_consume_token(0);
        return rootedExprList;
    }

    private final ExprNode ExprInput() throws ParseException {
        ExprNode expr = this.Expr();
        this.jj_consume_token(0);
        return expr;
    }

    private final VarNode VarInput() throws ParseException {
        VarNode var = this.Var();
        this.jj_consume_token(0);
        return var;
    }

    private final GlobalNode GlobalInput() throws ParseException {
        GlobalNode global = this.Global();
        this.jj_consume_token(0);
        return global;
    }

    private final List<ExprNode> ExprList() throws ParseException {
        ArrayList exprList = Lists.newArrayList();
        ExprNode expr = this.Expr();
        exprList.add(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(20);
            expr = this.Expr();
            exprList.add(expr);
        }
        return exprList;
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        return expr;
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(expr, expr1);
                        break block0;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        ExprNode expr1 = this.PrecExpr1();
                        this.jj_consume_token(23);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return expr;
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(9);
            ExprNode rightHand = this.PrecExpr3();
            expr = ExpressionParser.createOperatorNode(op.image, 2, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(10);
            ExprNode rightHand = this.PrecExpr4();
            expr = ExpressionParser.createOperatorNode(op.image, 3, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(11);
            ExprNode rightHand = this.PrecExpr5();
            expr = ExpressionParser.createOperatorNode(op.image, 4, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(12);
            ExprNode rightHand = this.PrecExpr6();
            expr = ExpressionParser.createOperatorNode(op.image, 5, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr;
        block8: {
            expr = this.PrecExpr7();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        Token op = this.jj_consume_token(13);
                        ExprNode rightHand = this.PrecExpr7();
                        expr = ExpressionParser.createOperatorNode(op.image, 6, expr, rightHand);
                        continue block7;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        ExprNode rightHand = this.PrecExpr7();
                        expr = Operator.MINUS.createNode(expr, rightHand);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(14);
            ExprNode rightHand = this.PrecExpr8();
            expr = ExpressionParser.createOperatorNode(op.image, 7, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 25: 
            case 28: 
            case 30: {
                expr = this.PrecExpr9();
                break;
            }
            case 8: {
                Token unaryOp = this.jj_consume_token(8);
                expr = this.PrecExpr8();
                expr = ExpressionParser.createOperatorNode(unaryOp.image, 8, expr);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                expr = this.PrecExpr8();
                expr = Operator.NEGATIVE.createNode(expr);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block10: {
            expr = this.Primary();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: 
                    case 18: 
                    case 25: 
                    case 27: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        Token tok = this.jj_consume_token(17);
                        expr = new FieldAccessNode(expr, tok.image.substring(1), false);
                        continue block9;
                    }
                    case 18: {
                        Token tok = this.jj_consume_token(18);
                        expr = new FieldAccessNode(expr, tok.image.substring(2), true);
                        continue block9;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        ExprNode keyExpr = this.Expr();
                        this.jj_consume_token(26);
                        expr = new ItemAccessNode(expr, keyExpr, false);
                        continue block9;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        ExprNode keyExpr = this.Expr();
                        this.jj_consume_token(26);
                        expr = new ItemAccessNode(expr, keyExpr, true);
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                primary = this.Expr();
                this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                if (this.jj_2_1(Integer.MAX_VALUE)) {
                    primary = this.FunctionCall();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: 
                    case 30: {
                        primary = this.DataRef();
                        break block0;
                    }
                    case 15: {
                        primary = this.Global();
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    primary = this.ListLiteral();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        primary = this.MapLiteral();
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        primary = this.Primitive();
                        break block0;
                    }
                }
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return primary;
    }

    private final VarNode Var() throws ParseException {
        Token dollarIdent = this.jj_consume_token(16);
        String identStr = dollarIdent.image.substring(1);
        if (identStr.equals("ij")) {
            this.errorReporter.report(this.createSrcLoc(dollarIdent), INVALID_VAR_NAME_IJ, new Object[0]);
        }
        return new VarNode(identStr, this.createSrcLoc(dollarIdent));
    }

    private final ExprNode DataRef() throws ParseException {
        VarRefNode dataRef;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                Token ident = this.jj_consume_token(15);
                dataRef = new VarRefNode(ident.image, this.createSrcLoc(ident), true, null);
                break;
            }
            case 16: {
                VarNode varNode = this.Var();
                dataRef = new VarRefNode(varNode.getName(), varNode.getSourceLocation(), false, null);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return dataRef;
    }

    private final GlobalNode Global() throws ParseException {
        StringBuilder globalNameSb = new StringBuilder();
        Token ident = this.jj_consume_token(15);
        SourceLocation loc = this.createSrcLoc(ident);
        globalNameSb.append(ident.image);
        while (this.jj_2_3(2)) {
            ident = this.jj_consume_token(17);
            loc = loc.extend(this.createSrcLoc(ident));
            globalNameSb.append(ident.image);
        }
        return new GlobalNode(globalNameSb.toString(), loc);
    }

    private final FunctionNode FunctionCall() throws ParseException {
        Token ident = this.jj_consume_token(15);
        this.jj_consume_token(28);
        List<ExprNode> exprList = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 30: {
                exprList = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(29);
        FunctionNode fnNode = new FunctionNode(ident.image, this.createSrcLoc(ident));
        if (exprList != null) {
            fnNode.addChildren((List<? extends ExprNode>)exprList);
        }
        return fnNode;
    }

    private final ListLiteralNode ListLiteral() throws ParseException {
        ArrayList items = Lists.newArrayList();
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 30: {
                ExprNode itemExpr = this.Expr();
                items.add(itemExpr);
                while (this.jj_2_4(Integer.MAX_VALUE)) {
                    this.jj_consume_token(20);
                    itemExpr = this.Expr();
                    items.add(itemExpr);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        return new ListLiteralNode(items, SourceLocation.UNKNOWN);
    }

    private final MapLiteralNode MapLiteral() throws ParseException {
        ArrayList alternatingKeysAndValues = Lists.newArrayList();
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 30: {
                Token ident;
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    ident = this.jj_consume_token(15);
                    this.errorReporter.report(this.createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
                }
                ExprNode keyExpr = this.Expr();
                alternatingKeysAndValues.add(keyExpr);
                this.jj_consume_token(23);
                ExprNode valueExpr = this.Expr();
                alternatingKeysAndValues.add(valueExpr);
                while (this.jj_2_6(Integer.MAX_VALUE)) {
                    this.jj_consume_token(20);
                    if (this.jj_2_7(Integer.MAX_VALUE)) {
                        ident = this.jj_consume_token(15);
                        this.errorReporter.report(this.createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
                    }
                    keyExpr = this.Expr();
                    alternatingKeysAndValues.add(keyExpr);
                    this.jj_consume_token(23);
                    valueExpr = this.Expr();
                    alternatingKeysAndValues.add(valueExpr);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(26);
        return new MapLiteralNode(alternatingKeysAndValues, SourceLocation.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_25() {
        Token xsp;
        if (this.jj_3R_27()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_28());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_62() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_47()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_48()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_49()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        return this.jj_scan_token(1);
    }

    private boolean jj_3R_58() {
        return this.jj_3R_67();
    }

    private boolean jj_3R_36() {
        Token xsp;
        if (this.jj_3R_37()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_38());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_62()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_63()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_64()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_65()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_57() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_26() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_58()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_59() {
        Token xsp;
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_68());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_23() {
        Token xsp;
        if (this.jj_3R_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_14() {
        if (this.jj_3R_15()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_35() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_12() {
        if (this.jj_3R_13()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(26)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3R_34() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_33() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_35()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_56() {
        return this.jj_3R_66();
    }

    private boolean jj_3R_21() {
        Token xsp;
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_24());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_12()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_50() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_45() {
        return this.jj_3R_55();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_70() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_44() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_43() {
        return this.jj_3R_53();
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_42() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_21();
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_41() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_13() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_40() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_17() {
        Token xsp;
        if (this.jj_3R_21()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_22());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_27() {
        Token xsp;
        if (this.jj_3R_29()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_69() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_39() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_70());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_41()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_42()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_43()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_44()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_45()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_71() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_54() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(23)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_60()) {
                return true;
            }
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_66() {
        Token xsp;
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_71());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_49() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_52() {
        Token xsp;
        if (this.jj_scan_token(15)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_3());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_15() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_18());
        this.jj_scanpos = xsp;
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{62, 0x100000, 0x600000, 0x600000, 512, 1024, 2048, 4096, 0x1002000, 0x1002000, 16384, 1392607550, 0xA060000, 0xA060000, 0x10000000, 1073840128, 33554494, 0x40010000, 1392607550, 0x100000, 1392607550, 0x100000, 1400996158};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public ExpressionParser(InputStream stream) {
        this(stream, null);
    }

    public ExpressionParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionParser(ExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[36];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 23; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 36; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionParser.jj_la1_init_0();
        ExpressionParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

