/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.Dir;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.internal.RenderableThunk;
import com.google.template.soy.data.restricted.SoyString;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public abstract class SanitizedContent
extends SoyData
implements SoyString {
    private final ContentKind contentKind;
    private final Dir contentDir;

    static SanitizedContent create(String content, ContentKind kind, @Nullable Dir dir) {
        return new ConstantContent(content, kind, dir);
    }

    static SanitizedContent createLazy(RenderableThunk thunk, ContentKind kind, @Nullable Dir dir) {
        return new LazyContent(thunk, kind, dir);
    }

    private SanitizedContent(ContentKind contentKind, @Nullable Dir contentDir) {
        this.contentKind = contentKind;
        this.contentDir = contentDir;
    }

    public abstract String getContent();

    public ContentKind getContentKind() {
        return this.contentKind;
    }

    @Nullable
    public Dir getContentDirection() {
        return this.contentDir;
    }

    @Override
    @Deprecated
    public boolean toBoolean() {
        return this.getContent().length() != 0;
    }

    @Override
    public String toString() {
        return this.getContent();
    }

    @Override
    public String stringValue() {
        return this.getContent();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SanitizedContent && this.contentKind == ((SanitizedContent)other).contentKind && this.contentDir == ((SanitizedContent)other).contentDir && this.getContent().equals(((SanitizedContent)other).getContent());
    }

    public int hashCode() {
        return this.getContent().hashCode() + 31 * this.contentKind.hashCode();
    }

    private static final class LazyContent
    extends SanitizedContent {
        final RenderableThunk thunk;

        LazyContent(RenderableThunk thunk, ContentKind contentKind, @Nullable Dir contentDir) {
            super(contentKind, contentDir);
            this.thunk = thunk;
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            this.thunk.render(appendable);
        }

        @Override
        public String getContent() {
            return this.thunk.renderAsString();
        }
    }

    private static final class ConstantContent
    extends SanitizedContent {
        final String content;

        ConstantContent(String content, ContentKind contentKind, @Nullable Dir contentDir) {
            super(contentKind, contentDir);
            this.content = content;
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            appendable.append(this.content);
        }

        @Override
        public String getContent() {
            return this.content;
        }
    }

    public static enum ContentKind {
        HTML,
        JS,
        URI,
        TRUSTED_RESOURCE_URI,
        ATTRIBUTES,
        CSS,
        TEXT;

    }
}

