/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.conversion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.sitebricks.conversion.Converter;
import com.google.sitebricks.conversion.TypeConverter;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateConverters {
    public static List<Class<? extends Converter<?, ?>>> converters() {
        ArrayList converters = new ArrayList();
        converters.add(LocalizedDateStringConverter.class);
        converters.add(DateLongConverter.class);
        converters.add(DateCalendarConverter.class);
        converters.add(CalendarLongConverter.class);
        converters.add(CalendarStringConverter.class);
        return converters;
    }

    public static class CalendarLongConverter
    implements Converter<Calendar, Long> {
        private final Provider<TypeConverter> provider;

        @Inject
        public CalendarLongConverter(Provider<TypeConverter> provider) {
            this.provider = provider;
        }

        @Override
        public Long to(Calendar source) {
            TypeConverter converter = (TypeConverter)this.provider.get();
            Date date = (Date)converter.convert(source, (Type)((Object)Date.class));
            return (Long)converter.convert(date, (Type)((Object)Long.class));
        }

        @Override
        public Calendar from(Long target) {
            TypeConverter converter = (TypeConverter)this.provider.get();
            Date date = (Date)converter.convert(target, (Type)((Object)Date.class));
            return (Calendar)converter.convert(date, (Type)((Object)Calendar.class));
        }
    }

    public static class CalendarStringConverter
    implements Converter<Calendar, String> {
        private final Provider<TypeConverter> provider;

        @Inject
        public CalendarStringConverter(Provider<TypeConverter> provider) {
            this.provider = provider;
        }

        @Override
        public String to(Calendar source) {
            TypeConverter converter = (TypeConverter)this.provider.get();
            Date date = (Date)converter.convert(source, (Type)((Object)Date.class));
            return (String)converter.convert(date, (Type)((Object)String.class));
        }

        @Override
        public Calendar from(String target) {
            TypeConverter converter = (TypeConverter)this.provider.get();
            Date date = (Date)converter.convert(target, (Type)((Object)Date.class));
            return (Calendar)converter.convert(date, (Type)((Object)Calendar.class));
        }
    }

    public static class LocalizedDateStringConverter
    extends DateStringConverter {
        private int dateStyle;
        private int timeStyle;
        private Provider<Locale> provider;

        public LocalizedDateStringConverter() {
            this(1, 1);
        }

        public LocalizedDateStringConverter(int dateStyle, int timeStyle) {
            this.dateStyle = dateStyle;
            this.timeStyle = timeStyle;
        }

        @Inject(optional=true)
        public void setLocaleProvider(Provider<Locale> provider) {
            this.provider = provider;
        }

        @Override
        protected DateFormat getFormat() {
            if (this.provider != null) {
                return DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, (Locale)this.provider.get());
            }
            return super.getFormat();
        }
    }

    public static class DateStringConverter
    implements Converter<Date, String> {
        protected DateFormat format;

        public DateStringConverter() {
            this.format = DateFormat.getInstance();
        }

        public DateStringConverter(DateFormat format) {
            this.format = format;
        }

        public DateStringConverter(String format) {
            this.format = new SimpleDateFormat(format);
        }

        @Override
        public Date from(String source) {
            try {
                return this.getFormat().parse(source);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid date format", e);
            }
        }

        @Override
        public String to(Date target) {
            return this.format.format(target);
        }

        protected DateFormat getFormat() {
            return this.format;
        }
    }

    public static class DateCalendarConverter
    implements Converter<Date, Calendar> {
        @Override
        public Calendar to(Date source) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(source);
            return calendar;
        }

        @Override
        public Date from(Calendar target) {
            return target.getTime();
        }
    }

    public static class DateLongConverter
    implements Converter<Date, Long> {
        @Override
        public Date from(Long source) {
            return new Date(source);
        }

        @Override
        public Long to(Date target) {
            return target.getTime();
        }
    }
}

