/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.conversion;

import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import com.google.sitebricks.conversion.Converter;
import com.google.sitebricks.conversion.ConverterRegistry;
import com.google.sitebricks.conversion.TypeConverter;
import com.google.sitebricks.conversion.generics.Generics;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;

public class MvelConversionHandlers {
    private TypeConverter delegate;
    private ConverterRegistry registry;

    @Inject
    public void prepare(ConverterRegistry registry, TypeConverter delegate) {
        this.registry = registry;
        this.delegate = delegate;
        Collection converters = registry.getConvertersBySource().values();
        for (Converter converter : converters) {
            ParameterizedType converterType = (ParameterizedType)Generics.getExactSuperType(converter.getClass(), Converter.class);
            Type[] converterParameters = converterType.getActualTypeArguments();
            this.registerMvelHandler(converterParameters[0]);
            this.registerMvelHandler(converterParameters[1]);
        }
    }

    private void registerMvelHandler(Type targetType) {
        Class<?> targetClass = Generics.erase(targetType);
        SitebricksConversionHandler targetHandler = new SitebricksConversionHandler(targetType);
        DataConversion.addConversionHandler(targetClass, (ConversionHandler)targetHandler);
        if (Primitives.isWrapperType(targetClass)) {
            DataConversion.addConversionHandler((Class)Primitives.unwrap(targetClass), (ConversionHandler)targetHandler);
        }
    }

    private class SitebricksConversionHandler
    implements ConversionHandler {
        private final Type targetType;

        public SitebricksConversionHandler(Type targetType) {
            this.targetType = targetType;
        }

        public Object convertFrom(Object in) {
            return MvelConversionHandlers.this.delegate.convert(in, this.targetType);
        }

        public boolean canConvertFrom(Class cls) {
            if (cls == this.targetType) {
                return true;
            }
            return MvelConversionHandlers.this.registry.converter(Primitives.wrap((Class)cls), this.targetType) != null;
        }
    }
}

