/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import com.google.shopping.css.v1.AccountLabel;
import com.google.shopping.css.v1.AccountLabelsServiceClient;
import com.google.shopping.css.v1.CreateAccountLabelRequest;
import com.google.shopping.css.v1.DeleteAccountLabelRequest;
import com.google.shopping.css.v1.ListAccountLabelsRequest;
import com.google.shopping.css.v1.ListAccountLabelsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelRequest;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStub;
import com.google.shopping.css.v1.stub.GrpcAccountLabelsServiceStub;
import com.google.shopping.css.v1.stub.HttpJsonAccountLabelsServiceStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AccountLabelsServiceStubSettings
extends StubSettings<AccountLabelsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/content").build();
    private final PagedCallSettings<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsSettings;
    private final UnaryCallSettings<CreateAccountLabelRequest, AccountLabel> createAccountLabelSettings;
    private final UnaryCallSettings<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelSettings;
    private final UnaryCallSettings<DeleteAccountLabelRequest, Empty> deleteAccountLabelSettings;
    private static final PagedListDescriptor<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel> LIST_ACCOUNT_LABELS_PAGE_STR_DESC = new PagedListDescriptor<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel>(){

        public String emptyToken() {
            return "";
        }

        public ListAccountLabelsRequest injectToken(ListAccountLabelsRequest payload, String token) {
            return ListAccountLabelsRequest.newBuilder((ListAccountLabelsRequest)payload).setPageToken(token).build();
        }

        public ListAccountLabelsRequest injectPageSize(ListAccountLabelsRequest payload, int pageSize) {
            return ListAccountLabelsRequest.newBuilder((ListAccountLabelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAccountLabelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAccountLabelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AccountLabel> extractResources(ListAccountLabelsResponse payload) {
            return payload.getAccountLabelsList() == null ? ImmutableList.of() : payload.getAccountLabelsList();
        }
    };
    private static final PagedListResponseFactory<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> LIST_ACCOUNT_LABELS_PAGE_STR_FACT = new PagedListResponseFactory<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabelsServiceClient.ListAccountLabelsPagedResponse>(){

        public ApiFuture<AccountLabelsServiceClient.ListAccountLabelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsResponse> callable, ListAccountLabelsRequest request, ApiCallContext context, ApiFuture<ListAccountLabelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCOUNT_LABELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccountLabelsServiceClient.ListAccountLabelsPagedResponse.createAsync((PageContext<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsSettings() {
        return this.listAccountLabelsSettings;
    }

    public UnaryCallSettings<CreateAccountLabelRequest, AccountLabel> createAccountLabelSettings() {
        return this.createAccountLabelSettings;
    }

    public UnaryCallSettings<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelSettings() {
        return this.updateAccountLabelSettings;
    }

    public UnaryCallSettings<DeleteAccountLabelRequest, Empty> deleteAccountLabelSettings() {
        return this.deleteAccountLabelSettings;
    }

    public AccountLabelsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAccountLabelsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAccountLabelsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AccountLabelsServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "css";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "css.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "css.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AccountLabelsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccountLabelsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccountLabelsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AccountLabelsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AccountLabelsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAccountLabelsSettings = settingsBuilder.listAccountLabelsSettings().build();
        this.createAccountLabelSettings = settingsBuilder.createAccountLabelSettings().build();
        this.updateAccountLabelSettings = settingsBuilder.updateAccountLabelSettings().build();
        this.deleteAccountLabelSettings = settingsBuilder.deleteAccountLabelSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AccountLabelsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsSettings;
        private final UnaryCallSettings.Builder<CreateAccountLabelRequest, AccountLabel> createAccountLabelSettings;
        private final UnaryCallSettings.Builder<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelSettings;
        private final UnaryCallSettings.Builder<DeleteAccountLabelRequest, Empty> deleteAccountLabelSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAccountLabelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCOUNT_LABELS_PAGE_STR_FACT);
            this.createAccountLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccountLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccountLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAccountLabelsSettings, this.createAccountLabelSettings, this.updateAccountLabelSettings, this.deleteAccountLabelSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AccountLabelsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAccountLabelsSettings = settings.listAccountLabelsSettings.toBuilder();
            this.createAccountLabelSettings = settings.createAccountLabelSettings.toBuilder();
            this.updateAccountLabelSettings = settings.updateAccountLabelSettings.toBuilder();
            this.deleteAccountLabelSettings = settings.deleteAccountLabelSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAccountLabelsSettings, this.createAccountLabelSettings, this.updateAccountLabelSettings, this.deleteAccountLabelSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AccountLabelsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AccountLabelsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccountLabelsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AccountLabelsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AccountLabelsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AccountLabelsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccountLabelsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AccountLabelsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAccountLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAccountLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAccountLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteAccountLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsSettings() {
            return this.listAccountLabelsSettings;
        }

        public UnaryCallSettings.Builder<CreateAccountLabelRequest, AccountLabel> createAccountLabelSettings() {
            return this.createAccountLabelSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelSettings() {
            return this.updateAccountLabelSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccountLabelRequest, Empty> deleteAccountLabelSettings() {
            return this.deleteAccountLabelSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AccountLabelsServiceStubSettings.getDefaultEndpoint();
        }

        public AccountLabelsServiceStubSettings build() throws IOException {
            return new AccountLabelsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

