/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.shopping.css.v1.ListQuotaGroupsRequest;
import com.google.shopping.css.v1.ListQuotaGroupsResponse;
import com.google.shopping.css.v1.QuotaGroup;
import com.google.shopping.css.v1.QuotaServiceClient;
import com.google.shopping.css.v1.stub.GrpcQuotaServiceStub;
import com.google.shopping.css.v1.stub.HttpJsonQuotaServiceStub;
import com.google.shopping.css.v1.stub.QuotaServiceStub;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class QuotaServiceStubSettings
extends StubSettings<QuotaServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/content").build();
    private final PagedCallSettings<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaServiceClient.ListQuotaGroupsPagedResponse> listQuotaGroupsSettings;
    private static final PagedListDescriptor<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup> LIST_QUOTA_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListQuotaGroupsRequest injectToken(ListQuotaGroupsRequest payload, String token) {
            return ListQuotaGroupsRequest.newBuilder((ListQuotaGroupsRequest)payload).setPageToken(token).build();
        }

        public ListQuotaGroupsRequest injectPageSize(ListQuotaGroupsRequest payload, int pageSize) {
            return ListQuotaGroupsRequest.newBuilder((ListQuotaGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListQuotaGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListQuotaGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<QuotaGroup> extractResources(ListQuotaGroupsResponse payload) {
            return payload.getQuotaGroupsList();
        }
    };
    private static final PagedListResponseFactory<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaServiceClient.ListQuotaGroupsPagedResponse> LIST_QUOTA_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaServiceClient.ListQuotaGroupsPagedResponse>(){

        public ApiFuture<QuotaServiceClient.ListQuotaGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListQuotaGroupsRequest, ListQuotaGroupsResponse> callable, ListQuotaGroupsRequest request, ApiCallContext context, ApiFuture<ListQuotaGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_QUOTA_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return QuotaServiceClient.ListQuotaGroupsPagedResponse.createAsync((PageContext<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaServiceClient.ListQuotaGroupsPagedResponse> listQuotaGroupsSettings() {
        return this.listQuotaGroupsSettings;
    }

    public QuotaServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcQuotaServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonQuotaServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "css";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "css.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "css.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return QuotaServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(QuotaServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(QuotaServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return QuotaServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected QuotaServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listQuotaGroupsSettings = settingsBuilder.listQuotaGroupsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<QuotaServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaServiceClient.ListQuotaGroupsPagedResponse> listQuotaGroupsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listQuotaGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_QUOTA_GROUPS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listQuotaGroupsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(QuotaServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listQuotaGroupsSettings = settings.listQuotaGroupsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listQuotaGroupsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(QuotaServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)QuotaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)QuotaServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(QuotaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)QuotaServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)QuotaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)QuotaServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(QuotaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listQuotaGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaServiceClient.ListQuotaGroupsPagedResponse> listQuotaGroupsSettings() {
            return this.listQuotaGroupsSettings;
        }

        public QuotaServiceStubSettings build() throws IOException {
            return new QuotaServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

