/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.shopping.css.v1.AccountLabel;
import com.google.shopping.css.v1.AccountLabelName;
import com.google.shopping.css.v1.AccountLabelsServiceSettings;
import com.google.shopping.css.v1.AccountName;
import com.google.shopping.css.v1.CreateAccountLabelRequest;
import com.google.shopping.css.v1.DeleteAccountLabelRequest;
import com.google.shopping.css.v1.ListAccountLabelsRequest;
import com.google.shopping.css.v1.ListAccountLabelsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelRequest;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStub;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AccountLabelsServiceClient
implements BackgroundResource {
    private final AccountLabelsServiceSettings settings;
    private final AccountLabelsServiceStub stub;

    public static final AccountLabelsServiceClient create() throws IOException {
        return AccountLabelsServiceClient.create(AccountLabelsServiceSettings.newBuilder().build());
    }

    public static final AccountLabelsServiceClient create(AccountLabelsServiceSettings settings) throws IOException {
        return new AccountLabelsServiceClient(settings);
    }

    public static final AccountLabelsServiceClient create(AccountLabelsServiceStub stub) {
        return new AccountLabelsServiceClient(stub);
    }

    protected AccountLabelsServiceClient(AccountLabelsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccountLabelsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AccountLabelsServiceClient(AccountLabelsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AccountLabelsServiceSettings getSettings() {
        return this.settings;
    }

    public AccountLabelsServiceStub getStub() {
        return this.stub;
    }

    public final ListAccountLabelsPagedResponse listAccountLabels(AccountName parent) {
        ListAccountLabelsRequest request = ListAccountLabelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAccountLabels(request);
    }

    public final ListAccountLabelsPagedResponse listAccountLabels(String parent) {
        ListAccountLabelsRequest request = ListAccountLabelsRequest.newBuilder().setParent(parent).build();
        return this.listAccountLabels(request);
    }

    public final ListAccountLabelsPagedResponse listAccountLabels(ListAccountLabelsRequest request) {
        return (ListAccountLabelsPagedResponse)((Object)this.listAccountLabelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsPagedResponse> listAccountLabelsPagedCallable() {
        return this.stub.listAccountLabelsPagedCallable();
    }

    public final UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsCallable() {
        return this.stub.listAccountLabelsCallable();
    }

    public final AccountLabel createAccountLabel(AccountName parent, AccountLabel accountLabel) {
        CreateAccountLabelRequest request = CreateAccountLabelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAccountLabel(accountLabel).build();
        return this.createAccountLabel(request);
    }

    public final AccountLabel createAccountLabel(String parent, AccountLabel accountLabel) {
        CreateAccountLabelRequest request = CreateAccountLabelRequest.newBuilder().setParent(parent).setAccountLabel(accountLabel).build();
        return this.createAccountLabel(request);
    }

    public final AccountLabel createAccountLabel(CreateAccountLabelRequest request) {
        return (AccountLabel)this.createAccountLabelCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAccountLabelRequest, AccountLabel> createAccountLabelCallable() {
        return this.stub.createAccountLabelCallable();
    }

    public final AccountLabel updateAccountLabel(AccountLabel accountLabel) {
        UpdateAccountLabelRequest request = UpdateAccountLabelRequest.newBuilder().setAccountLabel(accountLabel).build();
        return this.updateAccountLabel(request);
    }

    public final AccountLabel updateAccountLabel(UpdateAccountLabelRequest request) {
        return (AccountLabel)this.updateAccountLabelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelCallable() {
        return this.stub.updateAccountLabelCallable();
    }

    public final void deleteAccountLabel(AccountLabelName name) {
        DeleteAccountLabelRequest request = DeleteAccountLabelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAccountLabel(request);
    }

    public final void deleteAccountLabel(String name) {
        DeleteAccountLabelRequest request = DeleteAccountLabelRequest.newBuilder().setName(name).build();
        this.deleteAccountLabel(request);
    }

    public final void deleteAccountLabel(DeleteAccountLabelRequest request) {
        this.deleteAccountLabelCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAccountLabelRequest, Empty> deleteAccountLabelCallable() {
        return this.stub.deleteAccountLabelCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAccountLabelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel, ListAccountLabelsPage, ListAccountLabelsFixedSizeCollection> {
        private ListAccountLabelsFixedSizeCollection(List<ListAccountLabelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAccountLabelsFixedSizeCollection createEmptyCollection() {
            return new ListAccountLabelsFixedSizeCollection(null, 0);
        }

        protected ListAccountLabelsFixedSizeCollection createCollection(List<ListAccountLabelsPage> pages, int collectionSize) {
            return new ListAccountLabelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAccountLabelsPage
    extends AbstractPage<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel, ListAccountLabelsPage> {
        private ListAccountLabelsPage(PageContext<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel> context, ListAccountLabelsResponse response) {
            super(context, (Object)response);
        }

        private static ListAccountLabelsPage createEmptyPage() {
            return new ListAccountLabelsPage(null, null);
        }

        protected ListAccountLabelsPage createPage(PageContext<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel> context, ListAccountLabelsResponse response) {
            return new ListAccountLabelsPage(context, response);
        }

        public ApiFuture<ListAccountLabelsPage> createPageAsync(PageContext<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel> context, ApiFuture<ListAccountLabelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAccountLabelsPagedResponse
    extends AbstractPagedListResponse<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel, ListAccountLabelsPage, ListAccountLabelsFixedSizeCollection> {
        public static ApiFuture<ListAccountLabelsPagedResponse> createAsync(PageContext<ListAccountLabelsRequest, ListAccountLabelsResponse, AccountLabel> context, ApiFuture<ListAccountLabelsResponse> futureResponse) {
            ApiFuture<ListAccountLabelsPage> futurePage = ListAccountLabelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAccountLabelsPagedResponse((ListAccountLabelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAccountLabelsPagedResponse(ListAccountLabelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAccountLabelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

