/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.shopping.css.v1.Account;
import com.google.shopping.css.v1.AccountsServiceClient;
import com.google.shopping.css.v1.GetAccountRequest;
import com.google.shopping.css.v1.ListChildAccountsRequest;
import com.google.shopping.css.v1.ListChildAccountsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelsRequest;
import com.google.shopping.css.v1.stub.AccountsServiceStub;
import com.google.shopping.css.v1.stub.GrpcAccountsServiceStub;
import com.google.shopping.css.v1.stub.HttpJsonAccountsServiceStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AccountsServiceStubSettings
extends StubSettings<AccountsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/content").build();
    private final PagedCallSettings<ListChildAccountsRequest, ListChildAccountsResponse, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsSettings;
    private final UnaryCallSettings<GetAccountRequest, Account> getAccountSettings;
    private final UnaryCallSettings<UpdateAccountLabelsRequest, Account> updateLabelsSettings;
    private static final PagedListDescriptor<ListChildAccountsRequest, ListChildAccountsResponse, Account> LIST_CHILD_ACCOUNTS_PAGE_STR_DESC = new PagedListDescriptor<ListChildAccountsRequest, ListChildAccountsResponse, Account>(){

        public String emptyToken() {
            return "";
        }

        public ListChildAccountsRequest injectToken(ListChildAccountsRequest payload, String token) {
            return ListChildAccountsRequest.newBuilder((ListChildAccountsRequest)payload).setPageToken(token).build();
        }

        public ListChildAccountsRequest injectPageSize(ListChildAccountsRequest payload, int pageSize) {
            return ListChildAccountsRequest.newBuilder((ListChildAccountsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChildAccountsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChildAccountsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Account> extractResources(ListChildAccountsResponse payload) {
            return payload.getAccountsList() == null ? ImmutableList.of() : payload.getAccountsList();
        }
    };
    private static final PagedListResponseFactory<ListChildAccountsRequest, ListChildAccountsResponse, AccountsServiceClient.ListChildAccountsPagedResponse> LIST_CHILD_ACCOUNTS_PAGE_STR_FACT = new PagedListResponseFactory<ListChildAccountsRequest, ListChildAccountsResponse, AccountsServiceClient.ListChildAccountsPagedResponse>(){

        public ApiFuture<AccountsServiceClient.ListChildAccountsPagedResponse> getFuturePagedResponse(UnaryCallable<ListChildAccountsRequest, ListChildAccountsResponse> callable, ListChildAccountsRequest request, ApiCallContext context, ApiFuture<ListChildAccountsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHILD_ACCOUNTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccountsServiceClient.ListChildAccountsPagedResponse.createAsync((PageContext<ListChildAccountsRequest, ListChildAccountsResponse, Account>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListChildAccountsRequest, ListChildAccountsResponse, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsSettings() {
        return this.listChildAccountsSettings;
    }

    public UnaryCallSettings<GetAccountRequest, Account> getAccountSettings() {
        return this.getAccountSettings;
    }

    public UnaryCallSettings<UpdateAccountLabelsRequest, Account> updateLabelsSettings() {
        return this.updateLabelsSettings;
    }

    public AccountsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAccountsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAccountsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "css";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "css.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "css.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AccountsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccountsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccountsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AccountsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AccountsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listChildAccountsSettings = settingsBuilder.listChildAccountsSettings().build();
        this.getAccountSettings = settingsBuilder.getAccountSettings().build();
        this.updateLabelsSettings = settingsBuilder.updateLabelsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AccountsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListChildAccountsRequest, ListChildAccountsResponse, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsSettings;
        private final UnaryCallSettings.Builder<GetAccountRequest, Account> getAccountSettings;
        private final UnaryCallSettings.Builder<UpdateAccountLabelsRequest, Account> updateLabelsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listChildAccountsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHILD_ACCOUNTS_PAGE_STR_FACT);
            this.getAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listChildAccountsSettings, this.getAccountSettings, this.updateLabelsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AccountsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listChildAccountsSettings = settings.listChildAccountsSettings.toBuilder();
            this.getAccountSettings = settings.getAccountSettings.toBuilder();
            this.updateLabelsSettings = settings.updateLabelsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listChildAccountsSettings, this.getAccountSettings, this.updateLabelsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AccountsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AccountsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccountsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AccountsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AccountsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AccountsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccountsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AccountsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listChildAccountsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListChildAccountsRequest, ListChildAccountsResponse, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsSettings() {
            return this.listChildAccountsSettings;
        }

        public UnaryCallSettings.Builder<GetAccountRequest, Account> getAccountSettings() {
            return this.getAccountSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccountLabelsRequest, Account> updateLabelsSettings() {
            return this.updateLabelsSettings;
        }

        public AccountsServiceStubSettings build() throws IOException {
            return new AccountsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

