/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.shopping.css.v1.Account;
import com.google.shopping.css.v1.AccountName;
import com.google.shopping.css.v1.AccountsServiceSettings;
import com.google.shopping.css.v1.GetAccountRequest;
import com.google.shopping.css.v1.ListChildAccountsRequest;
import com.google.shopping.css.v1.ListChildAccountsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelsRequest;
import com.google.shopping.css.v1.stub.AccountsServiceStub;
import com.google.shopping.css.v1.stub.AccountsServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AccountsServiceClient
implements BackgroundResource {
    private final AccountsServiceSettings settings;
    private final AccountsServiceStub stub;

    public static final AccountsServiceClient create() throws IOException {
        return AccountsServiceClient.create(AccountsServiceSettings.newBuilder().build());
    }

    public static final AccountsServiceClient create(AccountsServiceSettings settings) throws IOException {
        return new AccountsServiceClient(settings);
    }

    public static final AccountsServiceClient create(AccountsServiceStub stub) {
        return new AccountsServiceClient(stub);
    }

    protected AccountsServiceClient(AccountsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccountsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AccountsServiceClient(AccountsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AccountsServiceSettings getSettings() {
        return this.settings;
    }

    public AccountsServiceStub getStub() {
        return this.stub;
    }

    public final ListChildAccountsPagedResponse listChildAccounts(AccountName parent) {
        ListChildAccountsRequest request = ListChildAccountsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChildAccounts(request);
    }

    public final ListChildAccountsPagedResponse listChildAccounts(String parent) {
        ListChildAccountsRequest request = ListChildAccountsRequest.newBuilder().setParent(parent).build();
        return this.listChildAccounts(request);
    }

    public final ListChildAccountsPagedResponse listChildAccounts(ListChildAccountsRequest request) {
        return (ListChildAccountsPagedResponse)((Object)this.listChildAccountsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChildAccountsRequest, ListChildAccountsPagedResponse> listChildAccountsPagedCallable() {
        return this.stub.listChildAccountsPagedCallable();
    }

    public final UnaryCallable<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsCallable() {
        return this.stub.listChildAccountsCallable();
    }

    public final Account getAccount(AccountName name) {
        GetAccountRequest request = GetAccountRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAccount(request);
    }

    public final Account getAccount(String name) {
        GetAccountRequest request = GetAccountRequest.newBuilder().setName(name).build();
        return this.getAccount(request);
    }

    public final Account getAccount(GetAccountRequest request) {
        return (Account)this.getAccountCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccountRequest, Account> getAccountCallable() {
        return this.stub.getAccountCallable();
    }

    public final Account updateLabels(AccountName name) {
        UpdateAccountLabelsRequest request = UpdateAccountLabelsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.updateLabels(request);
    }

    public final Account updateLabels(String name) {
        UpdateAccountLabelsRequest request = UpdateAccountLabelsRequest.newBuilder().setName(name).build();
        return this.updateLabels(request);
    }

    public final Account updateLabels(UpdateAccountLabelsRequest request) {
        return (Account)this.updateLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAccountLabelsRequest, Account> updateLabelsCallable() {
        return this.stub.updateLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListChildAccountsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChildAccountsRequest, ListChildAccountsResponse, Account, ListChildAccountsPage, ListChildAccountsFixedSizeCollection> {
        private ListChildAccountsFixedSizeCollection(List<ListChildAccountsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChildAccountsFixedSizeCollection createEmptyCollection() {
            return new ListChildAccountsFixedSizeCollection(null, 0);
        }

        protected ListChildAccountsFixedSizeCollection createCollection(List<ListChildAccountsPage> pages, int collectionSize) {
            return new ListChildAccountsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChildAccountsPage
    extends AbstractPage<ListChildAccountsRequest, ListChildAccountsResponse, Account, ListChildAccountsPage> {
        private ListChildAccountsPage(PageContext<ListChildAccountsRequest, ListChildAccountsResponse, Account> context, ListChildAccountsResponse response) {
            super(context, (Object)response);
        }

        private static ListChildAccountsPage createEmptyPage() {
            return new ListChildAccountsPage(null, null);
        }

        protected ListChildAccountsPage createPage(PageContext<ListChildAccountsRequest, ListChildAccountsResponse, Account> context, ListChildAccountsResponse response) {
            return new ListChildAccountsPage(context, response);
        }

        public ApiFuture<ListChildAccountsPage> createPageAsync(PageContext<ListChildAccountsRequest, ListChildAccountsResponse, Account> context, ApiFuture<ListChildAccountsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChildAccountsPagedResponse
    extends AbstractPagedListResponse<ListChildAccountsRequest, ListChildAccountsResponse, Account, ListChildAccountsPage, ListChildAccountsFixedSizeCollection> {
        public static ApiFuture<ListChildAccountsPagedResponse> createAsync(PageContext<ListChildAccountsRequest, ListChildAccountsResponse, Account> context, ApiFuture<ListChildAccountsResponse> futureResponse) {
            ApiFuture<ListChildAccountsPage> futurePage = ListChildAccountsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChildAccountsPagedResponse((ListChildAccountsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChildAccountsPagedResponse(ListChildAccountsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChildAccountsFixedSizeCollection.createEmptyCollection());
        }
    }
}

