/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import com.google.shopping.css.v1.Account;
import com.google.shopping.css.v1.AccountsServiceClient;
import com.google.shopping.css.v1.GetAccountRequest;
import com.google.shopping.css.v1.ListChildAccountsRequest;
import com.google.shopping.css.v1.ListChildAccountsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelsRequest;
import com.google.shopping.css.v1.stub.AccountsServiceStub;
import com.google.shopping.css.v1.stub.AccountsServiceStubSettings;
import com.google.shopping.css.v1.stub.GrpcAccountsServiceCallableFactory;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAccountsServiceStub
extends AccountsServiceStub {
    private static final MethodDescriptor<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountsService/ListChildAccounts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListChildAccountsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListChildAccountsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAccountRequest, Account> getAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountsService/GetAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAccountRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Account.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateAccountLabelsRequest, Account> updateLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountsService/UpdateLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAccountLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Account.getDefaultInstance())).build();
    private final UnaryCallable<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsCallable;
    private final UnaryCallable<ListChildAccountsRequest, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsPagedCallable;
    private final UnaryCallable<GetAccountRequest, Account> getAccountCallable;
    private final UnaryCallable<UpdateAccountLabelsRequest, Account> updateLabelsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAccountsServiceStub create(AccountsServiceStubSettings settings) throws IOException {
        return new GrpcAccountsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAccountsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAccountsServiceStub(AccountsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAccountsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAccountsServiceStub(AccountsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAccountsServiceStub(AccountsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAccountsServiceCallableFactory());
    }

    protected GrpcAccountsServiceStub(AccountsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listChildAccountsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listChildAccountsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateLabelsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listChildAccountsCallable = callableFactory.createUnaryCallable(listChildAccountsTransportSettings, settings.listChildAccountsSettings(), clientContext);
        this.listChildAccountsPagedCallable = callableFactory.createPagedCallable(listChildAccountsTransportSettings, settings.listChildAccountsSettings(), clientContext);
        this.getAccountCallable = callableFactory.createUnaryCallable(getAccountTransportSettings, settings.getAccountSettings(), clientContext);
        this.updateLabelsCallable = callableFactory.createUnaryCallable(updateLabelsTransportSettings, settings.updateLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsCallable() {
        return this.listChildAccountsCallable;
    }

    @Override
    public UnaryCallable<ListChildAccountsRequest, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsPagedCallable() {
        return this.listChildAccountsPagedCallable;
    }

    @Override
    public UnaryCallable<GetAccountRequest, Account> getAccountCallable() {
        return this.getAccountCallable;
    }

    @Override
    public UnaryCallable<UpdateAccountLabelsRequest, Account> updateLabelsCallable() {
        return this.updateLabelsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

