/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0006\u0010\u0017\u001a\u00020\bJ\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/json/internal/JsonStringBuilder;", "", "()V", "array", "", "size", "", "append", "", "ch", "", "value", "", "string", "", "appendQuoted", "appendStringSlowPath", "firstEscapedChar", "currentSize", "ensureAdditionalCapacity", "expected", "ensureTotalCapacity", "newSize", "release", "toString", "kotlinx-serialization-json"})
public final class JsonStringBuilder {
    @NotNull
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    public final void append(long value) {
        this.append(String.valueOf(value));
    }

    public final void append(char ch) {
        this.ensureAdditionalCapacity(1);
        JsonStringBuilder jsonStringBuilder = this;
        int n = jsonStringBuilder.size;
        jsonStringBuilder.size = n + 1;
        this.array[n] = ch;
    }

    public final void append(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        int length = string.length();
        this.ensureAdditionalCapacity(length);
        Object object = string;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        ((String)object).getChars(n2, n3, cArray, n);
        object = this;
        ((JsonStringBuilder)object).size += length;
    }

    public final void appendQuoted(@NotNull String string) {
        int sz;
        Intrinsics.checkNotNullParameter(string, "string");
        this.ensureAdditionalCapacity(string.length() + 2);
        char[] arr = this.array;
        int n = sz = this.size;
        sz = n + 1;
        arr[n] = 34;
        int length = string.length();
        String string2 = string;
        int n2 = 0;
        boolean bl = false;
        string2.getChars(n2, length, arr, sz);
        int n3 = sz;
        n2 = sz + length;
        if (n3 < n2) {
            do {
                int i = n3++;
                char c = arr[i];
                boolean bl2 = false;
                char ch = c;
                if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
                this.appendStringSlowPath(i - sz, i, string);
                return;
            } while (n3 < n2);
        }
        n3 = sz += length;
        sz = n3 + 1;
        arr[n3] = 34;
        this.size = sz;
    }

    private final void appendStringSlowPath(int firstEscapedChar, int currentSize, String string) {
        int sz = currentSize;
        int n = firstEscapedChar;
        int n2 = string.length();
        if (n < n2) {
            do {
                int i = n++;
                this.ensureTotalCapacity(sz + 2);
                int n3 = string.charAt(i);
                int n4 = 0;
                int ch = n3;
                if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                    byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                    if (marker == 0) {
                        n4 = sz;
                        sz = n4 + 1;
                        this.array[n4] = (char)ch;
                        continue;
                    }
                    if (marker == 1) {
                        String string2 = StringOpsKt.getESCAPE_STRINGS()[ch];
                        Intrinsics.checkNotNull(string2);
                        String escapedString = string2;
                        this.ensureTotalCapacity(sz + escapedString.length());
                        string2 = escapedString;
                        char[] cArray = this.array;
                        int n5 = 0;
                        int n6 = escapedString.length();
                        boolean bl = false;
                        string2.getChars(n5, n6, cArray, sz);
                        sz += escapedString.length();
                        continue;
                    }
                    this.array[sz] = 92;
                    this.array[sz + 1] = (char)marker;
                    sz += 2;
                    continue;
                }
                n3 = sz;
                sz = n3 + 1;
                this.array[n3] = (char)ch;
            } while (n < n2);
        }
        this.ensureTotalCapacity(sz + 1);
        n = sz;
        sz = n + 1;
        this.array[n] = 34;
        this.size = sz;
    }

    @NotNull
    public String toString() {
        char[] cArray = this.array;
        int n = 0;
        int n2 = this.size;
        boolean bl = false;
        return new String(cArray, n, n2);
    }

    private final void ensureAdditionalCapacity(int expected) {
        this.ensureTotalCapacity(this.size + expected);
    }

    private final void ensureTotalCapacity(int newSize) {
        if (this.array.length <= newSize) {
            char[] cArray = this.array;
            int n = RangesKt.coerceAtLeast(newSize, this.size * 2);
            boolean bl = false;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkNotNullExpressionValue(cArray2, "java.util.Arrays.copyOf(this, newSize)");
            this.array = cArray2;
        }
    }

    public final void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }
}

