/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPModelProto;
import com.google.ortools.linearsolver.MPModelRequest;
import com.google.ortools.linearsolver.MPObjective;
import com.google.ortools.linearsolver.MPSolutionResponse;
import com.google.ortools.linearsolver.MPSolverParameters;
import com.google.ortools.linearsolver.MPVariable;
import com.google.ortools.linearsolver.mainJNI;
import com.google.protobuf.InvalidProtocolBufferException;

public class MPSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPSolver(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MPSolver obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(MPSolver obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_MPSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MPVariable[] makeVarArray(int count, double lb, double ub, boolean integer) {
        MPVariable[] array = new MPVariable[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this.makeVar(lb, ub, integer, "");
        }
        return array;
    }

    public MPVariable[] makeVarArray(int count, double lb, double ub, boolean integer, String var_name) {
        MPVariable[] array = new MPVariable[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this.makeVar(lb, ub, integer, var_name + i);
        }
        return array;
    }

    public MPVariable[] makeNumVarArray(int count, double lb, double ub) {
        return this.makeVarArray(count, lb, ub, false);
    }

    public MPVariable[] makeNumVarArray(int count, double lb, double ub, String var_name) {
        return this.makeVarArray(count, lb, ub, false, var_name);
    }

    public MPVariable[] makeIntVarArray(int count, double lb, double ub) {
        return this.makeVarArray(count, lb, ub, true);
    }

    public MPVariable[] makeIntVarArray(int count, double lb, double ub, String var_name) {
        return this.makeVarArray(count, lb, ub, true, var_name);
    }

    public MPVariable[] makeBoolVarArray(int count) {
        return this.makeVarArray(count, 0.0, 1.0, true);
    }

    public MPVariable[] makeBoolVarArray(int count, String var_name) {
        return this.makeVarArray(count, 0.0, 1.0, true, var_name);
    }

    public MPSolver(String name, OptimizationProblemType problem_type) {
        this(mainJNI.new_MPSolver(name, problem_type.swigValue()), true);
    }

    public static MPSolver createSolver(String solver_id) {
        long cPtr = mainJNI.MPSolver_createSolver(solver_id);
        return cPtr == 0L ? null : new MPSolver(cPtr, true);
    }

    public static boolean supportsProblemType(OptimizationProblemType problem_type) {
        return mainJNI.MPSolver_supportsProblemType(problem_type.swigValue());
    }

    public boolean isMip() {
        return mainJNI.MPSolver_isMip(this.swigCPtr, this);
    }

    public OptimizationProblemType problemType() {
        return OptimizationProblemType.swigToEnum(mainJNI.MPSolver_problemType(this.swigCPtr, this));
    }

    public void clear() {
        mainJNI.MPSolver_clear(this.swigCPtr, this);
    }

    public int numVariables() {
        return mainJNI.MPSolver_numVariables(this.swigCPtr, this);
    }

    public MPVariable[] variables() {
        return mainJNI.MPSolver_variables(this.swigCPtr, this);
    }

    public MPVariable variable(int index) {
        long cPtr = mainJNI.MPSolver_variable(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable lookupVariableOrNull(String var_name) {
        long cPtr = mainJNI.MPSolver_lookupVariableOrNull(this.swigCPtr, this, var_name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeVar(double lb, double ub, boolean integer, String name) {
        long cPtr = mainJNI.MPSolver_makeVar(this.swigCPtr, this, lb, ub, integer, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeNumVar(double lb, double ub, String name) {
        long cPtr = mainJNI.MPSolver_makeNumVar(this.swigCPtr, this, lb, ub, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeIntVar(double lb, double ub, String name) {
        long cPtr = mainJNI.MPSolver_makeIntVar(this.swigCPtr, this, lb, ub, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public MPVariable makeBoolVar(String name) {
        long cPtr = mainJNI.MPSolver_makeBoolVar(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new MPVariable(cPtr, false);
    }

    public int numConstraints() {
        return mainJNI.MPSolver_numConstraints(this.swigCPtr, this);
    }

    public MPConstraint[] constraints() {
        return mainJNI.MPSolver_constraints(this.swigCPtr, this);
    }

    public MPConstraint constraint(int index) {
        long cPtr = mainJNI.MPSolver_constraint(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint lookupConstraintOrNull(String constraint_name) {
        long cPtr = mainJNI.MPSolver_lookupConstraintOrNull(this.swigCPtr, this, constraint_name);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint(double lb, double ub) {
        long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_0(this.swigCPtr, this, lb, ub);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint() {
        long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint(double lb, double ub, String name) {
        long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_2(this.swigCPtr, this, lb, ub, name);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPConstraint makeConstraint(String name) {
        long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_3(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new MPConstraint(cPtr, false);
    }

    public MPObjective objective() {
        long cPtr = mainJNI.MPSolver_objective(this.swigCPtr, this);
        return cPtr == 0L ? null : new MPObjective(cPtr, false);
    }

    public ResultStatus solve() {
        return ResultStatus.swigToEnum(mainJNI.MPSolver_solve__SWIG_0(this.swigCPtr, this));
    }

    public ResultStatus solve(MPSolverParameters param) {
        return ResultStatus.swigToEnum(mainJNI.MPSolver_solve__SWIG_1(this.swigCPtr, this, MPSolverParameters.getCPtr(param), param));
    }

    public void write(String file_name) {
        mainJNI.MPSolver_write(this.swigCPtr, this, file_name);
    }

    public double[] computeConstraintActivities() {
        return mainJNI.MPSolver_computeConstraintActivities(this.swigCPtr, this);
    }

    public boolean verifySolution(double tolerance, boolean log_errors) {
        return mainJNI.MPSolver_verifySolution(this.swigCPtr, this, tolerance, log_errors);
    }

    public void reset() {
        mainJNI.MPSolver_reset(this.swigCPtr, this);
    }

    public boolean interruptSolve() {
        return mainJNI.MPSolver_interruptSolve(this.swigCPtr, this);
    }

    public boolean setSolverSpecificParametersAsString(String parameters) {
        return mainJNI.MPSolver_setSolverSpecificParametersAsString(this.swigCPtr, this, parameters);
    }

    public static double infinity() {
        return mainJNI.MPSolver_infinity();
    }

    public void enableOutput() {
        mainJNI.MPSolver_enableOutput(this.swigCPtr, this);
    }

    public void suppressOutput() {
        mainJNI.MPSolver_suppressOutput(this.swigCPtr, this);
    }

    public long iterations() {
        return mainJNI.MPSolver_iterations(this.swigCPtr, this);
    }

    public long nodes() {
        return mainJNI.MPSolver_nodes(this.swigCPtr, this);
    }

    public String solverVersion() {
        return mainJNI.MPSolver_solverVersion(this.swigCPtr, this);
    }

    public double computeExactConditionNumber() {
        return mainJNI.MPSolver_computeExactConditionNumber(this.swigCPtr, this);
    }

    public void setTimeLimit(long time_limit_milliseconds) {
        mainJNI.MPSolver_setTimeLimit(this.swigCPtr, this, time_limit_milliseconds);
    }

    public long wallTime() {
        return mainJNI.MPSolver_wallTime(this.swigCPtr, this);
    }

    public String loadModelFromProto(MPModelProto input_model) {
        return mainJNI.MPSolver_loadModelFromProto(this.swigCPtr, this, input_model.toByteArray());
    }

    public String loadModelFromProtoKeepNames(MPModelProto input_model) {
        return mainJNI.MPSolver_loadModelFromProtoKeepNames(this.swigCPtr, this, input_model.toByteArray());
    }

    public String loadModelFromProtoWithUniqueNamesOrDie(MPModelProto input_model) {
        return mainJNI.MPSolver_loadModelFromProtoWithUniqueNamesOrDie(this.swigCPtr, this, input_model.toByteArray());
    }

    public MPModelProto exportModelToProto() {
        byte[] buf = mainJNI.MPSolver_exportModelToProto(this.swigCPtr, this);
        if (buf == null || buf.length == 0) {
            return null;
        }
        try {
            return MPModelProto.parseFrom(buf);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to parse com.google.ortools.linearsolver.MPModelProto protocol message.");
        }
    }

    public MPSolutionResponse createSolutionResponseProto() {
        byte[] buf = mainJNI.MPSolver_createSolutionResponseProto(this.swigCPtr, this);
        if (buf == null || buf.length == 0) {
            return null;
        }
        try {
            return MPSolutionResponse.parseFrom(buf);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to parse com.google.ortools.linearsolver.MPSolutionResponse protocol message.");
        }
    }

    public boolean loadSolutionFromProto(MPSolutionResponse response) {
        return mainJNI.MPSolver_loadSolutionFromProto(this.swigCPtr, this, response.toByteArray());
    }

    public static MPSolutionResponse solveWithProto(MPModelRequest model_request) {
        byte[] buf = mainJNI.MPSolver_solveWithProto(model_request.toByteArray());
        if (buf == null || buf.length == 0) {
            return null;
        }
        try {
            return MPSolutionResponse.parseFrom(buf);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to parse com.google.ortools.linearsolver.MPSolutionResponse protocol message.");
        }
    }

    public String exportModelAsLpFormat(boolean obfuscate) {
        return mainJNI.MPSolver_exportModelAsLpFormat__SWIG_0(this.swigCPtr, this, obfuscate);
    }

    public String exportModelAsLpFormat() {
        return mainJNI.MPSolver_exportModelAsLpFormat__SWIG_1(this.swigCPtr, this);
    }

    public String exportModelAsMpsFormat(boolean fixed_format, boolean obfuscate) {
        return mainJNI.MPSolver_exportModelAsMpsFormat(this.swigCPtr, this, fixed_format, obfuscate);
    }

    public boolean writeModelToMpsFile(String filename, boolean fixed_format, boolean obfuscate) {
        return mainJNI.MPSolver_writeModelToMpsFile(this.swigCPtr, this, filename, fixed_format, obfuscate);
    }

    public void setHint(MPVariable[] variables, double[] values) {
        mainJNI.MPSolver_setHint(this.swigCPtr, this, variables, values);
    }

    public boolean setNumThreads(int num_theads) {
        return mainJNI.MPSolver_setNumThreads(this.swigCPtr, this, num_theads);
    }

    public static enum OptimizationProblemType {
        CLP_LINEAR_PROGRAMMING(mainJNI.MPSolver_CLP_LINEAR_PROGRAMMING_get()),
        GLPK_LINEAR_PROGRAMMING(mainJNI.MPSolver_GLPK_LINEAR_PROGRAMMING_get()),
        GLOP_LINEAR_PROGRAMMING(mainJNI.MPSolver_GLOP_LINEAR_PROGRAMMING_get()),
        PDLP_LINEAR_PROGRAMMING(mainJNI.MPSolver_PDLP_LINEAR_PROGRAMMING_get()),
        SCIP_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_SCIP_MIXED_INTEGER_PROGRAMMING_get()),
        GLPK_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_GLPK_MIXED_INTEGER_PROGRAMMING_get()),
        CBC_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_CBC_MIXED_INTEGER_PROGRAMMING_get()),
        BOP_INTEGER_PROGRAMMING(mainJNI.MPSolver_BOP_INTEGER_PROGRAMMING_get()),
        SAT_INTEGER_PROGRAMMING(mainJNI.MPSolver_SAT_INTEGER_PROGRAMMING_get()),
        GUROBI_LINEAR_PROGRAMMING(mainJNI.MPSolver_GUROBI_LINEAR_PROGRAMMING_get()),
        GUROBI_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_GUROBI_MIXED_INTEGER_PROGRAMMING_get()),
        CPLEX_LINEAR_PROGRAMMING(mainJNI.MPSolver_CPLEX_LINEAR_PROGRAMMING_get()),
        CPLEX_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_CPLEX_MIXED_INTEGER_PROGRAMMING_get()),
        XPRESS_LINEAR_PROGRAMMING(mainJNI.MPSolver_XPRESS_LINEAR_PROGRAMMING_get()),
        XPRESS_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_XPRESS_MIXED_INTEGER_PROGRAMMING_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static OptimizationProblemType swigToEnum(int swigValue) {
            OptimizationProblemType[] swigValues = (OptimizationProblemType[])OptimizationProblemType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (OptimizationProblemType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + OptimizationProblemType.class + " with value " + swigValue);
        }

        private OptimizationProblemType() {
            this.swigValue = SwigNext.next++;
        }

        private OptimizationProblemType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private OptimizationProblemType(OptimizationProblemType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ResultStatus {
        OPTIMAL,
        FEASIBLE,
        INFEASIBLE,
        UNBOUNDED,
        ABNORMAL,
        MODEL_INVALID,
        NOT_SOLVED(mainJNI.MPSolver_NOT_SOLVED_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ResultStatus swigToEnum(int swigValue) {
            ResultStatus[] swigValues = (ResultStatus[])ResultStatus.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ResultStatus swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ResultStatus.class + " with value " + swigValue);
        }

        private ResultStatus() {
            this.swigValue = SwigNext.next++;
        }

        private ResultStatus(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ResultStatus(ResultStatus swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum BasisStatus {
        FREE(mainJNI.MPSolver_FREE_get()),
        AT_LOWER_BOUND,
        AT_UPPER_BOUND,
        FIXED_VALUE,
        BASIC;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static BasisStatus swigToEnum(int swigValue) {
            BasisStatus[] swigValues = (BasisStatus[])BasisStatus.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (BasisStatus swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + BasisStatus.class + " with value " + swigValue);
        }

        private BasisStatus() {
            this.swigValue = SwigNext.next++;
        }

        private BasisStatus(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private BasisStatus(BasisStatus swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

