/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.LinearSolver;
import com.google.ortools.linearsolver.MPSolution;
import com.google.ortools.linearsolver.MPSolutionOrBuilder;
import com.google.ortools.linearsolver.MPSolutionResponseOrBuilder;
import com.google.ortools.linearsolver.MPSolveInfo;
import com.google.ortools.linearsolver.MPSolveInfoOrBuilder;
import com.google.ortools.linearsolver.MPSolverResponseStatus;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class MPSolutionResponse
extends GeneratedMessage
implements MPSolutionResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_ = 99;
    public static final int STATUS_STR_FIELD_NUMBER = 7;
    private volatile Object statusStr_ = "";
    public static final int OBJECTIVE_VALUE_FIELD_NUMBER = 2;
    private double objectiveValue_ = 0.0;
    public static final int BEST_OBJECTIVE_BOUND_FIELD_NUMBER = 5;
    private double bestObjectiveBound_ = 0.0;
    public static final int VARIABLE_VALUE_FIELD_NUMBER = 3;
    private Internal.DoubleList variableValue_ = MPSolutionResponse.emptyDoubleList();
    private int variableValueMemoizedSerializedSize = -1;
    public static final int SOLVE_INFO_FIELD_NUMBER = 10;
    private MPSolveInfo solveInfo_;
    public static final int SOLVER_SPECIFIC_INFO_FIELD_NUMBER = 11;
    private ByteString solverSpecificInfo_ = ByteString.EMPTY;
    public static final int DUAL_VALUE_FIELD_NUMBER = 4;
    private Internal.DoubleList dualValue_ = MPSolutionResponse.emptyDoubleList();
    private int dualValueMemoizedSerializedSize = -1;
    public static final int REDUCED_COST_FIELD_NUMBER = 6;
    private Internal.DoubleList reducedCost_ = MPSolutionResponse.emptyDoubleList();
    private int reducedCostMemoizedSerializedSize = -1;
    public static final int ADDITIONAL_SOLUTIONS_FIELD_NUMBER = 8;
    private List<MPSolution> additionalSolutions_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final MPSolutionResponse DEFAULT_INSTANCE;
    private static final Parser<MPSolutionResponse> PARSER;

    private MPSolutionResponse(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private MPSolutionResponse() {
        this.status_ = 99;
        this.statusStr_ = "";
        this.variableValue_ = MPSolutionResponse.emptyDoubleList();
        this.solverSpecificInfo_ = ByteString.EMPTY;
        this.dualValue_ = MPSolutionResponse.emptyDoubleList();
        this.reducedCost_ = MPSolutionResponse.emptyDoubleList();
        this.additionalSolutions_ = Collections.emptyList();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return LinearSolver.internal_static_operations_research_MPSolutionResponse_descriptor;
    }

    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return LinearSolver.internal_static_operations_research_MPSolutionResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(MPSolutionResponse.class, Builder.class);
    }

    @Override
    public boolean hasStatus() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public MPSolverResponseStatus getStatus() {
        MPSolverResponseStatus result = MPSolverResponseStatus.forNumber(this.status_);
        return result == null ? MPSolverResponseStatus.MPSOLVER_UNKNOWN_STATUS : result;
    }

    @Override
    public boolean hasStatusStr() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getStatusStr() {
        Object ref = this.statusStr_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
            this.statusStr_ = s;
        }
        return s;
    }

    @Override
    public ByteString getStatusStrBytes() {
        Object ref = this.statusStr_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.statusStr_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasObjectiveValue() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public double getObjectiveValue() {
        return this.objectiveValue_;
    }

    @Override
    public boolean hasBestObjectiveBound() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public double getBestObjectiveBound() {
        return this.bestObjectiveBound_;
    }

    @Override
    public List<Double> getVariableValueList() {
        return this.variableValue_;
    }

    @Override
    public int getVariableValueCount() {
        return this.variableValue_.size();
    }

    @Override
    public double getVariableValue(int index) {
        return this.variableValue_.getDouble(index);
    }

    @Override
    public boolean hasSolveInfo() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public MPSolveInfo getSolveInfo() {
        return this.solveInfo_ == null ? MPSolveInfo.getDefaultInstance() : this.solveInfo_;
    }

    @Override
    public MPSolveInfoOrBuilder getSolveInfoOrBuilder() {
        return this.solveInfo_ == null ? MPSolveInfo.getDefaultInstance() : this.solveInfo_;
    }

    @Override
    public boolean hasSolverSpecificInfo() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public ByteString getSolverSpecificInfo() {
        return this.solverSpecificInfo_;
    }

    @Override
    public List<Double> getDualValueList() {
        return this.dualValue_;
    }

    @Override
    public int getDualValueCount() {
        return this.dualValue_.size();
    }

    @Override
    public double getDualValue(int index) {
        return this.dualValue_.getDouble(index);
    }

    @Override
    public List<Double> getReducedCostList() {
        return this.reducedCost_;
    }

    @Override
    public int getReducedCostCount() {
        return this.reducedCost_.size();
    }

    @Override
    public double getReducedCost(int index) {
        return this.reducedCost_.getDouble(index);
    }

    @Override
    public List<MPSolution> getAdditionalSolutionsList() {
        return this.additionalSolutions_;
    }

    @Override
    public List<? extends MPSolutionOrBuilder> getAdditionalSolutionsOrBuilderList() {
        return this.additionalSolutions_;
    }

    @Override
    public int getAdditionalSolutionsCount() {
        return this.additionalSolutions_.size();
    }

    @Override
    public MPSolution getAdditionalSolutions(int index) {
        return this.additionalSolutions_.get(index);
    }

    @Override
    public MPSolutionOrBuilder getAdditionalSolutionsOrBuilder(int index) {
        return this.additionalSolutions_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if ((this.bitField0_ & 1) != 0) {
            output.writeEnum(1, this.status_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeDouble(2, this.objectiveValue_);
        }
        if (this.getVariableValueList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.variableValueMemoizedSerializedSize);
        }
        for (i = 0; i < this.variableValue_.size(); ++i) {
            output.writeDoubleNoTag(this.variableValue_.getDouble(i));
        }
        if (this.getDualValueList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.dualValueMemoizedSerializedSize);
        }
        for (i = 0; i < this.dualValue_.size(); ++i) {
            output.writeDoubleNoTag(this.dualValue_.getDouble(i));
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeDouble(5, this.bestObjectiveBound_);
        }
        if (this.getReducedCostList().size() > 0) {
            output.writeUInt32NoTag(50);
            output.writeUInt32NoTag(this.reducedCostMemoizedSerializedSize);
        }
        for (i = 0; i < this.reducedCost_.size(); ++i) {
            output.writeDoubleNoTag(this.reducedCost_.getDouble(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)7, (Object)this.statusStr_);
        }
        for (i = 0; i < this.additionalSolutions_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.additionalSolutions_.get(i));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(10, (MessageLite)this.getSolveInfo());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeBytes(11, this.solverSpecificInfo_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.status_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)2, (double)this.objectiveValue_);
        }
        int dataSize = 0;
        dataSize = 8 * this.getVariableValueList().size();
        size += dataSize;
        if (!this.getVariableValueList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.variableValueMemoizedSerializedSize = dataSize;
        dataSize = 0;
        dataSize = 8 * this.getDualValueList().size();
        size += dataSize;
        if (!this.getDualValueList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.dualValueMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)5, (double)this.bestObjectiveBound_);
        }
        dataSize = 0;
        dataSize = 8 * this.getReducedCostList().size();
        size += dataSize;
        if (!this.getReducedCostList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.reducedCostMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessage.computeStringSize((int)7, (Object)this.statusStr_);
        }
        for (int i = 0; i < this.additionalSolutions_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.additionalSolutions_.get(i)));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getSolveInfo());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeBytesSize((int)11, (ByteString)this.solverSpecificInfo_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MPSolutionResponse)) {
            return super.equals(obj);
        }
        MPSolutionResponse other = (MPSolutionResponse)obj;
        if (this.hasStatus() != other.hasStatus()) {
            return false;
        }
        if (this.hasStatus() && this.status_ != other.status_) {
            return false;
        }
        if (this.hasStatusStr() != other.hasStatusStr()) {
            return false;
        }
        if (this.hasStatusStr() && !this.getStatusStr().equals(other.getStatusStr())) {
            return false;
        }
        if (this.hasObjectiveValue() != other.hasObjectiveValue()) {
            return false;
        }
        if (this.hasObjectiveValue() && Double.doubleToLongBits(this.getObjectiveValue()) != Double.doubleToLongBits(other.getObjectiveValue())) {
            return false;
        }
        if (this.hasBestObjectiveBound() != other.hasBestObjectiveBound()) {
            return false;
        }
        if (this.hasBestObjectiveBound() && Double.doubleToLongBits(this.getBestObjectiveBound()) != Double.doubleToLongBits(other.getBestObjectiveBound())) {
            return false;
        }
        if (!this.getVariableValueList().equals(other.getVariableValueList())) {
            return false;
        }
        if (this.hasSolveInfo() != other.hasSolveInfo()) {
            return false;
        }
        if (this.hasSolveInfo() && !this.getSolveInfo().equals(other.getSolveInfo())) {
            return false;
        }
        if (this.hasSolverSpecificInfo() != other.hasSolverSpecificInfo()) {
            return false;
        }
        if (this.hasSolverSpecificInfo() && !this.getSolverSpecificInfo().equals((Object)other.getSolverSpecificInfo())) {
            return false;
        }
        if (!this.getDualValueList().equals(other.getDualValueList())) {
            return false;
        }
        if (!this.getReducedCostList().equals(other.getReducedCostList())) {
            return false;
        }
        if (!this.getAdditionalSolutionsList().equals(other.getAdditionalSolutionsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + MPSolutionResponse.getDescriptor().hashCode();
        if (this.hasStatus()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.status_;
        }
        if (this.hasStatusStr()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getStatusStr().hashCode();
        }
        if (this.hasObjectiveValue()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getObjectiveValue()));
        }
        if (this.hasBestObjectiveBound()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getBestObjectiveBound()));
        }
        if (this.getVariableValueCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getVariableValueList().hashCode();
        }
        if (this.hasSolveInfo()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getSolveInfo().hashCode();
        }
        if (this.hasSolverSpecificInfo()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getSolverSpecificInfo().hashCode();
        }
        if (this.getDualValueCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getDualValueList().hashCode();
        }
        if (this.getReducedCostCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getReducedCostList().hashCode();
        }
        if (this.getAdditionalSolutionsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAdditionalSolutionsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static MPSolutionResponse parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (MPSolutionResponse)PARSER.parseFrom(data);
    }

    public static MPSolutionResponse parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MPSolutionResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MPSolutionResponse parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (MPSolutionResponse)PARSER.parseFrom(data);
    }

    public static MPSolutionResponse parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MPSolutionResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MPSolutionResponse parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MPSolutionResponse)PARSER.parseFrom(data);
    }

    public static MPSolutionResponse parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MPSolutionResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MPSolutionResponse parseFrom(InputStream input) throws IOException {
        return (MPSolutionResponse)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
    }

    public static MPSolutionResponse parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MPSolutionResponse)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MPSolutionResponse parseDelimitedFrom(InputStream input) throws IOException {
        return (MPSolutionResponse)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static MPSolutionResponse parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MPSolutionResponse)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MPSolutionResponse parseFrom(CodedInputStream input) throws IOException {
        return (MPSolutionResponse)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static MPSolutionResponse parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MPSolutionResponse)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return MPSolutionResponse.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MPSolutionResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static MPSolutionResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<MPSolutionResponse> parser() {
        return PARSER;
    }

    public Parser<MPSolutionResponse> getParserForType() {
        return PARSER;
    }

    public MPSolutionResponse getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.DoubleList access$1900() {
        return MPSolutionResponse.emptyDoubleList();
    }

    static /* synthetic */ Internal.DoubleList access$2300() {
        return MPSolutionResponse.emptyDoubleList();
    }

    static /* synthetic */ Internal.DoubleList access$2700() {
        return MPSolutionResponse.emptyDoubleList();
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)29, (int)3, (String)"", (String)MPSolutionResponse.class.getName());
        DEFAULT_INSTANCE = new MPSolutionResponse();
        PARSER = new AbstractParser<MPSolutionResponse>(){

            public MPSolutionResponse parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = MPSolutionResponse.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements MPSolutionResponseOrBuilder {
        private int bitField0_;
        private int status_ = 99;
        private Object statusStr_ = "";
        private double objectiveValue_;
        private double bestObjectiveBound_;
        private Internal.DoubleList variableValue_ = MPSolutionResponse.access$1900();
        private MPSolveInfo solveInfo_;
        private SingleFieldBuilder<MPSolveInfo, MPSolveInfo.Builder, MPSolveInfoOrBuilder> solveInfoBuilder_;
        private ByteString solverSpecificInfo_ = ByteString.EMPTY;
        private Internal.DoubleList dualValue_ = MPSolutionResponse.access$2300();
        private Internal.DoubleList reducedCost_ = MPSolutionResponse.access$2700();
        private List<MPSolution> additionalSolutions_ = Collections.emptyList();
        private RepeatedFieldBuilder<MPSolution, MPSolution.Builder, MPSolutionOrBuilder> additionalSolutionsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return LinearSolver.internal_static_operations_research_MPSolutionResponse_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return LinearSolver.internal_static_operations_research_MPSolutionResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(MPSolutionResponse.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getSolveInfoFieldBuilder();
                this.getAdditionalSolutionsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.status_ = 99;
            this.statusStr_ = "";
            this.objectiveValue_ = 0.0;
            this.bestObjectiveBound_ = 0.0;
            this.variableValue_ = MPSolutionResponse.emptyDoubleList();
            this.solveInfo_ = null;
            if (this.solveInfoBuilder_ != null) {
                this.solveInfoBuilder_.dispose();
                this.solveInfoBuilder_ = null;
            }
            this.solverSpecificInfo_ = ByteString.EMPTY;
            this.dualValue_ = MPSolutionResponse.emptyDoubleList();
            this.reducedCost_ = MPSolutionResponse.emptyDoubleList();
            if (this.additionalSolutionsBuilder_ == null) {
                this.additionalSolutions_ = Collections.emptyList();
            } else {
                this.additionalSolutions_ = null;
                this.additionalSolutionsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return LinearSolver.internal_static_operations_research_MPSolutionResponse_descriptor;
        }

        public MPSolutionResponse getDefaultInstanceForType() {
            return MPSolutionResponse.getDefaultInstance();
        }

        public MPSolutionResponse build() {
            MPSolutionResponse result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public MPSolutionResponse buildPartial() {
            MPSolutionResponse result = new MPSolutionResponse(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(MPSolutionResponse result) {
            if (this.additionalSolutionsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.additionalSolutions_ = Collections.unmodifiableList(this.additionalSolutions_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.additionalSolutions_ = this.additionalSolutions_;
            } else {
                result.additionalSolutions_ = this.additionalSolutionsBuilder_.build();
            }
        }

        private void buildPartial0(MPSolutionResponse result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.status_ = this.status_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.statusStr_ = this.statusStr_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.objectiveValue_ = this.objectiveValue_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.bestObjectiveBound_ = this.bestObjectiveBound_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.variableValue_.makeImmutable();
                result.variableValue_ = this.variableValue_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.solveInfo_ = this.solveInfoBuilder_ == null ? this.solveInfo_ : (MPSolveInfo)this.solveInfoBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.solverSpecificInfo_ = this.solverSpecificInfo_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                this.dualValue_.makeImmutable();
                result.dualValue_ = this.dualValue_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                this.reducedCost_.makeImmutable();
                result.reducedCost_ = this.reducedCost_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof MPSolutionResponse) {
                return this.mergeFrom((MPSolutionResponse)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(MPSolutionResponse other) {
            if (other == MPSolutionResponse.getDefaultInstance()) {
                return this;
            }
            if (other.hasStatus()) {
                this.setStatus(other.getStatus());
            }
            if (other.hasStatusStr()) {
                this.statusStr_ = other.statusStr_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasObjectiveValue()) {
                this.setObjectiveValue(other.getObjectiveValue());
            }
            if (other.hasBestObjectiveBound()) {
                this.setBestObjectiveBound(other.getBestObjectiveBound());
            }
            if (!other.variableValue_.isEmpty()) {
                if (this.variableValue_.isEmpty()) {
                    this.variableValue_ = other.variableValue_;
                    this.variableValue_.makeImmutable();
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensureVariableValueIsMutable();
                    this.variableValue_.addAll((Collection)other.variableValue_);
                }
                this.onChanged();
            }
            if (other.hasSolveInfo()) {
                this.mergeSolveInfo(other.getSolveInfo());
            }
            if (other.hasSolverSpecificInfo()) {
                this.setSolverSpecificInfo(other.getSolverSpecificInfo());
            }
            if (!other.dualValue_.isEmpty()) {
                if (this.dualValue_.isEmpty()) {
                    this.dualValue_ = other.dualValue_;
                    this.dualValue_.makeImmutable();
                    this.bitField0_ |= 0x80;
                } else {
                    this.ensureDualValueIsMutable();
                    this.dualValue_.addAll((Collection)other.dualValue_);
                }
                this.onChanged();
            }
            if (!other.reducedCost_.isEmpty()) {
                if (this.reducedCost_.isEmpty()) {
                    this.reducedCost_ = other.reducedCost_;
                    this.reducedCost_.makeImmutable();
                    this.bitField0_ |= 0x100;
                } else {
                    this.ensureReducedCostIsMutable();
                    this.reducedCost_.addAll((Collection)other.reducedCost_);
                }
                this.onChanged();
            }
            if (this.additionalSolutionsBuilder_ == null) {
                if (!other.additionalSolutions_.isEmpty()) {
                    if (this.additionalSolutions_.isEmpty()) {
                        this.additionalSolutions_ = other.additionalSolutions_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureAdditionalSolutionsIsMutable();
                        this.additionalSolutions_.addAll(other.additionalSolutions_);
                    }
                    this.onChanged();
                }
            } else if (!other.additionalSolutions_.isEmpty()) {
                if (this.additionalSolutionsBuilder_.isEmpty()) {
                    this.additionalSolutionsBuilder_.dispose();
                    this.additionalSolutionsBuilder_ = null;
                    this.additionalSolutions_ = other.additionalSolutions_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.additionalSolutionsBuilder_ = alwaysUseFieldBuilders ? this.getAdditionalSolutionsFieldBuilder() : null;
                } else {
                    this.additionalSolutionsBuilder_.addAllMessages((Iterable)other.additionalSolutions_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 8: {
                            int tmpRaw = input.readEnum();
                            MPSolverResponseStatus tmpValue = MPSolverResponseStatus.forNumber(tmpRaw);
                            if (tmpValue == null) {
                                this.mergeUnknownVarintField(1, tmpRaw);
                                continue block21;
                            }
                            this.status_ = tmpRaw;
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 17: {
                            this.objectiveValue_ = input.readDouble();
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 25: {
                            double v = input.readDouble();
                            this.ensureVariableValueIsMutable();
                            this.variableValue_.addDouble(v);
                            continue block21;
                        }
                        case 26: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            int alloc = length > 4096 ? 4096 : length;
                            this.ensureVariableValueIsMutable(alloc / 8);
                            while (input.getBytesUntilLimit() > 0) {
                                this.variableValue_.addDouble(input.readDouble());
                            }
                            input.popLimit(limit);
                            continue block21;
                        }
                        case 33: {
                            double v = input.readDouble();
                            this.ensureDualValueIsMutable();
                            this.dualValue_.addDouble(v);
                            continue block21;
                        }
                        case 34: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            int alloc = length > 4096 ? 4096 : length;
                            this.ensureDualValueIsMutable(alloc / 8);
                            while (input.getBytesUntilLimit() > 0) {
                                this.dualValue_.addDouble(input.readDouble());
                            }
                            input.popLimit(limit);
                            continue block21;
                        }
                        case 41: {
                            this.bestObjectiveBound_ = input.readDouble();
                            this.bitField0_ |= 8;
                            continue block21;
                        }
                        case 49: {
                            double v = input.readDouble();
                            this.ensureReducedCostIsMutable();
                            this.reducedCost_.addDouble(v);
                            continue block21;
                        }
                        case 50: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            int alloc = length > 4096 ? 4096 : length;
                            this.ensureReducedCostIsMutable(alloc / 8);
                            while (input.getBytesUntilLimit() > 0) {
                                this.reducedCost_.addDouble(input.readDouble());
                            }
                            input.popLimit(limit);
                            continue block21;
                        }
                        case 58: {
                            this.statusStr_ = input.readBytes();
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 66: {
                            MPSolution m = (MPSolution)input.readMessage(MPSolution.parser(), extensionRegistry);
                            if (this.additionalSolutionsBuilder_ == null) {
                                this.ensureAdditionalSolutionsIsMutable();
                                this.additionalSolutions_.add(m);
                                continue block21;
                            }
                            this.additionalSolutionsBuilder_.addMessage((GeneratedMessage)m);
                            continue block21;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getSolveInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 90: {
                            this.solverSpecificInfo_ = input.readBytes();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasStatus() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public MPSolverResponseStatus getStatus() {
            MPSolverResponseStatus result = MPSolverResponseStatus.forNumber(this.status_);
            return result == null ? MPSolverResponseStatus.MPSOLVER_UNKNOWN_STATUS : result;
        }

        public Builder setStatus(MPSolverResponseStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.status_ = 99;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStatusStr() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getStatusStr() {
            Object ref = this.statusStr_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (bs.isValidUtf8()) {
                    this.statusStr_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStatusStrBytes() {
            Object ref = this.statusStr_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.statusStr_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStatusStr(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.statusStr_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearStatusStr() {
            this.statusStr_ = MPSolutionResponse.getDefaultInstance().getStatusStr();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setStatusStrBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.statusStr_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasObjectiveValue() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public double getObjectiveValue() {
            return this.objectiveValue_;
        }

        public Builder setObjectiveValue(double value) {
            this.objectiveValue_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearObjectiveValue() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.objectiveValue_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBestObjectiveBound() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public double getBestObjectiveBound() {
            return this.bestObjectiveBound_;
        }

        public Builder setBestObjectiveBound(double value) {
            this.bestObjectiveBound_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearBestObjectiveBound() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.bestObjectiveBound_ = 0.0;
            this.onChanged();
            return this;
        }

        private void ensureVariableValueIsMutable() {
            if (!this.variableValue_.isModifiable()) {
                this.variableValue_ = (Internal.DoubleList)MPSolutionResponse.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.variableValue_));
            }
            this.bitField0_ |= 0x10;
        }

        private void ensureVariableValueIsMutable(int capacity) {
            if (!this.variableValue_.isModifiable()) {
                this.variableValue_ = (Internal.DoubleList)MPSolutionResponse.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.variableValue_), (int)capacity);
            }
            this.bitField0_ |= 0x10;
        }

        @Override
        public List<Double> getVariableValueList() {
            this.variableValue_.makeImmutable();
            return this.variableValue_;
        }

        @Override
        public int getVariableValueCount() {
            return this.variableValue_.size();
        }

        @Override
        public double getVariableValue(int index) {
            return this.variableValue_.getDouble(index);
        }

        public Builder setVariableValue(int index, double value) {
            this.ensureVariableValueIsMutable();
            this.variableValue_.setDouble(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addVariableValue(double value) {
            this.ensureVariableValueIsMutable();
            this.variableValue_.addDouble(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllVariableValue(Iterable<? extends Double> values) {
            this.ensureVariableValueIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.variableValue_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearVariableValue() {
            this.variableValue_ = MPSolutionResponse.emptyDoubleList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSolveInfo() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public MPSolveInfo getSolveInfo() {
            if (this.solveInfoBuilder_ == null) {
                return this.solveInfo_ == null ? MPSolveInfo.getDefaultInstance() : this.solveInfo_;
            }
            return (MPSolveInfo)this.solveInfoBuilder_.getMessage();
        }

        public Builder setSolveInfo(MPSolveInfo value) {
            if (this.solveInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.solveInfo_ = value;
            } else {
                this.solveInfoBuilder_.setMessage((GeneratedMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setSolveInfo(MPSolveInfo.Builder builderForValue) {
            if (this.solveInfoBuilder_ == null) {
                this.solveInfo_ = builderForValue.build();
            } else {
                this.solveInfoBuilder_.setMessage((GeneratedMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeSolveInfo(MPSolveInfo value) {
            if (this.solveInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.solveInfo_ != null && this.solveInfo_ != MPSolveInfo.getDefaultInstance()) {
                    this.getSolveInfoBuilder().mergeFrom(value);
                } else {
                    this.solveInfo_ = value;
                }
            } else {
                this.solveInfoBuilder_.mergeFrom((GeneratedMessage)value);
            }
            if (this.solveInfo_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSolveInfo() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.solveInfo_ = null;
            if (this.solveInfoBuilder_ != null) {
                this.solveInfoBuilder_.dispose();
                this.solveInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MPSolveInfo.Builder getSolveInfoBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (MPSolveInfo.Builder)this.getSolveInfoFieldBuilder().getBuilder();
        }

        @Override
        public MPSolveInfoOrBuilder getSolveInfoOrBuilder() {
            if (this.solveInfoBuilder_ != null) {
                return (MPSolveInfoOrBuilder)this.solveInfoBuilder_.getMessageOrBuilder();
            }
            return this.solveInfo_ == null ? MPSolveInfo.getDefaultInstance() : this.solveInfo_;
        }

        private SingleFieldBuilder<MPSolveInfo, MPSolveInfo.Builder, MPSolveInfoOrBuilder> getSolveInfoFieldBuilder() {
            if (this.solveInfoBuilder_ == null) {
                this.solveInfoBuilder_ = new SingleFieldBuilder((GeneratedMessage)this.getSolveInfo(), this.getParentForChildren(), this.isClean());
                this.solveInfo_ = null;
            }
            return this.solveInfoBuilder_;
        }

        @Override
        public boolean hasSolverSpecificInfo() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public ByteString getSolverSpecificInfo() {
            return this.solverSpecificInfo_;
        }

        public Builder setSolverSpecificInfo(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.solverSpecificInfo_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearSolverSpecificInfo() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.solverSpecificInfo_ = MPSolutionResponse.getDefaultInstance().getSolverSpecificInfo();
            this.onChanged();
            return this;
        }

        private void ensureDualValueIsMutable() {
            if (!this.dualValue_.isModifiable()) {
                this.dualValue_ = (Internal.DoubleList)MPSolutionResponse.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.dualValue_));
            }
            this.bitField0_ |= 0x80;
        }

        private void ensureDualValueIsMutable(int capacity) {
            if (!this.dualValue_.isModifiable()) {
                this.dualValue_ = (Internal.DoubleList)MPSolutionResponse.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.dualValue_), (int)capacity);
            }
            this.bitField0_ |= 0x80;
        }

        @Override
        public List<Double> getDualValueList() {
            this.dualValue_.makeImmutable();
            return this.dualValue_;
        }

        @Override
        public int getDualValueCount() {
            return this.dualValue_.size();
        }

        @Override
        public double getDualValue(int index) {
            return this.dualValue_.getDouble(index);
        }

        public Builder setDualValue(int index, double value) {
            this.ensureDualValueIsMutable();
            this.dualValue_.setDouble(index, value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addDualValue(double value) {
            this.ensureDualValueIsMutable();
            this.dualValue_.addDouble(value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addAllDualValue(Iterable<? extends Double> values) {
            this.ensureDualValueIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.dualValue_);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearDualValue() {
            this.dualValue_ = MPSolutionResponse.emptyDoubleList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        private void ensureReducedCostIsMutable() {
            if (!this.reducedCost_.isModifiable()) {
                this.reducedCost_ = (Internal.DoubleList)MPSolutionResponse.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.reducedCost_));
            }
            this.bitField0_ |= 0x100;
        }

        private void ensureReducedCostIsMutable(int capacity) {
            if (!this.reducedCost_.isModifiable()) {
                this.reducedCost_ = (Internal.DoubleList)MPSolutionResponse.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.reducedCost_), (int)capacity);
            }
            this.bitField0_ |= 0x100;
        }

        @Override
        public List<Double> getReducedCostList() {
            this.reducedCost_.makeImmutable();
            return this.reducedCost_;
        }

        @Override
        public int getReducedCostCount() {
            return this.reducedCost_.size();
        }

        @Override
        public double getReducedCost(int index) {
            return this.reducedCost_.getDouble(index);
        }

        public Builder setReducedCost(int index, double value) {
            this.ensureReducedCostIsMutable();
            this.reducedCost_.setDouble(index, value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addReducedCost(double value) {
            this.ensureReducedCostIsMutable();
            this.reducedCost_.addDouble(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAllReducedCost(Iterable<? extends Double> values) {
            this.ensureReducedCostIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.reducedCost_);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearReducedCost() {
            this.reducedCost_ = MPSolutionResponse.emptyDoubleList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        private void ensureAdditionalSolutionsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.additionalSolutions_ = new ArrayList<MPSolution>(this.additionalSolutions_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<MPSolution> getAdditionalSolutionsList() {
            if (this.additionalSolutionsBuilder_ == null) {
                return Collections.unmodifiableList(this.additionalSolutions_);
            }
            return this.additionalSolutionsBuilder_.getMessageList();
        }

        @Override
        public int getAdditionalSolutionsCount() {
            if (this.additionalSolutionsBuilder_ == null) {
                return this.additionalSolutions_.size();
            }
            return this.additionalSolutionsBuilder_.getCount();
        }

        @Override
        public MPSolution getAdditionalSolutions(int index) {
            if (this.additionalSolutionsBuilder_ == null) {
                return this.additionalSolutions_.get(index);
            }
            return (MPSolution)this.additionalSolutionsBuilder_.getMessage(index);
        }

        public Builder setAdditionalSolutions(int index, MPSolution value) {
            if (this.additionalSolutionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.set(index, value);
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setAdditionalSolutions(int index, MPSolution.Builder builderForValue) {
            if (this.additionalSolutionsBuilder_ == null) {
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalSolutions(MPSolution value) {
            if (this.additionalSolutionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.add(value);
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addAdditionalSolutions(int index, MPSolution value) {
            if (this.additionalSolutionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.add(index, value);
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addAdditionalSolutions(MPSolution.Builder builderForValue) {
            if (this.additionalSolutionsBuilder_ == null) {
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalSolutions(int index, MPSolution.Builder builderForValue) {
            if (this.additionalSolutionsBuilder_ == null) {
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdditionalSolutions(Iterable<? extends MPSolution> values) {
            if (this.additionalSolutionsBuilder_ == null) {
                this.ensureAdditionalSolutionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.additionalSolutions_);
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdditionalSolutions() {
            if (this.additionalSolutionsBuilder_ == null) {
                this.additionalSolutions_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdditionalSolutions(int index) {
            if (this.additionalSolutionsBuilder_ == null) {
                this.ensureAdditionalSolutionsIsMutable();
                this.additionalSolutions_.remove(index);
                this.onChanged();
            } else {
                this.additionalSolutionsBuilder_.remove(index);
            }
            return this;
        }

        public MPSolution.Builder getAdditionalSolutionsBuilder(int index) {
            return (MPSolution.Builder)this.getAdditionalSolutionsFieldBuilder().getBuilder(index);
        }

        @Override
        public MPSolutionOrBuilder getAdditionalSolutionsOrBuilder(int index) {
            if (this.additionalSolutionsBuilder_ == null) {
                return this.additionalSolutions_.get(index);
            }
            return (MPSolutionOrBuilder)this.additionalSolutionsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends MPSolutionOrBuilder> getAdditionalSolutionsOrBuilderList() {
            if (this.additionalSolutionsBuilder_ != null) {
                return this.additionalSolutionsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.additionalSolutions_);
        }

        public MPSolution.Builder addAdditionalSolutionsBuilder() {
            return (MPSolution.Builder)this.getAdditionalSolutionsFieldBuilder().addBuilder((GeneratedMessage)MPSolution.getDefaultInstance());
        }

        public MPSolution.Builder addAdditionalSolutionsBuilder(int index) {
            return (MPSolution.Builder)this.getAdditionalSolutionsFieldBuilder().addBuilder(index, (GeneratedMessage)MPSolution.getDefaultInstance());
        }

        public List<MPSolution.Builder> getAdditionalSolutionsBuilderList() {
            return this.getAdditionalSolutionsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<MPSolution, MPSolution.Builder, MPSolutionOrBuilder> getAdditionalSolutionsFieldBuilder() {
            if (this.additionalSolutionsBuilder_ == null) {
                this.additionalSolutionsBuilder_ = new RepeatedFieldBuilder(this.additionalSolutions_, (this.bitField0_ & 0x200) != 0, this.getParentForChildren(), this.isClean());
                this.additionalSolutions_ = null;
            }
            return this.additionalSolutionsBuilder_;
        }
    }
}

