/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.algorithms;

import com.google.ortools.algorithms.mainJNI;

public class KnapsackSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected KnapsackSolver(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(KnapsackSolver obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(KnapsackSolver obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_KnapsackSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public KnapsackSolver(String solver_name) {
        this(mainJNI.new_KnapsackSolver__SWIG_0(solver_name), true);
    }

    public KnapsackSolver(SolverType solver_type, String solver_name) {
        this(mainJNI.new_KnapsackSolver__SWIG_1(solver_type.swigValue(), solver_name), true);
    }

    public void init(long[] profits, long[][] weights, long[] capacities) {
        mainJNI.KnapsackSolver_init(this.swigCPtr, this, profits, weights, capacities);
    }

    public long solve() {
        return mainJNI.KnapsackSolver_solve(this.swigCPtr, this);
    }

    public boolean bestSolutionContains(int item_id) {
        return mainJNI.KnapsackSolver_bestSolutionContains(this.swigCPtr, this, item_id);
    }

    public boolean isSolutionOptimal() {
        return mainJNI.KnapsackSolver_isSolutionOptimal(this.swigCPtr, this);
    }

    public String getName() {
        return mainJNI.KnapsackSolver_getName(this.swigCPtr, this);
    }

    public boolean useReduction() {
        return mainJNI.KnapsackSolver_useReduction(this.swigCPtr, this);
    }

    public void setUseReduction(boolean use_reduction) {
        mainJNI.KnapsackSolver_setUseReduction(this.swigCPtr, this, use_reduction);
    }

    public void setTimeLimit(double time_limit_seconds) {
        mainJNI.KnapsackSolver_setTimeLimit(this.swigCPtr, this, time_limit_seconds);
    }

    public static enum SolverType {
        KNAPSACK_BRUTE_FORCE_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_BRUTE_FORCE_SOLVER_get()),
        KNAPSACK_64ITEMS_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_64ITEMS_SOLVER_get()),
        KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_CBC_MIP_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_CBC_MIP_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_SCIP_MIP_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_SCIP_MIP_SOLVER_get()),
        KNAPSACK_DIVIDE_AND_CONQUER_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_DIVIDE_AND_CONQUER_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_CP_SAT_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_CP_SAT_SOLVER_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static SolverType swigToEnum(int swigValue) {
            SolverType[] swigValues = (SolverType[])SolverType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (SolverType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + SolverType.class + " with value " + swigValue);
        }

        private SolverType() {
            this.swigValue = SwigNext.next++;
        }

        private SolverType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private SolverType(SolverType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

