/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jdo.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

@PersistenceCapable
class JdoPersistedCredential {
    @PrimaryKey
    private String userId;
    @Persistent
    private String accessToken;
    @Persistent
    private String refreshToken;
    @Persistent
    private Long expirationTimeMillis;

    JdoPersistedCredential(String userId, Credential credential) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId);
        this.accessToken = credential.getAccessToken();
        this.refreshToken = credential.getRefreshToken();
        this.expirationTimeMillis = credential.getExpirationTimeMilliseconds();
    }

    void load(Credential credential) {
        credential.setAccessToken(this.accessToken);
        credential.setRefreshToken(this.refreshToken);
        credential.setExpirationTimeMilliseconds(this.expirationTimeMillis);
    }
}

