/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.java6.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.common.base.Preconditions;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public class AuthorizationCodeInstalledApp {
    private final AuthorizationCodeFlow flow;
    private final VerificationCodeReceiver receiver;

    public AuthorizationCodeInstalledApp(AuthorizationCodeFlow flow, VerificationCodeReceiver receiver) {
        this.flow = (AuthorizationCodeFlow)Preconditions.checkNotNull((Object)flow);
        this.receiver = (VerificationCodeReceiver)Preconditions.checkNotNull((Object)receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential authorize(String userId) throws IOException {
        try {
            Credential credential = this.flow.loadCredential(userId);
            if (credential != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() > 60L)) {
                Credential credential2 = credential;
                return credential2;
            }
            String redirectUri = this.receiver.getRedirectUri();
            AuthorizationCodeRequestUrl authorizationUrl = this.flow.newAuthorizationUrl().setRedirectUri(redirectUri);
            this.onAuthorization(authorizationUrl);
            String code = this.receiver.waitForCode();
            TokenResponse response = this.flow.newTokenRequest(code).setRedirectUri(redirectUri).execute();
            Credential credential3 = this.flow.createAndStoreCredential(response, userId);
            return credential3;
        }
        finally {
            this.receiver.stop();
        }
    }

    protected void onAuthorization(AuthorizationCodeRequestUrl authorizationUrl) throws IOException {
        AuthorizationCodeInstalledApp.browse(authorizationUrl.build());
    }

    public static void browse(String url) {
        Desktop desktop;
        Preconditions.checkNotNull((Object)url);
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(url));
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("Please open the following URL in your browser:");
        System.out.println("  " + url);
    }

    public final AuthorizationCodeFlow getFlow() {
        return this.flow;
    }

    public final VerificationCodeReceiver getReceiver() {
        return this.receiver;
    }
}

