/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.common.internal.model.ModelUtils;
import com.google.mlkit.common.model.LocalModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@WorkerThread
@KeepForSdk
public class AutoMLModelUtils {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static List<String> readLabelsFile(@NonNull Context context, @NonNull String labelsFilePath, boolean isAsset) throws IOException {
        Object object;
        Object object2;
        void var2_3;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (var2_3 != false) {
            object2 = object2.getAssets().open((String)object);
        } else {
            File file = new File((String)object);
            object2 = new FileInputStream(file);
        }
        try {
            object = new InputStreamReader((InputStream)object2, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            object = bufferedReader.readLine();
            while (object != null) {
                arrayList.add((String)object);
                object = bufferedReader.readLine();
            }
            if (object2 == null) return arrayList;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            try {
                ((InputStream)object2).close();
            }
            finally {
                throw throwable;
            }
        }
        ((InputStream)object2).close();
        return arrayList;
    }

    private AutoMLModelUtils() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static String[] getModelAndLabelFilePaths(@NonNull Context context, @NonNull LocalModel localModel, boolean isAsset) throws IOException {
        void var0_4;
        Object object;
        Object object2 = isAsset != false ? (String)Preconditions.checkNotNull((Object)object.getAssetFilePath()) : (String)Preconditions.checkNotNull((Object)object.getAbsoluteFilePath());
        if (object.isManifestFile()) {
            Context context2;
            void var2_8;
            ModelUtils.AutoMLManifest autoMLManifest = ModelUtils.parseManifestFile((String)object2, (boolean)var2_8, (Context)context2);
            if (autoMLManifest == null) {
                IOException iOException = new IOException("Failed to parse manifest file.");
                throw iOException;
            }
            object = autoMLManifest.getModelType();
            boolean bl = "IMAGE_LABELING".equals(object);
            Object object3 = new Object[]{"IMAGE_LABELING"};
            Preconditions.checkState((boolean)bl, (String)"Model type should be: %s.", (Object[])object3);
            object3 = new File((String)object2);
            object = new File(((File)object3).getParent(), autoMLManifest.getModelFile());
            object = ((File)object).toString();
            object2 = new File((String)object);
            object3 = new File(((File)object2).getParent(), autoMLManifest.getLabelsFile());
            object3 = ((File)object3).toString();
            Object object4 = object;
            object = object3;
        } else {
            object = "";
            String string = object2;
        }
        String[] stringArray = new String[]{var0_4, object};
        return stringArray;
    }
}

