/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.solar.v1;

import com.google.api.HttpBody;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.solar.v1.BuildingInsights;
import com.google.maps.solar.v1.DataLayers;
import com.google.maps.solar.v1.FindClosestBuildingInsightsRequest;
import com.google.maps.solar.v1.GetDataLayersRequest;
import com.google.maps.solar.v1.GetGeoTiffRequest;
import com.google.maps.solar.v1.SolarSettings;
import com.google.maps.solar.v1.stub.SolarStub;
import com.google.maps.solar.v1.stub.SolarStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SolarClient
implements BackgroundResource {
    private final SolarSettings settings;
    private final SolarStub stub;

    public static final SolarClient create() throws IOException {
        return SolarClient.create(SolarSettings.newBuilder().build());
    }

    public static final SolarClient create(SolarSettings settings) throws IOException {
        return new SolarClient(settings);
    }

    public static final SolarClient create(SolarStub stub) {
        return new SolarClient(stub);
    }

    protected SolarClient(SolarSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SolarStubSettings)settings.getStubSettings()).createStub();
    }

    protected SolarClient(SolarStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SolarSettings getSettings() {
        return this.settings;
    }

    public SolarStub getStub() {
        return this.stub;
    }

    public final BuildingInsights findClosestBuildingInsights(FindClosestBuildingInsightsRequest request) {
        return (BuildingInsights)this.findClosestBuildingInsightsCallable().call((Object)request);
    }

    public final UnaryCallable<FindClosestBuildingInsightsRequest, BuildingInsights> findClosestBuildingInsightsCallable() {
        return this.stub.findClosestBuildingInsightsCallable();
    }

    public final DataLayers getDataLayers(GetDataLayersRequest request) {
        return (DataLayers)this.getDataLayersCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataLayersRequest, DataLayers> getDataLayersCallable() {
        return this.stub.getDataLayersCallable();
    }

    public final HttpBody getGeoTiff(GetGeoTiffRequest request) {
        return (HttpBody)this.getGeoTiffCallable().call((Object)request);
    }

    public final UnaryCallable<GetGeoTiffRequest, HttpBody> getGeoTiffCallable() {
        return this.stub.getGeoTiffCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

