/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.solar.v1.stub;

import com.google.api.HttpBody;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.solar.v1.BuildingInsights;
import com.google.maps.solar.v1.DataLayers;
import com.google.maps.solar.v1.FindClosestBuildingInsightsRequest;
import com.google.maps.solar.v1.GetDataLayersRequest;
import com.google.maps.solar.v1.GetGeoTiffRequest;
import com.google.maps.solar.v1.stub.HttpJsonSolarCallableFactory;
import com.google.maps.solar.v1.stub.SolarStub;
import com.google.maps.solar.v1.stub.SolarStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonSolarStub
extends SolarStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<FindClosestBuildingInsightsRequest, BuildingInsights> findClosestBuildingInsightsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.solar.v1.Solar/FindClosestBuildingInsights").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/buildingInsights:findClosest", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "exactQualityRequired", (Object)request.getExactQualityRequired());
        serializer.putQueryParam(fields, "experiments", (Object)request.getExperimentsList());
        serializer.putQueryParam(fields, "location", (Object)request.getLocation());
        serializer.putQueryParam(fields, "requiredQuality", (Object)request.getRequiredQualityValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BuildingInsights.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDataLayersRequest, DataLayers> getDataLayersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.solar.v1.Solar/GetDataLayers").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/dataLayers:get", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "exactQualityRequired", (Object)request.getExactQualityRequired());
        serializer.putQueryParam(fields, "experiments", (Object)request.getExperimentsList());
        serializer.putQueryParam(fields, "location", (Object)request.getLocation());
        serializer.putQueryParam(fields, "pixelSizeMeters", (Object)Float.valueOf(request.getPixelSizeMeters()));
        serializer.putQueryParam(fields, "radiusMeters", (Object)Float.valueOf(request.getRadiusMeters()));
        serializer.putQueryParam(fields, "requiredQuality", (Object)request.getRequiredQualityValue());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DataLayers.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetGeoTiffRequest, HttpBody> getGeoTiffMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.solar.v1.Solar/GetGeoTiff").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/geoTiff:get", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "id", (Object)request.getId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)HttpBody.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<FindClosestBuildingInsightsRequest, BuildingInsights> findClosestBuildingInsightsCallable;
    private final UnaryCallable<GetDataLayersRequest, DataLayers> getDataLayersCallable;
    private final UnaryCallable<GetGeoTiffRequest, HttpBody> getGeoTiffCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSolarStub create(SolarStubSettings settings) throws IOException {
        return new HttpJsonSolarStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSolarStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSolarStub(SolarStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSolarStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSolarStub(SolarStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSolarStub(SolarStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSolarCallableFactory());
    }

    protected HttpJsonSolarStub(SolarStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings findClosestBuildingInsightsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(findClosestBuildingInsightsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getDataLayersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDataLayersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getGeoTiffTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGeoTiffMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.findClosestBuildingInsightsCallable = callableFactory.createUnaryCallable(findClosestBuildingInsightsTransportSettings, settings.findClosestBuildingInsightsSettings(), clientContext);
        this.getDataLayersCallable = callableFactory.createUnaryCallable(getDataLayersTransportSettings, settings.getDataLayersSettings(), clientContext);
        this.getGeoTiffCallable = callableFactory.createUnaryCallable(getGeoTiffTransportSettings, settings.getGeoTiffSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(findClosestBuildingInsightsMethodDescriptor);
        methodDescriptors.add(getDataLayersMethodDescriptor);
        methodDescriptors.add(getGeoTiffMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<FindClosestBuildingInsightsRequest, BuildingInsights> findClosestBuildingInsightsCallable() {
        return this.findClosestBuildingInsightsCallable;
    }

    @Override
    public UnaryCallable<GetDataLayersRequest, DataLayers> getDataLayersCallable() {
        return this.getDataLayersCallable;
    }

    @Override
    public UnaryCallable<GetGeoTiffRequest, HttpBody> getGeoTiffCallable() {
        return this.getGeoTiffCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

