/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.maps.fleetengine.v1.CreateVehicleRequest;
import com.google.maps.fleetengine.v1.DeleteVehicleRequest;
import com.google.maps.fleetengine.v1.GetVehicleRequest;
import com.google.maps.fleetengine.v1.ListVehiclesRequest;
import com.google.maps.fleetengine.v1.ListVehiclesResponse;
import com.google.maps.fleetengine.v1.SearchVehiclesRequest;
import com.google.maps.fleetengine.v1.SearchVehiclesResponse;
import com.google.maps.fleetengine.v1.UpdateVehicleAttributesRequest;
import com.google.maps.fleetengine.v1.UpdateVehicleAttributesResponse;
import com.google.maps.fleetengine.v1.UpdateVehicleRequest;
import com.google.maps.fleetengine.v1.Vehicle;
import com.google.maps.fleetengine.v1.VehicleName;
import com.google.maps.fleetengine.v1.VehicleServiceSettings;
import com.google.maps.fleetengine.v1.stub.VehicleServiceStub;
import com.google.maps.fleetengine.v1.stub.VehicleServiceStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VehicleServiceClient
implements BackgroundResource {
    private final VehicleServiceSettings settings;
    private final VehicleServiceStub stub;

    public static final VehicleServiceClient create() throws IOException {
        return VehicleServiceClient.create(VehicleServiceSettings.newBuilder().build());
    }

    public static final VehicleServiceClient create(VehicleServiceSettings settings) throws IOException {
        return new VehicleServiceClient(settings);
    }

    public static final VehicleServiceClient create(VehicleServiceStub stub) {
        return new VehicleServiceClient(stub);
    }

    protected VehicleServiceClient(VehicleServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VehicleServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected VehicleServiceClient(VehicleServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final VehicleServiceSettings getSettings() {
        return this.settings;
    }

    public VehicleServiceStub getStub() {
        return this.stub;
    }

    public final Vehicle createVehicle(CreateVehicleRequest request) {
        return (Vehicle)this.createVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateVehicleRequest, Vehicle> createVehicleCallable() {
        return this.stub.createVehicleCallable();
    }

    public final Vehicle getVehicle(GetVehicleRequest request) {
        return (Vehicle)this.getVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<GetVehicleRequest, Vehicle> getVehicleCallable() {
        return this.stub.getVehicleCallable();
    }

    public final void deleteVehicle(VehicleName name) {
        DeleteVehicleRequest request = DeleteVehicleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteVehicle(request);
    }

    public final void deleteVehicle(String name) {
        DeleteVehicleRequest request = DeleteVehicleRequest.newBuilder().setName(name).build();
        this.deleteVehicle(request);
    }

    public final void deleteVehicle(DeleteVehicleRequest request) {
        this.deleteVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVehicleRequest, Empty> deleteVehicleCallable() {
        return this.stub.deleteVehicleCallable();
    }

    public final Vehicle updateVehicle(UpdateVehicleRequest request) {
        return (Vehicle)this.updateVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVehicleRequest, Vehicle> updateVehicleCallable() {
        return this.stub.updateVehicleCallable();
    }

    public final UpdateVehicleAttributesResponse updateVehicleAttributes(UpdateVehicleAttributesRequest request) {
        return (UpdateVehicleAttributesResponse)this.updateVehicleAttributesCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVehicleAttributesRequest, UpdateVehicleAttributesResponse> updateVehicleAttributesCallable() {
        return this.stub.updateVehicleAttributesCallable();
    }

    public final ListVehiclesPagedResponse listVehicles(ListVehiclesRequest request) {
        return (ListVehiclesPagedResponse)((Object)this.listVehiclesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVehiclesRequest, ListVehiclesPagedResponse> listVehiclesPagedCallable() {
        return this.stub.listVehiclesPagedCallable();
    }

    public final UnaryCallable<ListVehiclesRequest, ListVehiclesResponse> listVehiclesCallable() {
        return this.stub.listVehiclesCallable();
    }

    public final SearchVehiclesResponse searchVehicles(SearchVehiclesRequest request) {
        return (SearchVehiclesResponse)this.searchVehiclesCallable().call((Object)request);
    }

    public final UnaryCallable<SearchVehiclesRequest, SearchVehiclesResponse> searchVehiclesCallable() {
        return this.stub.searchVehiclesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListVehiclesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVehiclesRequest, ListVehiclesResponse, Vehicle, ListVehiclesPage, ListVehiclesFixedSizeCollection> {
        private ListVehiclesFixedSizeCollection(List<ListVehiclesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVehiclesFixedSizeCollection createEmptyCollection() {
            return new ListVehiclesFixedSizeCollection(null, 0);
        }

        protected ListVehiclesFixedSizeCollection createCollection(List<ListVehiclesPage> pages, int collectionSize) {
            return new ListVehiclesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVehiclesPage
    extends AbstractPage<ListVehiclesRequest, ListVehiclesResponse, Vehicle, ListVehiclesPage> {
        private ListVehiclesPage(PageContext<ListVehiclesRequest, ListVehiclesResponse, Vehicle> context, ListVehiclesResponse response) {
            super(context, (Object)response);
        }

        private static ListVehiclesPage createEmptyPage() {
            return new ListVehiclesPage(null, null);
        }

        protected ListVehiclesPage createPage(PageContext<ListVehiclesRequest, ListVehiclesResponse, Vehicle> context, ListVehiclesResponse response) {
            return new ListVehiclesPage(context, response);
        }

        public ApiFuture<ListVehiclesPage> createPageAsync(PageContext<ListVehiclesRequest, ListVehiclesResponse, Vehicle> context, ApiFuture<ListVehiclesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVehiclesPagedResponse
    extends AbstractPagedListResponse<ListVehiclesRequest, ListVehiclesResponse, Vehicle, ListVehiclesPage, ListVehiclesFixedSizeCollection> {
        public static ApiFuture<ListVehiclesPagedResponse> createAsync(PageContext<ListVehiclesRequest, ListVehiclesResponse, Vehicle> context, ApiFuture<ListVehiclesResponse> futureResponse) {
            ApiFuture<ListVehiclesPage> futurePage = ListVehiclesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVehiclesPagedResponse((ListVehiclesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVehiclesPagedResponse(ListVehiclesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVehiclesFixedSizeCollection.createEmptyCollection());
        }
    }
}

