/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.maps.fleetengine.v1.CreateTripRequest;
import com.google.maps.fleetengine.v1.GetTripRequest;
import com.google.maps.fleetengine.v1.ReportBillableTripRequest;
import com.google.maps.fleetengine.v1.SearchTripsRequest;
import com.google.maps.fleetengine.v1.SearchTripsResponse;
import com.google.maps.fleetengine.v1.Trip;
import com.google.maps.fleetengine.v1.TripServiceClient;
import com.google.maps.fleetengine.v1.UpdateTripRequest;
import com.google.maps.fleetengine.v1.stub.GrpcTripServiceCallableFactory;
import com.google.maps.fleetengine.v1.stub.TripServiceStub;
import com.google.maps.fleetengine.v1.stub.TripServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTripServiceStub
extends TripServiceStub {
    private static final MethodDescriptor<CreateTripRequest, Trip> createTripMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("maps.fleetengine.v1.TripService/CreateTrip").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTripRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Trip.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTripRequest, Trip> getTripMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("maps.fleetengine.v1.TripService/GetTrip").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTripRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Trip.getDefaultInstance())).build();
    private static final MethodDescriptor<ReportBillableTripRequest, Empty> reportBillableTripMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("maps.fleetengine.v1.TripService/ReportBillableTrip").setRequestMarshaller(ProtoUtils.marshaller((Message)ReportBillableTripRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchTripsRequest, SearchTripsResponse> searchTripsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("maps.fleetengine.v1.TripService/SearchTrips").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchTripsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchTripsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTripRequest, Trip> updateTripMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("maps.fleetengine.v1.TripService/UpdateTrip").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTripRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Trip.getDefaultInstance())).build();
    private final UnaryCallable<CreateTripRequest, Trip> createTripCallable;
    private final UnaryCallable<GetTripRequest, Trip> getTripCallable;
    private final UnaryCallable<ReportBillableTripRequest, Empty> reportBillableTripCallable;
    private final UnaryCallable<SearchTripsRequest, SearchTripsResponse> searchTripsCallable;
    private final UnaryCallable<SearchTripsRequest, TripServiceClient.SearchTripsPagedResponse> searchTripsPagedCallable;
    private final UnaryCallable<UpdateTripRequest, Trip> updateTripCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_TRIP_0_PATH_TEMPLATE = PathTemplate.create((String)"{provider_id=providers/*}");
    private static final PathTemplate GET_TRIP_0_PATH_TEMPLATE = PathTemplate.create((String)"{provider_id=providers/*}");
    private static final PathTemplate REPORT_BILLABLE_TRIP_0_PATH_TEMPLATE = PathTemplate.create((String)"{provider_id=providers/*}");
    private static final PathTemplate SEARCH_TRIPS_0_PATH_TEMPLATE = PathTemplate.create((String)"{provider_id=providers/*}");
    private static final PathTemplate UPDATE_TRIP_0_PATH_TEMPLATE = PathTemplate.create((String)"{provider_id=providers/*}");

    public static final GrpcTripServiceStub create(TripServiceStubSettings settings) throws IOException {
        return new GrpcTripServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTripServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTripServiceStub(TripServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTripServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTripServiceStub(TripServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTripServiceStub(TripServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTripServiceCallableFactory());
    }

    protected GrpcTripServiceStub(TripServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTripTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTripMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "provider_id", CREATE_TRIP_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getTripTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTripMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "provider_id", GET_TRIP_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings reportBillableTripTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reportBillableTripMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "provider_id", REPORT_BILLABLE_TRIP_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings searchTripsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchTripsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "provider_id", SEARCH_TRIPS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings updateTripTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTripMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "provider_id", UPDATE_TRIP_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.createTripCallable = callableFactory.createUnaryCallable(createTripTransportSettings, settings.createTripSettings(), clientContext);
        this.getTripCallable = callableFactory.createUnaryCallable(getTripTransportSettings, settings.getTripSettings(), clientContext);
        this.reportBillableTripCallable = callableFactory.createUnaryCallable(reportBillableTripTransportSettings, settings.reportBillableTripSettings(), clientContext);
        this.searchTripsCallable = callableFactory.createUnaryCallable(searchTripsTransportSettings, settings.searchTripsSettings(), clientContext);
        this.searchTripsPagedCallable = callableFactory.createPagedCallable(searchTripsTransportSettings, settings.searchTripsSettings(), clientContext);
        this.updateTripCallable = callableFactory.createUnaryCallable(updateTripTransportSettings, settings.updateTripSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTripRequest, Trip> createTripCallable() {
        return this.createTripCallable;
    }

    @Override
    public UnaryCallable<GetTripRequest, Trip> getTripCallable() {
        return this.getTripCallable;
    }

    @Override
    public UnaryCallable<ReportBillableTripRequest, Empty> reportBillableTripCallable() {
        return this.reportBillableTripCallable;
    }

    @Override
    public UnaryCallable<SearchTripsRequest, SearchTripsResponse> searchTripsCallable() {
        return this.searchTripsCallable;
    }

    @Override
    public UnaryCallable<SearchTripsRequest, TripServiceClient.SearchTripsPagedResponse> searchTripsPagedCallable() {
        return this.searchTripsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateTripRequest, Trip> updateTripCallable() {
        return this.updateTripCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

