/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.maps.fleetengine.delivery.v1.BatchCreateTasksRequest;
import com.google.maps.fleetengine.delivery.v1.BatchCreateTasksResponse;
import com.google.maps.fleetengine.delivery.v1.CreateDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.CreateTaskRequest;
import com.google.maps.fleetengine.delivery.v1.DeleteDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.DeleteTaskRequest;
import com.google.maps.fleetengine.delivery.v1.DeliveryServiceClient;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicle;
import com.google.maps.fleetengine.delivery.v1.GetDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.GetTaskRequest;
import com.google.maps.fleetengine.delivery.v1.GetTaskTrackingInfoRequest;
import com.google.maps.fleetengine.delivery.v1.ListDeliveryVehiclesRequest;
import com.google.maps.fleetengine.delivery.v1.ListDeliveryVehiclesResponse;
import com.google.maps.fleetengine.delivery.v1.ListTasksRequest;
import com.google.maps.fleetengine.delivery.v1.ListTasksResponse;
import com.google.maps.fleetengine.delivery.v1.Task;
import com.google.maps.fleetengine.delivery.v1.TaskTrackingInfo;
import com.google.maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.UpdateTaskRequest;
import com.google.maps.fleetengine.delivery.v1.stub.DeliveryServiceStub;
import com.google.maps.fleetengine.delivery.v1.stub.GrpcDeliveryServiceStub;
import com.google.maps.fleetengine.delivery.v1.stub.HttpJsonDeliveryServiceStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeliveryServiceStubSettings
extends StubSettings<DeliveryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDeliveryVehicleRequest, DeliveryVehicle> createDeliveryVehicleSettings;
    private final UnaryCallSettings<GetDeliveryVehicleRequest, DeliveryVehicle> getDeliveryVehicleSettings;
    private final UnaryCallSettings<DeleteDeliveryVehicleRequest, Empty> deleteDeliveryVehicleSettings;
    private final UnaryCallSettings<UpdateDeliveryVehicleRequest, DeliveryVehicle> updateDeliveryVehicleSettings;
    private final UnaryCallSettings<BatchCreateTasksRequest, BatchCreateTasksResponse> batchCreateTasksSettings;
    private final UnaryCallSettings<CreateTaskRequest, Task> createTaskSettings;
    private final UnaryCallSettings<GetTaskRequest, Task> getTaskSettings;
    private final UnaryCallSettings<DeleteTaskRequest, Empty> deleteTaskSettings;
    private final UnaryCallSettings<UpdateTaskRequest, Task> updateTaskSettings;
    private final PagedCallSettings<ListTasksRequest, ListTasksResponse, DeliveryServiceClient.ListTasksPagedResponse> listTasksSettings;
    private final UnaryCallSettings<GetTaskTrackingInfoRequest, TaskTrackingInfo> getTaskTrackingInfoSettings;
    private final PagedCallSettings<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryServiceClient.ListDeliveryVehiclesPagedResponse> listDeliveryVehiclesSettings;
    private static final PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task> LIST_TASKS_PAGE_STR_DESC = new PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task>(){

        public String emptyToken() {
            return "";
        }

        public ListTasksRequest injectToken(ListTasksRequest payload, String token) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageToken(token).build();
        }

        public ListTasksRequest injectPageSize(ListTasksRequest payload, int pageSize) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTasksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTasksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Task> extractResources(ListTasksResponse payload) {
            return payload.getTasksList();
        }
    };
    private static final PagedListDescriptor<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle> LIST_DELIVERY_VEHICLES_PAGE_STR_DESC = new PagedListDescriptor<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle>(){

        public String emptyToken() {
            return "";
        }

        public ListDeliveryVehiclesRequest injectToken(ListDeliveryVehiclesRequest payload, String token) {
            return ListDeliveryVehiclesRequest.newBuilder((ListDeliveryVehiclesRequest)payload).setPageToken(token).build();
        }

        public ListDeliveryVehiclesRequest injectPageSize(ListDeliveryVehiclesRequest payload, int pageSize) {
            return ListDeliveryVehiclesRequest.newBuilder((ListDeliveryVehiclesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeliveryVehiclesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeliveryVehiclesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeliveryVehicle> extractResources(ListDeliveryVehiclesResponse payload) {
            return payload.getDeliveryVehiclesList();
        }
    };
    private static final PagedListResponseFactory<ListTasksRequest, ListTasksResponse, DeliveryServiceClient.ListTasksPagedResponse> LIST_TASKS_PAGE_STR_FACT = new PagedListResponseFactory<ListTasksRequest, ListTasksResponse, DeliveryServiceClient.ListTasksPagedResponse>(){

        public ApiFuture<DeliveryServiceClient.ListTasksPagedResponse> getFuturePagedResponse(UnaryCallable<ListTasksRequest, ListTasksResponse> callable, ListTasksRequest request, ApiCallContext context, ApiFuture<ListTasksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TASKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeliveryServiceClient.ListTasksPagedResponse.createAsync((PageContext<ListTasksRequest, ListTasksResponse, Task>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryServiceClient.ListDeliveryVehiclesPagedResponse> LIST_DELIVERY_VEHICLES_PAGE_STR_FACT = new PagedListResponseFactory<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryServiceClient.ListDeliveryVehiclesPagedResponse>(){

        public ApiFuture<DeliveryServiceClient.ListDeliveryVehiclesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse> callable, ListDeliveryVehiclesRequest request, ApiCallContext context, ApiFuture<ListDeliveryVehiclesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DELIVERY_VEHICLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeliveryServiceClient.ListDeliveryVehiclesPagedResponse.createAsync((PageContext<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDeliveryVehicleRequest, DeliveryVehicle> createDeliveryVehicleSettings() {
        return this.createDeliveryVehicleSettings;
    }

    public UnaryCallSettings<GetDeliveryVehicleRequest, DeliveryVehicle> getDeliveryVehicleSettings() {
        return this.getDeliveryVehicleSettings;
    }

    public UnaryCallSettings<DeleteDeliveryVehicleRequest, Empty> deleteDeliveryVehicleSettings() {
        return this.deleteDeliveryVehicleSettings;
    }

    public UnaryCallSettings<UpdateDeliveryVehicleRequest, DeliveryVehicle> updateDeliveryVehicleSettings() {
        return this.updateDeliveryVehicleSettings;
    }

    public UnaryCallSettings<BatchCreateTasksRequest, BatchCreateTasksResponse> batchCreateTasksSettings() {
        return this.batchCreateTasksSettings;
    }

    public UnaryCallSettings<CreateTaskRequest, Task> createTaskSettings() {
        return this.createTaskSettings;
    }

    public UnaryCallSettings<GetTaskRequest, Task> getTaskSettings() {
        return this.getTaskSettings;
    }

    public UnaryCallSettings<DeleteTaskRequest, Empty> deleteTaskSettings() {
        return this.deleteTaskSettings;
    }

    public UnaryCallSettings<UpdateTaskRequest, Task> updateTaskSettings() {
        return this.updateTaskSettings;
    }

    public PagedCallSettings<ListTasksRequest, ListTasksResponse, DeliveryServiceClient.ListTasksPagedResponse> listTasksSettings() {
        return this.listTasksSettings;
    }

    public UnaryCallSettings<GetTaskTrackingInfoRequest, TaskTrackingInfo> getTaskTrackingInfoSettings() {
        return this.getTaskTrackingInfoSettings;
    }

    public PagedCallSettings<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryServiceClient.ListDeliveryVehiclesPagedResponse> listDeliveryVehiclesSettings() {
        return this.listDeliveryVehiclesSettings;
    }

    public DeliveryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDeliveryServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDeliveryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "fleetengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "fleetengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "fleetengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeliveryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeliveryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeliveryServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DeliveryServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeliveryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDeliveryVehicleSettings = settingsBuilder.createDeliveryVehicleSettings().build();
        this.getDeliveryVehicleSettings = settingsBuilder.getDeliveryVehicleSettings().build();
        this.deleteDeliveryVehicleSettings = settingsBuilder.deleteDeliveryVehicleSettings().build();
        this.updateDeliveryVehicleSettings = settingsBuilder.updateDeliveryVehicleSettings().build();
        this.batchCreateTasksSettings = settingsBuilder.batchCreateTasksSettings().build();
        this.createTaskSettings = settingsBuilder.createTaskSettings().build();
        this.getTaskSettings = settingsBuilder.getTaskSettings().build();
        this.deleteTaskSettings = settingsBuilder.deleteTaskSettings().build();
        this.updateTaskSettings = settingsBuilder.updateTaskSettings().build();
        this.listTasksSettings = settingsBuilder.listTasksSettings().build();
        this.getTaskTrackingInfoSettings = settingsBuilder.getTaskTrackingInfoSettings().build();
        this.listDeliveryVehiclesSettings = settingsBuilder.listDeliveryVehiclesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeliveryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDeliveryVehicleRequest, DeliveryVehicle> createDeliveryVehicleSettings;
        private final UnaryCallSettings.Builder<GetDeliveryVehicleRequest, DeliveryVehicle> getDeliveryVehicleSettings;
        private final UnaryCallSettings.Builder<DeleteDeliveryVehicleRequest, Empty> deleteDeliveryVehicleSettings;
        private final UnaryCallSettings.Builder<UpdateDeliveryVehicleRequest, DeliveryVehicle> updateDeliveryVehicleSettings;
        private final UnaryCallSettings.Builder<BatchCreateTasksRequest, BatchCreateTasksResponse> batchCreateTasksSettings;
        private final UnaryCallSettings.Builder<CreateTaskRequest, Task> createTaskSettings;
        private final UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings;
        private final UnaryCallSettings.Builder<DeleteTaskRequest, Empty> deleteTaskSettings;
        private final UnaryCallSettings.Builder<UpdateTaskRequest, Task> updateTaskSettings;
        private final PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, DeliveryServiceClient.ListTasksPagedResponse> listTasksSettings;
        private final UnaryCallSettings.Builder<GetTaskTrackingInfoRequest, TaskTrackingInfo> getTaskTrackingInfoSettings;
        private final PagedCallSettings.Builder<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryServiceClient.ListDeliveryVehiclesPagedResponse> listDeliveryVehiclesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDeliveryVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDeliveryVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeliveryVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeliveryVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateTasksSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTasksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TASKS_PAGE_STR_FACT);
            this.getTaskTrackingInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeliveryVehiclesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DELIVERY_VEHICLES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeliveryVehicleSettings, this.getDeliveryVehicleSettings, this.deleteDeliveryVehicleSettings, this.updateDeliveryVehicleSettings, this.batchCreateTasksSettings, this.createTaskSettings, this.getTaskSettings, this.deleteTaskSettings, this.updateTaskSettings, this.listTasksSettings, this.getTaskTrackingInfoSettings, this.listDeliveryVehiclesSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(DeliveryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDeliveryVehicleSettings = settings.createDeliveryVehicleSettings.toBuilder();
            this.getDeliveryVehicleSettings = settings.getDeliveryVehicleSettings.toBuilder();
            this.deleteDeliveryVehicleSettings = settings.deleteDeliveryVehicleSettings.toBuilder();
            this.updateDeliveryVehicleSettings = settings.updateDeliveryVehicleSettings.toBuilder();
            this.batchCreateTasksSettings = settings.batchCreateTasksSettings.toBuilder();
            this.createTaskSettings = settings.createTaskSettings.toBuilder();
            this.getTaskSettings = settings.getTaskSettings.toBuilder();
            this.deleteTaskSettings = settings.deleteTaskSettings.toBuilder();
            this.updateTaskSettings = settings.updateTaskSettings.toBuilder();
            this.listTasksSettings = settings.listTasksSettings.toBuilder();
            this.getTaskTrackingInfoSettings = settings.getTaskTrackingInfoSettings.toBuilder();
            this.listDeliveryVehiclesSettings = settings.listDeliveryVehiclesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeliveryVehicleSettings, this.getDeliveryVehicleSettings, this.deleteDeliveryVehicleSettings, this.updateDeliveryVehicleSettings, this.batchCreateTasksSettings, this.createTaskSettings, this.getTaskSettings, this.deleteTaskSettings, this.updateTaskSettings, this.listTasksSettings, this.getTaskTrackingInfoSettings, this.listDeliveryVehiclesSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeliveryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeliveryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeliveryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeliveryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DeliveryServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DeliveryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeliveryServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeliveryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDeliveryVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDeliveryVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDeliveryVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDeliveryVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchCreateTasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTaskTrackingInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDeliveryVehiclesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDeliveryVehicleRequest, DeliveryVehicle> createDeliveryVehicleSettings() {
            return this.createDeliveryVehicleSettings;
        }

        public UnaryCallSettings.Builder<GetDeliveryVehicleRequest, DeliveryVehicle> getDeliveryVehicleSettings() {
            return this.getDeliveryVehicleSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeliveryVehicleRequest, Empty> deleteDeliveryVehicleSettings() {
            return this.deleteDeliveryVehicleSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeliveryVehicleRequest, DeliveryVehicle> updateDeliveryVehicleSettings() {
            return this.updateDeliveryVehicleSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateTasksRequest, BatchCreateTasksResponse> batchCreateTasksSettings() {
            return this.batchCreateTasksSettings;
        }

        public UnaryCallSettings.Builder<CreateTaskRequest, Task> createTaskSettings() {
            return this.createTaskSettings;
        }

        public UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings() {
            return this.getTaskSettings;
        }

        public UnaryCallSettings.Builder<DeleteTaskRequest, Empty> deleteTaskSettings() {
            return this.deleteTaskSettings;
        }

        public UnaryCallSettings.Builder<UpdateTaskRequest, Task> updateTaskSettings() {
            return this.updateTaskSettings;
        }

        public PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, DeliveryServiceClient.ListTasksPagedResponse> listTasksSettings() {
            return this.listTasksSettings;
        }

        public UnaryCallSettings.Builder<GetTaskTrackingInfoRequest, TaskTrackingInfo> getTaskTrackingInfoSettings() {
            return this.getTaskTrackingInfoSettings;
        }

        public PagedCallSettings.Builder<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryServiceClient.ListDeliveryVehiclesPagedResponse> listDeliveryVehiclesSettings() {
            return this.listDeliveryVehiclesSettings;
        }

        public DeliveryServiceStubSettings build() throws IOException {
            return new DeliveryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

