/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.addressvalidation.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.addressvalidation.v1.AddressValidationSettings;
import com.google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest;
import com.google.maps.addressvalidation.v1.ProvideValidationFeedbackResponse;
import com.google.maps.addressvalidation.v1.ValidateAddressRequest;
import com.google.maps.addressvalidation.v1.ValidateAddressResponse;
import com.google.maps.addressvalidation.v1.stub.AddressValidationStub;
import com.google.maps.addressvalidation.v1.stub.AddressValidationStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AddressValidationClient
implements BackgroundResource {
    private final AddressValidationSettings settings;
    private final AddressValidationStub stub;

    public static final AddressValidationClient create() throws IOException {
        return AddressValidationClient.create(AddressValidationSettings.newBuilder().build());
    }

    public static final AddressValidationClient create(AddressValidationSettings settings) throws IOException {
        return new AddressValidationClient(settings);
    }

    public static final AddressValidationClient create(AddressValidationStub stub) {
        return new AddressValidationClient(stub);
    }

    protected AddressValidationClient(AddressValidationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AddressValidationStubSettings)settings.getStubSettings()).createStub();
    }

    protected AddressValidationClient(AddressValidationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AddressValidationSettings getSettings() {
        return this.settings;
    }

    public AddressValidationStub getStub() {
        return this.stub;
    }

    public final ValidateAddressResponse validateAddress(ValidateAddressRequest request) {
        return (ValidateAddressResponse)this.validateAddressCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateAddressRequest, ValidateAddressResponse> validateAddressCallable() {
        return this.stub.validateAddressCallable();
    }

    public final ProvideValidationFeedbackResponse provideValidationFeedback(ProvideValidationFeedbackRequest request) {
        return (ProvideValidationFeedbackResponse)this.provideValidationFeedbackCallable().call((Object)request);
    }

    public final UnaryCallable<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackCallable() {
        return this.stub.provideValidationFeedbackCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

