/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.maps.fleetengine.v1.DeviceSettings;
import com.google.maps.fleetengine.v1.DeviceSettingsOrBuilder;
import com.google.maps.fleetengine.v1.LicensePlate;
import com.google.maps.fleetengine.v1.LicensePlateOrBuilder;
import com.google.maps.fleetengine.v1.NavigationStatus;
import com.google.maps.fleetengine.v1.TerminalLocation;
import com.google.maps.fleetengine.v1.TerminalLocationOrBuilder;
import com.google.maps.fleetengine.v1.TrafficPolylineData;
import com.google.maps.fleetengine.v1.TrafficPolylineDataOrBuilder;
import com.google.maps.fleetengine.v1.TripType;
import com.google.maps.fleetengine.v1.TripWaypoint;
import com.google.maps.fleetengine.v1.TripWaypointOrBuilder;
import com.google.maps.fleetengine.v1.VehicleAttribute;
import com.google.maps.fleetengine.v1.VehicleAttributeOrBuilder;
import com.google.maps.fleetengine.v1.VehicleLocation;
import com.google.maps.fleetengine.v1.VehicleLocationOrBuilder;
import com.google.maps.fleetengine.v1.VehicleOrBuilder;
import com.google.maps.fleetengine.v1.VehicleState;
import com.google.maps.fleetengine.v1.Vehicles;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int32ValueOrBuilder;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Vehicle
extends GeneratedMessageV3
implements VehicleOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int VEHICLE_STATE_FIELD_NUMBER = 2;
    private int vehicleState_ = 0;
    public static final int SUPPORTED_TRIP_TYPES_FIELD_NUMBER = 3;
    private List<Integer> supportedTripTypes_;
    private static final Internal.ListAdapter.Converter<Integer, TripType> supportedTripTypes_converter_ = new Internal.ListAdapter.Converter<Integer, TripType>(){

        public TripType convert(Integer from) {
            TripType result = TripType.forNumber(from);
            return result == null ? TripType.UNRECOGNIZED : result;
        }
    };
    private int supportedTripTypesMemoizedSerializedSize;
    public static final int CURRENT_TRIPS_FIELD_NUMBER = 4;
    private LazyStringArrayList currentTrips_ = LazyStringArrayList.emptyList();
    public static final int LAST_LOCATION_FIELD_NUMBER = 5;
    private VehicleLocation lastLocation_;
    public static final int MAXIMUM_CAPACITY_FIELD_NUMBER = 6;
    private int maximumCapacity_ = 0;
    public static final int ATTRIBUTES_FIELD_NUMBER = 8;
    private List<VehicleAttribute> attributes_;
    public static final int VEHICLE_TYPE_FIELD_NUMBER = 9;
    private VehicleType vehicleType_;
    public static final int LICENSE_PLATE_FIELD_NUMBER = 10;
    private LicensePlate licensePlate_;
    public static final int ROUTE_FIELD_NUMBER = 12;
    private List<TerminalLocation> route_;
    public static final int CURRENT_ROUTE_SEGMENT_FIELD_NUMBER = 20;
    private volatile Object currentRouteSegment_ = "";
    public static final int CURRENT_ROUTE_SEGMENT_TRAFFIC_FIELD_NUMBER = 28;
    private TrafficPolylineData currentRouteSegmentTraffic_;
    public static final int CURRENT_ROUTE_SEGMENT_VERSION_FIELD_NUMBER = 15;
    private Timestamp currentRouteSegmentVersion_;
    public static final int CURRENT_ROUTE_SEGMENT_END_POINT_FIELD_NUMBER = 24;
    private TripWaypoint currentRouteSegmentEndPoint_;
    public static final int REMAINING_DISTANCE_METERS_FIELD_NUMBER = 18;
    private Int32Value remainingDistanceMeters_;
    public static final int ETA_TO_FIRST_WAYPOINT_FIELD_NUMBER = 19;
    private Timestamp etaToFirstWaypoint_;
    public static final int REMAINING_TIME_SECONDS_FIELD_NUMBER = 25;
    private Int32Value remainingTimeSeconds_;
    public static final int WAYPOINTS_FIELD_NUMBER = 22;
    private List<TripWaypoint> waypoints_;
    public static final int WAYPOINTS_VERSION_FIELD_NUMBER = 16;
    private Timestamp waypointsVersion_;
    public static final int BACK_TO_BACK_ENABLED_FIELD_NUMBER = 23;
    private boolean backToBackEnabled_ = false;
    public static final int NAVIGATION_STATUS_FIELD_NUMBER = 26;
    private int navigationStatus_ = 0;
    public static final int DEVICE_SETTINGS_FIELD_NUMBER = 27;
    private DeviceSettings deviceSettings_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Vehicle DEFAULT_INSTANCE = new Vehicle();
    private static final Parser<Vehicle> PARSER = new AbstractParser<Vehicle>(){

        public Vehicle parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Vehicle.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Vehicle(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Vehicle() {
        this.name_ = "";
        this.vehicleState_ = 0;
        this.supportedTripTypes_ = Collections.emptyList();
        this.currentTrips_ = LazyStringArrayList.emptyList();
        this.attributes_ = Collections.emptyList();
        this.route_ = Collections.emptyList();
        this.currentRouteSegment_ = "";
        this.waypoints_ = Collections.emptyList();
        this.navigationStatus_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Vehicle();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_fieldAccessorTable.ensureFieldAccessorsInitialized(Vehicle.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getVehicleStateValue() {
        return this.vehicleState_;
    }

    @Override
    public VehicleState getVehicleState() {
        VehicleState result = VehicleState.forNumber(this.vehicleState_);
        return result == null ? VehicleState.UNRECOGNIZED : result;
    }

    @Override
    public List<TripType> getSupportedTripTypesList() {
        return new Internal.ListAdapter(this.supportedTripTypes_, supportedTripTypes_converter_);
    }

    @Override
    public int getSupportedTripTypesCount() {
        return this.supportedTripTypes_.size();
    }

    @Override
    public TripType getSupportedTripTypes(int index) {
        return (TripType)((Object)supportedTripTypes_converter_.convert((Object)this.supportedTripTypes_.get(index)));
    }

    @Override
    public List<Integer> getSupportedTripTypesValueList() {
        return this.supportedTripTypes_;
    }

    @Override
    public int getSupportedTripTypesValue(int index) {
        return this.supportedTripTypes_.get(index);
    }

    public ProtocolStringList getCurrentTripsList() {
        return this.currentTrips_;
    }

    @Override
    public int getCurrentTripsCount() {
        return this.currentTrips_.size();
    }

    @Override
    public String getCurrentTrips(int index) {
        return this.currentTrips_.get(index);
    }

    @Override
    public ByteString getCurrentTripsBytes(int index) {
        return this.currentTrips_.getByteString(index);
    }

    @Override
    public boolean hasLastLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public VehicleLocation getLastLocation() {
        return this.lastLocation_ == null ? VehicleLocation.getDefaultInstance() : this.lastLocation_;
    }

    @Override
    public VehicleLocationOrBuilder getLastLocationOrBuilder() {
        return this.lastLocation_ == null ? VehicleLocation.getDefaultInstance() : this.lastLocation_;
    }

    @Override
    public int getMaximumCapacity() {
        return this.maximumCapacity_;
    }

    @Override
    public List<VehicleAttribute> getAttributesList() {
        return this.attributes_;
    }

    @Override
    public List<? extends VehicleAttributeOrBuilder> getAttributesOrBuilderList() {
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes_.size();
    }

    @Override
    public VehicleAttribute getAttributes(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public VehicleAttributeOrBuilder getAttributesOrBuilder(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public boolean hasVehicleType() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public VehicleType getVehicleType() {
        return this.vehicleType_ == null ? VehicleType.getDefaultInstance() : this.vehicleType_;
    }

    @Override
    public VehicleTypeOrBuilder getVehicleTypeOrBuilder() {
        return this.vehicleType_ == null ? VehicleType.getDefaultInstance() : this.vehicleType_;
    }

    @Override
    public boolean hasLicensePlate() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public LicensePlate getLicensePlate() {
        return this.licensePlate_ == null ? LicensePlate.getDefaultInstance() : this.licensePlate_;
    }

    @Override
    public LicensePlateOrBuilder getLicensePlateOrBuilder() {
        return this.licensePlate_ == null ? LicensePlate.getDefaultInstance() : this.licensePlate_;
    }

    @Override
    @Deprecated
    public List<TerminalLocation> getRouteList() {
        return this.route_;
    }

    @Override
    @Deprecated
    public List<? extends TerminalLocationOrBuilder> getRouteOrBuilderList() {
        return this.route_;
    }

    @Override
    @Deprecated
    public int getRouteCount() {
        return this.route_.size();
    }

    @Override
    @Deprecated
    public TerminalLocation getRoute(int index) {
        return this.route_.get(index);
    }

    @Override
    @Deprecated
    public TerminalLocationOrBuilder getRouteOrBuilder(int index) {
        return this.route_.get(index);
    }

    @Override
    public String getCurrentRouteSegment() {
        Object ref = this.currentRouteSegment_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.currentRouteSegment_ = s;
        return s;
    }

    @Override
    public ByteString getCurrentRouteSegmentBytes() {
        Object ref = this.currentRouteSegment_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.currentRouteSegment_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCurrentRouteSegmentTraffic() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public TrafficPolylineData getCurrentRouteSegmentTraffic() {
        return this.currentRouteSegmentTraffic_ == null ? TrafficPolylineData.getDefaultInstance() : this.currentRouteSegmentTraffic_;
    }

    @Override
    public TrafficPolylineDataOrBuilder getCurrentRouteSegmentTrafficOrBuilder() {
        return this.currentRouteSegmentTraffic_ == null ? TrafficPolylineData.getDefaultInstance() : this.currentRouteSegmentTraffic_;
    }

    @Override
    public boolean hasCurrentRouteSegmentVersion() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public Timestamp getCurrentRouteSegmentVersion() {
        return this.currentRouteSegmentVersion_ == null ? Timestamp.getDefaultInstance() : this.currentRouteSegmentVersion_;
    }

    @Override
    public TimestampOrBuilder getCurrentRouteSegmentVersionOrBuilder() {
        return this.currentRouteSegmentVersion_ == null ? Timestamp.getDefaultInstance() : this.currentRouteSegmentVersion_;
    }

    @Override
    public boolean hasCurrentRouteSegmentEndPoint() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public TripWaypoint getCurrentRouteSegmentEndPoint() {
        return this.currentRouteSegmentEndPoint_ == null ? TripWaypoint.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
    }

    @Override
    public TripWaypointOrBuilder getCurrentRouteSegmentEndPointOrBuilder() {
        return this.currentRouteSegmentEndPoint_ == null ? TripWaypoint.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
    }

    @Override
    public boolean hasRemainingDistanceMeters() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public Int32Value getRemainingDistanceMeters() {
        return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
    }

    @Override
    public Int32ValueOrBuilder getRemainingDistanceMetersOrBuilder() {
        return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
    }

    @Override
    public boolean hasEtaToFirstWaypoint() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public Timestamp getEtaToFirstWaypoint() {
        return this.etaToFirstWaypoint_ == null ? Timestamp.getDefaultInstance() : this.etaToFirstWaypoint_;
    }

    @Override
    public TimestampOrBuilder getEtaToFirstWaypointOrBuilder() {
        return this.etaToFirstWaypoint_ == null ? Timestamp.getDefaultInstance() : this.etaToFirstWaypoint_;
    }

    @Override
    public boolean hasRemainingTimeSeconds() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public Int32Value getRemainingTimeSeconds() {
        return this.remainingTimeSeconds_ == null ? Int32Value.getDefaultInstance() : this.remainingTimeSeconds_;
    }

    @Override
    public Int32ValueOrBuilder getRemainingTimeSecondsOrBuilder() {
        return this.remainingTimeSeconds_ == null ? Int32Value.getDefaultInstance() : this.remainingTimeSeconds_;
    }

    @Override
    public List<TripWaypoint> getWaypointsList() {
        return this.waypoints_;
    }

    @Override
    public List<? extends TripWaypointOrBuilder> getWaypointsOrBuilderList() {
        return this.waypoints_;
    }

    @Override
    public int getWaypointsCount() {
        return this.waypoints_.size();
    }

    @Override
    public TripWaypoint getWaypoints(int index) {
        return this.waypoints_.get(index);
    }

    @Override
    public TripWaypointOrBuilder getWaypointsOrBuilder(int index) {
        return this.waypoints_.get(index);
    }

    @Override
    public boolean hasWaypointsVersion() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public Timestamp getWaypointsVersion() {
        return this.waypointsVersion_ == null ? Timestamp.getDefaultInstance() : this.waypointsVersion_;
    }

    @Override
    public TimestampOrBuilder getWaypointsVersionOrBuilder() {
        return this.waypointsVersion_ == null ? Timestamp.getDefaultInstance() : this.waypointsVersion_;
    }

    @Override
    public boolean getBackToBackEnabled() {
        return this.backToBackEnabled_;
    }

    @Override
    public int getNavigationStatusValue() {
        return this.navigationStatus_;
    }

    @Override
    public NavigationStatus getNavigationStatus() {
        NavigationStatus result = NavigationStatus.forNumber(this.navigationStatus_);
        return result == null ? NavigationStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasDeviceSettings() {
        return (this.bitField0_ & 0x400) != 0;
    }

    @Override
    public DeviceSettings getDeviceSettings() {
        return this.deviceSettings_ == null ? DeviceSettings.getDefaultInstance() : this.deviceSettings_;
    }

    @Override
    public DeviceSettingsOrBuilder getDeviceSettingsOrBuilder() {
        return this.deviceSettings_ == null ? DeviceSettings.getDefaultInstance() : this.deviceSettings_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.vehicleState_ != VehicleState.UNKNOWN_VEHICLE_STATE.getNumber()) {
            output.writeEnum(2, this.vehicleState_);
        }
        if (this.getSupportedTripTypesList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.supportedTripTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.supportedTripTypes_.size(); ++i) {
            output.writeEnumNoTag(this.supportedTripTypes_.get(i).intValue());
        }
        for (i = 0; i < this.currentTrips_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.currentTrips_.getRaw(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(5, (MessageLite)this.getLastLocation());
        }
        if (this.maximumCapacity_ != 0) {
            output.writeInt32(6, this.maximumCapacity_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.attributes_.get(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(9, (MessageLite)this.getVehicleType());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(10, (MessageLite)this.getLicensePlate());
        }
        for (i = 0; i < this.route_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.route_.get(i));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(15, (MessageLite)this.getCurrentRouteSegmentVersion());
        }
        if ((this.bitField0_ & 0x200) != 0) {
            output.writeMessage(16, (MessageLite)this.getWaypointsVersion());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(18, (MessageLite)this.getRemainingDistanceMeters());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(19, (MessageLite)this.getEtaToFirstWaypoint());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currentRouteSegment_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)20, (Object)this.currentRouteSegment_);
        }
        for (i = 0; i < this.waypoints_.size(); ++i) {
            output.writeMessage(22, (MessageLite)this.waypoints_.get(i));
        }
        if (this.backToBackEnabled_) {
            output.writeBool(23, this.backToBackEnabled_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(24, (MessageLite)this.getCurrentRouteSegmentEndPoint());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeMessage(25, (MessageLite)this.getRemainingTimeSeconds());
        }
        if (this.navigationStatus_ != NavigationStatus.UNKNOWN_NAVIGATION_STATUS.getNumber()) {
            output.writeEnum(26, this.navigationStatus_);
        }
        if ((this.bitField0_ & 0x400) != 0) {
            output.writeMessage(27, (MessageLite)this.getDeviceSettings());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(28, (MessageLite)this.getCurrentRouteSegmentTraffic());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (this.vehicleState_ != VehicleState.UNKNOWN_VEHICLE_STATE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.vehicleState_);
        }
        int dataSize = 0;
        for (i2 = 0; i2 < this.supportedTripTypes_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.supportedTripTypes_.get(i2));
        }
        size += dataSize;
        if (!this.getSupportedTripTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.supportedTripTypesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i2 = 0; i2 < this.currentTrips_.size(); ++i2) {
            dataSize += Vehicle.computeStringSizeNoTag((Object)this.currentTrips_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getCurrentTripsList().size();
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getLastLocation());
        }
        if (this.maximumCapacity_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)6, (int)this.maximumCapacity_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.attributes_.get(i)));
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getVehicleType());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getLicensePlate());
        }
        for (i = 0; i < this.route_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.route_.get(i)));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getCurrentRouteSegmentVersion());
        }
        if ((this.bitField0_ & 0x200) != 0) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)this.getWaypointsVersion());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getRemainingDistanceMeters());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)19, (MessageLite)this.getEtaToFirstWaypoint());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currentRouteSegment_)) {
            size += GeneratedMessageV3.computeStringSize((int)20, (Object)this.currentRouteSegment_);
        }
        for (i = 0; i < this.waypoints_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)22, (MessageLite)((MessageLite)this.waypoints_.get(i)));
        }
        if (this.backToBackEnabled_) {
            size += CodedOutputStream.computeBoolSize((int)23, (boolean)this.backToBackEnabled_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)24, (MessageLite)this.getCurrentRouteSegmentEndPoint());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeMessageSize((int)25, (MessageLite)this.getRemainingTimeSeconds());
        }
        if (this.navigationStatus_ != NavigationStatus.UNKNOWN_NAVIGATION_STATUS.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)26, (int)this.navigationStatus_);
        }
        if ((this.bitField0_ & 0x400) != 0) {
            size += CodedOutputStream.computeMessageSize((int)27, (MessageLite)this.getDeviceSettings());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)28, (MessageLite)this.getCurrentRouteSegmentTraffic());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Vehicle)) {
            return super.equals(obj);
        }
        Vehicle other = (Vehicle)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.vehicleState_ != other.vehicleState_) {
            return false;
        }
        if (!this.supportedTripTypes_.equals(other.supportedTripTypes_)) {
            return false;
        }
        if (!this.getCurrentTripsList().equals(other.getCurrentTripsList())) {
            return false;
        }
        if (this.hasLastLocation() != other.hasLastLocation()) {
            return false;
        }
        if (this.hasLastLocation() && !this.getLastLocation().equals(other.getLastLocation())) {
            return false;
        }
        if (this.getMaximumCapacity() != other.getMaximumCapacity()) {
            return false;
        }
        if (!this.getAttributesList().equals(other.getAttributesList())) {
            return false;
        }
        if (this.hasVehicleType() != other.hasVehicleType()) {
            return false;
        }
        if (this.hasVehicleType() && !this.getVehicleType().equals(other.getVehicleType())) {
            return false;
        }
        if (this.hasLicensePlate() != other.hasLicensePlate()) {
            return false;
        }
        if (this.hasLicensePlate() && !this.getLicensePlate().equals(other.getLicensePlate())) {
            return false;
        }
        if (!this.getRouteList().equals(other.getRouteList())) {
            return false;
        }
        if (!this.getCurrentRouteSegment().equals(other.getCurrentRouteSegment())) {
            return false;
        }
        if (this.hasCurrentRouteSegmentTraffic() != other.hasCurrentRouteSegmentTraffic()) {
            return false;
        }
        if (this.hasCurrentRouteSegmentTraffic() && !this.getCurrentRouteSegmentTraffic().equals(other.getCurrentRouteSegmentTraffic())) {
            return false;
        }
        if (this.hasCurrentRouteSegmentVersion() != other.hasCurrentRouteSegmentVersion()) {
            return false;
        }
        if (this.hasCurrentRouteSegmentVersion() && !this.getCurrentRouteSegmentVersion().equals((Object)other.getCurrentRouteSegmentVersion())) {
            return false;
        }
        if (this.hasCurrentRouteSegmentEndPoint() != other.hasCurrentRouteSegmentEndPoint()) {
            return false;
        }
        if (this.hasCurrentRouteSegmentEndPoint() && !this.getCurrentRouteSegmentEndPoint().equals(other.getCurrentRouteSegmentEndPoint())) {
            return false;
        }
        if (this.hasRemainingDistanceMeters() != other.hasRemainingDistanceMeters()) {
            return false;
        }
        if (this.hasRemainingDistanceMeters() && !this.getRemainingDistanceMeters().equals((Object)other.getRemainingDistanceMeters())) {
            return false;
        }
        if (this.hasEtaToFirstWaypoint() != other.hasEtaToFirstWaypoint()) {
            return false;
        }
        if (this.hasEtaToFirstWaypoint() && !this.getEtaToFirstWaypoint().equals((Object)other.getEtaToFirstWaypoint())) {
            return false;
        }
        if (this.hasRemainingTimeSeconds() != other.hasRemainingTimeSeconds()) {
            return false;
        }
        if (this.hasRemainingTimeSeconds() && !this.getRemainingTimeSeconds().equals((Object)other.getRemainingTimeSeconds())) {
            return false;
        }
        if (!this.getWaypointsList().equals(other.getWaypointsList())) {
            return false;
        }
        if (this.hasWaypointsVersion() != other.hasWaypointsVersion()) {
            return false;
        }
        if (this.hasWaypointsVersion() && !this.getWaypointsVersion().equals((Object)other.getWaypointsVersion())) {
            return false;
        }
        if (this.getBackToBackEnabled() != other.getBackToBackEnabled()) {
            return false;
        }
        if (this.navigationStatus_ != other.navigationStatus_) {
            return false;
        }
        if (this.hasDeviceSettings() != other.hasDeviceSettings()) {
            return false;
        }
        if (this.hasDeviceSettings() && !this.getDeviceSettings().equals(other.getDeviceSettings())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Vehicle.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.vehicleState_;
        if (this.getSupportedTripTypesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.supportedTripTypes_.hashCode();
        }
        if (this.getCurrentTripsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getCurrentTripsList().hashCode();
        }
        if (this.hasLastLocation()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getLastLocation().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getMaximumCapacity();
        if (this.getAttributesCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAttributesList().hashCode();
        }
        if (this.hasVehicleType()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getVehicleType().hashCode();
        }
        if (this.hasLicensePlate()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getLicensePlate().hashCode();
        }
        if (this.getRouteCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getRouteList().hashCode();
        }
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getCurrentRouteSegment().hashCode();
        if (this.hasCurrentRouteSegmentTraffic()) {
            hash = 37 * hash + 28;
            hash = 53 * hash + this.getCurrentRouteSegmentTraffic().hashCode();
        }
        if (this.hasCurrentRouteSegmentVersion()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getCurrentRouteSegmentVersion().hashCode();
        }
        if (this.hasCurrentRouteSegmentEndPoint()) {
            hash = 37 * hash + 24;
            hash = 53 * hash + this.getCurrentRouteSegmentEndPoint().hashCode();
        }
        if (this.hasRemainingDistanceMeters()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getRemainingDistanceMeters().hashCode();
        }
        if (this.hasEtaToFirstWaypoint()) {
            hash = 37 * hash + 19;
            hash = 53 * hash + this.getEtaToFirstWaypoint().hashCode();
        }
        if (this.hasRemainingTimeSeconds()) {
            hash = 37 * hash + 25;
            hash = 53 * hash + this.getRemainingTimeSeconds().hashCode();
        }
        if (this.getWaypointsCount() > 0) {
            hash = 37 * hash + 22;
            hash = 53 * hash + this.getWaypointsList().hashCode();
        }
        if (this.hasWaypointsVersion()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getWaypointsVersion().hashCode();
        }
        hash = 37 * hash + 23;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getBackToBackEnabled());
        hash = 37 * hash + 26;
        hash = 53 * hash + this.navigationStatus_;
        if (this.hasDeviceSettings()) {
            hash = 37 * hash + 27;
            hash = 53 * hash + this.getDeviceSettings().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Vehicle parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data);
    }

    public static Vehicle parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Vehicle parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data);
    }

    public static Vehicle parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Vehicle parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data);
    }

    public static Vehicle parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Vehicle parseFrom(InputStream input) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Vehicle parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Vehicle parseDelimitedFrom(InputStream input) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Vehicle parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Vehicle parseFrom(CodedInputStream input) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Vehicle parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Vehicle.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Vehicle prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Vehicle getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Vehicle> parser() {
        return PARSER;
    }

    public Parser<Vehicle> getParserForType() {
        return PARSER;
    }

    public Vehicle getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements VehicleOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private int vehicleState_ = 0;
        private List<Integer> supportedTripTypes_ = Collections.emptyList();
        private LazyStringArrayList currentTrips_ = LazyStringArrayList.emptyList();
        private VehicleLocation lastLocation_;
        private SingleFieldBuilderV3<VehicleLocation, VehicleLocation.Builder, VehicleLocationOrBuilder> lastLocationBuilder_;
        private int maximumCapacity_;
        private List<VehicleAttribute> attributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VehicleAttribute, VehicleAttribute.Builder, VehicleAttributeOrBuilder> attributesBuilder_;
        private VehicleType vehicleType_;
        private SingleFieldBuilderV3<VehicleType, VehicleType.Builder, VehicleTypeOrBuilder> vehicleTypeBuilder_;
        private LicensePlate licensePlate_;
        private SingleFieldBuilderV3<LicensePlate, LicensePlate.Builder, LicensePlateOrBuilder> licensePlateBuilder_;
        private List<TerminalLocation> route_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> routeBuilder_;
        private Object currentRouteSegment_ = "";
        private TrafficPolylineData currentRouteSegmentTraffic_;
        private SingleFieldBuilderV3<TrafficPolylineData, TrafficPolylineData.Builder, TrafficPolylineDataOrBuilder> currentRouteSegmentTrafficBuilder_;
        private Timestamp currentRouteSegmentVersion_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> currentRouteSegmentVersionBuilder_;
        private TripWaypoint currentRouteSegmentEndPoint_;
        private SingleFieldBuilderV3<TripWaypoint, TripWaypoint.Builder, TripWaypointOrBuilder> currentRouteSegmentEndPointBuilder_;
        private Int32Value remainingDistanceMeters_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> remainingDistanceMetersBuilder_;
        private Timestamp etaToFirstWaypoint_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> etaToFirstWaypointBuilder_;
        private Int32Value remainingTimeSeconds_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> remainingTimeSecondsBuilder_;
        private List<TripWaypoint> waypoints_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<TripWaypoint, TripWaypoint.Builder, TripWaypointOrBuilder> waypointsBuilder_;
        private Timestamp waypointsVersion_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> waypointsVersionBuilder_;
        private boolean backToBackEnabled_;
        private int navigationStatus_ = 0;
        private DeviceSettings deviceSettings_;
        private SingleFieldBuilderV3<DeviceSettings, DeviceSettings.Builder, DeviceSettingsOrBuilder> deviceSettingsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_fieldAccessorTable.ensureFieldAccessorsInitialized(Vehicle.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getLastLocationFieldBuilder();
                this.getAttributesFieldBuilder();
                this.getVehicleTypeFieldBuilder();
                this.getLicensePlateFieldBuilder();
                this.getRouteFieldBuilder();
                this.getCurrentRouteSegmentTrafficFieldBuilder();
                this.getCurrentRouteSegmentVersionFieldBuilder();
                this.getCurrentRouteSegmentEndPointFieldBuilder();
                this.getRemainingDistanceMetersFieldBuilder();
                this.getEtaToFirstWaypointFieldBuilder();
                this.getRemainingTimeSecondsFieldBuilder();
                this.getWaypointsFieldBuilder();
                this.getWaypointsVersionFieldBuilder();
                this.getDeviceSettingsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.vehicleState_ = 0;
            this.supportedTripTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.currentTrips_ = LazyStringArrayList.emptyList();
            this.lastLocation_ = null;
            if (this.lastLocationBuilder_ != null) {
                this.lastLocationBuilder_.dispose();
                this.lastLocationBuilder_ = null;
            }
            this.maximumCapacity_ = 0;
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
            } else {
                this.attributes_ = null;
                this.attributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.vehicleType_ = null;
            if (this.vehicleTypeBuilder_ != null) {
                this.vehicleTypeBuilder_.dispose();
                this.vehicleTypeBuilder_ = null;
            }
            this.licensePlate_ = null;
            if (this.licensePlateBuilder_ != null) {
                this.licensePlateBuilder_.dispose();
                this.licensePlateBuilder_ = null;
            }
            if (this.routeBuilder_ == null) {
                this.route_ = Collections.emptyList();
            } else {
                this.route_ = null;
                this.routeBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.currentRouteSegment_ = "";
            this.currentRouteSegmentTraffic_ = null;
            if (this.currentRouteSegmentTrafficBuilder_ != null) {
                this.currentRouteSegmentTrafficBuilder_.dispose();
                this.currentRouteSegmentTrafficBuilder_ = null;
            }
            this.currentRouteSegmentVersion_ = null;
            if (this.currentRouteSegmentVersionBuilder_ != null) {
                this.currentRouteSegmentVersionBuilder_.dispose();
                this.currentRouteSegmentVersionBuilder_ = null;
            }
            this.currentRouteSegmentEndPoint_ = null;
            if (this.currentRouteSegmentEndPointBuilder_ != null) {
                this.currentRouteSegmentEndPointBuilder_.dispose();
                this.currentRouteSegmentEndPointBuilder_ = null;
            }
            this.remainingDistanceMeters_ = null;
            if (this.remainingDistanceMetersBuilder_ != null) {
                this.remainingDistanceMetersBuilder_.dispose();
                this.remainingDistanceMetersBuilder_ = null;
            }
            this.etaToFirstWaypoint_ = null;
            if (this.etaToFirstWaypointBuilder_ != null) {
                this.etaToFirstWaypointBuilder_.dispose();
                this.etaToFirstWaypointBuilder_ = null;
            }
            this.remainingTimeSeconds_ = null;
            if (this.remainingTimeSecondsBuilder_ != null) {
                this.remainingTimeSecondsBuilder_.dispose();
                this.remainingTimeSecondsBuilder_ = null;
            }
            if (this.waypointsBuilder_ == null) {
                this.waypoints_ = Collections.emptyList();
            } else {
                this.waypoints_ = null;
                this.waypointsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFDFFFF;
            this.waypointsVersion_ = null;
            if (this.waypointsVersionBuilder_ != null) {
                this.waypointsVersionBuilder_.dispose();
                this.waypointsVersionBuilder_ = null;
            }
            this.backToBackEnabled_ = false;
            this.navigationStatus_ = 0;
            this.deviceSettings_ = null;
            if (this.deviceSettingsBuilder_ != null) {
                this.deviceSettingsBuilder_.dispose();
                this.deviceSettingsBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_descriptor;
        }

        public Vehicle getDefaultInstanceForType() {
            return Vehicle.getDefaultInstance();
        }

        public Vehicle build() {
            Vehicle result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Vehicle buildPartial() {
            Vehicle result = new Vehicle(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Vehicle result) {
            if ((this.bitField0_ & 4) != 0) {
                this.supportedTripTypes_ = Collections.unmodifiableList(this.supportedTripTypes_);
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.supportedTripTypes_ = this.supportedTripTypes_;
            if (this.attributesBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.attributes_ = this.attributes_;
            } else {
                result.attributes_ = this.attributesBuilder_.build();
            }
            if (this.routeBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.route_ = Collections.unmodifiableList(this.route_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.route_ = this.route_;
            } else {
                result.route_ = this.routeBuilder_.build();
            }
            if (this.waypointsBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0) {
                    this.waypoints_ = Collections.unmodifiableList(this.waypoints_);
                    this.bitField0_ &= 0xFFFDFFFF;
                }
                result.waypoints_ = this.waypoints_;
            } else {
                result.waypoints_ = this.waypointsBuilder_.build();
            }
        }

        private void buildPartial0(Vehicle result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.vehicleState_ = this.vehicleState_;
            }
            if ((from_bitField0_ & 8) != 0) {
                this.currentTrips_.makeImmutable();
                result.currentTrips_ = this.currentTrips_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x10) != 0) {
                result.lastLocation_ = this.lastLocationBuilder_ == null ? this.lastLocation_ : (VehicleLocation)this.lastLocationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.maximumCapacity_ = this.maximumCapacity_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.vehicleType_ = this.vehicleTypeBuilder_ == null ? this.vehicleType_ : (VehicleType)this.vehicleTypeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.licensePlate_ = this.licensePlateBuilder_ == null ? this.licensePlate_ : (LicensePlate)this.licensePlateBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.currentRouteSegment_ = this.currentRouteSegment_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.currentRouteSegmentTraffic_ = this.currentRouteSegmentTrafficBuilder_ == null ? this.currentRouteSegmentTraffic_ : (TrafficPolylineData)this.currentRouteSegmentTrafficBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.currentRouteSegmentVersion_ = this.currentRouteSegmentVersionBuilder_ == null ? this.currentRouteSegmentVersion_ : (Timestamp)this.currentRouteSegmentVersionBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.currentRouteSegmentEndPoint_ = this.currentRouteSegmentEndPointBuilder_ == null ? this.currentRouteSegmentEndPoint_ : (TripWaypoint)this.currentRouteSegmentEndPointBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.remainingDistanceMeters_ = this.remainingDistanceMetersBuilder_ == null ? this.remainingDistanceMeters_ : (Int32Value)this.remainingDistanceMetersBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.etaToFirstWaypoint_ = this.etaToFirstWaypointBuilder_ == null ? this.etaToFirstWaypoint_ : (Timestamp)this.etaToFirstWaypointBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.remainingTimeSeconds_ = this.remainingTimeSecondsBuilder_ == null ? this.remainingTimeSeconds_ : (Int32Value)this.remainingTimeSecondsBuilder_.build();
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.waypointsVersion_ = this.waypointsVersionBuilder_ == null ? this.waypointsVersion_ : (Timestamp)this.waypointsVersionBuilder_.build();
                to_bitField0_ |= 0x200;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.backToBackEnabled_ = this.backToBackEnabled_;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.navigationStatus_ = this.navigationStatus_;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.deviceSettings_ = this.deviceSettingsBuilder_ == null ? this.deviceSettings_ : (DeviceSettings)this.deviceSettingsBuilder_.build();
                to_bitField0_ |= 0x400;
            }
            Vehicle vehicle = result;
            vehicle.bitField0_ = vehicle.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Vehicle) {
                return this.mergeFrom((Vehicle)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Vehicle other) {
            if (other == Vehicle.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.vehicleState_ != 0) {
                this.setVehicleStateValue(other.getVehicleStateValue());
            }
            if (!other.supportedTripTypes_.isEmpty()) {
                if (this.supportedTripTypes_.isEmpty()) {
                    this.supportedTripTypes_ = other.supportedTripTypes_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureSupportedTripTypesIsMutable();
                    this.supportedTripTypes_.addAll(other.supportedTripTypes_);
                }
                this.onChanged();
            }
            if (!other.currentTrips_.isEmpty()) {
                if (this.currentTrips_.isEmpty()) {
                    this.currentTrips_ = other.currentTrips_;
                    this.bitField0_ |= 8;
                } else {
                    this.ensureCurrentTripsIsMutable();
                    this.currentTrips_.addAll((Collection)other.currentTrips_);
                }
                this.onChanged();
            }
            if (other.hasLastLocation()) {
                this.mergeLastLocation(other.getLastLocation());
            }
            if (other.getMaximumCapacity() != 0) {
                this.setMaximumCapacity(other.getMaximumCapacity());
            }
            if (this.attributesBuilder_ == null) {
                if (!other.attributes_.isEmpty()) {
                    if (this.attributes_.isEmpty()) {
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureAttributesIsMutable();
                        this.attributes_.addAll(other.attributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributes_.isEmpty()) {
                if (this.attributesBuilder_.isEmpty()) {
                    this.attributesBuilder_.dispose();
                    this.attributesBuilder_ = null;
                    this.attributes_ = other.attributes_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                } else {
                    this.attributesBuilder_.addAllMessages((Iterable)other.attributes_);
                }
            }
            if (other.hasVehicleType()) {
                this.mergeVehicleType(other.getVehicleType());
            }
            if (other.hasLicensePlate()) {
                this.mergeLicensePlate(other.getLicensePlate());
            }
            if (this.routeBuilder_ == null) {
                if (!other.route_.isEmpty()) {
                    if (this.route_.isEmpty()) {
                        this.route_ = other.route_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureRouteIsMutable();
                        this.route_.addAll(other.route_);
                    }
                    this.onChanged();
                }
            } else if (!other.route_.isEmpty()) {
                if (this.routeBuilder_.isEmpty()) {
                    this.routeBuilder_.dispose();
                    this.routeBuilder_ = null;
                    this.route_ = other.route_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.routeBuilder_ = alwaysUseFieldBuilders ? this.getRouteFieldBuilder() : null;
                } else {
                    this.routeBuilder_.addAllMessages((Iterable)other.route_);
                }
            }
            if (!other.getCurrentRouteSegment().isEmpty()) {
                this.currentRouteSegment_ = other.currentRouteSegment_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (other.hasCurrentRouteSegmentTraffic()) {
                this.mergeCurrentRouteSegmentTraffic(other.getCurrentRouteSegmentTraffic());
            }
            if (other.hasCurrentRouteSegmentVersion()) {
                this.mergeCurrentRouteSegmentVersion(other.getCurrentRouteSegmentVersion());
            }
            if (other.hasCurrentRouteSegmentEndPoint()) {
                this.mergeCurrentRouteSegmentEndPoint(other.getCurrentRouteSegmentEndPoint());
            }
            if (other.hasRemainingDistanceMeters()) {
                this.mergeRemainingDistanceMeters(other.getRemainingDistanceMeters());
            }
            if (other.hasEtaToFirstWaypoint()) {
                this.mergeEtaToFirstWaypoint(other.getEtaToFirstWaypoint());
            }
            if (other.hasRemainingTimeSeconds()) {
                this.mergeRemainingTimeSeconds(other.getRemainingTimeSeconds());
            }
            if (this.waypointsBuilder_ == null) {
                if (!other.waypoints_.isEmpty()) {
                    if (this.waypoints_.isEmpty()) {
                        this.waypoints_ = other.waypoints_;
                        this.bitField0_ &= 0xFFFDFFFF;
                    } else {
                        this.ensureWaypointsIsMutable();
                        this.waypoints_.addAll(other.waypoints_);
                    }
                    this.onChanged();
                }
            } else if (!other.waypoints_.isEmpty()) {
                if (this.waypointsBuilder_.isEmpty()) {
                    this.waypointsBuilder_.dispose();
                    this.waypointsBuilder_ = null;
                    this.waypoints_ = other.waypoints_;
                    this.bitField0_ &= 0xFFFDFFFF;
                    this.waypointsBuilder_ = alwaysUseFieldBuilders ? this.getWaypointsFieldBuilder() : null;
                } else {
                    this.waypointsBuilder_.addAllMessages((Iterable)other.waypoints_);
                }
            }
            if (other.hasWaypointsVersion()) {
                this.mergeWaypointsVersion(other.getWaypointsVersion());
            }
            if (other.getBackToBackEnabled()) {
                this.setBackToBackEnabled(other.getBackToBackEnabled());
            }
            if (other.navigationStatus_ != 0) {
                this.setNavigationStatusValue(other.getNavigationStatusValue());
            }
            if (other.hasDeviceSettings()) {
                this.mergeDeviceSettings(other.getDeviceSettings());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block31: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block31;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block31;
                        }
                        case 16: {
                            this.vehicleState_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block31;
                        }
                        case 24: {
                            int tmpRaw = input.readEnum();
                            this.ensureSupportedTripTypesIsMutable();
                            this.supportedTripTypes_.add(tmpRaw);
                            continue block31;
                        }
                        case 26: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureSupportedTripTypesIsMutable();
                                this.supportedTripTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block31;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensureCurrentTripsIsMutable();
                            this.currentTrips_.add((Object)s);
                            continue block31;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getLastLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block31;
                        }
                        case 48: {
                            this.maximumCapacity_ = input.readInt32();
                            this.bitField0_ |= 0x20;
                            continue block31;
                        }
                        case 66: {
                            VehicleAttribute m = (VehicleAttribute)input.readMessage(VehicleAttribute.parser(), extensionRegistry);
                            if (this.attributesBuilder_ == null) {
                                this.ensureAttributesIsMutable();
                                this.attributes_.add(m);
                                continue block31;
                            }
                            this.attributesBuilder_.addMessage((AbstractMessage)m);
                            continue block31;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getVehicleTypeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block31;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getLicensePlateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block31;
                        }
                        case 98: {
                            TerminalLocation m = (TerminalLocation)input.readMessage(TerminalLocation.parser(), extensionRegistry);
                            if (this.routeBuilder_ == null) {
                                this.ensureRouteIsMutable();
                                this.route_.add(m);
                                continue block31;
                            }
                            this.routeBuilder_.addMessage((AbstractMessage)m);
                            continue block31;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.getCurrentRouteSegmentVersionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block31;
                        }
                        case 130: {
                            input.readMessage((MessageLite.Builder)this.getWaypointsVersionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40000;
                            continue block31;
                        }
                        case 146: {
                            input.readMessage((MessageLite.Builder)this.getRemainingDistanceMetersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x4000;
                            continue block31;
                        }
                        case 154: {
                            input.readMessage((MessageLite.Builder)this.getEtaToFirstWaypointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x8000;
                            continue block31;
                        }
                        case 162: {
                            this.currentRouteSegment_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block31;
                        }
                        case 178: {
                            TripWaypoint m = (TripWaypoint)input.readMessage(TripWaypoint.parser(), extensionRegistry);
                            if (this.waypointsBuilder_ == null) {
                                this.ensureWaypointsIsMutable();
                                this.waypoints_.add(m);
                                continue block31;
                            }
                            this.waypointsBuilder_.addMessage((AbstractMessage)m);
                            continue block31;
                        }
                        case 184: {
                            this.backToBackEnabled_ = input.readBool();
                            this.bitField0_ |= 0x80000;
                            continue block31;
                        }
                        case 194: {
                            input.readMessage((MessageLite.Builder)this.getCurrentRouteSegmentEndPointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block31;
                        }
                        case 202: {
                            input.readMessage((MessageLite.Builder)this.getRemainingTimeSecondsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block31;
                        }
                        case 208: {
                            this.navigationStatus_ = input.readEnum();
                            this.bitField0_ |= 0x100000;
                            continue block31;
                        }
                        case 218: {
                            input.readMessage((MessageLite.Builder)this.getDeviceSettingsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200000;
                            continue block31;
                        }
                        case 226: {
                            input.readMessage((MessageLite.Builder)this.getCurrentRouteSegmentTrafficFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block31;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Vehicle.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getVehicleStateValue() {
            return this.vehicleState_;
        }

        public Builder setVehicleStateValue(int value) {
            this.vehicleState_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public VehicleState getVehicleState() {
            VehicleState result = VehicleState.forNumber(this.vehicleState_);
            return result == null ? VehicleState.UNRECOGNIZED : result;
        }

        public Builder setVehicleState(VehicleState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.vehicleState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearVehicleState() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.vehicleState_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureSupportedTripTypesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.supportedTripTypes_ = new ArrayList<Integer>(this.supportedTripTypes_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<TripType> getSupportedTripTypesList() {
            return new Internal.ListAdapter(this.supportedTripTypes_, supportedTripTypes_converter_);
        }

        @Override
        public int getSupportedTripTypesCount() {
            return this.supportedTripTypes_.size();
        }

        @Override
        public TripType getSupportedTripTypes(int index) {
            return (TripType)((Object)supportedTripTypes_converter_.convert((Object)this.supportedTripTypes_.get(index)));
        }

        public Builder setSupportedTripTypes(int index, TripType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSupportedTripTypesIsMutable();
            this.supportedTripTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addSupportedTripTypes(TripType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSupportedTripTypesIsMutable();
            this.supportedTripTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllSupportedTripTypes(Iterable<? extends TripType> values) {
            this.ensureSupportedTripTypesIsMutable();
            for (TripType tripType : values) {
                this.supportedTripTypes_.add(tripType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearSupportedTripTypes() {
            this.supportedTripTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getSupportedTripTypesValueList() {
            return Collections.unmodifiableList(this.supportedTripTypes_);
        }

        @Override
        public int getSupportedTripTypesValue(int index) {
            return this.supportedTripTypes_.get(index);
        }

        public Builder setSupportedTripTypesValue(int index, int value) {
            this.ensureSupportedTripTypesIsMutable();
            this.supportedTripTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addSupportedTripTypesValue(int value) {
            this.ensureSupportedTripTypesIsMutable();
            this.supportedTripTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllSupportedTripTypesValue(Iterable<Integer> values) {
            this.ensureSupportedTripTypesIsMutable();
            for (int value : values) {
                this.supportedTripTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureCurrentTripsIsMutable() {
            if (!this.currentTrips_.isModifiable()) {
                this.currentTrips_ = new LazyStringArrayList((LazyStringList)this.currentTrips_);
            }
            this.bitField0_ |= 8;
        }

        public ProtocolStringList getCurrentTripsList() {
            this.currentTrips_.makeImmutable();
            return this.currentTrips_;
        }

        @Override
        public int getCurrentTripsCount() {
            return this.currentTrips_.size();
        }

        @Override
        public String getCurrentTrips(int index) {
            return this.currentTrips_.get(index);
        }

        @Override
        public ByteString getCurrentTripsBytes(int index) {
            return this.currentTrips_.getByteString(index);
        }

        public Builder setCurrentTrips(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCurrentTripsIsMutable();
            this.currentTrips_.set(index, value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addCurrentTrips(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCurrentTripsIsMutable();
            this.currentTrips_.add((Object)value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAllCurrentTrips(Iterable<String> values) {
            this.ensureCurrentTripsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.currentTrips_);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearCurrentTrips() {
            this.currentTrips_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addCurrentTripsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.ensureCurrentTripsIsMutable();
            this.currentTrips_.add(value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLastLocation() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public VehicleLocation getLastLocation() {
            if (this.lastLocationBuilder_ == null) {
                return this.lastLocation_ == null ? VehicleLocation.getDefaultInstance() : this.lastLocation_;
            }
            return (VehicleLocation)this.lastLocationBuilder_.getMessage();
        }

        public Builder setLastLocation(VehicleLocation value) {
            if (this.lastLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastLocation_ = value;
            } else {
                this.lastLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setLastLocation(VehicleLocation.Builder builderForValue) {
            if (this.lastLocationBuilder_ == null) {
                this.lastLocation_ = builderForValue.build();
            } else {
                this.lastLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeLastLocation(VehicleLocation value) {
            if (this.lastLocationBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.lastLocation_ != null && this.lastLocation_ != VehicleLocation.getDefaultInstance()) {
                    this.getLastLocationBuilder().mergeFrom(value);
                } else {
                    this.lastLocation_ = value;
                }
            } else {
                this.lastLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.lastLocation_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLastLocation() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.lastLocation_ = null;
            if (this.lastLocationBuilder_ != null) {
                this.lastLocationBuilder_.dispose();
                this.lastLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public VehicleLocation.Builder getLastLocationBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (VehicleLocation.Builder)this.getLastLocationFieldBuilder().getBuilder();
        }

        @Override
        public VehicleLocationOrBuilder getLastLocationOrBuilder() {
            if (this.lastLocationBuilder_ != null) {
                return (VehicleLocationOrBuilder)this.lastLocationBuilder_.getMessageOrBuilder();
            }
            return this.lastLocation_ == null ? VehicleLocation.getDefaultInstance() : this.lastLocation_;
        }

        private SingleFieldBuilderV3<VehicleLocation, VehicleLocation.Builder, VehicleLocationOrBuilder> getLastLocationFieldBuilder() {
            if (this.lastLocationBuilder_ == null) {
                this.lastLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastLocation_ = null;
            }
            return this.lastLocationBuilder_;
        }

        @Override
        public int getMaximumCapacity() {
            return this.maximumCapacity_;
        }

        public Builder setMaximumCapacity(int value) {
            this.maximumCapacity_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearMaximumCapacity() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.maximumCapacity_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureAttributesIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.attributes_ = new ArrayList<VehicleAttribute>(this.attributes_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<VehicleAttribute> getAttributesList() {
            if (this.attributesBuilder_ == null) {
                return Collections.unmodifiableList(this.attributes_);
            }
            return this.attributesBuilder_.getMessageList();
        }

        @Override
        public int getAttributesCount() {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.size();
            }
            return this.attributesBuilder_.getCount();
        }

        @Override
        public VehicleAttribute getAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (VehicleAttribute)this.attributesBuilder_.getMessage(index);
        }

        public Builder setAttributes(int index, VehicleAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAttributes(int index, VehicleAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(VehicleAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(int index, VehicleAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(VehicleAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(int index, VehicleAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributes(Iterable<? extends VehicleAttribute> values) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributes_);
                this.onChanged();
            } else {
                this.attributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributes() {
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.attributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.remove(index);
                this.onChanged();
            } else {
                this.attributesBuilder_.remove(index);
            }
            return this;
        }

        public VehicleAttribute.Builder getAttributesBuilder(int index) {
            return (VehicleAttribute.Builder)this.getAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public VehicleAttributeOrBuilder getAttributesOrBuilder(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (VehicleAttributeOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VehicleAttributeOrBuilder> getAttributesOrBuilderList() {
            if (this.attributesBuilder_ != null) {
                return this.attributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributes_);
        }

        public VehicleAttribute.Builder addAttributesBuilder() {
            return (VehicleAttribute.Builder)this.getAttributesFieldBuilder().addBuilder((AbstractMessage)VehicleAttribute.getDefaultInstance());
        }

        public VehicleAttribute.Builder addAttributesBuilder(int index) {
            return (VehicleAttribute.Builder)this.getAttributesFieldBuilder().addBuilder(index, (AbstractMessage)VehicleAttribute.getDefaultInstance());
        }

        public List<VehicleAttribute.Builder> getAttributesBuilderList() {
            return this.getAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VehicleAttribute, VehicleAttribute.Builder, VehicleAttributeOrBuilder> getAttributesFieldBuilder() {
            if (this.attributesBuilder_ == null) {
                this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.attributes_ = null;
            }
            return this.attributesBuilder_;
        }

        @Override
        public boolean hasVehicleType() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public VehicleType getVehicleType() {
            if (this.vehicleTypeBuilder_ == null) {
                return this.vehicleType_ == null ? VehicleType.getDefaultInstance() : this.vehicleType_;
            }
            return (VehicleType)this.vehicleTypeBuilder_.getMessage();
        }

        public Builder setVehicleType(VehicleType value) {
            if (this.vehicleTypeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.vehicleType_ = value;
            } else {
                this.vehicleTypeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setVehicleType(VehicleType.Builder builderForValue) {
            if (this.vehicleTypeBuilder_ == null) {
                this.vehicleType_ = builderForValue.build();
            } else {
                this.vehicleTypeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeVehicleType(VehicleType value) {
            if (this.vehicleTypeBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.vehicleType_ != null && this.vehicleType_ != VehicleType.getDefaultInstance()) {
                    this.getVehicleTypeBuilder().mergeFrom(value);
                } else {
                    this.vehicleType_ = value;
                }
            } else {
                this.vehicleTypeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.vehicleType_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearVehicleType() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.vehicleType_ = null;
            if (this.vehicleTypeBuilder_ != null) {
                this.vehicleTypeBuilder_.dispose();
                this.vehicleTypeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public VehicleType.Builder getVehicleTypeBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (VehicleType.Builder)this.getVehicleTypeFieldBuilder().getBuilder();
        }

        @Override
        public VehicleTypeOrBuilder getVehicleTypeOrBuilder() {
            if (this.vehicleTypeBuilder_ != null) {
                return (VehicleTypeOrBuilder)this.vehicleTypeBuilder_.getMessageOrBuilder();
            }
            return this.vehicleType_ == null ? VehicleType.getDefaultInstance() : this.vehicleType_;
        }

        private SingleFieldBuilderV3<VehicleType, VehicleType.Builder, VehicleTypeOrBuilder> getVehicleTypeFieldBuilder() {
            if (this.vehicleTypeBuilder_ == null) {
                this.vehicleTypeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getVehicleType(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.vehicleType_ = null;
            }
            return this.vehicleTypeBuilder_;
        }

        @Override
        public boolean hasLicensePlate() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public LicensePlate getLicensePlate() {
            if (this.licensePlateBuilder_ == null) {
                return this.licensePlate_ == null ? LicensePlate.getDefaultInstance() : this.licensePlate_;
            }
            return (LicensePlate)this.licensePlateBuilder_.getMessage();
        }

        public Builder setLicensePlate(LicensePlate value) {
            if (this.licensePlateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.licensePlate_ = value;
            } else {
                this.licensePlateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setLicensePlate(LicensePlate.Builder builderForValue) {
            if (this.licensePlateBuilder_ == null) {
                this.licensePlate_ = builderForValue.build();
            } else {
                this.licensePlateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeLicensePlate(LicensePlate value) {
            if (this.licensePlateBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.licensePlate_ != null && this.licensePlate_ != LicensePlate.getDefaultInstance()) {
                    this.getLicensePlateBuilder().mergeFrom(value);
                } else {
                    this.licensePlate_ = value;
                }
            } else {
                this.licensePlateBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.licensePlate_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLicensePlate() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.licensePlate_ = null;
            if (this.licensePlateBuilder_ != null) {
                this.licensePlateBuilder_.dispose();
                this.licensePlateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LicensePlate.Builder getLicensePlateBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (LicensePlate.Builder)this.getLicensePlateFieldBuilder().getBuilder();
        }

        @Override
        public LicensePlateOrBuilder getLicensePlateOrBuilder() {
            if (this.licensePlateBuilder_ != null) {
                return (LicensePlateOrBuilder)this.licensePlateBuilder_.getMessageOrBuilder();
            }
            return this.licensePlate_ == null ? LicensePlate.getDefaultInstance() : this.licensePlate_;
        }

        private SingleFieldBuilderV3<LicensePlate, LicensePlate.Builder, LicensePlateOrBuilder> getLicensePlateFieldBuilder() {
            if (this.licensePlateBuilder_ == null) {
                this.licensePlateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLicensePlate(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.licensePlate_ = null;
            }
            return this.licensePlateBuilder_;
        }

        private void ensureRouteIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.route_ = new ArrayList<TerminalLocation>(this.route_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        @Deprecated
        public List<TerminalLocation> getRouteList() {
            if (this.routeBuilder_ == null) {
                return Collections.unmodifiableList(this.route_);
            }
            return this.routeBuilder_.getMessageList();
        }

        @Override
        @Deprecated
        public int getRouteCount() {
            if (this.routeBuilder_ == null) {
                return this.route_.size();
            }
            return this.routeBuilder_.getCount();
        }

        @Override
        @Deprecated
        public TerminalLocation getRoute(int index) {
            if (this.routeBuilder_ == null) {
                return this.route_.get(index);
            }
            return (TerminalLocation)this.routeBuilder_.getMessage(index);
        }

        @Deprecated
        public Builder setRoute(int index, TerminalLocation value) {
            if (this.routeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRouteIsMutable();
                this.route_.set(index, value);
                this.onChanged();
            } else {
                this.routeBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        @Deprecated
        public Builder setRoute(int index, TerminalLocation.Builder builderForValue) {
            if (this.routeBuilder_ == null) {
                this.ensureRouteIsMutable();
                this.route_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.routeBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addRoute(TerminalLocation value) {
            if (this.routeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRouteIsMutable();
                this.route_.add(value);
                this.onChanged();
            } else {
                this.routeBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        @Deprecated
        public Builder addRoute(int index, TerminalLocation value) {
            if (this.routeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRouteIsMutable();
                this.route_.add(index, value);
                this.onChanged();
            } else {
                this.routeBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        @Deprecated
        public Builder addRoute(TerminalLocation.Builder builderForValue) {
            if (this.routeBuilder_ == null) {
                this.ensureRouteIsMutable();
                this.route_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.routeBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addRoute(int index, TerminalLocation.Builder builderForValue) {
            if (this.routeBuilder_ == null) {
                this.ensureRouteIsMutable();
                this.route_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.routeBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addAllRoute(Iterable<? extends TerminalLocation> values) {
            if (this.routeBuilder_ == null) {
                this.ensureRouteIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.route_);
                this.onChanged();
            } else {
                this.routeBuilder_.addAllMessages(values);
            }
            return this;
        }

        @Deprecated
        public Builder clearRoute() {
            if (this.routeBuilder_ == null) {
                this.route_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.routeBuilder_.clear();
            }
            return this;
        }

        @Deprecated
        public Builder removeRoute(int index) {
            if (this.routeBuilder_ == null) {
                this.ensureRouteIsMutable();
                this.route_.remove(index);
                this.onChanged();
            } else {
                this.routeBuilder_.remove(index);
            }
            return this;
        }

        @Deprecated
        public TerminalLocation.Builder getRouteBuilder(int index) {
            return (TerminalLocation.Builder)this.getRouteFieldBuilder().getBuilder(index);
        }

        @Override
        @Deprecated
        public TerminalLocationOrBuilder getRouteOrBuilder(int index) {
            if (this.routeBuilder_ == null) {
                return this.route_.get(index);
            }
            return (TerminalLocationOrBuilder)this.routeBuilder_.getMessageOrBuilder(index);
        }

        @Override
        @Deprecated
        public List<? extends TerminalLocationOrBuilder> getRouteOrBuilderList() {
            if (this.routeBuilder_ != null) {
                return this.routeBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.route_);
        }

        @Deprecated
        public TerminalLocation.Builder addRouteBuilder() {
            return (TerminalLocation.Builder)this.getRouteFieldBuilder().addBuilder((AbstractMessage)TerminalLocation.getDefaultInstance());
        }

        @Deprecated
        public TerminalLocation.Builder addRouteBuilder(int index) {
            return (TerminalLocation.Builder)this.getRouteFieldBuilder().addBuilder(index, (AbstractMessage)TerminalLocation.getDefaultInstance());
        }

        @Deprecated
        public List<TerminalLocation.Builder> getRouteBuilderList() {
            return this.getRouteFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> getRouteFieldBuilder() {
            if (this.routeBuilder_ == null) {
                this.routeBuilder_ = new RepeatedFieldBuilderV3(this.route_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.route_ = null;
            }
            return this.routeBuilder_;
        }

        @Override
        public String getCurrentRouteSegment() {
            Object ref = this.currentRouteSegment_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.currentRouteSegment_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCurrentRouteSegmentBytes() {
            Object ref = this.currentRouteSegment_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.currentRouteSegment_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCurrentRouteSegment(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currentRouteSegment_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearCurrentRouteSegment() {
            this.currentRouteSegment_ = Vehicle.getDefaultInstance().getCurrentRouteSegment();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setCurrentRouteSegmentBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.currentRouteSegment_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCurrentRouteSegmentTraffic() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public TrafficPolylineData getCurrentRouteSegmentTraffic() {
            if (this.currentRouteSegmentTrafficBuilder_ == null) {
                return this.currentRouteSegmentTraffic_ == null ? TrafficPolylineData.getDefaultInstance() : this.currentRouteSegmentTraffic_;
            }
            return (TrafficPolylineData)this.currentRouteSegmentTrafficBuilder_.getMessage();
        }

        public Builder setCurrentRouteSegmentTraffic(TrafficPolylineData value) {
            if (this.currentRouteSegmentTrafficBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.currentRouteSegmentTraffic_ = value;
            } else {
                this.currentRouteSegmentTrafficBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setCurrentRouteSegmentTraffic(TrafficPolylineData.Builder builderForValue) {
            if (this.currentRouteSegmentTrafficBuilder_ == null) {
                this.currentRouteSegmentTraffic_ = builderForValue.build();
            } else {
                this.currentRouteSegmentTrafficBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeCurrentRouteSegmentTraffic(TrafficPolylineData value) {
            if (this.currentRouteSegmentTrafficBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.currentRouteSegmentTraffic_ != null && this.currentRouteSegmentTraffic_ != TrafficPolylineData.getDefaultInstance()) {
                    this.getCurrentRouteSegmentTrafficBuilder().mergeFrom(value);
                } else {
                    this.currentRouteSegmentTraffic_ = value;
                }
            } else {
                this.currentRouteSegmentTrafficBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.currentRouteSegmentTraffic_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCurrentRouteSegmentTraffic() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.currentRouteSegmentTraffic_ = null;
            if (this.currentRouteSegmentTrafficBuilder_ != null) {
                this.currentRouteSegmentTrafficBuilder_.dispose();
                this.currentRouteSegmentTrafficBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TrafficPolylineData.Builder getCurrentRouteSegmentTrafficBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (TrafficPolylineData.Builder)this.getCurrentRouteSegmentTrafficFieldBuilder().getBuilder();
        }

        @Override
        public TrafficPolylineDataOrBuilder getCurrentRouteSegmentTrafficOrBuilder() {
            if (this.currentRouteSegmentTrafficBuilder_ != null) {
                return (TrafficPolylineDataOrBuilder)this.currentRouteSegmentTrafficBuilder_.getMessageOrBuilder();
            }
            return this.currentRouteSegmentTraffic_ == null ? TrafficPolylineData.getDefaultInstance() : this.currentRouteSegmentTraffic_;
        }

        private SingleFieldBuilderV3<TrafficPolylineData, TrafficPolylineData.Builder, TrafficPolylineDataOrBuilder> getCurrentRouteSegmentTrafficFieldBuilder() {
            if (this.currentRouteSegmentTrafficBuilder_ == null) {
                this.currentRouteSegmentTrafficBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCurrentRouteSegmentTraffic(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.currentRouteSegmentTraffic_ = null;
            }
            return this.currentRouteSegmentTrafficBuilder_;
        }

        @Override
        public boolean hasCurrentRouteSegmentVersion() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public Timestamp getCurrentRouteSegmentVersion() {
            if (this.currentRouteSegmentVersionBuilder_ == null) {
                return this.currentRouteSegmentVersion_ == null ? Timestamp.getDefaultInstance() : this.currentRouteSegmentVersion_;
            }
            return (Timestamp)this.currentRouteSegmentVersionBuilder_.getMessage();
        }

        public Builder setCurrentRouteSegmentVersion(Timestamp value) {
            if (this.currentRouteSegmentVersionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.currentRouteSegmentVersion_ = value;
            } else {
                this.currentRouteSegmentVersionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setCurrentRouteSegmentVersion(Timestamp.Builder builderForValue) {
            if (this.currentRouteSegmentVersionBuilder_ == null) {
                this.currentRouteSegmentVersion_ = builderForValue.build();
            } else {
                this.currentRouteSegmentVersionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeCurrentRouteSegmentVersion(Timestamp value) {
            if (this.currentRouteSegmentVersionBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.currentRouteSegmentVersion_ != null && this.currentRouteSegmentVersion_ != Timestamp.getDefaultInstance()) {
                    this.getCurrentRouteSegmentVersionBuilder().mergeFrom(value);
                } else {
                    this.currentRouteSegmentVersion_ = value;
                }
            } else {
                this.currentRouteSegmentVersionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.currentRouteSegmentVersion_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCurrentRouteSegmentVersion() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.currentRouteSegmentVersion_ = null;
            if (this.currentRouteSegmentVersionBuilder_ != null) {
                this.currentRouteSegmentVersionBuilder_.dispose();
                this.currentRouteSegmentVersionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCurrentRouteSegmentVersionBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (Timestamp.Builder)this.getCurrentRouteSegmentVersionFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCurrentRouteSegmentVersionOrBuilder() {
            if (this.currentRouteSegmentVersionBuilder_ != null) {
                return (TimestampOrBuilder)this.currentRouteSegmentVersionBuilder_.getMessageOrBuilder();
            }
            return this.currentRouteSegmentVersion_ == null ? Timestamp.getDefaultInstance() : this.currentRouteSegmentVersion_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCurrentRouteSegmentVersionFieldBuilder() {
            if (this.currentRouteSegmentVersionBuilder_ == null) {
                this.currentRouteSegmentVersionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCurrentRouteSegmentVersion(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.currentRouteSegmentVersion_ = null;
            }
            return this.currentRouteSegmentVersionBuilder_;
        }

        @Override
        public boolean hasCurrentRouteSegmentEndPoint() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public TripWaypoint getCurrentRouteSegmentEndPoint() {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                return this.currentRouteSegmentEndPoint_ == null ? TripWaypoint.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
            }
            return (TripWaypoint)this.currentRouteSegmentEndPointBuilder_.getMessage();
        }

        public Builder setCurrentRouteSegmentEndPoint(TripWaypoint value) {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.currentRouteSegmentEndPoint_ = value;
            } else {
                this.currentRouteSegmentEndPointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setCurrentRouteSegmentEndPoint(TripWaypoint.Builder builderForValue) {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                this.currentRouteSegmentEndPoint_ = builderForValue.build();
            } else {
                this.currentRouteSegmentEndPointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeCurrentRouteSegmentEndPoint(TripWaypoint value) {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.currentRouteSegmentEndPoint_ != null && this.currentRouteSegmentEndPoint_ != TripWaypoint.getDefaultInstance()) {
                    this.getCurrentRouteSegmentEndPointBuilder().mergeFrom(value);
                } else {
                    this.currentRouteSegmentEndPoint_ = value;
                }
            } else {
                this.currentRouteSegmentEndPointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.currentRouteSegmentEndPoint_ != null) {
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCurrentRouteSegmentEndPoint() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.currentRouteSegmentEndPoint_ = null;
            if (this.currentRouteSegmentEndPointBuilder_ != null) {
                this.currentRouteSegmentEndPointBuilder_.dispose();
                this.currentRouteSegmentEndPointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TripWaypoint.Builder getCurrentRouteSegmentEndPointBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (TripWaypoint.Builder)this.getCurrentRouteSegmentEndPointFieldBuilder().getBuilder();
        }

        @Override
        public TripWaypointOrBuilder getCurrentRouteSegmentEndPointOrBuilder() {
            if (this.currentRouteSegmentEndPointBuilder_ != null) {
                return (TripWaypointOrBuilder)this.currentRouteSegmentEndPointBuilder_.getMessageOrBuilder();
            }
            return this.currentRouteSegmentEndPoint_ == null ? TripWaypoint.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
        }

        private SingleFieldBuilderV3<TripWaypoint, TripWaypoint.Builder, TripWaypointOrBuilder> getCurrentRouteSegmentEndPointFieldBuilder() {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                this.currentRouteSegmentEndPointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCurrentRouteSegmentEndPoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.currentRouteSegmentEndPoint_ = null;
            }
            return this.currentRouteSegmentEndPointBuilder_;
        }

        @Override
        public boolean hasRemainingDistanceMeters() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public Int32Value getRemainingDistanceMeters() {
            if (this.remainingDistanceMetersBuilder_ == null) {
                return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
            }
            return (Int32Value)this.remainingDistanceMetersBuilder_.getMessage();
        }

        public Builder setRemainingDistanceMeters(Int32Value value) {
            if (this.remainingDistanceMetersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remainingDistanceMeters_ = value;
            } else {
                this.remainingDistanceMetersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder setRemainingDistanceMeters(Int32Value.Builder builderForValue) {
            if (this.remainingDistanceMetersBuilder_ == null) {
                this.remainingDistanceMeters_ = builderForValue.build();
            } else {
                this.remainingDistanceMetersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder mergeRemainingDistanceMeters(Int32Value value) {
            if (this.remainingDistanceMetersBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0 && this.remainingDistanceMeters_ != null && this.remainingDistanceMeters_ != Int32Value.getDefaultInstance()) {
                    this.getRemainingDistanceMetersBuilder().mergeFrom(value);
                } else {
                    this.remainingDistanceMeters_ = value;
                }
            } else {
                this.remainingDistanceMetersBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.remainingDistanceMeters_ != null) {
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRemainingDistanceMeters() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.remainingDistanceMeters_ = null;
            if (this.remainingDistanceMetersBuilder_ != null) {
                this.remainingDistanceMetersBuilder_.dispose();
                this.remainingDistanceMetersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getRemainingDistanceMetersBuilder() {
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return (Int32Value.Builder)this.getRemainingDistanceMetersFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getRemainingDistanceMetersOrBuilder() {
            if (this.remainingDistanceMetersBuilder_ != null) {
                return (Int32ValueOrBuilder)this.remainingDistanceMetersBuilder_.getMessageOrBuilder();
            }
            return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getRemainingDistanceMetersFieldBuilder() {
            if (this.remainingDistanceMetersBuilder_ == null) {
                this.remainingDistanceMetersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemainingDistanceMeters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingDistanceMeters_ = null;
            }
            return this.remainingDistanceMetersBuilder_;
        }

        @Override
        public boolean hasEtaToFirstWaypoint() {
            return (this.bitField0_ & 0x8000) != 0;
        }

        @Override
        public Timestamp getEtaToFirstWaypoint() {
            if (this.etaToFirstWaypointBuilder_ == null) {
                return this.etaToFirstWaypoint_ == null ? Timestamp.getDefaultInstance() : this.etaToFirstWaypoint_;
            }
            return (Timestamp)this.etaToFirstWaypointBuilder_.getMessage();
        }

        public Builder setEtaToFirstWaypoint(Timestamp value) {
            if (this.etaToFirstWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.etaToFirstWaypoint_ = value;
            } else {
                this.etaToFirstWaypointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder setEtaToFirstWaypoint(Timestamp.Builder builderForValue) {
            if (this.etaToFirstWaypointBuilder_ == null) {
                this.etaToFirstWaypoint_ = builderForValue.build();
            } else {
                this.etaToFirstWaypointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder mergeEtaToFirstWaypoint(Timestamp value) {
            if (this.etaToFirstWaypointBuilder_ == null) {
                if ((this.bitField0_ & 0x8000) != 0 && this.etaToFirstWaypoint_ != null && this.etaToFirstWaypoint_ != Timestamp.getDefaultInstance()) {
                    this.getEtaToFirstWaypointBuilder().mergeFrom(value);
                } else {
                    this.etaToFirstWaypoint_ = value;
                }
            } else {
                this.etaToFirstWaypointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.etaToFirstWaypoint_ != null) {
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEtaToFirstWaypoint() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.etaToFirstWaypoint_ = null;
            if (this.etaToFirstWaypointBuilder_ != null) {
                this.etaToFirstWaypointBuilder_.dispose();
                this.etaToFirstWaypointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEtaToFirstWaypointBuilder() {
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return (Timestamp.Builder)this.getEtaToFirstWaypointFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEtaToFirstWaypointOrBuilder() {
            if (this.etaToFirstWaypointBuilder_ != null) {
                return (TimestampOrBuilder)this.etaToFirstWaypointBuilder_.getMessageOrBuilder();
            }
            return this.etaToFirstWaypoint_ == null ? Timestamp.getDefaultInstance() : this.etaToFirstWaypoint_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEtaToFirstWaypointFieldBuilder() {
            if (this.etaToFirstWaypointBuilder_ == null) {
                this.etaToFirstWaypointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEtaToFirstWaypoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.etaToFirstWaypoint_ = null;
            }
            return this.etaToFirstWaypointBuilder_;
        }

        @Override
        public boolean hasRemainingTimeSeconds() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public Int32Value getRemainingTimeSeconds() {
            if (this.remainingTimeSecondsBuilder_ == null) {
                return this.remainingTimeSeconds_ == null ? Int32Value.getDefaultInstance() : this.remainingTimeSeconds_;
            }
            return (Int32Value)this.remainingTimeSecondsBuilder_.getMessage();
        }

        public Builder setRemainingTimeSeconds(Int32Value value) {
            if (this.remainingTimeSecondsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remainingTimeSeconds_ = value;
            } else {
                this.remainingTimeSecondsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setRemainingTimeSeconds(Int32Value.Builder builderForValue) {
            if (this.remainingTimeSecondsBuilder_ == null) {
                this.remainingTimeSeconds_ = builderForValue.build();
            } else {
                this.remainingTimeSecondsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeRemainingTimeSeconds(Int32Value value) {
            if (this.remainingTimeSecondsBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.remainingTimeSeconds_ != null && this.remainingTimeSeconds_ != Int32Value.getDefaultInstance()) {
                    this.getRemainingTimeSecondsBuilder().mergeFrom(value);
                } else {
                    this.remainingTimeSeconds_ = value;
                }
            } else {
                this.remainingTimeSecondsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.remainingTimeSeconds_ != null) {
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRemainingTimeSeconds() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.remainingTimeSeconds_ = null;
            if (this.remainingTimeSecondsBuilder_ != null) {
                this.remainingTimeSecondsBuilder_.dispose();
                this.remainingTimeSecondsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getRemainingTimeSecondsBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (Int32Value.Builder)this.getRemainingTimeSecondsFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getRemainingTimeSecondsOrBuilder() {
            if (this.remainingTimeSecondsBuilder_ != null) {
                return (Int32ValueOrBuilder)this.remainingTimeSecondsBuilder_.getMessageOrBuilder();
            }
            return this.remainingTimeSeconds_ == null ? Int32Value.getDefaultInstance() : this.remainingTimeSeconds_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getRemainingTimeSecondsFieldBuilder() {
            if (this.remainingTimeSecondsBuilder_ == null) {
                this.remainingTimeSecondsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemainingTimeSeconds(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingTimeSeconds_ = null;
            }
            return this.remainingTimeSecondsBuilder_;
        }

        private void ensureWaypointsIsMutable() {
            if ((this.bitField0_ & 0x20000) == 0) {
                this.waypoints_ = new ArrayList<TripWaypoint>(this.waypoints_);
                this.bitField0_ |= 0x20000;
            }
        }

        @Override
        public List<TripWaypoint> getWaypointsList() {
            if (this.waypointsBuilder_ == null) {
                return Collections.unmodifiableList(this.waypoints_);
            }
            return this.waypointsBuilder_.getMessageList();
        }

        @Override
        public int getWaypointsCount() {
            if (this.waypointsBuilder_ == null) {
                return this.waypoints_.size();
            }
            return this.waypointsBuilder_.getCount();
        }

        @Override
        public TripWaypoint getWaypoints(int index) {
            if (this.waypointsBuilder_ == null) {
                return this.waypoints_.get(index);
            }
            return (TripWaypoint)this.waypointsBuilder_.getMessage(index);
        }

        public Builder setWaypoints(int index, TripWaypoint value) {
            if (this.waypointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureWaypointsIsMutable();
                this.waypoints_.set(index, value);
                this.onChanged();
            } else {
                this.waypointsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setWaypoints(int index, TripWaypoint.Builder builderForValue) {
            if (this.waypointsBuilder_ == null) {
                this.ensureWaypointsIsMutable();
                this.waypoints_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.waypointsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addWaypoints(TripWaypoint value) {
            if (this.waypointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureWaypointsIsMutable();
                this.waypoints_.add(value);
                this.onChanged();
            } else {
                this.waypointsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addWaypoints(int index, TripWaypoint value) {
            if (this.waypointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureWaypointsIsMutable();
                this.waypoints_.add(index, value);
                this.onChanged();
            } else {
                this.waypointsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addWaypoints(TripWaypoint.Builder builderForValue) {
            if (this.waypointsBuilder_ == null) {
                this.ensureWaypointsIsMutable();
                this.waypoints_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.waypointsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addWaypoints(int index, TripWaypoint.Builder builderForValue) {
            if (this.waypointsBuilder_ == null) {
                this.ensureWaypointsIsMutable();
                this.waypoints_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.waypointsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllWaypoints(Iterable<? extends TripWaypoint> values) {
            if (this.waypointsBuilder_ == null) {
                this.ensureWaypointsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.waypoints_);
                this.onChanged();
            } else {
                this.waypointsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearWaypoints() {
            if (this.waypointsBuilder_ == null) {
                this.waypoints_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFDFFFF;
                this.onChanged();
            } else {
                this.waypointsBuilder_.clear();
            }
            return this;
        }

        public Builder removeWaypoints(int index) {
            if (this.waypointsBuilder_ == null) {
                this.ensureWaypointsIsMutable();
                this.waypoints_.remove(index);
                this.onChanged();
            } else {
                this.waypointsBuilder_.remove(index);
            }
            return this;
        }

        public TripWaypoint.Builder getWaypointsBuilder(int index) {
            return (TripWaypoint.Builder)this.getWaypointsFieldBuilder().getBuilder(index);
        }

        @Override
        public TripWaypointOrBuilder getWaypointsOrBuilder(int index) {
            if (this.waypointsBuilder_ == null) {
                return this.waypoints_.get(index);
            }
            return (TripWaypointOrBuilder)this.waypointsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends TripWaypointOrBuilder> getWaypointsOrBuilderList() {
            if (this.waypointsBuilder_ != null) {
                return this.waypointsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.waypoints_);
        }

        public TripWaypoint.Builder addWaypointsBuilder() {
            return (TripWaypoint.Builder)this.getWaypointsFieldBuilder().addBuilder((AbstractMessage)TripWaypoint.getDefaultInstance());
        }

        public TripWaypoint.Builder addWaypointsBuilder(int index) {
            return (TripWaypoint.Builder)this.getWaypointsFieldBuilder().addBuilder(index, (AbstractMessage)TripWaypoint.getDefaultInstance());
        }

        public List<TripWaypoint.Builder> getWaypointsBuilderList() {
            return this.getWaypointsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<TripWaypoint, TripWaypoint.Builder, TripWaypointOrBuilder> getWaypointsFieldBuilder() {
            if (this.waypointsBuilder_ == null) {
                this.waypointsBuilder_ = new RepeatedFieldBuilderV3(this.waypoints_, (this.bitField0_ & 0x20000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.waypoints_ = null;
            }
            return this.waypointsBuilder_;
        }

        @Override
        public boolean hasWaypointsVersion() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public Timestamp getWaypointsVersion() {
            if (this.waypointsVersionBuilder_ == null) {
                return this.waypointsVersion_ == null ? Timestamp.getDefaultInstance() : this.waypointsVersion_;
            }
            return (Timestamp)this.waypointsVersionBuilder_.getMessage();
        }

        public Builder setWaypointsVersion(Timestamp value) {
            if (this.waypointsVersionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.waypointsVersion_ = value;
            } else {
                this.waypointsVersionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder setWaypointsVersion(Timestamp.Builder builderForValue) {
            if (this.waypointsVersionBuilder_ == null) {
                this.waypointsVersion_ = builderForValue.build();
            } else {
                this.waypointsVersionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder mergeWaypointsVersion(Timestamp value) {
            if (this.waypointsVersionBuilder_ == null) {
                if ((this.bitField0_ & 0x40000) != 0 && this.waypointsVersion_ != null && this.waypointsVersion_ != Timestamp.getDefaultInstance()) {
                    this.getWaypointsVersionBuilder().mergeFrom(value);
                } else {
                    this.waypointsVersion_ = value;
                }
            } else {
                this.waypointsVersionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.waypointsVersion_ != null) {
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearWaypointsVersion() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.waypointsVersion_ = null;
            if (this.waypointsVersionBuilder_ != null) {
                this.waypointsVersionBuilder_.dispose();
                this.waypointsVersionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getWaypointsVersionBuilder() {
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return (Timestamp.Builder)this.getWaypointsVersionFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getWaypointsVersionOrBuilder() {
            if (this.waypointsVersionBuilder_ != null) {
                return (TimestampOrBuilder)this.waypointsVersionBuilder_.getMessageOrBuilder();
            }
            return this.waypointsVersion_ == null ? Timestamp.getDefaultInstance() : this.waypointsVersion_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getWaypointsVersionFieldBuilder() {
            if (this.waypointsVersionBuilder_ == null) {
                this.waypointsVersionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getWaypointsVersion(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.waypointsVersion_ = null;
            }
            return this.waypointsVersionBuilder_;
        }

        @Override
        public boolean getBackToBackEnabled() {
            return this.backToBackEnabled_;
        }

        public Builder setBackToBackEnabled(boolean value) {
            this.backToBackEnabled_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder clearBackToBackEnabled() {
            this.bitField0_ &= 0xFFF7FFFF;
            this.backToBackEnabled_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getNavigationStatusValue() {
            return this.navigationStatus_;
        }

        public Builder setNavigationStatusValue(int value) {
            this.navigationStatus_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        @Override
        public NavigationStatus getNavigationStatus() {
            NavigationStatus result = NavigationStatus.forNumber(this.navigationStatus_);
            return result == null ? NavigationStatus.UNRECOGNIZED : result;
        }

        public Builder setNavigationStatus(NavigationStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100000;
            this.navigationStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearNavigationStatus() {
            this.bitField0_ &= 0xFFEFFFFF;
            this.navigationStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDeviceSettings() {
            return (this.bitField0_ & 0x200000) != 0;
        }

        @Override
        public DeviceSettings getDeviceSettings() {
            if (this.deviceSettingsBuilder_ == null) {
                return this.deviceSettings_ == null ? DeviceSettings.getDefaultInstance() : this.deviceSettings_;
            }
            return (DeviceSettings)this.deviceSettingsBuilder_.getMessage();
        }

        public Builder setDeviceSettings(DeviceSettings value) {
            if (this.deviceSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.deviceSettings_ = value;
            } else {
                this.deviceSettingsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder setDeviceSettings(DeviceSettings.Builder builderForValue) {
            if (this.deviceSettingsBuilder_ == null) {
                this.deviceSettings_ = builderForValue.build();
            } else {
                this.deviceSettingsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder mergeDeviceSettings(DeviceSettings value) {
            if (this.deviceSettingsBuilder_ == null) {
                if ((this.bitField0_ & 0x200000) != 0 && this.deviceSettings_ != null && this.deviceSettings_ != DeviceSettings.getDefaultInstance()) {
                    this.getDeviceSettingsBuilder().mergeFrom(value);
                } else {
                    this.deviceSettings_ = value;
                }
            } else {
                this.deviceSettingsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.deviceSettings_ != null) {
                this.bitField0_ |= 0x200000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDeviceSettings() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.deviceSettings_ = null;
            if (this.deviceSettingsBuilder_ != null) {
                this.deviceSettingsBuilder_.dispose();
                this.deviceSettingsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DeviceSettings.Builder getDeviceSettingsBuilder() {
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return (DeviceSettings.Builder)this.getDeviceSettingsFieldBuilder().getBuilder();
        }

        @Override
        public DeviceSettingsOrBuilder getDeviceSettingsOrBuilder() {
            if (this.deviceSettingsBuilder_ != null) {
                return (DeviceSettingsOrBuilder)this.deviceSettingsBuilder_.getMessageOrBuilder();
            }
            return this.deviceSettings_ == null ? DeviceSettings.getDefaultInstance() : this.deviceSettings_;
        }

        private SingleFieldBuilderV3<DeviceSettings, DeviceSettings.Builder, DeviceSettingsOrBuilder> getDeviceSettingsFieldBuilder() {
            if (this.deviceSettingsBuilder_ == null) {
                this.deviceSettingsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDeviceSettings(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.deviceSettings_ = null;
            }
            return this.deviceSettingsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class VehicleType
    extends GeneratedMessageV3
    implements VehicleTypeOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CATEGORY_FIELD_NUMBER = 1;
        private int category_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final VehicleType DEFAULT_INSTANCE = new VehicleType();
        private static final Parser<VehicleType> PARSER = new AbstractParser<VehicleType>(){

            public VehicleType parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = VehicleType.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private VehicleType(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private VehicleType() {
            this.category_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new VehicleType();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_VehicleType_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_VehicleType_fieldAccessorTable.ensureFieldAccessorsInitialized(VehicleType.class, Builder.class);
        }

        @Override
        public int getCategoryValue() {
            return this.category_;
        }

        @Override
        public Category getCategory() {
            Category result = Category.forNumber(this.category_);
            return result == null ? Category.UNRECOGNIZED : result;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.category_ != Category.UNKNOWN.getNumber()) {
                output.writeEnum(1, this.category_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.category_ != Category.UNKNOWN.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.category_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VehicleType)) {
                return super.equals(obj);
            }
            VehicleType other = (VehicleType)obj;
            if (this.category_ != other.category_) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + VehicleType.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.category_;
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static VehicleType parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (VehicleType)PARSER.parseFrom(data);
        }

        public static VehicleType parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (VehicleType)PARSER.parseFrom(data, extensionRegistry);
        }

        public static VehicleType parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (VehicleType)PARSER.parseFrom(data);
        }

        public static VehicleType parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (VehicleType)PARSER.parseFrom(data, extensionRegistry);
        }

        public static VehicleType parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (VehicleType)PARSER.parseFrom(data);
        }

        public static VehicleType parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (VehicleType)PARSER.parseFrom(data, extensionRegistry);
        }

        public static VehicleType parseFrom(InputStream input) throws IOException {
            return (VehicleType)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static VehicleType parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (VehicleType)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static VehicleType parseDelimitedFrom(InputStream input) throws IOException {
            return (VehicleType)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static VehicleType parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (VehicleType)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static VehicleType parseFrom(CodedInputStream input) throws IOException {
            return (VehicleType)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static VehicleType parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (VehicleType)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return VehicleType.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(VehicleType prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static VehicleType getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<VehicleType> parser() {
            return PARSER;
        }

        public Parser<VehicleType> getParserForType() {
            return PARSER;
        }

        public VehicleType getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements VehicleTypeOrBuilder {
            private int bitField0_;
            private int category_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_VehicleType_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_VehicleType_fieldAccessorTable.ensureFieldAccessorsInitialized(VehicleType.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.category_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return Vehicles.internal_static_maps_fleetengine_v1_Vehicle_VehicleType_descriptor;
            }

            public VehicleType getDefaultInstanceForType() {
                return VehicleType.getDefaultInstance();
            }

            public VehicleType build() {
                VehicleType result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public VehicleType buildPartial() {
                VehicleType result = new VehicleType(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(VehicleType result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.category_ = this.category_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof VehicleType) {
                    return this.mergeFrom((VehicleType)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(VehicleType other) {
                if (other == VehicleType.getDefaultInstance()) {
                    return this;
                }
                if (other.category_ != 0) {
                    this.setCategoryValue(other.getCategoryValue());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 8: {
                                this.category_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getCategoryValue() {
                return this.category_;
            }

            public Builder setCategoryValue(int value) {
                this.category_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public Category getCategory() {
                Category result = Category.forNumber(this.category_);
                return result == null ? Category.UNRECOGNIZED : result;
            }

            public Builder setCategory(Category value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.category_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearCategory() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.category_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum Category implements ProtocolMessageEnum
        {
            UNKNOWN(0),
            AUTO(1),
            TAXI(2),
            TRUCK(3),
            TWO_WHEELER(4),
            BICYCLE(5),
            PEDESTRIAN(6),
            UNRECOGNIZED(-1);

            public static final int UNKNOWN_VALUE = 0;
            public static final int AUTO_VALUE = 1;
            public static final int TAXI_VALUE = 2;
            public static final int TRUCK_VALUE = 3;
            public static final int TWO_WHEELER_VALUE = 4;
            public static final int BICYCLE_VALUE = 5;
            public static final int PEDESTRIAN_VALUE = 6;
            private static final Internal.EnumLiteMap<Category> internalValueMap;
            private static final Category[] VALUES;
            private final int value;

            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static Category valueOf(int value) {
                return Category.forNumber(value);
            }

            public static Category forNumber(int value) {
                switch (value) {
                    case 0: {
                        return UNKNOWN;
                    }
                    case 1: {
                        return AUTO;
                    }
                    case 2: {
                        return TAXI;
                    }
                    case 3: {
                        return TRUCK;
                    }
                    case 4: {
                        return TWO_WHEELER;
                    }
                    case 5: {
                        return BICYCLE;
                    }
                    case 6: {
                        return PEDESTRIAN;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<Category> internalGetValueMap() {
                return internalValueMap;
            }

            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return (Descriptors.EnumValueDescriptor)Category.getDescriptor().getValues().get(this.ordinal());
            }

            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return Category.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return (Descriptors.EnumDescriptor)VehicleType.getDescriptor().getEnumTypes().get(0);
            }

            public static Category valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != Category.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private Category(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<Category>(){

                    public Category findValueByNumber(int number) {
                        return Category.forNumber(number);
                    }
                };
                VALUES = Category.values();
            }
        }
    }

    public static interface VehicleTypeOrBuilder
    extends MessageOrBuilder {
        public int getCategoryValue();

        public VehicleType.Category getCategory();
    }
}

