/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TripName
implements ResourceName {
    private static final PathTemplate PROVIDER_TRIP = PathTemplate.createWithoutUrlEncoding((String)"providers/{provider}/trips/{trip}");
    private volatile Map<String, String> fieldValuesMap;
    private final String provider;
    private final String trip;

    @Deprecated
    protected TripName() {
        this.provider = null;
        this.trip = null;
    }

    private TripName(Builder builder) {
        this.provider = (String)Preconditions.checkNotNull((Object)builder.getProvider());
        this.trip = (String)Preconditions.checkNotNull((Object)builder.getTrip());
    }

    public String getProvider() {
        return this.provider;
    }

    public String getTrip() {
        return this.trip;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TripName of(String provider, String trip) {
        return TripName.newBuilder().setProvider(provider).setTrip(trip).build();
    }

    public static String format(String provider, String trip) {
        return TripName.newBuilder().setProvider(provider).setTrip(trip).build().toString();
    }

    public static TripName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROVIDER_TRIP.validatedMatch(formattedString, "TripName.parse: formattedString not in valid format");
        return TripName.of((String)matchMap.get("provider"), (String)matchMap.get("trip"));
    }

    public static List<TripName> parseList(List<String> formattedStrings) {
        ArrayList<TripName> list = new ArrayList<TripName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TripName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TripName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TripName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROVIDER_TRIP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TripName tripName = this;
            synchronized (tripName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.provider != null) {
                        fieldMapBuilder.put((Object)"provider", (Object)this.provider);
                    }
                    if (this.trip != null) {
                        fieldMapBuilder.put((Object)"trip", (Object)this.trip);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROVIDER_TRIP.instantiate(new String[]{"provider", this.provider, "trip", this.trip});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TripName that = (TripName)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.trip, that.trip);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.provider);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trip);
    }

    public static class Builder {
        private String provider;
        private String trip;

        protected Builder() {
        }

        public String getProvider() {
            return this.provider;
        }

        public String getTrip() {
            return this.trip;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder setTrip(String trip) {
            this.trip = trip;
            return this;
        }

        private Builder(TripName tripName) {
            this.provider = tripName.provider;
            this.trip = tripName.trip;
        }

        public TripName build() {
            return new TripName(this);
        }
    }
}

