/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.maps.fleetengine.v1.RequestHeader;
import com.google.maps.fleetengine.v1.RequestHeaderOrBuilder;
import com.google.maps.fleetengine.v1.SearchVehiclesRequestOrBuilder;
import com.google.maps.fleetengine.v1.TerminalLocation;
import com.google.maps.fleetengine.v1.TerminalLocationOrBuilder;
import com.google.maps.fleetengine.v1.TripType;
import com.google.maps.fleetengine.v1.Vehicle;
import com.google.maps.fleetengine.v1.VehicleApi;
import com.google.maps.fleetengine.v1.VehicleAttribute;
import com.google.maps.fleetengine.v1.VehicleAttributeList;
import com.google.maps.fleetengine.v1.VehicleAttributeListOrBuilder;
import com.google.maps.fleetengine.v1.VehicleAttributeOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SearchVehiclesRequest
extends GeneratedMessageV3
implements SearchVehiclesRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int HEADER_FIELD_NUMBER = 1;
    private RequestHeader header_;
    public static final int PARENT_FIELD_NUMBER = 3;
    private volatile Object parent_ = "";
    public static final int PICKUP_POINT_FIELD_NUMBER = 4;
    private TerminalLocation pickupPoint_;
    public static final int DROPOFF_POINT_FIELD_NUMBER = 5;
    private TerminalLocation dropoffPoint_;
    public static final int PICKUP_RADIUS_METERS_FIELD_NUMBER = 6;
    private int pickupRadiusMeters_ = 0;
    public static final int COUNT_FIELD_NUMBER = 7;
    private int count_ = 0;
    public static final int MINIMUM_CAPACITY_FIELD_NUMBER = 8;
    private int minimumCapacity_ = 0;
    public static final int TRIP_TYPES_FIELD_NUMBER = 9;
    private List<Integer> tripTypes_;
    private static final Internal.ListAdapter.Converter<Integer, TripType> tripTypes_converter_ = new Internal.ListAdapter.Converter<Integer, TripType>(){

        public TripType convert(Integer from) {
            TripType result = TripType.forNumber(from);
            return result == null ? TripType.UNRECOGNIZED : result;
        }
    };
    private int tripTypesMemoizedSerializedSize;
    public static final int MAXIMUM_STALENESS_FIELD_NUMBER = 10;
    private Duration maximumStaleness_;
    public static final int VEHICLE_TYPES_FIELD_NUMBER = 14;
    private List<Vehicle.VehicleType> vehicleTypes_;
    public static final int REQUIRED_ATTRIBUTES_FIELD_NUMBER = 12;
    private List<VehicleAttribute> requiredAttributes_;
    public static final int REQUIRED_ONE_OF_ATTRIBUTES_FIELD_NUMBER = 15;
    private List<VehicleAttributeList> requiredOneOfAttributes_;
    public static final int REQUIRED_ONE_OF_ATTRIBUTE_SETS_FIELD_NUMBER = 20;
    private List<VehicleAttributeList> requiredOneOfAttributeSets_;
    public static final int ORDER_BY_FIELD_NUMBER = 13;
    private int orderBy_ = 0;
    public static final int INCLUDE_BACK_TO_BACK_FIELD_NUMBER = 18;
    private boolean includeBackToBack_ = false;
    public static final int TRIP_ID_FIELD_NUMBER = 19;
    private volatile Object tripId_ = "";
    public static final int CURRENT_TRIPS_PRESENT_FIELD_NUMBER = 21;
    private int currentTripsPresent_ = 0;
    public static final int FILTER_FIELD_NUMBER = 22;
    private volatile Object filter_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final SearchVehiclesRequest DEFAULT_INSTANCE = new SearchVehiclesRequest();
    private static final Parser<SearchVehiclesRequest> PARSER = new AbstractParser<SearchVehiclesRequest>(){

        public SearchVehiclesRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = SearchVehiclesRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private SearchVehiclesRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SearchVehiclesRequest() {
        this.parent_ = "";
        this.tripTypes_ = Collections.emptyList();
        this.vehicleTypes_ = Collections.emptyList();
        this.requiredAttributes_ = Collections.emptyList();
        this.requiredOneOfAttributes_ = Collections.emptyList();
        this.requiredOneOfAttributeSets_ = Collections.emptyList();
        this.orderBy_ = 0;
        this.tripId_ = "";
        this.currentTripsPresent_ = 0;
        this.filter_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SearchVehiclesRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return VehicleApi.internal_static_maps_fleetengine_v1_SearchVehiclesRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return VehicleApi.internal_static_maps_fleetengine_v1_SearchVehiclesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchVehiclesRequest.class, Builder.class);
    }

    @Override
    public boolean hasHeader() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public RequestHeader getHeader() {
        return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
    }

    @Override
    public RequestHeaderOrBuilder getHeaderOrBuilder() {
        return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
    }

    @Override
    public String getParent() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.parent_ = s;
        return s;
    }

    @Override
    public ByteString getParentBytes() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.parent_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasPickupPoint() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public TerminalLocation getPickupPoint() {
        return this.pickupPoint_ == null ? TerminalLocation.getDefaultInstance() : this.pickupPoint_;
    }

    @Override
    public TerminalLocationOrBuilder getPickupPointOrBuilder() {
        return this.pickupPoint_ == null ? TerminalLocation.getDefaultInstance() : this.pickupPoint_;
    }

    @Override
    public boolean hasDropoffPoint() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public TerminalLocation getDropoffPoint() {
        return this.dropoffPoint_ == null ? TerminalLocation.getDefaultInstance() : this.dropoffPoint_;
    }

    @Override
    public TerminalLocationOrBuilder getDropoffPointOrBuilder() {
        return this.dropoffPoint_ == null ? TerminalLocation.getDefaultInstance() : this.dropoffPoint_;
    }

    @Override
    public int getPickupRadiusMeters() {
        return this.pickupRadiusMeters_;
    }

    @Override
    public int getCount() {
        return this.count_;
    }

    @Override
    public int getMinimumCapacity() {
        return this.minimumCapacity_;
    }

    @Override
    public List<TripType> getTripTypesList() {
        return new Internal.ListAdapter(this.tripTypes_, tripTypes_converter_);
    }

    @Override
    public int getTripTypesCount() {
        return this.tripTypes_.size();
    }

    @Override
    public TripType getTripTypes(int index) {
        return (TripType)((Object)tripTypes_converter_.convert((Object)this.tripTypes_.get(index)));
    }

    @Override
    public List<Integer> getTripTypesValueList() {
        return this.tripTypes_;
    }

    @Override
    public int getTripTypesValue(int index) {
        return this.tripTypes_.get(index);
    }

    @Override
    public boolean hasMaximumStaleness() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Duration getMaximumStaleness() {
        return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
    }

    @Override
    public DurationOrBuilder getMaximumStalenessOrBuilder() {
        return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
    }

    @Override
    public List<Vehicle.VehicleType> getVehicleTypesList() {
        return this.vehicleTypes_;
    }

    @Override
    public List<? extends Vehicle.VehicleTypeOrBuilder> getVehicleTypesOrBuilderList() {
        return this.vehicleTypes_;
    }

    @Override
    public int getVehicleTypesCount() {
        return this.vehicleTypes_.size();
    }

    @Override
    public Vehicle.VehicleType getVehicleTypes(int index) {
        return this.vehicleTypes_.get(index);
    }

    @Override
    public Vehicle.VehicleTypeOrBuilder getVehicleTypesOrBuilder(int index) {
        return this.vehicleTypes_.get(index);
    }

    @Override
    public List<VehicleAttribute> getRequiredAttributesList() {
        return this.requiredAttributes_;
    }

    @Override
    public List<? extends VehicleAttributeOrBuilder> getRequiredAttributesOrBuilderList() {
        return this.requiredAttributes_;
    }

    @Override
    public int getRequiredAttributesCount() {
        return this.requiredAttributes_.size();
    }

    @Override
    public VehicleAttribute getRequiredAttributes(int index) {
        return this.requiredAttributes_.get(index);
    }

    @Override
    public VehicleAttributeOrBuilder getRequiredAttributesOrBuilder(int index) {
        return this.requiredAttributes_.get(index);
    }

    @Override
    public List<VehicleAttributeList> getRequiredOneOfAttributesList() {
        return this.requiredOneOfAttributes_;
    }

    @Override
    public List<? extends VehicleAttributeListOrBuilder> getRequiredOneOfAttributesOrBuilderList() {
        return this.requiredOneOfAttributes_;
    }

    @Override
    public int getRequiredOneOfAttributesCount() {
        return this.requiredOneOfAttributes_.size();
    }

    @Override
    public VehicleAttributeList getRequiredOneOfAttributes(int index) {
        return this.requiredOneOfAttributes_.get(index);
    }

    @Override
    public VehicleAttributeListOrBuilder getRequiredOneOfAttributesOrBuilder(int index) {
        return this.requiredOneOfAttributes_.get(index);
    }

    @Override
    public List<VehicleAttributeList> getRequiredOneOfAttributeSetsList() {
        return this.requiredOneOfAttributeSets_;
    }

    @Override
    public List<? extends VehicleAttributeListOrBuilder> getRequiredOneOfAttributeSetsOrBuilderList() {
        return this.requiredOneOfAttributeSets_;
    }

    @Override
    public int getRequiredOneOfAttributeSetsCount() {
        return this.requiredOneOfAttributeSets_.size();
    }

    @Override
    public VehicleAttributeList getRequiredOneOfAttributeSets(int index) {
        return this.requiredOneOfAttributeSets_.get(index);
    }

    @Override
    public VehicleAttributeListOrBuilder getRequiredOneOfAttributeSetsOrBuilder(int index) {
        return this.requiredOneOfAttributeSets_.get(index);
    }

    @Override
    public int getOrderByValue() {
        return this.orderBy_;
    }

    @Override
    public VehicleMatchOrder getOrderBy() {
        VehicleMatchOrder result = VehicleMatchOrder.forNumber(this.orderBy_);
        return result == null ? VehicleMatchOrder.UNRECOGNIZED : result;
    }

    @Override
    public boolean getIncludeBackToBack() {
        return this.includeBackToBack_;
    }

    @Override
    public String getTripId() {
        Object ref = this.tripId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.tripId_ = s;
        return s;
    }

    @Override
    public ByteString getTripIdBytes() {
        Object ref = this.tripId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.tripId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getCurrentTripsPresentValue() {
        return this.currentTripsPresent_;
    }

    @Override
    public CurrentTripsPresent getCurrentTripsPresent() {
        CurrentTripsPresent result = CurrentTripsPresent.forNumber(this.currentTripsPresent_);
        return result == null ? CurrentTripsPresent.UNRECOGNIZED : result;
    }

    @Override
    public String getFilter() {
        Object ref = this.filter_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.filter_ = s;
        return s;
    }

    @Override
    public ByteString getFilterBytes() {
        Object ref = this.filter_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.filter_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getHeader());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.parent_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(4, (MessageLite)this.getPickupPoint());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(5, (MessageLite)this.getDropoffPoint());
        }
        if (this.pickupRadiusMeters_ != 0) {
            output.writeInt32(6, this.pickupRadiusMeters_);
        }
        if (this.count_ != 0) {
            output.writeInt32(7, this.count_);
        }
        if (this.minimumCapacity_ != 0) {
            output.writeInt32(8, this.minimumCapacity_);
        }
        if (this.getTripTypesList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.tripTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.tripTypes_.size(); ++i) {
            output.writeEnumNoTag(this.tripTypes_.get(i).intValue());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(10, (MessageLite)this.getMaximumStaleness());
        }
        for (i = 0; i < this.requiredAttributes_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.requiredAttributes_.get(i));
        }
        if (this.orderBy_ != VehicleMatchOrder.UNKNOWN_VEHICLE_MATCH_ORDER.getNumber()) {
            output.writeEnum(13, this.orderBy_);
        }
        for (i = 0; i < this.vehicleTypes_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.vehicleTypes_.get(i));
        }
        for (i = 0; i < this.requiredOneOfAttributes_.size(); ++i) {
            output.writeMessage(15, (MessageLite)this.requiredOneOfAttributes_.get(i));
        }
        if (this.includeBackToBack_) {
            output.writeBool(18, this.includeBackToBack_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tripId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.tripId_);
        }
        for (i = 0; i < this.requiredOneOfAttributeSets_.size(); ++i) {
            output.writeMessage(20, (MessageLite)this.requiredOneOfAttributeSets_.get(i));
        }
        if (this.currentTripsPresent_ != CurrentTripsPresent.CURRENT_TRIPS_PRESENT_UNSPECIFIED.getNumber()) {
            output.writeEnum(21, this.currentTripsPresent_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.filter_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)22, (Object)this.filter_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getHeader());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.parent_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getPickupPoint());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getDropoffPoint());
        }
        if (this.pickupRadiusMeters_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)6, (int)this.pickupRadiusMeters_);
        }
        if (this.count_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)7, (int)this.count_);
        }
        if (this.minimumCapacity_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)8, (int)this.minimumCapacity_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.tripTypes_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.tripTypes_.get(i2));
        }
        size += dataSize;
        if (!this.getTripTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.tripTypesMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getMaximumStaleness());
        }
        for (i = 0; i < this.requiredAttributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.requiredAttributes_.get(i)));
        }
        if (this.orderBy_ != VehicleMatchOrder.UNKNOWN_VEHICLE_MATCH_ORDER.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)13, (int)this.orderBy_);
        }
        for (i = 0; i < this.vehicleTypes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.vehicleTypes_.get(i)));
        }
        for (i = 0; i < this.requiredOneOfAttributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)((MessageLite)this.requiredOneOfAttributes_.get(i)));
        }
        if (this.includeBackToBack_) {
            size += CodedOutputStream.computeBoolSize((int)18, (boolean)this.includeBackToBack_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tripId_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.tripId_);
        }
        for (i = 0; i < this.requiredOneOfAttributeSets_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)20, (MessageLite)((MessageLite)this.requiredOneOfAttributeSets_.get(i)));
        }
        if (this.currentTripsPresent_ != CurrentTripsPresent.CURRENT_TRIPS_PRESENT_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)21, (int)this.currentTripsPresent_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.filter_)) {
            size += GeneratedMessageV3.computeStringSize((int)22, (Object)this.filter_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchVehiclesRequest)) {
            return super.equals(obj);
        }
        SearchVehiclesRequest other = (SearchVehiclesRequest)obj;
        if (this.hasHeader() != other.hasHeader()) {
            return false;
        }
        if (this.hasHeader() && !this.getHeader().equals(other.getHeader())) {
            return false;
        }
        if (!this.getParent().equals(other.getParent())) {
            return false;
        }
        if (this.hasPickupPoint() != other.hasPickupPoint()) {
            return false;
        }
        if (this.hasPickupPoint() && !this.getPickupPoint().equals(other.getPickupPoint())) {
            return false;
        }
        if (this.hasDropoffPoint() != other.hasDropoffPoint()) {
            return false;
        }
        if (this.hasDropoffPoint() && !this.getDropoffPoint().equals(other.getDropoffPoint())) {
            return false;
        }
        if (this.getPickupRadiusMeters() != other.getPickupRadiusMeters()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getMinimumCapacity() != other.getMinimumCapacity()) {
            return false;
        }
        if (!this.tripTypes_.equals(other.tripTypes_)) {
            return false;
        }
        if (this.hasMaximumStaleness() != other.hasMaximumStaleness()) {
            return false;
        }
        if (this.hasMaximumStaleness() && !this.getMaximumStaleness().equals((Object)other.getMaximumStaleness())) {
            return false;
        }
        if (!this.getVehicleTypesList().equals(other.getVehicleTypesList())) {
            return false;
        }
        if (!this.getRequiredAttributesList().equals(other.getRequiredAttributesList())) {
            return false;
        }
        if (!this.getRequiredOneOfAttributesList().equals(other.getRequiredOneOfAttributesList())) {
            return false;
        }
        if (!this.getRequiredOneOfAttributeSetsList().equals(other.getRequiredOneOfAttributeSetsList())) {
            return false;
        }
        if (this.orderBy_ != other.orderBy_) {
            return false;
        }
        if (this.getIncludeBackToBack() != other.getIncludeBackToBack()) {
            return false;
        }
        if (!this.getTripId().equals(other.getTripId())) {
            return false;
        }
        if (this.currentTripsPresent_ != other.currentTripsPresent_) {
            return false;
        }
        if (!this.getFilter().equals(other.getFilter())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SearchVehiclesRequest.getDescriptor().hashCode();
        if (this.hasHeader()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getHeader().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getParent().hashCode();
        if (this.hasPickupPoint()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getPickupPoint().hashCode();
        }
        if (this.hasDropoffPoint()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDropoffPoint().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getPickupRadiusMeters();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getCount();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getMinimumCapacity();
        if (this.getTripTypesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.tripTypes_.hashCode();
        }
        if (this.hasMaximumStaleness()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getMaximumStaleness().hashCode();
        }
        if (this.getVehicleTypesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getVehicleTypesList().hashCode();
        }
        if (this.getRequiredAttributesCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getRequiredAttributesList().hashCode();
        }
        if (this.getRequiredOneOfAttributesCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getRequiredOneOfAttributesList().hashCode();
        }
        if (this.getRequiredOneOfAttributeSetsCount() > 0) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.getRequiredOneOfAttributeSetsList().hashCode();
        }
        hash = 37 * hash + 13;
        hash = 53 * hash + this.orderBy_;
        hash = 37 * hash + 18;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIncludeBackToBack());
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getTripId().hashCode();
        hash = 37 * hash + 21;
        hash = 53 * hash + this.currentTripsPresent_;
        hash = 37 * hash + 22;
        hash = 53 * hash + this.getFilter().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static SearchVehiclesRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (SearchVehiclesRequest)PARSER.parseFrom(data);
    }

    public static SearchVehiclesRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchVehiclesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchVehiclesRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (SearchVehiclesRequest)PARSER.parseFrom(data);
    }

    public static SearchVehiclesRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchVehiclesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchVehiclesRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (SearchVehiclesRequest)PARSER.parseFrom(data);
    }

    public static SearchVehiclesRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchVehiclesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchVehiclesRequest parseFrom(InputStream input) throws IOException {
        return (SearchVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static SearchVehiclesRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchVehiclesRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (SearchVehiclesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static SearchVehiclesRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchVehiclesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchVehiclesRequest parseFrom(CodedInputStream input) throws IOException {
        return (SearchVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static SearchVehiclesRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return SearchVehiclesRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SearchVehiclesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SearchVehiclesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SearchVehiclesRequest> parser() {
        return PARSER;
    }

    public Parser<SearchVehiclesRequest> getParserForType() {
        return PARSER;
    }

    public SearchVehiclesRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SearchVehiclesRequestOrBuilder {
        private int bitField0_;
        private RequestHeader header_;
        private SingleFieldBuilderV3<RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder> headerBuilder_;
        private Object parent_ = "";
        private TerminalLocation pickupPoint_;
        private SingleFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> pickupPointBuilder_;
        private TerminalLocation dropoffPoint_;
        private SingleFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> dropoffPointBuilder_;
        private int pickupRadiusMeters_;
        private int count_;
        private int minimumCapacity_;
        private List<Integer> tripTypes_ = Collections.emptyList();
        private Duration maximumStaleness_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> maximumStalenessBuilder_;
        private List<Vehicle.VehicleType> vehicleTypes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Vehicle.VehicleType, Vehicle.VehicleType.Builder, Vehicle.VehicleTypeOrBuilder> vehicleTypesBuilder_;
        private List<VehicleAttribute> requiredAttributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VehicleAttribute, VehicleAttribute.Builder, VehicleAttributeOrBuilder> requiredAttributesBuilder_;
        private List<VehicleAttributeList> requiredOneOfAttributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VehicleAttributeList, VehicleAttributeList.Builder, VehicleAttributeListOrBuilder> requiredOneOfAttributesBuilder_;
        private List<VehicleAttributeList> requiredOneOfAttributeSets_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VehicleAttributeList, VehicleAttributeList.Builder, VehicleAttributeListOrBuilder> requiredOneOfAttributeSetsBuilder_;
        private int orderBy_ = 0;
        private boolean includeBackToBack_;
        private Object tripId_ = "";
        private int currentTripsPresent_ = 0;
        private Object filter_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return VehicleApi.internal_static_maps_fleetengine_v1_SearchVehiclesRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return VehicleApi.internal_static_maps_fleetengine_v1_SearchVehiclesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchVehiclesRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getHeaderFieldBuilder();
                this.getPickupPointFieldBuilder();
                this.getDropoffPointFieldBuilder();
                this.getMaximumStalenessFieldBuilder();
                this.getVehicleTypesFieldBuilder();
                this.getRequiredAttributesFieldBuilder();
                this.getRequiredOneOfAttributesFieldBuilder();
                this.getRequiredOneOfAttributeSetsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.header_ = null;
            if (this.headerBuilder_ != null) {
                this.headerBuilder_.dispose();
                this.headerBuilder_ = null;
            }
            this.parent_ = "";
            this.pickupPoint_ = null;
            if (this.pickupPointBuilder_ != null) {
                this.pickupPointBuilder_.dispose();
                this.pickupPointBuilder_ = null;
            }
            this.dropoffPoint_ = null;
            if (this.dropoffPointBuilder_ != null) {
                this.dropoffPointBuilder_.dispose();
                this.dropoffPointBuilder_ = null;
            }
            this.pickupRadiusMeters_ = 0;
            this.count_ = 0;
            this.minimumCapacity_ = 0;
            this.tripTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.maximumStaleness_ = null;
            if (this.maximumStalenessBuilder_ != null) {
                this.maximumStalenessBuilder_.dispose();
                this.maximumStalenessBuilder_ = null;
            }
            if (this.vehicleTypesBuilder_ == null) {
                this.vehicleTypes_ = Collections.emptyList();
            } else {
                this.vehicleTypes_ = null;
                this.vehicleTypesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            if (this.requiredAttributesBuilder_ == null) {
                this.requiredAttributes_ = Collections.emptyList();
            } else {
                this.requiredAttributes_ = null;
                this.requiredAttributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.requiredOneOfAttributes_ = Collections.emptyList();
            } else {
                this.requiredOneOfAttributes_ = null;
                this.requiredOneOfAttributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.requiredOneOfAttributeSets_ = Collections.emptyList();
            } else {
                this.requiredOneOfAttributeSets_ = null;
                this.requiredOneOfAttributeSetsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFEFFF;
            this.orderBy_ = 0;
            this.includeBackToBack_ = false;
            this.tripId_ = "";
            this.currentTripsPresent_ = 0;
            this.filter_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return VehicleApi.internal_static_maps_fleetengine_v1_SearchVehiclesRequest_descriptor;
        }

        public SearchVehiclesRequest getDefaultInstanceForType() {
            return SearchVehiclesRequest.getDefaultInstance();
        }

        public SearchVehiclesRequest build() {
            SearchVehiclesRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public SearchVehiclesRequest buildPartial() {
            SearchVehiclesRequest result = new SearchVehiclesRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(SearchVehiclesRequest result) {
            if ((this.bitField0_ & 0x80) != 0) {
                this.tripTypes_ = Collections.unmodifiableList(this.tripTypes_);
                this.bitField0_ &= 0xFFFFFF7F;
            }
            result.tripTypes_ = this.tripTypes_;
            if (this.vehicleTypesBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.vehicleTypes_ = Collections.unmodifiableList(this.vehicleTypes_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.vehicleTypes_ = this.vehicleTypes_;
            } else {
                result.vehicleTypes_ = this.vehicleTypesBuilder_.build();
            }
            if (this.requiredAttributesBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.requiredAttributes_ = Collections.unmodifiableList(this.requiredAttributes_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.requiredAttributes_ = this.requiredAttributes_;
            } else {
                result.requiredAttributes_ = this.requiredAttributesBuilder_.build();
            }
            if (this.requiredOneOfAttributesBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.requiredOneOfAttributes_ = Collections.unmodifiableList(this.requiredOneOfAttributes_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                result.requiredOneOfAttributes_ = this.requiredOneOfAttributes_;
            } else {
                result.requiredOneOfAttributes_ = this.requiredOneOfAttributesBuilder_.build();
            }
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0) {
                    this.requiredOneOfAttributeSets_ = Collections.unmodifiableList(this.requiredOneOfAttributeSets_);
                    this.bitField0_ &= 0xFFFFEFFF;
                }
                result.requiredOneOfAttributeSets_ = this.requiredOneOfAttributeSets_;
            } else {
                result.requiredOneOfAttributeSets_ = this.requiredOneOfAttributeSetsBuilder_.build();
            }
        }

        private void buildPartial0(SearchVehiclesRequest result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.header_ = this.headerBuilder_ == null ? this.header_ : (RequestHeader)this.headerBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.parent_ = this.parent_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.pickupPoint_ = this.pickupPointBuilder_ == null ? this.pickupPoint_ : (TerminalLocation)this.pickupPointBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.dropoffPoint_ = this.dropoffPointBuilder_ == null ? this.dropoffPoint_ : (TerminalLocation)this.dropoffPointBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.pickupRadiusMeters_ = this.pickupRadiusMeters_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.count_ = this.count_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.minimumCapacity_ = this.minimumCapacity_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.maximumStaleness_ = this.maximumStalenessBuilder_ == null ? this.maximumStaleness_ : (Duration)this.maximumStalenessBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.orderBy_ = this.orderBy_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.includeBackToBack_ = this.includeBackToBack_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.tripId_ = this.tripId_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.currentTripsPresent_ = this.currentTripsPresent_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.filter_ = this.filter_;
            }
            SearchVehiclesRequest searchVehiclesRequest = result;
            searchVehiclesRequest.bitField0_ = searchVehiclesRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof SearchVehiclesRequest) {
                return this.mergeFrom((SearchVehiclesRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SearchVehiclesRequest other) {
            if (other == SearchVehiclesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.hasHeader()) {
                this.mergeHeader(other.getHeader());
            }
            if (!other.getParent().isEmpty()) {
                this.parent_ = other.parent_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasPickupPoint()) {
                this.mergePickupPoint(other.getPickupPoint());
            }
            if (other.hasDropoffPoint()) {
                this.mergeDropoffPoint(other.getDropoffPoint());
            }
            if (other.getPickupRadiusMeters() != 0) {
                this.setPickupRadiusMeters(other.getPickupRadiusMeters());
            }
            if (other.getCount() != 0) {
                this.setCount(other.getCount());
            }
            if (other.getMinimumCapacity() != 0) {
                this.setMinimumCapacity(other.getMinimumCapacity());
            }
            if (!other.tripTypes_.isEmpty()) {
                if (this.tripTypes_.isEmpty()) {
                    this.tripTypes_ = other.tripTypes_;
                    this.bitField0_ &= 0xFFFFFF7F;
                } else {
                    this.ensureTripTypesIsMutable();
                    this.tripTypes_.addAll(other.tripTypes_);
                }
                this.onChanged();
            }
            if (other.hasMaximumStaleness()) {
                this.mergeMaximumStaleness(other.getMaximumStaleness());
            }
            if (this.vehicleTypesBuilder_ == null) {
                if (!other.vehicleTypes_.isEmpty()) {
                    if (this.vehicleTypes_.isEmpty()) {
                        this.vehicleTypes_ = other.vehicleTypes_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureVehicleTypesIsMutable();
                        this.vehicleTypes_.addAll(other.vehicleTypes_);
                    }
                    this.onChanged();
                }
            } else if (!other.vehicleTypes_.isEmpty()) {
                if (this.vehicleTypesBuilder_.isEmpty()) {
                    this.vehicleTypesBuilder_.dispose();
                    this.vehicleTypesBuilder_ = null;
                    this.vehicleTypes_ = other.vehicleTypes_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.vehicleTypesBuilder_ = alwaysUseFieldBuilders ? this.getVehicleTypesFieldBuilder() : null;
                } else {
                    this.vehicleTypesBuilder_.addAllMessages((Iterable)other.vehicleTypes_);
                }
            }
            if (this.requiredAttributesBuilder_ == null) {
                if (!other.requiredAttributes_.isEmpty()) {
                    if (this.requiredAttributes_.isEmpty()) {
                        this.requiredAttributes_ = other.requiredAttributes_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureRequiredAttributesIsMutable();
                        this.requiredAttributes_.addAll(other.requiredAttributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.requiredAttributes_.isEmpty()) {
                if (this.requiredAttributesBuilder_.isEmpty()) {
                    this.requiredAttributesBuilder_.dispose();
                    this.requiredAttributesBuilder_ = null;
                    this.requiredAttributes_ = other.requiredAttributes_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.requiredAttributesBuilder_ = alwaysUseFieldBuilders ? this.getRequiredAttributesFieldBuilder() : null;
                } else {
                    this.requiredAttributesBuilder_.addAllMessages((Iterable)other.requiredAttributes_);
                }
            }
            if (this.requiredOneOfAttributesBuilder_ == null) {
                if (!other.requiredOneOfAttributes_.isEmpty()) {
                    if (this.requiredOneOfAttributes_.isEmpty()) {
                        this.requiredOneOfAttributes_ = other.requiredOneOfAttributes_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensureRequiredOneOfAttributesIsMutable();
                        this.requiredOneOfAttributes_.addAll(other.requiredOneOfAttributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.requiredOneOfAttributes_.isEmpty()) {
                if (this.requiredOneOfAttributesBuilder_.isEmpty()) {
                    this.requiredOneOfAttributesBuilder_.dispose();
                    this.requiredOneOfAttributesBuilder_ = null;
                    this.requiredOneOfAttributes_ = other.requiredOneOfAttributes_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.requiredOneOfAttributesBuilder_ = alwaysUseFieldBuilders ? this.getRequiredOneOfAttributesFieldBuilder() : null;
                } else {
                    this.requiredOneOfAttributesBuilder_.addAllMessages((Iterable)other.requiredOneOfAttributes_);
                }
            }
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                if (!other.requiredOneOfAttributeSets_.isEmpty()) {
                    if (this.requiredOneOfAttributeSets_.isEmpty()) {
                        this.requiredOneOfAttributeSets_ = other.requiredOneOfAttributeSets_;
                        this.bitField0_ &= 0xFFFFEFFF;
                    } else {
                        this.ensureRequiredOneOfAttributeSetsIsMutable();
                        this.requiredOneOfAttributeSets_.addAll(other.requiredOneOfAttributeSets_);
                    }
                    this.onChanged();
                }
            } else if (!other.requiredOneOfAttributeSets_.isEmpty()) {
                if (this.requiredOneOfAttributeSetsBuilder_.isEmpty()) {
                    this.requiredOneOfAttributeSetsBuilder_.dispose();
                    this.requiredOneOfAttributeSetsBuilder_ = null;
                    this.requiredOneOfAttributeSets_ = other.requiredOneOfAttributeSets_;
                    this.bitField0_ &= 0xFFFFEFFF;
                    this.requiredOneOfAttributeSetsBuilder_ = alwaysUseFieldBuilders ? this.getRequiredOneOfAttributeSetsFieldBuilder() : null;
                } else {
                    this.requiredOneOfAttributeSetsBuilder_.addAllMessages((Iterable)other.requiredOneOfAttributeSets_);
                }
            }
            if (other.orderBy_ != 0) {
                this.setOrderByValue(other.getOrderByValue());
            }
            if (other.getIncludeBackToBack()) {
                this.setIncludeBackToBack(other.getIncludeBackToBack());
            }
            if (!other.getTripId().isEmpty()) {
                this.tripId_ = other.tripId_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (other.currentTripsPresent_ != 0) {
                this.setCurrentTripsPresentValue(other.getCurrentTripsPresentValue());
            }
            if (!other.getFilter().isEmpty()) {
                this.filter_ = other.filter_;
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getHeaderFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block27;
                        }
                        case 26: {
                            this.parent_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block27;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getPickupPointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block27;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getDropoffPointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block27;
                        }
                        case 48: {
                            this.pickupRadiusMeters_ = input.readInt32();
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 56: {
                            this.count_ = input.readInt32();
                            this.bitField0_ |= 0x20;
                            continue block27;
                        }
                        case 64: {
                            this.minimumCapacity_ = input.readInt32();
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 72: {
                            int tmpRaw = input.readEnum();
                            this.ensureTripTypesIsMutable();
                            this.tripTypes_.add(tmpRaw);
                            continue block27;
                        }
                        case 74: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureTripTypesIsMutable();
                                this.tripTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block27;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getMaximumStalenessFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 98: {
                            VehicleAttribute m = (VehicleAttribute)input.readMessage(VehicleAttribute.parser(), extensionRegistry);
                            if (this.requiredAttributesBuilder_ == null) {
                                this.ensureRequiredAttributesIsMutable();
                                this.requiredAttributes_.add(m);
                                continue block27;
                            }
                            this.requiredAttributesBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 104: {
                            this.orderBy_ = input.readEnum();
                            this.bitField0_ |= 0x2000;
                            continue block27;
                        }
                        case 114: {
                            Vehicle.VehicleType m = (Vehicle.VehicleType)input.readMessage(Vehicle.VehicleType.parser(), extensionRegistry);
                            if (this.vehicleTypesBuilder_ == null) {
                                this.ensureVehicleTypesIsMutable();
                                this.vehicleTypes_.add(m);
                                continue block27;
                            }
                            this.vehicleTypesBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 122: {
                            VehicleAttributeList m = (VehicleAttributeList)input.readMessage(VehicleAttributeList.parser(), extensionRegistry);
                            if (this.requiredOneOfAttributesBuilder_ == null) {
                                this.ensureRequiredOneOfAttributesIsMutable();
                                this.requiredOneOfAttributes_.add(m);
                                continue block27;
                            }
                            this.requiredOneOfAttributesBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 144: {
                            this.includeBackToBack_ = input.readBool();
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 154: {
                            this.tripId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block27;
                        }
                        case 162: {
                            VehicleAttributeList m = (VehicleAttributeList)input.readMessage(VehicleAttributeList.parser(), extensionRegistry);
                            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                                this.ensureRequiredOneOfAttributeSetsIsMutable();
                                this.requiredOneOfAttributeSets_.add(m);
                                continue block27;
                            }
                            this.requiredOneOfAttributeSetsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 168: {
                            this.currentTripsPresent_ = input.readEnum();
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 178: {
                            this.filter_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasHeader() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public RequestHeader getHeader() {
            if (this.headerBuilder_ == null) {
                return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
            }
            return (RequestHeader)this.headerBuilder_.getMessage();
        }

        public Builder setHeader(RequestHeader value) {
            if (this.headerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.header_ = value;
            } else {
                this.headerBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setHeader(RequestHeader.Builder builderForValue) {
            if (this.headerBuilder_ == null) {
                this.header_ = builderForValue.build();
            } else {
                this.headerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeHeader(RequestHeader value) {
            if (this.headerBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.header_ != null && this.header_ != RequestHeader.getDefaultInstance()) {
                    this.getHeaderBuilder().mergeFrom(value);
                } else {
                    this.header_ = value;
                }
            } else {
                this.headerBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.header_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearHeader() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.header_ = null;
            if (this.headerBuilder_ != null) {
                this.headerBuilder_.dispose();
                this.headerBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RequestHeader.Builder getHeaderBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (RequestHeader.Builder)this.getHeaderFieldBuilder().getBuilder();
        }

        @Override
        public RequestHeaderOrBuilder getHeaderOrBuilder() {
            if (this.headerBuilder_ != null) {
                return (RequestHeaderOrBuilder)this.headerBuilder_.getMessageOrBuilder();
            }
            return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
        }

        private SingleFieldBuilderV3<RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder> getHeaderFieldBuilder() {
            if (this.headerBuilder_ == null) {
                this.headerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getHeader(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.header_ = null;
            }
            return this.headerBuilder_;
        }

        @Override
        public String getParent() {
            Object ref = this.parent_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.parent_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getParentBytes() {
            Object ref = this.parent_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.parent_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setParent(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.parent_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearParent() {
            this.parent_ = SearchVehiclesRequest.getDefaultInstance().getParent();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setParentBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.parent_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPickupPoint() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public TerminalLocation getPickupPoint() {
            if (this.pickupPointBuilder_ == null) {
                return this.pickupPoint_ == null ? TerminalLocation.getDefaultInstance() : this.pickupPoint_;
            }
            return (TerminalLocation)this.pickupPointBuilder_.getMessage();
        }

        public Builder setPickupPoint(TerminalLocation value) {
            if (this.pickupPointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.pickupPoint_ = value;
            } else {
                this.pickupPointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setPickupPoint(TerminalLocation.Builder builderForValue) {
            if (this.pickupPointBuilder_ == null) {
                this.pickupPoint_ = builderForValue.build();
            } else {
                this.pickupPointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergePickupPoint(TerminalLocation value) {
            if (this.pickupPointBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.pickupPoint_ != null && this.pickupPoint_ != TerminalLocation.getDefaultInstance()) {
                    this.getPickupPointBuilder().mergeFrom(value);
                } else {
                    this.pickupPoint_ = value;
                }
            } else {
                this.pickupPointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.pickupPoint_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPickupPoint() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.pickupPoint_ = null;
            if (this.pickupPointBuilder_ != null) {
                this.pickupPointBuilder_.dispose();
                this.pickupPointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TerminalLocation.Builder getPickupPointBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (TerminalLocation.Builder)this.getPickupPointFieldBuilder().getBuilder();
        }

        @Override
        public TerminalLocationOrBuilder getPickupPointOrBuilder() {
            if (this.pickupPointBuilder_ != null) {
                return (TerminalLocationOrBuilder)this.pickupPointBuilder_.getMessageOrBuilder();
            }
            return this.pickupPoint_ == null ? TerminalLocation.getDefaultInstance() : this.pickupPoint_;
        }

        private SingleFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> getPickupPointFieldBuilder() {
            if (this.pickupPointBuilder_ == null) {
                this.pickupPointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPickupPoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pickupPoint_ = null;
            }
            return this.pickupPointBuilder_;
        }

        @Override
        public boolean hasDropoffPoint() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public TerminalLocation getDropoffPoint() {
            if (this.dropoffPointBuilder_ == null) {
                return this.dropoffPoint_ == null ? TerminalLocation.getDefaultInstance() : this.dropoffPoint_;
            }
            return (TerminalLocation)this.dropoffPointBuilder_.getMessage();
        }

        public Builder setDropoffPoint(TerminalLocation value) {
            if (this.dropoffPointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.dropoffPoint_ = value;
            } else {
                this.dropoffPointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setDropoffPoint(TerminalLocation.Builder builderForValue) {
            if (this.dropoffPointBuilder_ == null) {
                this.dropoffPoint_ = builderForValue.build();
            } else {
                this.dropoffPointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeDropoffPoint(TerminalLocation value) {
            if (this.dropoffPointBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.dropoffPoint_ != null && this.dropoffPoint_ != TerminalLocation.getDefaultInstance()) {
                    this.getDropoffPointBuilder().mergeFrom(value);
                } else {
                    this.dropoffPoint_ = value;
                }
            } else {
                this.dropoffPointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.dropoffPoint_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDropoffPoint() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.dropoffPoint_ = null;
            if (this.dropoffPointBuilder_ != null) {
                this.dropoffPointBuilder_.dispose();
                this.dropoffPointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TerminalLocation.Builder getDropoffPointBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (TerminalLocation.Builder)this.getDropoffPointFieldBuilder().getBuilder();
        }

        @Override
        public TerminalLocationOrBuilder getDropoffPointOrBuilder() {
            if (this.dropoffPointBuilder_ != null) {
                return (TerminalLocationOrBuilder)this.dropoffPointBuilder_.getMessageOrBuilder();
            }
            return this.dropoffPoint_ == null ? TerminalLocation.getDefaultInstance() : this.dropoffPoint_;
        }

        private SingleFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> getDropoffPointFieldBuilder() {
            if (this.dropoffPointBuilder_ == null) {
                this.dropoffPointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDropoffPoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dropoffPoint_ = null;
            }
            return this.dropoffPointBuilder_;
        }

        @Override
        public int getPickupRadiusMeters() {
            return this.pickupRadiusMeters_;
        }

        public Builder setPickupRadiusMeters(int value) {
            this.pickupRadiusMeters_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPickupRadiusMeters() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.pickupRadiusMeters_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getCount() {
            return this.count_;
        }

        public Builder setCount(int value) {
            this.count_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearCount() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.count_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getMinimumCapacity() {
            return this.minimumCapacity_;
        }

        public Builder setMinimumCapacity(int value) {
            this.minimumCapacity_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearMinimumCapacity() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.minimumCapacity_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTripTypesIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.tripTypes_ = new ArrayList<Integer>(this.tripTypes_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<TripType> getTripTypesList() {
            return new Internal.ListAdapter(this.tripTypes_, tripTypes_converter_);
        }

        @Override
        public int getTripTypesCount() {
            return this.tripTypes_.size();
        }

        @Override
        public TripType getTripTypes(int index) {
            return (TripType)((Object)tripTypes_converter_.convert((Object)this.tripTypes_.get(index)));
        }

        public Builder setTripTypes(int index, TripType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTripTypesIsMutable();
            this.tripTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addTripTypes(TripType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTripTypesIsMutable();
            this.tripTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllTripTypes(Iterable<? extends TripType> values) {
            this.ensureTripTypesIsMutable();
            for (TripType tripType : values) {
                this.tripTypes_.add(tripType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearTripTypes() {
            this.tripTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getTripTypesValueList() {
            return Collections.unmodifiableList(this.tripTypes_);
        }

        @Override
        public int getTripTypesValue(int index) {
            return this.tripTypes_.get(index);
        }

        public Builder setTripTypesValue(int index, int value) {
            this.ensureTripTypesIsMutable();
            this.tripTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addTripTypesValue(int value) {
            this.ensureTripTypesIsMutable();
            this.tripTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllTripTypesValue(Iterable<Integer> values) {
            this.ensureTripTypesIsMutable();
            for (int value : values) {
                this.tripTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMaximumStaleness() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Duration getMaximumStaleness() {
            if (this.maximumStalenessBuilder_ == null) {
                return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
            }
            return (Duration)this.maximumStalenessBuilder_.getMessage();
        }

        public Builder setMaximumStaleness(Duration value) {
            if (this.maximumStalenessBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.maximumStaleness_ = value;
            } else {
                this.maximumStalenessBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setMaximumStaleness(Duration.Builder builderForValue) {
            if (this.maximumStalenessBuilder_ == null) {
                this.maximumStaleness_ = builderForValue.build();
            } else {
                this.maximumStalenessBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeMaximumStaleness(Duration value) {
            if (this.maximumStalenessBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.maximumStaleness_ != null && this.maximumStaleness_ != Duration.getDefaultInstance()) {
                    this.getMaximumStalenessBuilder().mergeFrom(value);
                } else {
                    this.maximumStaleness_ = value;
                }
            } else {
                this.maximumStalenessBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.maximumStaleness_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMaximumStaleness() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.maximumStaleness_ = null;
            if (this.maximumStalenessBuilder_ != null) {
                this.maximumStalenessBuilder_.dispose();
                this.maximumStalenessBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getMaximumStalenessBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Duration.Builder)this.getMaximumStalenessFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getMaximumStalenessOrBuilder() {
            if (this.maximumStalenessBuilder_ != null) {
                return (DurationOrBuilder)this.maximumStalenessBuilder_.getMessageOrBuilder();
            }
            return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getMaximumStalenessFieldBuilder() {
            if (this.maximumStalenessBuilder_ == null) {
                this.maximumStalenessBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMaximumStaleness(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.maximumStaleness_ = null;
            }
            return this.maximumStalenessBuilder_;
        }

        private void ensureVehicleTypesIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.vehicleTypes_ = new ArrayList<Vehicle.VehicleType>(this.vehicleTypes_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<Vehicle.VehicleType> getVehicleTypesList() {
            if (this.vehicleTypesBuilder_ == null) {
                return Collections.unmodifiableList(this.vehicleTypes_);
            }
            return this.vehicleTypesBuilder_.getMessageList();
        }

        @Override
        public int getVehicleTypesCount() {
            if (this.vehicleTypesBuilder_ == null) {
                return this.vehicleTypes_.size();
            }
            return this.vehicleTypesBuilder_.getCount();
        }

        @Override
        public Vehicle.VehicleType getVehicleTypes(int index) {
            if (this.vehicleTypesBuilder_ == null) {
                return this.vehicleTypes_.get(index);
            }
            return (Vehicle.VehicleType)this.vehicleTypesBuilder_.getMessage(index);
        }

        public Builder setVehicleTypes(int index, Vehicle.VehicleType value) {
            if (this.vehicleTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.set(index, value);
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setVehicleTypes(int index, Vehicle.VehicleType.Builder builderForValue) {
            if (this.vehicleTypesBuilder_ == null) {
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVehicleTypes(Vehicle.VehicleType value) {
            if (this.vehicleTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.add(value);
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addVehicleTypes(int index, Vehicle.VehicleType value) {
            if (this.vehicleTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.add(index, value);
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addVehicleTypes(Vehicle.VehicleType.Builder builderForValue) {
            if (this.vehicleTypesBuilder_ == null) {
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVehicleTypes(int index, Vehicle.VehicleType.Builder builderForValue) {
            if (this.vehicleTypesBuilder_ == null) {
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllVehicleTypes(Iterable<? extends Vehicle.VehicleType> values) {
            if (this.vehicleTypesBuilder_ == null) {
                this.ensureVehicleTypesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.vehicleTypes_);
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearVehicleTypes() {
            if (this.vehicleTypesBuilder_ == null) {
                this.vehicleTypes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.clear();
            }
            return this;
        }

        public Builder removeVehicleTypes(int index) {
            if (this.vehicleTypesBuilder_ == null) {
                this.ensureVehicleTypesIsMutable();
                this.vehicleTypes_.remove(index);
                this.onChanged();
            } else {
                this.vehicleTypesBuilder_.remove(index);
            }
            return this;
        }

        public Vehicle.VehicleType.Builder getVehicleTypesBuilder(int index) {
            return (Vehicle.VehicleType.Builder)this.getVehicleTypesFieldBuilder().getBuilder(index);
        }

        @Override
        public Vehicle.VehicleTypeOrBuilder getVehicleTypesOrBuilder(int index) {
            if (this.vehicleTypesBuilder_ == null) {
                return this.vehicleTypes_.get(index);
            }
            return (Vehicle.VehicleTypeOrBuilder)this.vehicleTypesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends Vehicle.VehicleTypeOrBuilder> getVehicleTypesOrBuilderList() {
            if (this.vehicleTypesBuilder_ != null) {
                return this.vehicleTypesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.vehicleTypes_);
        }

        public Vehicle.VehicleType.Builder addVehicleTypesBuilder() {
            return (Vehicle.VehicleType.Builder)this.getVehicleTypesFieldBuilder().addBuilder((AbstractMessage)Vehicle.VehicleType.getDefaultInstance());
        }

        public Vehicle.VehicleType.Builder addVehicleTypesBuilder(int index) {
            return (Vehicle.VehicleType.Builder)this.getVehicleTypesFieldBuilder().addBuilder(index, (AbstractMessage)Vehicle.VehicleType.getDefaultInstance());
        }

        public List<Vehicle.VehicleType.Builder> getVehicleTypesBuilderList() {
            return this.getVehicleTypesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Vehicle.VehicleType, Vehicle.VehicleType.Builder, Vehicle.VehicleTypeOrBuilder> getVehicleTypesFieldBuilder() {
            if (this.vehicleTypesBuilder_ == null) {
                this.vehicleTypesBuilder_ = new RepeatedFieldBuilderV3(this.vehicleTypes_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.vehicleTypes_ = null;
            }
            return this.vehicleTypesBuilder_;
        }

        private void ensureRequiredAttributesIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.requiredAttributes_ = new ArrayList<VehicleAttribute>(this.requiredAttributes_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<VehicleAttribute> getRequiredAttributesList() {
            if (this.requiredAttributesBuilder_ == null) {
                return Collections.unmodifiableList(this.requiredAttributes_);
            }
            return this.requiredAttributesBuilder_.getMessageList();
        }

        @Override
        public int getRequiredAttributesCount() {
            if (this.requiredAttributesBuilder_ == null) {
                return this.requiredAttributes_.size();
            }
            return this.requiredAttributesBuilder_.getCount();
        }

        @Override
        public VehicleAttribute getRequiredAttributes(int index) {
            if (this.requiredAttributesBuilder_ == null) {
                return this.requiredAttributes_.get(index);
            }
            return (VehicleAttribute)this.requiredAttributesBuilder_.getMessage(index);
        }

        public Builder setRequiredAttributes(int index, VehicleAttribute value) {
            if (this.requiredAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.set(index, value);
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRequiredAttributes(int index, VehicleAttribute.Builder builderForValue) {
            if (this.requiredAttributesBuilder_ == null) {
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRequiredAttributes(VehicleAttribute value) {
            if (this.requiredAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.add(value);
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRequiredAttributes(int index, VehicleAttribute value) {
            if (this.requiredAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.add(index, value);
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRequiredAttributes(VehicleAttribute.Builder builderForValue) {
            if (this.requiredAttributesBuilder_ == null) {
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRequiredAttributes(int index, VehicleAttribute.Builder builderForValue) {
            if (this.requiredAttributesBuilder_ == null) {
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRequiredAttributes(Iterable<? extends VehicleAttribute> values) {
            if (this.requiredAttributesBuilder_ == null) {
                this.ensureRequiredAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.requiredAttributes_);
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRequiredAttributes() {
            if (this.requiredAttributesBuilder_ == null) {
                this.requiredAttributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeRequiredAttributes(int index) {
            if (this.requiredAttributesBuilder_ == null) {
                this.ensureRequiredAttributesIsMutable();
                this.requiredAttributes_.remove(index);
                this.onChanged();
            } else {
                this.requiredAttributesBuilder_.remove(index);
            }
            return this;
        }

        public VehicleAttribute.Builder getRequiredAttributesBuilder(int index) {
            return (VehicleAttribute.Builder)this.getRequiredAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public VehicleAttributeOrBuilder getRequiredAttributesOrBuilder(int index) {
            if (this.requiredAttributesBuilder_ == null) {
                return this.requiredAttributes_.get(index);
            }
            return (VehicleAttributeOrBuilder)this.requiredAttributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VehicleAttributeOrBuilder> getRequiredAttributesOrBuilderList() {
            if (this.requiredAttributesBuilder_ != null) {
                return this.requiredAttributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.requiredAttributes_);
        }

        public VehicleAttribute.Builder addRequiredAttributesBuilder() {
            return (VehicleAttribute.Builder)this.getRequiredAttributesFieldBuilder().addBuilder((AbstractMessage)VehicleAttribute.getDefaultInstance());
        }

        public VehicleAttribute.Builder addRequiredAttributesBuilder(int index) {
            return (VehicleAttribute.Builder)this.getRequiredAttributesFieldBuilder().addBuilder(index, (AbstractMessage)VehicleAttribute.getDefaultInstance());
        }

        public List<VehicleAttribute.Builder> getRequiredAttributesBuilderList() {
            return this.getRequiredAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VehicleAttribute, VehicleAttribute.Builder, VehicleAttributeOrBuilder> getRequiredAttributesFieldBuilder() {
            if (this.requiredAttributesBuilder_ == null) {
                this.requiredAttributesBuilder_ = new RepeatedFieldBuilderV3(this.requiredAttributes_, (this.bitField0_ & 0x400) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.requiredAttributes_ = null;
            }
            return this.requiredAttributesBuilder_;
        }

        private void ensureRequiredOneOfAttributesIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.requiredOneOfAttributes_ = new ArrayList<VehicleAttributeList>(this.requiredOneOfAttributes_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<VehicleAttributeList> getRequiredOneOfAttributesList() {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                return Collections.unmodifiableList(this.requiredOneOfAttributes_);
            }
            return this.requiredOneOfAttributesBuilder_.getMessageList();
        }

        @Override
        public int getRequiredOneOfAttributesCount() {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                return this.requiredOneOfAttributes_.size();
            }
            return this.requiredOneOfAttributesBuilder_.getCount();
        }

        @Override
        public VehicleAttributeList getRequiredOneOfAttributes(int index) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                return this.requiredOneOfAttributes_.get(index);
            }
            return (VehicleAttributeList)this.requiredOneOfAttributesBuilder_.getMessage(index);
        }

        public Builder setRequiredOneOfAttributes(int index, VehicleAttributeList value) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.set(index, value);
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRequiredOneOfAttributes(int index, VehicleAttributeList.Builder builderForValue) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRequiredOneOfAttributes(VehicleAttributeList value) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.add(value);
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRequiredOneOfAttributes(int index, VehicleAttributeList value) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.add(index, value);
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRequiredOneOfAttributes(VehicleAttributeList.Builder builderForValue) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRequiredOneOfAttributes(int index, VehicleAttributeList.Builder builderForValue) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRequiredOneOfAttributes(Iterable<? extends VehicleAttributeList> values) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.ensureRequiredOneOfAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.requiredOneOfAttributes_);
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRequiredOneOfAttributes() {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.requiredOneOfAttributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeRequiredOneOfAttributes(int index) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.ensureRequiredOneOfAttributesIsMutable();
                this.requiredOneOfAttributes_.remove(index);
                this.onChanged();
            } else {
                this.requiredOneOfAttributesBuilder_.remove(index);
            }
            return this;
        }

        public VehicleAttributeList.Builder getRequiredOneOfAttributesBuilder(int index) {
            return (VehicleAttributeList.Builder)this.getRequiredOneOfAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public VehicleAttributeListOrBuilder getRequiredOneOfAttributesOrBuilder(int index) {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                return this.requiredOneOfAttributes_.get(index);
            }
            return (VehicleAttributeListOrBuilder)this.requiredOneOfAttributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VehicleAttributeListOrBuilder> getRequiredOneOfAttributesOrBuilderList() {
            if (this.requiredOneOfAttributesBuilder_ != null) {
                return this.requiredOneOfAttributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.requiredOneOfAttributes_);
        }

        public VehicleAttributeList.Builder addRequiredOneOfAttributesBuilder() {
            return (VehicleAttributeList.Builder)this.getRequiredOneOfAttributesFieldBuilder().addBuilder((AbstractMessage)VehicleAttributeList.getDefaultInstance());
        }

        public VehicleAttributeList.Builder addRequiredOneOfAttributesBuilder(int index) {
            return (VehicleAttributeList.Builder)this.getRequiredOneOfAttributesFieldBuilder().addBuilder(index, (AbstractMessage)VehicleAttributeList.getDefaultInstance());
        }

        public List<VehicleAttributeList.Builder> getRequiredOneOfAttributesBuilderList() {
            return this.getRequiredOneOfAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VehicleAttributeList, VehicleAttributeList.Builder, VehicleAttributeListOrBuilder> getRequiredOneOfAttributesFieldBuilder() {
            if (this.requiredOneOfAttributesBuilder_ == null) {
                this.requiredOneOfAttributesBuilder_ = new RepeatedFieldBuilderV3(this.requiredOneOfAttributes_, (this.bitField0_ & 0x800) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.requiredOneOfAttributes_ = null;
            }
            return this.requiredOneOfAttributesBuilder_;
        }

        private void ensureRequiredOneOfAttributeSetsIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.requiredOneOfAttributeSets_ = new ArrayList<VehicleAttributeList>(this.requiredOneOfAttributeSets_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        public List<VehicleAttributeList> getRequiredOneOfAttributeSetsList() {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                return Collections.unmodifiableList(this.requiredOneOfAttributeSets_);
            }
            return this.requiredOneOfAttributeSetsBuilder_.getMessageList();
        }

        @Override
        public int getRequiredOneOfAttributeSetsCount() {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                return this.requiredOneOfAttributeSets_.size();
            }
            return this.requiredOneOfAttributeSetsBuilder_.getCount();
        }

        @Override
        public VehicleAttributeList getRequiredOneOfAttributeSets(int index) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                return this.requiredOneOfAttributeSets_.get(index);
            }
            return (VehicleAttributeList)this.requiredOneOfAttributeSetsBuilder_.getMessage(index);
        }

        public Builder setRequiredOneOfAttributeSets(int index, VehicleAttributeList value) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.set(index, value);
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRequiredOneOfAttributeSets(int index, VehicleAttributeList.Builder builderForValue) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRequiredOneOfAttributeSets(VehicleAttributeList value) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.add(value);
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRequiredOneOfAttributeSets(int index, VehicleAttributeList value) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.add(index, value);
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRequiredOneOfAttributeSets(VehicleAttributeList.Builder builderForValue) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRequiredOneOfAttributeSets(int index, VehicleAttributeList.Builder builderForValue) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRequiredOneOfAttributeSets(Iterable<? extends VehicleAttributeList> values) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.requiredOneOfAttributeSets_);
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRequiredOneOfAttributeSets() {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.requiredOneOfAttributeSets_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFEFFF;
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRequiredOneOfAttributeSets(int index) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.ensureRequiredOneOfAttributeSetsIsMutable();
                this.requiredOneOfAttributeSets_.remove(index);
                this.onChanged();
            } else {
                this.requiredOneOfAttributeSetsBuilder_.remove(index);
            }
            return this;
        }

        public VehicleAttributeList.Builder getRequiredOneOfAttributeSetsBuilder(int index) {
            return (VehicleAttributeList.Builder)this.getRequiredOneOfAttributeSetsFieldBuilder().getBuilder(index);
        }

        @Override
        public VehicleAttributeListOrBuilder getRequiredOneOfAttributeSetsOrBuilder(int index) {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                return this.requiredOneOfAttributeSets_.get(index);
            }
            return (VehicleAttributeListOrBuilder)this.requiredOneOfAttributeSetsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VehicleAttributeListOrBuilder> getRequiredOneOfAttributeSetsOrBuilderList() {
            if (this.requiredOneOfAttributeSetsBuilder_ != null) {
                return this.requiredOneOfAttributeSetsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.requiredOneOfAttributeSets_);
        }

        public VehicleAttributeList.Builder addRequiredOneOfAttributeSetsBuilder() {
            return (VehicleAttributeList.Builder)this.getRequiredOneOfAttributeSetsFieldBuilder().addBuilder((AbstractMessage)VehicleAttributeList.getDefaultInstance());
        }

        public VehicleAttributeList.Builder addRequiredOneOfAttributeSetsBuilder(int index) {
            return (VehicleAttributeList.Builder)this.getRequiredOneOfAttributeSetsFieldBuilder().addBuilder(index, (AbstractMessage)VehicleAttributeList.getDefaultInstance());
        }

        public List<VehicleAttributeList.Builder> getRequiredOneOfAttributeSetsBuilderList() {
            return this.getRequiredOneOfAttributeSetsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VehicleAttributeList, VehicleAttributeList.Builder, VehicleAttributeListOrBuilder> getRequiredOneOfAttributeSetsFieldBuilder() {
            if (this.requiredOneOfAttributeSetsBuilder_ == null) {
                this.requiredOneOfAttributeSetsBuilder_ = new RepeatedFieldBuilderV3(this.requiredOneOfAttributeSets_, (this.bitField0_ & 0x1000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.requiredOneOfAttributeSets_ = null;
            }
            return this.requiredOneOfAttributeSetsBuilder_;
        }

        @Override
        public int getOrderByValue() {
            return this.orderBy_;
        }

        public Builder setOrderByValue(int value) {
            this.orderBy_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public VehicleMatchOrder getOrderBy() {
            VehicleMatchOrder result = VehicleMatchOrder.forNumber(this.orderBy_);
            return result == null ? VehicleMatchOrder.UNRECOGNIZED : result;
        }

        public Builder setOrderBy(VehicleMatchOrder value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x2000;
            this.orderBy_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearOrderBy() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.orderBy_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIncludeBackToBack() {
            return this.includeBackToBack_;
        }

        public Builder setIncludeBackToBack(boolean value) {
            this.includeBackToBack_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearIncludeBackToBack() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.includeBackToBack_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getTripId() {
            Object ref = this.tripId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.tripId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTripIdBytes() {
            Object ref = this.tripId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.tripId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTripId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.tripId_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearTripId() {
            this.tripId_ = SearchVehiclesRequest.getDefaultInstance().getTripId();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setTripIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.tripId_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public int getCurrentTripsPresentValue() {
            return this.currentTripsPresent_;
        }

        public Builder setCurrentTripsPresentValue(int value) {
            this.currentTripsPresent_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        @Override
        public CurrentTripsPresent getCurrentTripsPresent() {
            CurrentTripsPresent result = CurrentTripsPresent.forNumber(this.currentTripsPresent_);
            return result == null ? CurrentTripsPresent.UNRECOGNIZED : result;
        }

        public Builder setCurrentTripsPresent(CurrentTripsPresent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10000;
            this.currentTripsPresent_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCurrentTripsPresent() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.currentTripsPresent_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getFilter() {
            Object ref = this.filter_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.filter_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFilterBytes() {
            Object ref = this.filter_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.filter_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFilter(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.filter_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearFilter() {
            this.filter_ = SearchVehiclesRequest.getDefaultInstance().getFilter();
            this.bitField0_ &= 0xFFFDFFFF;
            this.onChanged();
            return this;
        }

        public Builder setFilterBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.filter_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum CurrentTripsPresent implements ProtocolMessageEnum
    {
        CURRENT_TRIPS_PRESENT_UNSPECIFIED(0),
        NONE(1),
        ANY(2),
        UNRECOGNIZED(-1);

        public static final int CURRENT_TRIPS_PRESENT_UNSPECIFIED_VALUE = 0;
        public static final int NONE_VALUE = 1;
        public static final int ANY_VALUE = 2;
        private static final Internal.EnumLiteMap<CurrentTripsPresent> internalValueMap;
        private static final CurrentTripsPresent[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static CurrentTripsPresent valueOf(int value) {
            return CurrentTripsPresent.forNumber(value);
        }

        public static CurrentTripsPresent forNumber(int value) {
            switch (value) {
                case 0: {
                    return CURRENT_TRIPS_PRESENT_UNSPECIFIED;
                }
                case 1: {
                    return NONE;
                }
                case 2: {
                    return ANY;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<CurrentTripsPresent> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)CurrentTripsPresent.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return CurrentTripsPresent.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)SearchVehiclesRequest.getDescriptor().getEnumTypes().get(1);
        }

        public static CurrentTripsPresent valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != CurrentTripsPresent.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private CurrentTripsPresent(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<CurrentTripsPresent>(){

                public CurrentTripsPresent findValueByNumber(int number) {
                    return CurrentTripsPresent.forNumber(number);
                }
            };
            VALUES = CurrentTripsPresent.values();
        }
    }

    public static enum VehicleMatchOrder implements ProtocolMessageEnum
    {
        UNKNOWN_VEHICLE_MATCH_ORDER(0),
        PICKUP_POINT_ETA(1),
        PICKUP_POINT_DISTANCE(2),
        DROPOFF_POINT_ETA(3),
        PICKUP_POINT_STRAIGHT_DISTANCE(4),
        COST(5),
        UNRECOGNIZED(-1);

        public static final int UNKNOWN_VEHICLE_MATCH_ORDER_VALUE = 0;
        public static final int PICKUP_POINT_ETA_VALUE = 1;
        public static final int PICKUP_POINT_DISTANCE_VALUE = 2;
        public static final int DROPOFF_POINT_ETA_VALUE = 3;
        public static final int PICKUP_POINT_STRAIGHT_DISTANCE_VALUE = 4;
        public static final int COST_VALUE = 5;
        private static final Internal.EnumLiteMap<VehicleMatchOrder> internalValueMap;
        private static final VehicleMatchOrder[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static VehicleMatchOrder valueOf(int value) {
            return VehicleMatchOrder.forNumber(value);
        }

        public static VehicleMatchOrder forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN_VEHICLE_MATCH_ORDER;
                }
                case 1: {
                    return PICKUP_POINT_ETA;
                }
                case 2: {
                    return PICKUP_POINT_DISTANCE;
                }
                case 3: {
                    return DROPOFF_POINT_ETA;
                }
                case 4: {
                    return PICKUP_POINT_STRAIGHT_DISTANCE;
                }
                case 5: {
                    return COST;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<VehicleMatchOrder> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)VehicleMatchOrder.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return VehicleMatchOrder.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)SearchVehiclesRequest.getDescriptor().getEnumTypes().get(0);
        }

        public static VehicleMatchOrder valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != VehicleMatchOrder.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private VehicleMatchOrder(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<VehicleMatchOrder>(){

                public VehicleMatchOrder findValueByNumber(int number) {
                    return VehicleMatchOrder.forNumber(number);
                }
            };
            VALUES = VehicleMatchOrder.values();
        }
    }
}

