/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.geo.type.Viewport;
import com.google.geo.type.ViewportOrBuilder;
import com.google.maps.fleetengine.v1.ListVehiclesRequestOrBuilder;
import com.google.maps.fleetengine.v1.RequestHeader;
import com.google.maps.fleetengine.v1.RequestHeaderOrBuilder;
import com.google.maps.fleetengine.v1.TripType;
import com.google.maps.fleetengine.v1.Vehicle;
import com.google.maps.fleetengine.v1.VehicleApi;
import com.google.maps.fleetengine.v1.VehicleState;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int32ValueOrBuilder;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ListVehiclesRequest
extends GeneratedMessageV3
implements ListVehiclesRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int HEADER_FIELD_NUMBER = 12;
    private RequestHeader header_;
    public static final int PARENT_FIELD_NUMBER = 1;
    private volatile Object parent_ = "";
    public static final int PAGE_SIZE_FIELD_NUMBER = 3;
    private int pageSize_ = 0;
    public static final int PAGE_TOKEN_FIELD_NUMBER = 4;
    private volatile Object pageToken_ = "";
    public static final int MINIMUM_CAPACITY_FIELD_NUMBER = 6;
    private Int32Value minimumCapacity_;
    public static final int TRIP_TYPES_FIELD_NUMBER = 7;
    private List<Integer> tripTypes_;
    private static final Internal.ListAdapter.Converter<Integer, TripType> tripTypes_converter_ = new Internal.ListAdapter.Converter<Integer, TripType>(){

        public TripType convert(Integer from) {
            TripType result = TripType.forNumber(from);
            return result == null ? TripType.UNRECOGNIZED : result;
        }
    };
    private int tripTypesMemoizedSerializedSize;
    public static final int MAXIMUM_STALENESS_FIELD_NUMBER = 8;
    private Duration maximumStaleness_;
    public static final int VEHICLE_TYPE_CATEGORIES_FIELD_NUMBER = 9;
    private List<Integer> vehicleTypeCategories_;
    private static final Internal.ListAdapter.Converter<Integer, Vehicle.VehicleType.Category> vehicleTypeCategories_converter_ = new Internal.ListAdapter.Converter<Integer, Vehicle.VehicleType.Category>(){

        public Vehicle.VehicleType.Category convert(Integer from) {
            Vehicle.VehicleType.Category result = Vehicle.VehicleType.Category.forNumber(from);
            return result == null ? Vehicle.VehicleType.Category.UNRECOGNIZED : result;
        }
    };
    private int vehicleTypeCategoriesMemoizedSerializedSize;
    public static final int REQUIRED_ATTRIBUTES_FIELD_NUMBER = 10;
    private LazyStringArrayList requiredAttributes_ = LazyStringArrayList.emptyList();
    public static final int REQUIRED_ONE_OF_ATTRIBUTES_FIELD_NUMBER = 13;
    private LazyStringArrayList requiredOneOfAttributes_ = LazyStringArrayList.emptyList();
    public static final int REQUIRED_ONE_OF_ATTRIBUTE_SETS_FIELD_NUMBER = 15;
    private LazyStringArrayList requiredOneOfAttributeSets_ = LazyStringArrayList.emptyList();
    public static final int VEHICLE_STATE_FIELD_NUMBER = 11;
    private int vehicleState_ = 0;
    public static final int ON_TRIP_ONLY_FIELD_NUMBER = 14;
    private boolean onTripOnly_ = false;
    public static final int FILTER_FIELD_NUMBER = 16;
    private volatile Object filter_ = "";
    public static final int VIEWPORT_FIELD_NUMBER = 17;
    private Viewport viewport_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ListVehiclesRequest DEFAULT_INSTANCE = new ListVehiclesRequest();
    private static final Parser<ListVehiclesRequest> PARSER = new AbstractParser<ListVehiclesRequest>(){

        public ListVehiclesRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ListVehiclesRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ListVehiclesRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ListVehiclesRequest() {
        this.parent_ = "";
        this.pageToken_ = "";
        this.tripTypes_ = Collections.emptyList();
        this.vehicleTypeCategories_ = Collections.emptyList();
        this.requiredAttributes_ = LazyStringArrayList.emptyList();
        this.requiredOneOfAttributes_ = LazyStringArrayList.emptyList();
        this.requiredOneOfAttributeSets_ = LazyStringArrayList.emptyList();
        this.vehicleState_ = 0;
        this.filter_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ListVehiclesRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return VehicleApi.internal_static_maps_fleetengine_v1_ListVehiclesRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return VehicleApi.internal_static_maps_fleetengine_v1_ListVehiclesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ListVehiclesRequest.class, Builder.class);
    }

    @Override
    public boolean hasHeader() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public RequestHeader getHeader() {
        return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
    }

    @Override
    public RequestHeaderOrBuilder getHeaderOrBuilder() {
        return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
    }

    @Override
    public String getParent() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.parent_ = s;
        return s;
    }

    @Override
    public ByteString getParentBytes() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.parent_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getPageSize() {
        return this.pageSize_;
    }

    @Override
    public String getPageToken() {
        Object ref = this.pageToken_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.pageToken_ = s;
        return s;
    }

    @Override
    public ByteString getPageTokenBytes() {
        Object ref = this.pageToken_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.pageToken_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMinimumCapacity() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Int32Value getMinimumCapacity() {
        return this.minimumCapacity_ == null ? Int32Value.getDefaultInstance() : this.minimumCapacity_;
    }

    @Override
    public Int32ValueOrBuilder getMinimumCapacityOrBuilder() {
        return this.minimumCapacity_ == null ? Int32Value.getDefaultInstance() : this.minimumCapacity_;
    }

    @Override
    public List<TripType> getTripTypesList() {
        return new Internal.ListAdapter(this.tripTypes_, tripTypes_converter_);
    }

    @Override
    public int getTripTypesCount() {
        return this.tripTypes_.size();
    }

    @Override
    public TripType getTripTypes(int index) {
        return (TripType)((Object)tripTypes_converter_.convert((Object)this.tripTypes_.get(index)));
    }

    @Override
    public List<Integer> getTripTypesValueList() {
        return this.tripTypes_;
    }

    @Override
    public int getTripTypesValue(int index) {
        return this.tripTypes_.get(index);
    }

    @Override
    public boolean hasMaximumStaleness() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Duration getMaximumStaleness() {
        return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
    }

    @Override
    public DurationOrBuilder getMaximumStalenessOrBuilder() {
        return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
    }

    @Override
    public List<Vehicle.VehicleType.Category> getVehicleTypeCategoriesList() {
        return new Internal.ListAdapter(this.vehicleTypeCategories_, vehicleTypeCategories_converter_);
    }

    @Override
    public int getVehicleTypeCategoriesCount() {
        return this.vehicleTypeCategories_.size();
    }

    @Override
    public Vehicle.VehicleType.Category getVehicleTypeCategories(int index) {
        return (Vehicle.VehicleType.Category)((Object)vehicleTypeCategories_converter_.convert((Object)this.vehicleTypeCategories_.get(index)));
    }

    @Override
    public List<Integer> getVehicleTypeCategoriesValueList() {
        return this.vehicleTypeCategories_;
    }

    @Override
    public int getVehicleTypeCategoriesValue(int index) {
        return this.vehicleTypeCategories_.get(index);
    }

    public ProtocolStringList getRequiredAttributesList() {
        return this.requiredAttributes_;
    }

    @Override
    public int getRequiredAttributesCount() {
        return this.requiredAttributes_.size();
    }

    @Override
    public String getRequiredAttributes(int index) {
        return this.requiredAttributes_.get(index);
    }

    @Override
    public ByteString getRequiredAttributesBytes(int index) {
        return this.requiredAttributes_.getByteString(index);
    }

    public ProtocolStringList getRequiredOneOfAttributesList() {
        return this.requiredOneOfAttributes_;
    }

    @Override
    public int getRequiredOneOfAttributesCount() {
        return this.requiredOneOfAttributes_.size();
    }

    @Override
    public String getRequiredOneOfAttributes(int index) {
        return this.requiredOneOfAttributes_.get(index);
    }

    @Override
    public ByteString getRequiredOneOfAttributesBytes(int index) {
        return this.requiredOneOfAttributes_.getByteString(index);
    }

    public ProtocolStringList getRequiredOneOfAttributeSetsList() {
        return this.requiredOneOfAttributeSets_;
    }

    @Override
    public int getRequiredOneOfAttributeSetsCount() {
        return this.requiredOneOfAttributeSets_.size();
    }

    @Override
    public String getRequiredOneOfAttributeSets(int index) {
        return this.requiredOneOfAttributeSets_.get(index);
    }

    @Override
    public ByteString getRequiredOneOfAttributeSetsBytes(int index) {
        return this.requiredOneOfAttributeSets_.getByteString(index);
    }

    @Override
    public int getVehicleStateValue() {
        return this.vehicleState_;
    }

    @Override
    public VehicleState getVehicleState() {
        VehicleState result = VehicleState.forNumber(this.vehicleState_);
        return result == null ? VehicleState.UNRECOGNIZED : result;
    }

    @Override
    public boolean getOnTripOnly() {
        return this.onTripOnly_;
    }

    @Override
    public String getFilter() {
        Object ref = this.filter_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.filter_ = s;
        return s;
    }

    @Override
    public ByteString getFilterBytes() {
        Object ref = this.filter_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.filter_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasViewport() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Viewport getViewport() {
        return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
    }

    @Override
    public ViewportOrBuilder getViewportOrBuilder() {
        return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.parent_);
        }
        if (this.pageSize_ != 0) {
            output.writeInt32(3, this.pageSize_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.pageToken_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.pageToken_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(6, (MessageLite)this.getMinimumCapacity());
        }
        if (this.getTripTypesList().size() > 0) {
            output.writeUInt32NoTag(58);
            output.writeUInt32NoTag(this.tripTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.tripTypes_.size(); ++i) {
            output.writeEnumNoTag(this.tripTypes_.get(i).intValue());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(8, (MessageLite)this.getMaximumStaleness());
        }
        if (this.getVehicleTypeCategoriesList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.vehicleTypeCategoriesMemoizedSerializedSize);
        }
        for (i = 0; i < this.vehicleTypeCategories_.size(); ++i) {
            output.writeEnumNoTag(this.vehicleTypeCategories_.get(i).intValue());
        }
        for (i = 0; i < this.requiredAttributes_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.requiredAttributes_.getRaw(i));
        }
        if (this.vehicleState_ != VehicleState.UNKNOWN_VEHICLE_STATE.getNumber()) {
            output.writeEnum(11, this.vehicleState_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(12, (MessageLite)this.getHeader());
        }
        for (i = 0; i < this.requiredOneOfAttributes_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.requiredOneOfAttributes_.getRaw(i));
        }
        if (this.onTripOnly_) {
            output.writeBool(14, this.onTripOnly_);
        }
        for (i = 0; i < this.requiredOneOfAttributeSets_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)15, (Object)this.requiredOneOfAttributeSets_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.filter_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.filter_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(17, (MessageLite)this.getViewport());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.parent_);
        }
        if (this.pageSize_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)3, (int)this.pageSize_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.pageToken_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.pageToken_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getMinimumCapacity());
        }
        int dataSize = 0;
        for (i = 0; i < this.tripTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.tripTypes_.get(i));
        }
        size += dataSize;
        if (!this.getTripTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.tripTypesMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getMaximumStaleness());
        }
        dataSize = 0;
        for (i = 0; i < this.vehicleTypeCategories_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.vehicleTypeCategories_.get(i));
        }
        size += dataSize;
        if (!this.getVehicleTypeCategoriesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.vehicleTypeCategoriesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.requiredAttributes_.size(); ++i) {
            dataSize += ListVehiclesRequest.computeStringSizeNoTag((Object)this.requiredAttributes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getRequiredAttributesList().size();
        if (this.vehicleState_ != VehicleState.UNKNOWN_VEHICLE_STATE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.vehicleState_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getHeader());
        }
        dataSize = 0;
        for (i = 0; i < this.requiredOneOfAttributes_.size(); ++i) {
            dataSize += ListVehiclesRequest.computeStringSizeNoTag((Object)this.requiredOneOfAttributes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getRequiredOneOfAttributesList().size();
        if (this.onTripOnly_) {
            size += CodedOutputStream.computeBoolSize((int)14, (boolean)this.onTripOnly_);
        }
        dataSize = 0;
        for (i = 0; i < this.requiredOneOfAttributeSets_.size(); ++i) {
            dataSize += ListVehiclesRequest.computeStringSizeNoTag((Object)this.requiredOneOfAttributeSets_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getRequiredOneOfAttributeSetsList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.filter_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.filter_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)this.getViewport());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListVehiclesRequest)) {
            return super.equals(obj);
        }
        ListVehiclesRequest other = (ListVehiclesRequest)obj;
        if (this.hasHeader() != other.hasHeader()) {
            return false;
        }
        if (this.hasHeader() && !this.getHeader().equals(other.getHeader())) {
            return false;
        }
        if (!this.getParent().equals(other.getParent())) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (!this.getPageToken().equals(other.getPageToken())) {
            return false;
        }
        if (this.hasMinimumCapacity() != other.hasMinimumCapacity()) {
            return false;
        }
        if (this.hasMinimumCapacity() && !this.getMinimumCapacity().equals((Object)other.getMinimumCapacity())) {
            return false;
        }
        if (!this.tripTypes_.equals(other.tripTypes_)) {
            return false;
        }
        if (this.hasMaximumStaleness() != other.hasMaximumStaleness()) {
            return false;
        }
        if (this.hasMaximumStaleness() && !this.getMaximumStaleness().equals((Object)other.getMaximumStaleness())) {
            return false;
        }
        if (!this.vehicleTypeCategories_.equals(other.vehicleTypeCategories_)) {
            return false;
        }
        if (!this.getRequiredAttributesList().equals(other.getRequiredAttributesList())) {
            return false;
        }
        if (!this.getRequiredOneOfAttributesList().equals(other.getRequiredOneOfAttributesList())) {
            return false;
        }
        if (!this.getRequiredOneOfAttributeSetsList().equals(other.getRequiredOneOfAttributeSetsList())) {
            return false;
        }
        if (this.vehicleState_ != other.vehicleState_) {
            return false;
        }
        if (this.getOnTripOnly() != other.getOnTripOnly()) {
            return false;
        }
        if (!this.getFilter().equals(other.getFilter())) {
            return false;
        }
        if (this.hasViewport() != other.hasViewport()) {
            return false;
        }
        if (this.hasViewport() && !this.getViewport().equals((Object)other.getViewport())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ListVehiclesRequest.getDescriptor().hashCode();
        if (this.hasHeader()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getHeader().hashCode();
        }
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getParent().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getPageSize();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getPageToken().hashCode();
        if (this.hasMinimumCapacity()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getMinimumCapacity().hashCode();
        }
        if (this.getTripTypesCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.tripTypes_.hashCode();
        }
        if (this.hasMaximumStaleness()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getMaximumStaleness().hashCode();
        }
        if (this.getVehicleTypeCategoriesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.vehicleTypeCategories_.hashCode();
        }
        if (this.getRequiredAttributesCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getRequiredAttributesList().hashCode();
        }
        if (this.getRequiredOneOfAttributesCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getRequiredOneOfAttributesList().hashCode();
        }
        if (this.getRequiredOneOfAttributeSetsCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getRequiredOneOfAttributeSetsList().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.vehicleState_;
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getOnTripOnly());
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getFilter().hashCode();
        if (this.hasViewport()) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getViewport().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ListVehiclesRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ListVehiclesRequest)PARSER.parseFrom(data);
    }

    public static ListVehiclesRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ListVehiclesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListVehiclesRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ListVehiclesRequest)PARSER.parseFrom(data);
    }

    public static ListVehiclesRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ListVehiclesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListVehiclesRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ListVehiclesRequest)PARSER.parseFrom(data);
    }

    public static ListVehiclesRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ListVehiclesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListVehiclesRequest parseFrom(InputStream input) throws IOException {
        return (ListVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ListVehiclesRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ListVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ListVehiclesRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (ListVehiclesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ListVehiclesRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ListVehiclesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ListVehiclesRequest parseFrom(CodedInputStream input) throws IOException {
        return (ListVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ListVehiclesRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ListVehiclesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ListVehiclesRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ListVehiclesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ListVehiclesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ListVehiclesRequest> parser() {
        return PARSER;
    }

    public Parser<ListVehiclesRequest> getParserForType() {
        return PARSER;
    }

    public ListVehiclesRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ListVehiclesRequestOrBuilder {
        private int bitField0_;
        private RequestHeader header_;
        private SingleFieldBuilderV3<RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder> headerBuilder_;
        private Object parent_ = "";
        private int pageSize_;
        private Object pageToken_ = "";
        private Int32Value minimumCapacity_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> minimumCapacityBuilder_;
        private List<Integer> tripTypes_ = Collections.emptyList();
        private Duration maximumStaleness_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> maximumStalenessBuilder_;
        private List<Integer> vehicleTypeCategories_ = Collections.emptyList();
        private LazyStringArrayList requiredAttributes_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList requiredOneOfAttributes_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList requiredOneOfAttributeSets_ = LazyStringArrayList.emptyList();
        private int vehicleState_ = 0;
        private boolean onTripOnly_;
        private Object filter_ = "";
        private Viewport viewport_;
        private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> viewportBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return VehicleApi.internal_static_maps_fleetengine_v1_ListVehiclesRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return VehicleApi.internal_static_maps_fleetengine_v1_ListVehiclesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ListVehiclesRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getHeaderFieldBuilder();
                this.getMinimumCapacityFieldBuilder();
                this.getMaximumStalenessFieldBuilder();
                this.getViewportFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.header_ = null;
            if (this.headerBuilder_ != null) {
                this.headerBuilder_.dispose();
                this.headerBuilder_ = null;
            }
            this.parent_ = "";
            this.pageSize_ = 0;
            this.pageToken_ = "";
            this.minimumCapacity_ = null;
            if (this.minimumCapacityBuilder_ != null) {
                this.minimumCapacityBuilder_.dispose();
                this.minimumCapacityBuilder_ = null;
            }
            this.tripTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFDF;
            this.maximumStaleness_ = null;
            if (this.maximumStalenessBuilder_ != null) {
                this.maximumStalenessBuilder_.dispose();
                this.maximumStalenessBuilder_ = null;
            }
            this.vehicleTypeCategories_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.requiredAttributes_ = LazyStringArrayList.emptyList();
            this.requiredOneOfAttributes_ = LazyStringArrayList.emptyList();
            this.requiredOneOfAttributeSets_ = LazyStringArrayList.emptyList();
            this.vehicleState_ = 0;
            this.onTripOnly_ = false;
            this.filter_ = "";
            this.viewport_ = null;
            if (this.viewportBuilder_ != null) {
                this.viewportBuilder_.dispose();
                this.viewportBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return VehicleApi.internal_static_maps_fleetengine_v1_ListVehiclesRequest_descriptor;
        }

        public ListVehiclesRequest getDefaultInstanceForType() {
            return ListVehiclesRequest.getDefaultInstance();
        }

        public ListVehiclesRequest build() {
            ListVehiclesRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ListVehiclesRequest buildPartial() {
            ListVehiclesRequest result = new ListVehiclesRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ListVehiclesRequest result) {
            if ((this.bitField0_ & 0x20) != 0) {
                this.tripTypes_ = Collections.unmodifiableList(this.tripTypes_);
                this.bitField0_ &= 0xFFFFFFDF;
            }
            result.tripTypes_ = this.tripTypes_;
            if ((this.bitField0_ & 0x80) != 0) {
                this.vehicleTypeCategories_ = Collections.unmodifiableList(this.vehicleTypeCategories_);
                this.bitField0_ &= 0xFFFFFF7F;
            }
            result.vehicleTypeCategories_ = this.vehicleTypeCategories_;
        }

        private void buildPartial0(ListVehiclesRequest result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.header_ = this.headerBuilder_ == null ? this.header_ : (RequestHeader)this.headerBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.parent_ = this.parent_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.pageSize_ = this.pageSize_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.pageToken_ = this.pageToken_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.minimumCapacity_ = this.minimumCapacityBuilder_ == null ? this.minimumCapacity_ : (Int32Value)this.minimumCapacityBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.maximumStaleness_ = this.maximumStalenessBuilder_ == null ? this.maximumStaleness_ : (Duration)this.maximumStalenessBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                this.requiredAttributes_.makeImmutable();
                result.requiredAttributes_ = this.requiredAttributes_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                this.requiredOneOfAttributes_.makeImmutable();
                result.requiredOneOfAttributes_ = this.requiredOneOfAttributes_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                this.requiredOneOfAttributeSets_.makeImmutable();
                result.requiredOneOfAttributeSets_ = this.requiredOneOfAttributeSets_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.vehicleState_ = this.vehicleState_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.onTripOnly_ = this.onTripOnly_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.filter_ = this.filter_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.viewport_ = this.viewportBuilder_ == null ? this.viewport_ : (Viewport)this.viewportBuilder_.build();
                to_bitField0_ |= 8;
            }
            ListVehiclesRequest listVehiclesRequest = result;
            listVehiclesRequest.bitField0_ = listVehiclesRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ListVehiclesRequest) {
                return this.mergeFrom((ListVehiclesRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ListVehiclesRequest other) {
            if (other == ListVehiclesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.hasHeader()) {
                this.mergeHeader(other.getHeader());
            }
            if (!other.getParent().isEmpty()) {
                this.parent_ = other.parent_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.getPageSize() != 0) {
                this.setPageSize(other.getPageSize());
            }
            if (!other.getPageToken().isEmpty()) {
                this.pageToken_ = other.pageToken_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasMinimumCapacity()) {
                this.mergeMinimumCapacity(other.getMinimumCapacity());
            }
            if (!other.tripTypes_.isEmpty()) {
                if (this.tripTypes_.isEmpty()) {
                    this.tripTypes_ = other.tripTypes_;
                    this.bitField0_ &= 0xFFFFFFDF;
                } else {
                    this.ensureTripTypesIsMutable();
                    this.tripTypes_.addAll(other.tripTypes_);
                }
                this.onChanged();
            }
            if (other.hasMaximumStaleness()) {
                this.mergeMaximumStaleness(other.getMaximumStaleness());
            }
            if (!other.vehicleTypeCategories_.isEmpty()) {
                if (this.vehicleTypeCategories_.isEmpty()) {
                    this.vehicleTypeCategories_ = other.vehicleTypeCategories_;
                    this.bitField0_ &= 0xFFFFFF7F;
                } else {
                    this.ensureVehicleTypeCategoriesIsMutable();
                    this.vehicleTypeCategories_.addAll(other.vehicleTypeCategories_);
                }
                this.onChanged();
            }
            if (!other.requiredAttributes_.isEmpty()) {
                if (this.requiredAttributes_.isEmpty()) {
                    this.requiredAttributes_ = other.requiredAttributes_;
                    this.bitField0_ |= 0x100;
                } else {
                    this.ensureRequiredAttributesIsMutable();
                    this.requiredAttributes_.addAll((Collection)other.requiredAttributes_);
                }
                this.onChanged();
            }
            if (!other.requiredOneOfAttributes_.isEmpty()) {
                if (this.requiredOneOfAttributes_.isEmpty()) {
                    this.requiredOneOfAttributes_ = other.requiredOneOfAttributes_;
                    this.bitField0_ |= 0x200;
                } else {
                    this.ensureRequiredOneOfAttributesIsMutable();
                    this.requiredOneOfAttributes_.addAll((Collection)other.requiredOneOfAttributes_);
                }
                this.onChanged();
            }
            if (!other.requiredOneOfAttributeSets_.isEmpty()) {
                if (this.requiredOneOfAttributeSets_.isEmpty()) {
                    this.requiredOneOfAttributeSets_ = other.requiredOneOfAttributeSets_;
                    this.bitField0_ |= 0x400;
                } else {
                    this.ensureRequiredOneOfAttributeSetsIsMutable();
                    this.requiredOneOfAttributeSets_.addAll((Collection)other.requiredOneOfAttributeSets_);
                }
                this.onChanged();
            }
            if (other.vehicleState_ != 0) {
                this.setVehicleStateValue(other.getVehicleStateValue());
            }
            if (other.getOnTripOnly()) {
                this.setOnTripOnly(other.getOnTripOnly());
            }
            if (!other.getFilter().isEmpty()) {
                this.filter_ = other.filter_;
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            if (other.hasViewport()) {
                this.mergeViewport(other.getViewport());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block25: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block25;
                        }
                        case 10: {
                            this.parent_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block25;
                        }
                        case 24: {
                            this.pageSize_ = input.readInt32();
                            this.bitField0_ |= 4;
                            continue block25;
                        }
                        case 34: {
                            this.pageToken_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block25;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getMinimumCapacityFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block25;
                        }
                        case 56: {
                            int tmpRaw = input.readEnum();
                            this.ensureTripTypesIsMutable();
                            this.tripTypes_.add(tmpRaw);
                            continue block25;
                        }
                        case 58: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureTripTypesIsMutable();
                                this.tripTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block25;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getMaximumStalenessFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block25;
                        }
                        case 72: {
                            int tmpRaw = input.readEnum();
                            this.ensureVehicleTypeCategoriesIsMutable();
                            this.vehicleTypeCategories_.add(tmpRaw);
                            continue block25;
                        }
                        case 74: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureVehicleTypeCategoriesIsMutable();
                                this.vehicleTypeCategories_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block25;
                        }
                        case 82: {
                            String s = input.readStringRequireUtf8();
                            this.ensureRequiredAttributesIsMutable();
                            this.requiredAttributes_.add((Object)s);
                            continue block25;
                        }
                        case 88: {
                            this.vehicleState_ = input.readEnum();
                            this.bitField0_ |= 0x800;
                            continue block25;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getHeaderFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block25;
                        }
                        case 106: {
                            String s = input.readStringRequireUtf8();
                            this.ensureRequiredOneOfAttributesIsMutable();
                            this.requiredOneOfAttributes_.add((Object)s);
                            continue block25;
                        }
                        case 112: {
                            this.onTripOnly_ = input.readBool();
                            this.bitField0_ |= 0x1000;
                            continue block25;
                        }
                        case 122: {
                            String s = input.readStringRequireUtf8();
                            this.ensureRequiredOneOfAttributeSetsIsMutable();
                            this.requiredOneOfAttributeSets_.add((Object)s);
                            continue block25;
                        }
                        case 130: {
                            this.filter_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000;
                            continue block25;
                        }
                        case 138: {
                            input.readMessage((MessageLite.Builder)this.getViewportFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x4000;
                            continue block25;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasHeader() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public RequestHeader getHeader() {
            if (this.headerBuilder_ == null) {
                return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
            }
            return (RequestHeader)this.headerBuilder_.getMessage();
        }

        public Builder setHeader(RequestHeader value) {
            if (this.headerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.header_ = value;
            } else {
                this.headerBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setHeader(RequestHeader.Builder builderForValue) {
            if (this.headerBuilder_ == null) {
                this.header_ = builderForValue.build();
            } else {
                this.headerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeHeader(RequestHeader value) {
            if (this.headerBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.header_ != null && this.header_ != RequestHeader.getDefaultInstance()) {
                    this.getHeaderBuilder().mergeFrom(value);
                } else {
                    this.header_ = value;
                }
            } else {
                this.headerBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.header_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearHeader() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.header_ = null;
            if (this.headerBuilder_ != null) {
                this.headerBuilder_.dispose();
                this.headerBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RequestHeader.Builder getHeaderBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (RequestHeader.Builder)this.getHeaderFieldBuilder().getBuilder();
        }

        @Override
        public RequestHeaderOrBuilder getHeaderOrBuilder() {
            if (this.headerBuilder_ != null) {
                return (RequestHeaderOrBuilder)this.headerBuilder_.getMessageOrBuilder();
            }
            return this.header_ == null ? RequestHeader.getDefaultInstance() : this.header_;
        }

        private SingleFieldBuilderV3<RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder> getHeaderFieldBuilder() {
            if (this.headerBuilder_ == null) {
                this.headerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getHeader(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.header_ = null;
            }
            return this.headerBuilder_;
        }

        @Override
        public String getParent() {
            Object ref = this.parent_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.parent_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getParentBytes() {
            Object ref = this.parent_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.parent_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setParent(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.parent_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearParent() {
            this.parent_ = ListVehiclesRequest.getDefaultInstance().getParent();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setParentBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.parent_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getPageSize() {
            return this.pageSize_;
        }

        public Builder setPageSize(int value) {
            this.pageSize_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearPageSize() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.pageSize_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getPageToken() {
            Object ref = this.pageToken_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.pageToken_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPageTokenBytes() {
            Object ref = this.pageToken_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.pageToken_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPageToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.pageToken_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearPageToken() {
            this.pageToken_ = ListVehiclesRequest.getDefaultInstance().getPageToken();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setPageTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.pageToken_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMinimumCapacity() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Int32Value getMinimumCapacity() {
            if (this.minimumCapacityBuilder_ == null) {
                return this.minimumCapacity_ == null ? Int32Value.getDefaultInstance() : this.minimumCapacity_;
            }
            return (Int32Value)this.minimumCapacityBuilder_.getMessage();
        }

        public Builder setMinimumCapacity(Int32Value value) {
            if (this.minimumCapacityBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.minimumCapacity_ = value;
            } else {
                this.minimumCapacityBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setMinimumCapacity(Int32Value.Builder builderForValue) {
            if (this.minimumCapacityBuilder_ == null) {
                this.minimumCapacity_ = builderForValue.build();
            } else {
                this.minimumCapacityBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeMinimumCapacity(Int32Value value) {
            if (this.minimumCapacityBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.minimumCapacity_ != null && this.minimumCapacity_ != Int32Value.getDefaultInstance()) {
                    this.getMinimumCapacityBuilder().mergeFrom(value);
                } else {
                    this.minimumCapacity_ = value;
                }
            } else {
                this.minimumCapacityBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.minimumCapacity_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMinimumCapacity() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.minimumCapacity_ = null;
            if (this.minimumCapacityBuilder_ != null) {
                this.minimumCapacityBuilder_.dispose();
                this.minimumCapacityBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getMinimumCapacityBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Int32Value.Builder)this.getMinimumCapacityFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getMinimumCapacityOrBuilder() {
            if (this.minimumCapacityBuilder_ != null) {
                return (Int32ValueOrBuilder)this.minimumCapacityBuilder_.getMessageOrBuilder();
            }
            return this.minimumCapacity_ == null ? Int32Value.getDefaultInstance() : this.minimumCapacity_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getMinimumCapacityFieldBuilder() {
            if (this.minimumCapacityBuilder_ == null) {
                this.minimumCapacityBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMinimumCapacity(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.minimumCapacity_ = null;
            }
            return this.minimumCapacityBuilder_;
        }

        private void ensureTripTypesIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.tripTypes_ = new ArrayList<Integer>(this.tripTypes_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<TripType> getTripTypesList() {
            return new Internal.ListAdapter(this.tripTypes_, tripTypes_converter_);
        }

        @Override
        public int getTripTypesCount() {
            return this.tripTypes_.size();
        }

        @Override
        public TripType getTripTypes(int index) {
            return (TripType)((Object)tripTypes_converter_.convert((Object)this.tripTypes_.get(index)));
        }

        public Builder setTripTypes(int index, TripType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTripTypesIsMutable();
            this.tripTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addTripTypes(TripType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTripTypesIsMutable();
            this.tripTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllTripTypes(Iterable<? extends TripType> values) {
            this.ensureTripTypesIsMutable();
            for (TripType tripType : values) {
                this.tripTypes_.add(tripType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearTripTypes() {
            this.tripTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getTripTypesValueList() {
            return Collections.unmodifiableList(this.tripTypes_);
        }

        @Override
        public int getTripTypesValue(int index) {
            return this.tripTypes_.get(index);
        }

        public Builder setTripTypesValue(int index, int value) {
            this.ensureTripTypesIsMutable();
            this.tripTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addTripTypesValue(int value) {
            this.ensureTripTypesIsMutable();
            this.tripTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllTripTypesValue(Iterable<Integer> values) {
            this.ensureTripTypesIsMutable();
            for (int value : values) {
                this.tripTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMaximumStaleness() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Duration getMaximumStaleness() {
            if (this.maximumStalenessBuilder_ == null) {
                return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
            }
            return (Duration)this.maximumStalenessBuilder_.getMessage();
        }

        public Builder setMaximumStaleness(Duration value) {
            if (this.maximumStalenessBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.maximumStaleness_ = value;
            } else {
                this.maximumStalenessBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setMaximumStaleness(Duration.Builder builderForValue) {
            if (this.maximumStalenessBuilder_ == null) {
                this.maximumStaleness_ = builderForValue.build();
            } else {
                this.maximumStalenessBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeMaximumStaleness(Duration value) {
            if (this.maximumStalenessBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.maximumStaleness_ != null && this.maximumStaleness_ != Duration.getDefaultInstance()) {
                    this.getMaximumStalenessBuilder().mergeFrom(value);
                } else {
                    this.maximumStaleness_ = value;
                }
            } else {
                this.maximumStalenessBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.maximumStaleness_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMaximumStaleness() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.maximumStaleness_ = null;
            if (this.maximumStalenessBuilder_ != null) {
                this.maximumStalenessBuilder_.dispose();
                this.maximumStalenessBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getMaximumStalenessBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Duration.Builder)this.getMaximumStalenessFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getMaximumStalenessOrBuilder() {
            if (this.maximumStalenessBuilder_ != null) {
                return (DurationOrBuilder)this.maximumStalenessBuilder_.getMessageOrBuilder();
            }
            return this.maximumStaleness_ == null ? Duration.getDefaultInstance() : this.maximumStaleness_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getMaximumStalenessFieldBuilder() {
            if (this.maximumStalenessBuilder_ == null) {
                this.maximumStalenessBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMaximumStaleness(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.maximumStaleness_ = null;
            }
            return this.maximumStalenessBuilder_;
        }

        private void ensureVehicleTypeCategoriesIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.vehicleTypeCategories_ = new ArrayList<Integer>(this.vehicleTypeCategories_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<Vehicle.VehicleType.Category> getVehicleTypeCategoriesList() {
            return new Internal.ListAdapter(this.vehicleTypeCategories_, vehicleTypeCategories_converter_);
        }

        @Override
        public int getVehicleTypeCategoriesCount() {
            return this.vehicleTypeCategories_.size();
        }

        @Override
        public Vehicle.VehicleType.Category getVehicleTypeCategories(int index) {
            return (Vehicle.VehicleType.Category)((Object)vehicleTypeCategories_converter_.convert((Object)this.vehicleTypeCategories_.get(index)));
        }

        public Builder setVehicleTypeCategories(int index, Vehicle.VehicleType.Category value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureVehicleTypeCategoriesIsMutable();
            this.vehicleTypeCategories_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addVehicleTypeCategories(Vehicle.VehicleType.Category value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureVehicleTypeCategoriesIsMutable();
            this.vehicleTypeCategories_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllVehicleTypeCategories(Iterable<? extends Vehicle.VehicleType.Category> values) {
            this.ensureVehicleTypeCategoriesIsMutable();
            for (Vehicle.VehicleType.Category category : values) {
                this.vehicleTypeCategories_.add(category.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearVehicleTypeCategories() {
            this.vehicleTypeCategories_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getVehicleTypeCategoriesValueList() {
            return Collections.unmodifiableList(this.vehicleTypeCategories_);
        }

        @Override
        public int getVehicleTypeCategoriesValue(int index) {
            return this.vehicleTypeCategories_.get(index);
        }

        public Builder setVehicleTypeCategoriesValue(int index, int value) {
            this.ensureVehicleTypeCategoriesIsMutable();
            this.vehicleTypeCategories_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addVehicleTypeCategoriesValue(int value) {
            this.ensureVehicleTypeCategoriesIsMutable();
            this.vehicleTypeCategories_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllVehicleTypeCategoriesValue(Iterable<Integer> values) {
            this.ensureVehicleTypeCategoriesIsMutable();
            for (int value : values) {
                this.vehicleTypeCategories_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureRequiredAttributesIsMutable() {
            if (!this.requiredAttributes_.isModifiable()) {
                this.requiredAttributes_ = new LazyStringArrayList((LazyStringList)this.requiredAttributes_);
            }
            this.bitField0_ |= 0x100;
        }

        public ProtocolStringList getRequiredAttributesList() {
            this.requiredAttributes_.makeImmutable();
            return this.requiredAttributes_;
        }

        @Override
        public int getRequiredAttributesCount() {
            return this.requiredAttributes_.size();
        }

        @Override
        public String getRequiredAttributes(int index) {
            return this.requiredAttributes_.get(index);
        }

        @Override
        public ByteString getRequiredAttributesBytes(int index) {
            return this.requiredAttributes_.getByteString(index);
        }

        public Builder setRequiredAttributes(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequiredAttributesIsMutable();
            this.requiredAttributes_.set(index, value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addRequiredAttributes(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequiredAttributesIsMutable();
            this.requiredAttributes_.add((Object)value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAllRequiredAttributes(Iterable<String> values) {
            this.ensureRequiredAttributesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.requiredAttributes_);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearRequiredAttributes() {
            this.requiredAttributes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addRequiredAttributesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureRequiredAttributesIsMutable();
            this.requiredAttributes_.add(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        private void ensureRequiredOneOfAttributesIsMutable() {
            if (!this.requiredOneOfAttributes_.isModifiable()) {
                this.requiredOneOfAttributes_ = new LazyStringArrayList((LazyStringList)this.requiredOneOfAttributes_);
            }
            this.bitField0_ |= 0x200;
        }

        public ProtocolStringList getRequiredOneOfAttributesList() {
            this.requiredOneOfAttributes_.makeImmutable();
            return this.requiredOneOfAttributes_;
        }

        @Override
        public int getRequiredOneOfAttributesCount() {
            return this.requiredOneOfAttributes_.size();
        }

        @Override
        public String getRequiredOneOfAttributes(int index) {
            return this.requiredOneOfAttributes_.get(index);
        }

        @Override
        public ByteString getRequiredOneOfAttributesBytes(int index) {
            return this.requiredOneOfAttributes_.getByteString(index);
        }

        public Builder setRequiredOneOfAttributes(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequiredOneOfAttributesIsMutable();
            this.requiredOneOfAttributes_.set(index, value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addRequiredOneOfAttributes(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequiredOneOfAttributesIsMutable();
            this.requiredOneOfAttributes_.add((Object)value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addAllRequiredOneOfAttributes(Iterable<String> values) {
            this.ensureRequiredOneOfAttributesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.requiredOneOfAttributes_);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearRequiredOneOfAttributes() {
            this.requiredOneOfAttributes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder addRequiredOneOfAttributesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureRequiredOneOfAttributesIsMutable();
            this.requiredOneOfAttributes_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        private void ensureRequiredOneOfAttributeSetsIsMutable() {
            if (!this.requiredOneOfAttributeSets_.isModifiable()) {
                this.requiredOneOfAttributeSets_ = new LazyStringArrayList((LazyStringList)this.requiredOneOfAttributeSets_);
            }
            this.bitField0_ |= 0x400;
        }

        public ProtocolStringList getRequiredOneOfAttributeSetsList() {
            this.requiredOneOfAttributeSets_.makeImmutable();
            return this.requiredOneOfAttributeSets_;
        }

        @Override
        public int getRequiredOneOfAttributeSetsCount() {
            return this.requiredOneOfAttributeSets_.size();
        }

        @Override
        public String getRequiredOneOfAttributeSets(int index) {
            return this.requiredOneOfAttributeSets_.get(index);
        }

        @Override
        public ByteString getRequiredOneOfAttributeSetsBytes(int index) {
            return this.requiredOneOfAttributeSets_.getByteString(index);
        }

        public Builder setRequiredOneOfAttributeSets(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequiredOneOfAttributeSetsIsMutable();
            this.requiredOneOfAttributeSets_.set(index, value);
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder addRequiredOneOfAttributeSets(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequiredOneOfAttributeSetsIsMutable();
            this.requiredOneOfAttributeSets_.add((Object)value);
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder addAllRequiredOneOfAttributeSets(Iterable<String> values) {
            this.ensureRequiredOneOfAttributeSetsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.requiredOneOfAttributeSets_);
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearRequiredOneOfAttributeSets() {
            this.requiredOneOfAttributeSets_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder addRequiredOneOfAttributeSetsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureRequiredOneOfAttributeSetsIsMutable();
            this.requiredOneOfAttributeSets_.add(value);
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public int getVehicleStateValue() {
            return this.vehicleState_;
        }

        public Builder setVehicleStateValue(int value) {
            this.vehicleState_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public VehicleState getVehicleState() {
            VehicleState result = VehicleState.forNumber(this.vehicleState_);
            return result == null ? VehicleState.UNRECOGNIZED : result;
        }

        public Builder setVehicleState(VehicleState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x800;
            this.vehicleState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearVehicleState() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.vehicleState_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getOnTripOnly() {
            return this.onTripOnly_;
        }

        public Builder setOnTripOnly(boolean value) {
            this.onTripOnly_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearOnTripOnly() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.onTripOnly_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getFilter() {
            Object ref = this.filter_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.filter_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFilterBytes() {
            Object ref = this.filter_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.filter_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFilter(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.filter_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearFilter() {
            this.filter_ = ListVehiclesRequest.getDefaultInstance().getFilter();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        public Builder setFilterBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListVehiclesRequest.checkByteStringIsUtf8((ByteString)value);
            this.filter_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasViewport() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public Viewport getViewport() {
            if (this.viewportBuilder_ == null) {
                return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
            }
            return (Viewport)this.viewportBuilder_.getMessage();
        }

        public Builder setViewport(Viewport value) {
            if (this.viewportBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.viewport_ = value;
            } else {
                this.viewportBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder setViewport(Viewport.Builder builderForValue) {
            if (this.viewportBuilder_ == null) {
                this.viewport_ = builderForValue.build();
            } else {
                this.viewportBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder mergeViewport(Viewport value) {
            if (this.viewportBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0 && this.viewport_ != null && this.viewport_ != Viewport.getDefaultInstance()) {
                    this.getViewportBuilder().mergeFrom(value);
                } else {
                    this.viewport_ = value;
                }
            } else {
                this.viewportBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.viewport_ != null) {
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearViewport() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.viewport_ = null;
            if (this.viewportBuilder_ != null) {
                this.viewportBuilder_.dispose();
                this.viewportBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Viewport.Builder getViewportBuilder() {
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return (Viewport.Builder)this.getViewportFieldBuilder().getBuilder();
        }

        @Override
        public ViewportOrBuilder getViewportOrBuilder() {
            if (this.viewportBuilder_ != null) {
                return (ViewportOrBuilder)this.viewportBuilder_.getMessageOrBuilder();
            }
            return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
        }

        private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> getViewportFieldBuilder() {
            if (this.viewportBuilder_ == null) {
                this.viewportBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getViewport(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.viewport_ = null;
            }
            return this.viewportBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

