/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.compose;

import androidx.compose.runtime.AbstractApplier;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import com.google.maps.android.compose.CircleNode;
import com.google.maps.android.compose.ComposeInfoWindowAdapter;
import com.google.maps.android.compose.DragState;
import com.google.maps.android.compose.GroundOverlayNode;
import com.google.maps.android.compose.MapApplierKt;
import com.google.maps.android.compose.MapNode;
import com.google.maps.android.compose.MapNodeRoot;
import com.google.maps.android.compose.MarkerNode;
import com.google.maps.android.compose.MarkerState;
import com.google.maps.android.compose.PolygonNode;
import com.google.maps.android.compose.PolylineNode;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0014J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/google/maps/android/compose/MapApplier;", "Landroidx/compose/runtime/AbstractApplier;", "Lcom/google/maps/android/compose/MapNode;", "map", "Lcom/google/android/gms/maps/GoogleMap;", "mapView", "Lcom/google/android/gms/maps/MapView;", "(Lcom/google/android/gms/maps/GoogleMap;Lcom/google/android/gms/maps/MapView;)V", "decorations", "", "getMap", "()Lcom/google/android/gms/maps/GoogleMap;", "attachClickListeners", "", "insertBottomUp", "index", "", "instance", "insertTopDown", "move", "from", "to", "count", "onClear", "remove", "maps-compose_release"})
public final class MapApplier
extends AbstractApplier<MapNode> {
    @NotNull
    private final GoogleMap map;
    @NotNull
    private final MapView mapView;
    @NotNull
    private final List<MapNode> decorations;

    public MapApplier(@NotNull GoogleMap map, @NotNull MapView mapView) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        super((Object)MapNodeRoot.INSTANCE);
        this.map = map;
        this.mapView = mapView;
        this.decorations = new ArrayList();
        this.attachClickListeners();
    }

    @NotNull
    public final GoogleMap getMap() {
        return this.map;
    }

    protected void onClear() {
        this.map.clear();
        Iterable $this$forEach$iv = this.decorations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MapNode it = (MapNode)element$iv;
            boolean bl = false;
            it.onCleared();
        }
        this.decorations.clear();
    }

    public void insertBottomUp(int index, @NotNull MapNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.decorations.add(index, instance);
        instance.onAttached();
    }

    public void insertTopDown(int index, @NotNull MapNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
    }

    public void move(int from, int to, int count) {
        this.move(this.decorations, from, to, count);
    }

    public void remove(int index, int count) {
        int n = 0;
        while (n < count) {
            int n2;
            int it = n2 = n++;
            boolean bl = false;
            this.decorations.get(index + it).onRemoved();
        }
        this.remove(this.decorations, index, count);
    }

    private final void attachClickListeners() {
        this.map.setOnCircleClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-2(this, arg_0));
        this.map.setOnGroundOverlayClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-3(this, arg_0));
        this.map.setOnPolygonClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-4(this, arg_0));
        this.map.setOnPolylineClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-5(this, arg_0));
        this.map.setOnMarkerClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-6(this, arg_0));
        this.map.setOnInfoWindowClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-7(this, arg_0));
        this.map.setOnInfoWindowCloseListener(arg_0 -> MapApplier.attachClickListeners$lambda-8(this, arg_0));
        this.map.setOnInfoWindowLongClickListener(arg_0 -> MapApplier.attachClickListeners$lambda-9(this, arg_0));
        this.map.setOnMarkerDragListener(new GoogleMap.OnMarkerDragListener(this){
            final /* synthetic */ MapApplier this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMarkerDrag(@NotNull Marker marker) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                MarkerNode $this$onMarkerDrag_u24lambda_u2d0 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker);
                boolean bl = false;
                MarkerNode markerNode = $this$onMarkerDrag_u24lambda_u2d0;
                MarkerState markerState = markerNode == null ? null : markerNode.getMarkerState();
                if (markerState != null) {
                    LatLng latLng = marker.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"marker.position");
                    markerState.setPosition(latLng);
                }
                MarkerNode markerNode2 = $this$onMarkerDrag_u24lambda_u2d0;
                MarkerState markerState2 = markerNode2 == null ? null : markerNode2.getMarkerState();
                if (markerState2 != null) {
                    markerState2.setDragState$maps_compose_release(DragState.DRAG);
                }
            }

            public void onMarkerDragEnd(@NotNull Marker marker) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                MarkerNode $this$onMarkerDragEnd_u24lambda_u2d1 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker);
                boolean bl = false;
                MarkerNode markerNode = $this$onMarkerDragEnd_u24lambda_u2d1;
                MarkerState markerState = markerNode == null ? null : markerNode.getMarkerState();
                if (markerState != null) {
                    LatLng latLng = marker.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"marker.position");
                    markerState.setPosition(latLng);
                }
                MarkerNode markerNode2 = $this$onMarkerDragEnd_u24lambda_u2d1;
                MarkerState markerState2 = markerNode2 == null ? null : markerNode2.getMarkerState();
                if (markerState2 != null) {
                    markerState2.setDragState$maps_compose_release(DragState.END);
                }
            }

            public void onMarkerDragStart(@NotNull Marker marker) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                MarkerNode $this$onMarkerDragStart_u24lambda_u2d2 = MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), marker);
                boolean bl = false;
                MarkerNode markerNode = $this$onMarkerDragStart_u24lambda_u2d2;
                MarkerState markerState = markerNode == null ? null : markerNode.getMarkerState();
                if (markerState != null) {
                    LatLng latLng = marker.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"marker.position");
                    markerState.setPosition(latLng);
                }
                MarkerNode markerNode2 = $this$onMarkerDragStart_u24lambda_u2d2;
                MarkerState markerState2 = markerNode2 == null ? null : markerNode2.getMarkerState();
                if (markerState2 != null) {
                    markerState2.setDragState$maps_compose_release(DragState.START);
                }
            }
        });
        this.map.setInfoWindowAdapter((GoogleMap.InfoWindowAdapter)new ComposeInfoWindowAdapter(this.mapView, (Function1<? super Marker, MarkerNode>)((Function1)new Function1<Marker, MarkerNode>(this){
            final /* synthetic */ MapApplier this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final MarkerNode invoke(@NotNull Marker it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MapApplierKt.access$nodeForMarker(MapApplier.access$getDecorations$p(this.this$0), it);
            }
        })));
    }

    private static final void attachClickListeners$lambda-2(MapApplier this$0, Circle it) {
        Function1<Circle, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CircleNode circleNode = MapApplierKt.access$nodeForCircle(this$0.decorations, it);
        if (circleNode != null && (function1 = circleNode.getOnCircleClick()) != null) {
            function1.invoke((Object)it);
        }
    }

    private static final void attachClickListeners$lambda-3(MapApplier this$0, GroundOverlay it) {
        Function1<GroundOverlay, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GroundOverlayNode groundOverlayNode = MapApplierKt.access$nodeForGroundOverlay(this$0.decorations, it);
        if (groundOverlayNode != null && (function1 = groundOverlayNode.getOnGroundOverlayClick()) != null) {
            function1.invoke((Object)it);
        }
    }

    private static final void attachClickListeners$lambda-4(MapApplier this$0, Polygon it) {
        Function1<Polygon, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PolygonNode polygonNode = MapApplierKt.access$nodeForPolygon(this$0.decorations, it);
        if (polygonNode != null && (function1 = polygonNode.getOnPolygonClick()) != null) {
            function1.invoke((Object)it);
        }
    }

    private static final void attachClickListeners$lambda-5(MapApplier this$0, Polyline it) {
        Function1<Polyline, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PolylineNode polylineNode = MapApplierKt.access$nodeForPolyline(this$0.decorations, it);
        if (polylineNode != null && (function1 = polylineNode.getOnPolylineClick()) != null) {
            function1.invoke((Object)it);
        }
    }

    private static final boolean attachClickListeners$lambda-6(MapApplier this$0, Marker marker) {
        Boolean bl;
        Function1<Marker, Boolean> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = MapApplierKt.access$nodeForMarker(this$0.decorations, marker);
        return markerNode == null ? false : ((function1 = markerNode.getOnMarkerClick()) == null ? false : ((bl = (Boolean)function1.invoke((Object)marker)) == null ? false : bl));
    }

    private static final void attachClickListeners$lambda-7(MapApplier this$0, Marker marker) {
        Function1<Marker, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = MapApplierKt.access$nodeForMarker(this$0.decorations, marker);
        if (markerNode != null && (function1 = markerNode.getOnInfoWindowClick()) != null) {
            function1.invoke((Object)marker);
        }
    }

    private static final void attachClickListeners$lambda-8(MapApplier this$0, Marker marker) {
        Function1<Marker, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = MapApplierKt.access$nodeForMarker(this$0.decorations, marker);
        if (markerNode != null && (function1 = markerNode.getOnInfoWindowClose()) != null) {
            function1.invoke((Object)marker);
        }
    }

    private static final void attachClickListeners$lambda-9(MapApplier this$0, Marker marker) {
        Function1<Marker, Unit> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = MapApplierKt.access$nodeForMarker(this$0.decorations, marker);
        if (markerNode != null && (function1 = markerNode.getOnInfoWindowLongClick()) != null) {
            function1.invoke((Object)marker);
        }
    }

    public static final /* synthetic */ List access$getDecorations$p(MapApplier $this) {
        return $this.decorations;
    }
}

