/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.quadtree;

import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.geometry.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002'(B\u001b\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0013\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0015H\u0002J\u0013\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u0015J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010$\u001a\u00020\u0005J\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/google/maps/android/quadtree/PointQuadTree;", "T", "Lcom/google/maps/android/quadtree/PointQuadTree$Item;", "", "mBounds", "Lcom/google/maps/android/geometry/Bounds;", "mDepth", "", "<init>", "(Lcom/google/maps/android/geometry/Bounds;I)V", "minX", "", "maxX", "minY", "maxY", "(DDDD)V", "mItems", "", "mChildren", "", "add", "", "item", "(Lcom/google/maps/android/quadtree/PointQuadTree$Item;)V", "insert", "x", "y", "(DDLcom/google/maps/android/quadtree/PointQuadTree$Item;)V", "split", "remove", "", "(Lcom/google/maps/android/quadtree/PointQuadTree$Item;)Z", "(DDLcom/google/maps/android/quadtree/PointQuadTree$Item;)Z", "clear", "search", "", "searchBounds", "results", "", "Item", "Companion", "library_release"})
public final class PointQuadTree<T extends Item> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bounds mBounds;
    private final int mDepth;
    @Nullable
    private Set<T> mItems;
    @Nullable
    private List<PointQuadTree<T>> mChildren;
    private static final int MAX_ELEMENTS = 50;
    private static final int MAX_DEPTH = 40;

    @JvmOverloads
    public PointQuadTree(@NotNull Bounds mBounds, int mDepth) {
        Intrinsics.checkNotNullParameter((Object)mBounds, (String)"mBounds");
        this.mBounds = mBounds;
        this.mDepth = mDepth;
    }

    public /* synthetic */ PointQuadTree(Bounds bounds, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(bounds, n);
    }

    public PointQuadTree(double minX, double maxX, double minY, double maxY) {
        this(new Bounds(minX, maxX, minY, maxY), 0, 2, null);
    }

    public final void add(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Point point = item.getPoint();
        if (this.mBounds.contains(point.x, point.y)) {
            this.insert(point.x, point.y, item);
        }
    }

    private final void insert(double x, double y, T item) {
        if (this.mChildren != null) {
            if (y < this.mBounds.midY) {
                if (x < this.mBounds.midX) {
                    List<PointQuadTree<T>> list = this.mChildren;
                    Intrinsics.checkNotNull(list);
                    super.insert(x, y, item);
                } else {
                    List<PointQuadTree<T>> list = this.mChildren;
                    Intrinsics.checkNotNull(list);
                    super.insert(x, y, item);
                }
            } else if (x < this.mBounds.midX) {
                List<PointQuadTree<T>> list = this.mChildren;
                Intrinsics.checkNotNull(list);
                super.insert(x, y, item);
            } else {
                List<PointQuadTree<T>> list = this.mChildren;
                Intrinsics.checkNotNull(list);
                super.insert(x, y, item);
            }
            return;
        }
        if (this.mItems == null) {
            this.mItems = new LinkedHashSet();
        }
        Set<T> set = this.mItems;
        Intrinsics.checkNotNull(set);
        set.add(item);
        Set<T> set2 = this.mItems;
        Intrinsics.checkNotNull(set2);
        if (set2.size() > 50 && this.mDepth < 40) {
            this.split();
        }
    }

    private final void split() {
        this.mChildren = new ArrayList(4);
        List<PointQuadTree<T>> list = this.mChildren;
        Intrinsics.checkNotNull(list);
        list.add(new PointQuadTree<T>(new Bounds(this.mBounds.minX, this.mBounds.midX, this.mBounds.minY, this.mBounds.midY), this.mDepth + 1));
        List<PointQuadTree<T>> list2 = this.mChildren;
        Intrinsics.checkNotNull(list2);
        list2.add(new PointQuadTree<T>(new Bounds(this.mBounds.midX, this.mBounds.maxX, this.mBounds.minY, this.mBounds.midY), this.mDepth + 1));
        List<PointQuadTree<T>> list3 = this.mChildren;
        Intrinsics.checkNotNull(list3);
        list3.add(new PointQuadTree<T>(new Bounds(this.mBounds.minX, this.mBounds.midX, this.mBounds.midY, this.mBounds.maxY), this.mDepth + 1));
        List<PointQuadTree<T>> list4 = this.mChildren;
        Intrinsics.checkNotNull(list4);
        list4.add(new PointQuadTree<T>(new Bounds(this.mBounds.midX, this.mBounds.maxX, this.mBounds.midY, this.mBounds.maxY), this.mDepth + 1));
        Set<T> items = this.mItems;
        this.mItems = null;
        if (items != null) {
            for (Item item : items) {
                this.insert(item.getPoint().x, item.getPoint().y, item);
            }
        }
    }

    public final boolean remove(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Point point = item.getPoint();
        return this.mBounds.contains(point.x, point.y) ? this.remove(point.x, point.y, item) : false;
    }

    private final boolean remove(double x, double y, T item) {
        boolean bl;
        if (this.mChildren != null) {
            if (y < this.mBounds.midY) {
                if (x < this.mBounds.midX) {
                    List<PointQuadTree<T>> list = this.mChildren;
                    Intrinsics.checkNotNull(list);
                    bl = super.remove(x, y, item);
                } else {
                    List<PointQuadTree<T>> list = this.mChildren;
                    Intrinsics.checkNotNull(list);
                    bl = super.remove(x, y, item);
                }
            } else if (x < this.mBounds.midX) {
                List<PointQuadTree<T>> list = this.mChildren;
                Intrinsics.checkNotNull(list);
                bl = super.remove(x, y, item);
            } else {
                List<PointQuadTree<T>> list = this.mChildren;
                Intrinsics.checkNotNull(list);
                bl = super.remove(x, y, item);
            }
        } else if (this.mItems == null) {
            bl = false;
        } else {
            Set<T> set = this.mItems;
            Intrinsics.checkNotNull(set);
            bl = set.remove(item);
        }
        return bl;
    }

    public final void clear() {
        this.mChildren = null;
        if (this.mItems != null) {
            Set<T> set = this.mItems;
            Intrinsics.checkNotNull(set);
            set.clear();
        }
    }

    @NotNull
    public final Collection<T> search(@NotNull Bounds searchBounds) {
        Intrinsics.checkNotNullParameter((Object)searchBounds, (String)"searchBounds");
        List results = new ArrayList();
        this.search(searchBounds, results);
        return results;
    }

    private final void search(Bounds searchBounds, Collection<T> results) {
        block6: {
            block5: {
                if (!this.mBounds.intersects(searchBounds)) {
                    return;
                }
                if (this.mChildren == null) break block5;
                List<PointQuadTree<T>> list = this.mChildren;
                Intrinsics.checkNotNull(list);
                for (PointQuadTree<T> quad : list) {
                    super.search(searchBounds, results);
                }
                break block6;
            }
            if (this.mItems == null) break block6;
            if (searchBounds.contains(this.mBounds)) {
                Set<T> set = this.mItems;
                Intrinsics.checkNotNull(set);
                results.addAll((Collection)set);
            } else {
                Set<T> set = this.mItems;
                Intrinsics.checkNotNull(set);
                for (Item item : set) {
                    if (!searchBounds.contains(item.getPoint())) continue;
                    results.add(item);
                }
            }
        }
    }

    @JvmOverloads
    public PointQuadTree(@NotNull Bounds mBounds) {
        Intrinsics.checkNotNullParameter((Object)mBounds, (String)"mBounds");
        this(mBounds, 0, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/maps/android/quadtree/PointQuadTree$Companion;", "", "<init>", "()V", "MAX_ELEMENTS", "", "MAX_DEPTH", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/google/maps/android/quadtree/PointQuadTree$Item;", "", "point", "Lcom/google/maps/android/geometry/Point;", "getPoint", "()Lcom/google/maps/android/geometry/Point;", "library_release"})
    public static interface Item {
        @NotNull
        public Point getPoint();
    }
}

