/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.heatmaps;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.projection.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import com.google.maps.android.quadtree.PointQuadTree;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/google/maps/android/heatmaps/WeightedLatLng;", "Lcom/google/maps/android/quadtree/PointQuadTree$Item;", "latLng", "Lcom/google/android/gms/maps/model/LatLng;", "point", "Lcom/google/maps/android/geometry/Point;", "intensity", "", "<init>", "(Lcom/google/android/gms/maps/model/LatLng;Lcom/google/maps/android/geometry/Point;D)V", "(Lcom/google/android/gms/maps/model/LatLng;D)V", "getLatLng", "()Lcom/google/android/gms/maps/model/LatLng;", "getPoint", "()Lcom/google/maps/android/geometry/Point;", "getIntensity", "()D", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "library_release"})
public final class WeightedLatLng
implements PointQuadTree.Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LatLng latLng;
    @NotNull
    private final com.google.maps.android.geometry.Point point;
    private final double intensity;
    public static final double DEFAULT_INTENSITY = 1.0;
    @NotNull
    private static final SphericalMercatorProjection sProjection = new SphericalMercatorProjection(1.0);

    public WeightedLatLng(@NotNull LatLng latLng, @NotNull com.google.maps.android.geometry.Point point, double intensity) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.latLng = latLng;
        this.point = point;
        this.intensity = intensity;
    }

    @NotNull
    public final LatLng getLatLng() {
        return this.latLng;
    }

    @Override
    @NotNull
    public com.google.maps.android.geometry.Point getPoint() {
        return this.point;
    }

    public final double getIntensity() {
        return this.intensity;
    }

    @JvmOverloads
    public WeightedLatLng(@NotNull LatLng latLng, double intensity) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        Point point = sProjection.toPoint(latLng);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"toPoint(...)");
        this(latLng, point, intensity >= 0.0 ? intensity : 1.0);
    }

    public /* synthetic */ WeightedLatLng(LatLng latLng, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(latLng, d);
    }

    @NotNull
    public final LatLng component1() {
        return this.latLng;
    }

    @NotNull
    public final com.google.maps.android.geometry.Point component2() {
        return this.point;
    }

    public final double component3() {
        return this.intensity;
    }

    @NotNull
    public final WeightedLatLng copy(@NotNull LatLng latLng, @NotNull com.google.maps.android.geometry.Point point, double intensity) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return new WeightedLatLng(latLng, point, intensity);
    }

    public static /* synthetic */ WeightedLatLng copy$default(WeightedLatLng weightedLatLng, LatLng latLng, com.google.maps.android.geometry.Point point, double d, int n, Object object) {
        if ((n & 1) != 0) {
            latLng = weightedLatLng.latLng;
        }
        if ((n & 2) != 0) {
            point = weightedLatLng.point;
        }
        if ((n & 4) != 0) {
            d = weightedLatLng.intensity;
        }
        return weightedLatLng.copy(latLng, point, d);
    }

    @NotNull
    public String toString() {
        return "WeightedLatLng(latLng=" + this.latLng + ", point=" + this.point + ", intensity=" + this.intensity + ")";
    }

    public int hashCode() {
        int result = this.latLng.hashCode();
        result = result * 31 + this.point.hashCode();
        result = result * 31 + Double.hashCode(this.intensity);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WeightedLatLng)) {
            return false;
        }
        WeightedLatLng weightedLatLng = (WeightedLatLng)other;
        if (!Intrinsics.areEqual((Object)this.latLng, (Object)weightedLatLng.latLng)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.point, (Object)weightedLatLng.point)) {
            return false;
        }
        return Double.compare(this.intensity, weightedLatLng.intensity) == 0;
    }

    @JvmOverloads
    public WeightedLatLng(@NotNull LatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        this(latLng, 0.0, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/maps/android/heatmaps/WeightedLatLng$Companion;", "", "<init>", "()V", "DEFAULT_INTENSITY", "", "sProjection", "Lcom/google/maps/android/projection/SphericalMercatorProjection;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

