/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.heatmaps;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Tile;
import com.google.android.gms.maps.model.TileProvider;
import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.geometry.Point;
import com.google.maps.android.heatmaps.Gradient;
import com.google.maps.android.heatmaps.WeightedLatLng;
import com.google.maps.android.quadtree.PointQuadTree;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0014\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007H\u0007J\u0014\u0010\u001f\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007J\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000eJ \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/google/maps/android/heatmaps/HeatmapTileProvider;", "Lcom/google/android/gms/maps/model/TileProvider;", "builder", "Lcom/google/maps/android/heatmaps/HeatmapTileProvider$Builder;", "<init>", "(Lcom/google/maps/android/heatmaps/HeatmapTileProvider$Builder;)V", "data", "", "Lcom/google/maps/android/heatmaps/WeightedLatLng;", "radius", "", "gradient", "Lcom/google/maps/android/heatmaps/Gradient;", "opacity", "", "customMaxIntensity", "tree", "Lcom/google/maps/android/quadtree/PointQuadTree;", "bounds", "Lcom/google/maps/android/geometry/Bounds;", "colorMap", "", "kernel", "", "maxIntensity", "setWeightedData", "", "updateData", "setData", "latLngs", "Lcom/google/android/gms/maps/model/LatLng;", "updateLatLngs", "setGradient", "setRadius", "setOpacity", "setMaxIntensity", "intensity", "getTile", "Lcom/google/android/gms/maps/model/Tile;", "x", "y", "zoom", "getMaxIntensities", "Builder", "Companion", "library_release"})
@SourceDebugExtension(value={"SMAP\nHeatmapTileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeatmapTileProvider.kt\ncom/google/maps/android/heatmaps/HeatmapTileProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,426:1\n1#2:427\n1869#3,2:428\n1869#3,2:430\n*S KotlinDebug\n*F\n+ 1 HeatmapTileProvider.kt\ncom/google/maps/android/heatmaps/HeatmapTileProvider\n*L\n248#1:428,2\n254#1:430,2\n*E\n"})
public final class HeatmapTileProvider
implements TileProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Collection<WeightedLatLng> data;
    private int radius;
    @NotNull
    private Gradient gradient;
    private double opacity;
    private double customMaxIntensity;
    private PointQuadTree<WeightedLatLng> tree;
    private Bounds bounds;
    private int[] colorMap;
    @NotNull
    private double[] kernel;
    private double[] maxIntensity;
    public static final int DEFAULT_RADIUS = 20;
    public static final double DEFAULT_OPACITY = 0.7;
    @NotNull
    private static final int[] DEFAULT_GRADIENT_COLORS;
    @NotNull
    private static final float[] DEFAULT_GRADIENT_START_POINTS;
    @JvmField
    @NotNull
    public static final Gradient DEFAULT_GRADIENT;
    public static final double WORLD_WIDTH = 1.0;
    private static final int TILE_DIM = 512;
    private static final int SCREEN_SIZE = 1280;
    private static final int DEFAULT_MIN_ZOOM = 5;
    private static final int DEFAULT_MAX_ZOOM = 11;
    private static final int MAX_ZOOM_LEVEL = 22;
    public static final int MIN_RADIUS = 10;
    public static final int MAX_RADIUS = 50;

    private HeatmapTileProvider(Builder builder) {
        Collection<WeightedLatLng> collection = builder.getWeightedData$library_release();
        Intrinsics.checkNotNull(collection);
        this.data = collection;
        this.radius = builder.getRadius$library_release();
        this.gradient = builder.getGradient$library_release();
        this.opacity = builder.getOpacity$library_release();
        this.customMaxIntensity = builder.getIntensity$library_release();
        this.kernel = Companion.generateKernel(this.radius, (double)this.radius / 3.0);
        this.setGradient(this.gradient);
        this.updateData(this.data);
    }

    @Deprecated(message="Use updateData(Collection<WeightedLatLng>) instead.", replaceWith=@ReplaceWith(expression="updateData(data)", imports={}))
    public final void setWeightedData(@NotNull Collection<WeightedLatLng> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.updateData(data);
    }

    public final void updateData(@NotNull Collection<WeightedLatLng> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        if (!(!this.data.isEmpty())) {
            boolean $i$a$-require-HeatmapTileProvider$updateData$22 = false;
            String $i$a$-require-HeatmapTileProvider$updateData$22 = "No input points.";
            throw new IllegalArgumentException($i$a$-require-HeatmapTileProvider$updateData$22.toString());
        }
        this.bounds = Companion.getBounds(this.data);
        Bounds bounds = this.bounds;
        if (bounds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            bounds = null;
        }
        this.tree = new PointQuadTree(bounds, 0, 2, null);
        for (WeightedLatLng l : this.data) {
            PointQuadTree<WeightedLatLng> pointQuadTree = this.tree;
            if (pointQuadTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                pointQuadTree = null;
            }
            pointQuadTree.add((WeightedLatLng)((PointQuadTree.Item)l));
        }
        this.maxIntensity = this.getMaxIntensities(this.radius);
    }

    @Deprecated(message="Use updateLatLngs(Collection<LatLng>) instead.", replaceWith=@ReplaceWith(expression="updateLatLngs(latLngs)", imports={}))
    public final void setData(@NotNull Collection<LatLng> latLngs) {
        Intrinsics.checkNotNullParameter(latLngs, (String)"latLngs");
        this.updateLatLngs(latLngs);
    }

    public final void updateLatLngs(@NotNull Collection<LatLng> latLngs) {
        Intrinsics.checkNotNullParameter(latLngs, (String)"latLngs");
        this.updateData(HeatmapTileProvider.Companion.wrapData(latLngs));
    }

    public final void setGradient(@NotNull Gradient gradient) {
        Intrinsics.checkNotNullParameter((Object)gradient, (String)"gradient");
        this.gradient = gradient;
        this.colorMap = gradient.generateColorMap(this.opacity);
    }

    public final void setRadius(int radius) {
        this.radius = radius;
        this.kernel = Companion.generateKernel(this.radius, (double)this.radius / 3.0);
        this.maxIntensity = this.getMaxIntensities(this.radius);
    }

    public final void setOpacity(double opacity) {
        this.opacity = opacity;
        this.setGradient(this.gradient);
    }

    public final void setMaxIntensity(double intensity) {
        this.customMaxIntensity = intensity;
        this.updateData(this.data);
    }

    @NotNull
    public Tile getTile(int x, int y, int zoom) {
        double[] dArray;
        int bucketY;
        int bucketX;
        Point p;
        WeightedLatLng w;
        Collection<WeightedLatLng> points;
        Bounds paddedBounds;
        double tileWidth = 1.0 / Math.pow(2.0, zoom);
        double padding = tileWidth * (double)this.radius / (double)512;
        double tileWidthPadded = tileWidth + (double)2 * padding;
        double bucketWidth = tileWidthPadded / (double)(512 + this.radius * 2);
        double minX = (double)x * tileWidth - padding;
        double maxX = (double)(x + 1) * tileWidth + padding;
        double minY = (double)y * tileWidth - padding;
        double maxY = (double)(y + 1) * tileWidth + padding;
        double xOffset = 0.0;
        Collection<WeightedLatLng> wrappedPoints = CollectionsKt.emptyList();
        if (minX < 0.0) {
            overlapBounds = new Bounds(minX + 1.0, 1.0, minY, maxY);
            xOffset = -1.0;
            PointQuadTree<WeightedLatLng> pointQuadTree = this.tree;
            if (pointQuadTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                pointQuadTree = null;
            }
            wrappedPoints = pointQuadTree.search(overlapBounds);
        } else if (maxX > 1.0) {
            overlapBounds = new Bounds(0.0, maxX - 1.0, minY, maxY);
            xOffset = 1.0;
            PointQuadTree<WeightedLatLng> pointQuadTree = this.tree;
            if (pointQuadTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                pointQuadTree = null;
            }
            wrappedPoints = pointQuadTree.search(overlapBounds);
        }
        Bounds tileBounds = new Bounds(minX, maxX, minY, maxY);
        Bounds bounds = this.bounds;
        if (bounds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            bounds = null;
        }
        double d = bounds.minX - padding;
        Bounds bounds2 = this.bounds;
        if (bounds2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            bounds2 = null;
        }
        double d2 = bounds2.maxX + padding;
        Bounds bounds3 = this.bounds;
        if (bounds3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            bounds3 = null;
        }
        double d3 = bounds3.minY - padding;
        Bounds bounds4 = this.bounds;
        if (bounds4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
            bounds4 = null;
        }
        if (!tileBounds.intersects(paddedBounds = new Bounds(d, d2, d3, bounds4.maxY + padding))) {
            Tile tile = TileProvider.NO_TILE;
            Intrinsics.checkNotNullExpressionValue((Object)tile, (String)"NO_TILE");
            return tile;
        }
        PointQuadTree<WeightedLatLng> pointQuadTree = this.tree;
        if (pointQuadTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
            pointQuadTree = null;
        }
        if ((points = pointQuadTree.search(tileBounds)).isEmpty()) {
            Tile tile = TileProvider.NO_TILE;
            Intrinsics.checkNotNullExpressionValue((Object)tile, (String)"NO_TILE");
            return tile;
        }
        int n = 0;
        int n2 = 512 + this.radius * 2;
        Object object = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            object[n3] = new double[512 + this.radius * 2];
        }
        double[][] intensity = object;
        Iterable $this$forEach$iv = points;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            w = (WeightedLatLng)element$iv;
            boolean bl = false;
            p = w.getPoint();
            bucketX = (int)((p.x - minX) / bucketWidth);
            bucketY = (int)((p.y - minY) / bucketWidth);
            dArray = intensity[bucketX];
            dArray[bucketY] = dArray[bucketY] + w.getIntensity();
        }
        $this$forEach$iv = wrappedPoints;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            w = (WeightedLatLng)element$iv;
            boolean bl = false;
            p = w.getPoint();
            bucketX = (int)((p.x + xOffset - minX) / bucketWidth);
            bucketY = (int)((p.y - minY) / bucketWidth);
            dArray = intensity[bucketX];
            dArray[bucketY] = dArray[bucketY] + w.getIntensity();
        }
        double[][] convolved = Companion.convolve(intensity, this.kernel);
        int[] nArray = this.colorMap;
        if (this.colorMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorMap");
            nArray = null;
        }
        double[] dArray2 = this.maxIntensity;
        if (this.maxIntensity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxIntensity");
            dArray2 = null;
        }
        Bitmap bitmap = Companion.colorize$library_release(convolved, nArray, dArray2[zoom]);
        return HeatmapTileProvider.Companion.convertBitmap(bitmap);
    }

    private final double[] getMaxIntensities(int radius) {
        int i;
        double[] maxIntensityArray = new double[22];
        if (!(this.customMaxIntensity == 0.0)) {
            for (int i2 = 0; i2 < 22; ++i2) {
                maxIntensityArray[i2] = this.customMaxIntensity;
            }
            return maxIntensityArray;
        }
        for (i = 5; i < 11; ++i) {
            Bounds bounds = this.bounds;
            if (bounds == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bounds");
                bounds = null;
            }
            maxIntensityArray[i] = Companion.getMaxValue$library_release(this.data, bounds, radius, (int)((double)1280 * Math.pow(2.0, i - 3)));
            if (i != 5) continue;
            for (int j = 0; j < i; ++j) {
                maxIntensityArray[j] = maxIntensityArray[i];
            }
        }
        for (i = 11; i < 22; ++i) {
            maxIntensityArray[i] = maxIntensityArray[10];
        }
        return maxIntensityArray;
    }

    @JvmStatic
    @NotNull
    public static final Bounds getBounds(@NotNull Collection<WeightedLatLng> points) {
        return Companion.getBounds(points);
    }

    @JvmStatic
    @NotNull
    public static final double[] generateKernel(int radius, double sd) {
        return Companion.generateKernel(radius, sd);
    }

    @JvmStatic
    @NotNull
    public static final double[][] convolve(@NotNull double[][] grid, @NotNull double[] kernel) {
        return Companion.convolve(grid, kernel);
    }

    public /* synthetic */ HeatmapTileProvider(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    static {
        Object[] objectArray = new int[]{Color.rgb((int)102, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
        DEFAULT_GRADIENT_COLORS = objectArray;
        objectArray = new float[2];
        objectArray[0] = (int)0.2f;
        objectArray[1] = (int)1.0f;
        DEFAULT_GRADIENT_START_POINTS = objectArray;
        DEFAULT_GRADIENT = new Gradient(DEFAULT_GRADIENT_COLORS, DEFAULT_GRADIENT_START_POINTS, 0, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010 \u001a\u00020\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005J\u0014\u0010\u0004\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020%R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/google/maps/android/heatmaps/HeatmapTileProvider$Builder;", "", "<init>", "()V", "weightedData", "", "Lcom/google/maps/android/heatmaps/WeightedLatLng;", "getWeightedData$library_release", "()Ljava/util/Collection;", "setWeightedData$library_release", "(Ljava/util/Collection;)V", "radius", "", "getRadius$library_release", "()I", "setRadius$library_release", "(I)V", "gradient", "Lcom/google/maps/android/heatmaps/Gradient;", "getGradient$library_release", "()Lcom/google/maps/android/heatmaps/Gradient;", "setGradient$library_release", "(Lcom/google/maps/android/heatmaps/Gradient;)V", "opacity", "", "getOpacity$library_release", "()D", "setOpacity$library_release", "(D)V", "intensity", "getIntensity$library_release", "setIntensity$library_release", "data", "latLngs", "Lcom/google/android/gms/maps/model/LatLng;", "maxIntensity", "build", "Lcom/google/maps/android/heatmaps/HeatmapTileProvider;", "library_release"})
    @SourceDebugExtension(value={"SMAP\nHeatmapTileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeatmapTileProvider.kt\ncom/google/maps/android/heatmaps/HeatmapTileProvider$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1#2:427\n*E\n"})
    public static final class Builder {
        @Nullable
        private Collection<WeightedLatLng> weightedData;
        private int radius = 20;
        @NotNull
        private Gradient gradient = DEFAULT_GRADIENT;
        private double opacity = 0.7;
        private double intensity;

        @Nullable
        public final Collection<WeightedLatLng> getWeightedData$library_release() {
            return this.weightedData;
        }

        public final void setWeightedData$library_release(@Nullable Collection<WeightedLatLng> collection) {
            this.weightedData = collection;
        }

        public final int getRadius$library_release() {
            return this.radius;
        }

        public final void setRadius$library_release(int n) {
            this.radius = n;
        }

        @NotNull
        public final Gradient getGradient$library_release() {
            return this.gradient;
        }

        public final void setGradient$library_release(@NotNull Gradient gradient) {
            Intrinsics.checkNotNullParameter((Object)gradient, (String)"<set-?>");
            this.gradient = gradient;
        }

        public final double getOpacity$library_release() {
            return this.opacity;
        }

        public final void setOpacity$library_release(double d) {
            this.opacity = d;
        }

        public final double getIntensity$library_release() {
            return this.intensity;
        }

        public final void setIntensity$library_release(double d) {
            this.intensity = d;
        }

        @NotNull
        public final Builder data(@NotNull Collection<LatLng> latLngs) {
            Builder builder;
            Intrinsics.checkNotNullParameter(latLngs, (String)"latLngs");
            Builder $this$data_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$data_u24lambda_u240.weightedData(Companion.wrapData(latLngs));
            Collection<WeightedLatLng> collection = $this$data_u24lambda_u240.weightedData;
            if (!(collection != null ? !collection.isEmpty() : false)) {
                boolean bl2 = false;
                String string = "No input points.";
                throw new IllegalArgumentException(string.toString());
            }
            return builder;
        }

        @NotNull
        public final Builder weightedData(@NotNull Collection<WeightedLatLng> weightedData) {
            Builder builder;
            Intrinsics.checkNotNullParameter(weightedData, (String)"weightedData");
            Builder $this$weightedData_u24lambda_u240 = builder = this;
            boolean bl = false;
            Collection<WeightedLatLng> collection = $this$weightedData_u24lambda_u240.weightedData = weightedData;
            if (!(collection != null ? !collection.isEmpty() : false)) {
                boolean bl2 = false;
                String string = "No input points.";
                throw new IllegalArgumentException(string.toString());
            }
            return builder;
        }

        @NotNull
        public final Builder radius(int radius) {
            Builder builder;
            Builder $this$radius_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$radius_u24lambda_u240.radius = radius;
            int n = $this$radius_u24lambda_u240.radius;
            if (!(10 <= n ? n < 51 : false)) {
                boolean bl2 = false;
                String string = "Radius not within bounds.";
                throw new IllegalArgumentException(string.toString());
            }
            return builder;
        }

        @NotNull
        public final Builder gradient(@NotNull Gradient gradient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)gradient, (String)"gradient");
            Builder $this$gradient_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$gradient_u24lambda_u240.gradient = gradient;
            return builder;
        }

        @NotNull
        public final Builder opacity(double opacity) {
            Builder builder;
            Builder $this$opacity_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$opacity_u24lambda_u240.opacity = opacity;
            double d = $this$opacity_u24lambda_u240.opacity;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Opacity must be in range [0, 1]";
                throw new IllegalArgumentException(string.toString());
            }
            return builder;
        }

        @NotNull
        public final Builder maxIntensity(double intensity) {
            Builder builder;
            Builder $this$maxIntensity_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$maxIntensity_u24lambda_u240.intensity = intensity;
            return builder;
        }

        @NotNull
        public final HeatmapTileProvider build() {
            Collection<WeightedLatLng> collection = this.weightedData;
            if (!(collection != null ? !collection.isEmpty() : false)) {
                boolean bl = false;
                String string = "No input data: you must use either .data or .weightedData before building.";
                throw new IllegalArgumentException(string.toString());
            }
            return new HeatmapTileProvider(this, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001:\u00014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0007H\u0007J)\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0'2\u0006\u0010)\u001a\u00020#H\u0007\u00a2\u0006\u0002\u0010*J-\u0010+\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0'2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b.\u0010/J3\u00100\u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u00101\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b3R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/google/maps/android/heatmaps/HeatmapTileProvider$Companion;", "", "<init>", "()V", "DEFAULT_RADIUS", "", "DEFAULT_OPACITY", "", "DEFAULT_GRADIENT_COLORS", "", "DEFAULT_GRADIENT_START_POINTS", "", "DEFAULT_GRADIENT", "Lcom/google/maps/android/heatmaps/Gradient;", "WORLD_WIDTH", "TILE_DIM", "SCREEN_SIZE", "DEFAULT_MIN_ZOOM", "DEFAULT_MAX_ZOOM", "MAX_ZOOM_LEVEL", "MIN_RADIUS", "MAX_RADIUS", "wrapData", "", "Lcom/google/maps/android/heatmaps/WeightedLatLng;", "data", "Lcom/google/android/gms/maps/model/LatLng;", "convertBitmap", "Lcom/google/android/gms/maps/model/Tile;", "bitmap", "Landroid/graphics/Bitmap;", "getBounds", "Lcom/google/maps/android/geometry/Bounds;", "points", "generateKernel", "", "radius", "sd", "convolve", "", "grid", "kernel", "([[D[D)[[D", "colorize", "colorMap", "max", "colorize$library_release", "([[D[ID)Landroid/graphics/Bitmap;", "getMaxValue", "bounds", "screenDim", "getMaxValue$library_release", "Vector", "library_release"})
    @SourceDebugExtension(value={"SMAP\nHeatmapTileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeatmapTileProvider.kt\ncom/google/maps/android/heatmaps/HeatmapTileProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,426:1\n1563#2:427\n1634#2,3:428\n1869#2,2:431\n1869#2:439\n1870#2:447\n83#3,6:433\n382#4,7:440\n*S KotlinDebug\n*F\n+ 1 HeatmapTileProvider.kt\ncom/google/maps/android/heatmaps/HeatmapTileProvider$Companion\n*L\n304#1:427\n304#1:428,3\n321#1:431,2\n414#1:439\n414#1:447\n394#1:433,6\n420#1:440,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<WeightedLatLng> wrapData(Collection<LatLng> data) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = data;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LatLng latLng = (LatLng)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new WeightedLatLng((LatLng)it, 0.0, 2, null));
            }
            return (List)destination$iv$iv;
        }

        private final Tile convertBitmap(Bitmap bitmap) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            byte[] bitmapData = stream.toByteArray();
            return new Tile(512, 512, bitmapData);
        }

        @JvmStatic
        @NotNull
        public final Bounds getBounds(@NotNull Collection<WeightedLatLng> points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Point firstPoint = ((WeightedLatLng)CollectionsKt.first((Iterable)points)).getPoint();
            double minX = 0.0;
            minX = firstPoint.x;
            double maxX = 0.0;
            maxX = firstPoint.x;
            double minY = 0.0;
            minY = firstPoint.y;
            double maxY = 0.0;
            maxY = firstPoint.y;
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)points, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeightedLatLng it = (WeightedLatLng)element$iv;
                boolean bl = false;
                double x = it.getPoint().x;
                double y = it.getPoint().y;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (!(y > maxY)) continue;
                maxY = y;
            }
            return new Bounds(minX, maxX, minY, maxY);
        }

        @JvmStatic
        @NotNull
        public final double[] generateKernel(int radius, double sd) {
            double[] kernel = new double[radius * 2 + 1];
            int i = -radius;
            if (i <= radius) {
                while (true) {
                    kernel[i + radius] = Math.exp((double)(-i * i) / ((double)2 * sd * sd));
                    if (i == radius) break;
                    ++i;
                }
            }
            return kernel;
        }

        @JvmStatic
        @NotNull
        public final double[][] convolve(@NotNull double[][] grid, @NotNull double[] kernel) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
            int radius = (int)Math.floor((double)kernel.length / 2.0);
            int dimOld = ((Object[])grid).length;
            int dim = dimOld - 2 * radius;
            int lowerLimit = radius;
            int upperLimit = radius + dim - 1;
            int n = 0;
            double[][] dArrayArray = new double[dimOld][];
            while (n < dimOld) {
                int n2 = n++;
                dArrayArray[n2] = new double[dimOld];
            }
            double[][] intermediate = dArrayArray;
            for (int x = 0; x < dimOld; ++x) {
                block2: for (int y = 0; y < dimOld; ++y) {
                    double value = grid[x][y];
                    if (value == 0.0) continue;
                    int xUpperLimit = RangesKt.coerceAtMost((int)(x + radius), (int)upperLimit);
                    int x2 = RangesKt.coerceAtLeast((int)(x - radius), (int)lowerLimit);
                    if (x2 > xUpperLimit) continue;
                    while (true) {
                        double[] dArray = intermediate[x2];
                        int n3 = y;
                        dArray[n3] = dArray[n3] + value * kernel[x2 - (x - radius)];
                        if (x2 == xUpperLimit) continue block2;
                        ++x2;
                    }
                }
            }
            int y = 0;
            double[][] value = new double[dim][];
            while (y < dim) {
                int n4 = y++;
                value[n4] = new double[dim];
            }
            double[][] outputGrid = value;
            int x = lowerLimit;
            if (x <= upperLimit) {
                while (true) {
                    block6: for (int y2 = 0; y2 < dimOld; ++y2) {
                        double value2 = intermediate[x][y2];
                        if (value2 == 0.0) continue;
                        int yUpperLimit = RangesKt.coerceAtMost((int)(y2 + radius), (int)upperLimit);
                        int y22 = RangesKt.coerceAtLeast((int)(y2 - radius), (int)lowerLimit);
                        if (y22 > yUpperLimit) continue;
                        while (true) {
                            double[] dArray = outputGrid[x - radius];
                            int n5 = y22 - radius;
                            dArray[n5] = dArray[n5] + value2 * kernel[y22 - (y2 - radius)];
                            if (y22 == yUpperLimit) continue block6;
                            ++y22;
                        }
                    }
                    if (x == upperLimit) break;
                    ++x;
                }
            }
            return outputGrid;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Bitmap colorize$library_release(@NotNull double[][] grid, @NotNull int[] colorMap, double max) {
            void width$iv;
            int j;
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)colorMap, (String)"colorMap");
            int maxColor = ArraysKt.last((int[])colorMap);
            double colorMapScaling = (double)(colorMap.length - 1) / max;
            int dim = ((Object[])grid).length;
            int[] colors = new int[dim * dim];
            for (int i = 0; i < dim; ++i) {
                for (j = 0; j < dim; ++j) {
                    double value = grid[j][i];
                    int index = i * dim + j;
                    int col = (int)(value * colorMapScaling);
                    colors[index] = !(value == 0.0) ? (col < colorMap.length ? colorMap[col] : maxColor) : 0;
                }
            }
            j = dim;
            int height$iv = dim;
            Bitmap.Config config$iv = Bitmap.Config.ARGB_8888;
            boolean $i$f$createBitmap = false;
            Bitmap tile = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
            tile.setPixels(colors, 0, dim, 0, 0, dim, dim);
            return tile;
        }

        /*
         * WARNING - void declaration
         */
        public final double getMaxValue$library_release(@NotNull Collection<WeightedLatLng> points, @NotNull Bounds bounds, int radius, int screenDim) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            double minX = bounds.minX;
            double maxX = bounds.maxX;
            double minY = bounds.minY;
            double maxY = bounds.maxY;
            double boundsDim = RangesKt.coerceAtLeast((double)(maxX - minX), (double)(maxY - minY));
            int nBuckets = (int)((double)(screenDim / (2 * radius)) + 0.5);
            double scale = (double)nBuckets / boundsDim;
            Map buckets = new LinkedHashMap();
            Iterable $this$forEach$iv = points;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                WeightedLatLng l = (WeightedLatLng)element$iv;
                boolean bl = false;
                double x = l.getPoint().x;
                double y = l.getPoint().y;
                int xBucket = (int)((x - minX) * scale);
                int yBucket = (int)((y - minY) * scale);
                Vector bucket = new Vector(xBucket, yBucket);
                Map map = buckets;
                Vector key$iv = bucket;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Double answer$iv = 0.0;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                double currentValue = ((Number)object).doubleValue();
                buckets.put(bucket, currentValue + l.getIntensity());
            }
            Double d = CollectionsKt.maxOrNull((Iterable)buckets.values());
            return d != null ? d : 0.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/google/maps/android/heatmaps/HeatmapTileProvider$Companion$Vector;", "", "x", "", "y", "<init>", "(II)V", "getX", "()I", "getY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "library_release"})
        private static final class Vector {
            private final int x;
            private final int y;

            public Vector(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public final int getX() {
                return this.x;
            }

            public final int getY() {
                return this.y;
            }

            public final int component1() {
                return this.x;
            }

            public final int component2() {
                return this.y;
            }

            @NotNull
            public final Vector copy(int x, int y) {
                return new Vector(x, y);
            }

            public static /* synthetic */ Vector copy$default(Vector vector, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = vector.x;
                }
                if ((n3 & 2) != 0) {
                    n2 = vector.y;
                }
                return vector.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Vector(x=" + this.x + ", y=" + this.y + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.x);
                result = result * 31 + Integer.hashCode(this.y);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Vector)) {
                    return false;
                }
                Vector vector = (Vector)other;
                if (this.x != vector.x) {
                    return false;
                }
                return this.y == vector.y;
            }
        }
    }
}

