/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.collections;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.maps.android.collections.MapObjectManager;

public class GroundOverlayManager
extends MapObjectManager<GroundOverlay, Collection>
implements GoogleMap.OnGroundOverlayClickListener {
    public GroundOverlayManager(@NonNull GoogleMap map) {
        super(map);
    }

    @Override
    void setListenersOnUiThread() {
        if (this.mMap != null) {
            this.mMap.setOnGroundOverlayClickListener((GoogleMap.OnGroundOverlayClickListener)this);
        }
    }

    @Override
    public Collection newCollection() {
        return new Collection();
    }

    @Override
    protected void removeObjectFromMap(GroundOverlay object) {
        object.remove();
    }

    public void onGroundOverlayClick(@NonNull GroundOverlay groundOverlay) {
        Collection collection = (Collection)this.mAllObjects.get(groundOverlay);
        if (collection != null && collection.mGroundOverlayClickListener != null) {
            collection.mGroundOverlayClickListener.onGroundOverlayClick(groundOverlay);
        }
    }

    public class Collection
    extends MapObjectManager.Collection {
        private GoogleMap.OnGroundOverlayClickListener mGroundOverlayClickListener;

        public Collection() {
            super(GroundOverlayManager.this);
        }

        public GroundOverlay addGroundOverlay(GroundOverlayOptions opts) {
            GroundOverlay groundOverlay = GroundOverlayManager.this.mMap.addGroundOverlay(opts);
            super.add(groundOverlay);
            return groundOverlay;
        }

        public void addAll(java.util.Collection<GroundOverlayOptions> opts) {
            for (GroundOverlayOptions opt : opts) {
                this.addGroundOverlay(opt);
            }
        }

        public void addAll(java.util.Collection<GroundOverlayOptions> opts, boolean defaultVisible) {
            for (GroundOverlayOptions opt : opts) {
                this.addGroundOverlay(opt).setVisible(defaultVisible);
            }
        }

        public void showAll() {
            for (GroundOverlay groundOverlay : this.getGroundOverlays()) {
                groundOverlay.setVisible(true);
            }
        }

        public void hideAll() {
            for (GroundOverlay groundOverlay : this.getGroundOverlays()) {
                groundOverlay.setVisible(false);
            }
        }

        public boolean remove(GroundOverlay groundOverlay) {
            return super.remove(groundOverlay);
        }

        public java.util.Collection<GroundOverlay> getGroundOverlays() {
            return this.getObjects();
        }

        public void setOnGroundOverlayClickListener(GoogleMap.OnGroundOverlayClickListener groundOverlayClickListener) {
            this.mGroundOverlayClickListener = groundOverlayClickListener;
        }
    }
}

